/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.TenantType;
import kd.bos.bd.utils.FieldPropUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class CtsyCommonService {
    private static final Log LOGGER = LogFactory.getLog(CtsyCommonService.class);
    protected static final String SERVER_IP = "serverip";
    protected static final String SERVER_PORT = "serverport";
    protected static final String WEB_APP = "web_app";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String ACCESS_TOKEN = "accesstoken";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String CTSY_TENANT_ASSIGN_SYNC_API = "/kapi/v2/ctsy/base/assign";
    protected static final String CTSY_TENANT_INDIVIDUALIZE_SYNC_API = "/kapi/v2/ctsy/base/individualize";
    protected static final String SAVE = "save";
    protected static int defaultConnectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 3000);
    protected static int defaultReadTimeout = Integer.getInteger("httpclient.readTimeout", 30000);
    protected static final String ENTITY_ID = "entityid";
    protected static final String OP_ORG_ID = "oporgid";
    protected static final String APP_ID = "appid";
    protected static final String DATA_ENTRY_ENTITY = "dataentryentity";
    protected static final String ORG_ENTRY_ENTITY = "orgentryentity";
    protected static final String DATA_ID = "dataid";
    protected static final String ORG_ID = "orgid";
    protected static final String ORG_NUMBER = "orgnumber";
    protected static final String UID = "uid";
    protected static final String ENTITY_BOS_ORG = "bos_org";
    protected static final String TARGET_TENANT_NUMBER = "tartenantnumber";
    private static final String ACCOUNT_ID = "accountid";
    private static final String TENANT_ID = "tenantid";
    private static final String TYPE = "type";
    private static final String TYPE_BUSINESS_UNIT = "1";
    private static final String REMARK = "remark";

    protected static void markSyncFail(long syncRecordId, String remark) {
        DynamicObject syncRecord = BusinessDataServiceHelper.loadSingle((Object)syncRecordId, (String)"ctsy_ctrlstrategy_sync");
        syncRecord.set("syncstatus", (Object)CtsyRecordSyncStatus.FAIL.getStatus());
        syncRecord.set(REMARK, (Object)remark);
        OperationServiceHelper.executeOperate((String)SAVE, (String)"ctsy_ctrlstrategy_sync", (DynamicObject[])new DynamicObject[]{syncRecord}, (OperateOption)OperateOption.create());
    }

    protected static boolean ifCurrentTenantIsMaster(Map<Object, DynamicObject> tenantMap) {
        DynamicObject masterTenant = CollectionUtils.isEmpty(tenantMap) ? null : (DynamicObject)tenantMap.values().stream().filter(tenant -> TenantType.GROUP.getType().equals(tenant.getString("tenanttype"))).findFirst().orElse(null);
        String accountId = RequestContext.get().getAccountId();
        boolean isMasterTenant = null != masterTenant && null != masterTenant.get(ACCOUNT_ID) ? masterTenant.get(ACCOUNT_ID).equals(accountId) : false;
        return isMasterTenant;
    }

    protected boolean validateParamIsEmpty(String entityId, Long assignOrgId, Set<Long> dataIds, Set<Long> orgIds) {
        if (null == entityId) {
            LOGGER.info("entityId is null.");
            return true;
        }
        if (null == assignOrgId || assignOrgId.equals(0L)) {
            LOGGER.info("assignOrgId is null.");
            return true;
        }
        if (CollectionUtils.isEmpty(dataIds)) {
            LOGGER.info("dataIds is empty.");
            return true;
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            LOGGER.info("orgIds is empty.");
            return true;
        }
        return false;
    }

    protected boolean validateParamIsEmpty(String entityId, Long useOrgId, Set<Long> dataIds) {
        if (null == entityId) {
            LOGGER.info("entityId is null.");
            return true;
        }
        if (null == useOrgId || useOrgId.equals(0L)) {
            LOGGER.info("useOrgId is null.");
            return true;
        }
        if (CollectionUtils.isEmpty(dataIds)) {
            LOGGER.info("dataIds is empty.");
            return true;
        }
        return false;
    }

    protected Map<String, Set<String>> gerTenantOrgRelationship(Map<Long, String> allOrgId2Number, Set<Long> orgIds, Map<Long, String> tenantId2NumberMap) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ORG_ID, "in", orgIds), new QFilter(TYPE, "=", (Object)TYPE_BUSINESS_UNIT)};
        String selectFields = FieldPropUtils.getSelectField(TENANT_ID, ORG_ID);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"ctsy_tenantorgrelation", (String)selectFields, (QFilter[])qFilters);
        HashMap<String, Set<String>> tenantNumber2BizOrgNumberMap = new HashMap<String, Set<String>>(10);
        for (DynamicObject tenantOrgRelation : doc) {
            Long orgId = tenantOrgRelation.getLong(ORG_ID);
            Long tenantId = tenantOrgRelation.getLong(TENANT_ID);
            String orgNumber = allOrgId2Number.get(orgId);
            String tenantNumber = tenantId2NumberMap.get(tenantId);
            if (null == tenantNumber) continue;
            HashSet<String> orgNumbers = (HashSet<String>)tenantNumber2BizOrgNumberMap.get(tenantNumber);
            if (null == orgNumbers) {
                orgNumbers = new HashSet<String>(tenantNumber2BizOrgNumberMap.size());
            }
            orgNumbers.add(orgNumber);
            tenantNumber2BizOrgNumberMap.put(tenantNumber, orgNumbers);
        }
        return tenantNumber2BizOrgNumberMap;
    }

    public static boolean ifCurrentIsSubTenant() {
        QFilter[] qFilters;
        String selectFields = CtsyCommonService.getSelectField("id", ACCOUNT_ID);
        Map subTenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (String)selectFields, (QFilter[])(qFilters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("tenanttype", "<>", (Object)TenantType.GROUP.getType())}));
        if (subTenantMap.isEmpty()) {
            return false;
        }
        String accountId = RequestContext.get().getAccountId();
        Set subAccountIds = subTenantMap.values().stream().map(subTenant -> subTenant.getString(ACCOUNT_ID)).filter(Objects::nonNull).collect(Collectors.toSet());
        return !CollectionUtils.isEmpty(subAccountIds) && subAccountIds.contains(accountId);
    }

    private static String getSelectField(String ... props) {
        if (null == props || props.length == 0) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }
}

