/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.service;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.IndividualizedSyncRecord;
import kd.bos.bd.ctsy.pojo.TenantType;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.IndividualizeService;
import kd.bos.bd.utils.CtsyUtils;
import kd.bos.bd.utils.FieldPropUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyIndividualizeConsumerService {
    private static final Log LOGGER = LogFactory.getLog(CtsyIndividualizeConsumerService.class);
    private static final String MASTER_ID_NUMBER = "masterid.number";
    private static final String PRO_SERVER_IP = "serverip";
    private static final String PRO_WEB_APP = "web_app";
    private static final String PRO_SERVER_PORT = "serverport";
    private static final String API_MAIN_TENANT_MARK = "/kapi/v2/ctsy/base/afterSyncRecordSave";

    public void handleIndividualize(DynamicObject record) {
        if (null == record) {
            return;
        }
        IndividualizedSyncRecord syncRecord = this.convertToIndividualizedSyncRecord(record);
        final String entityId = syncRecord.getEntityId();
        final Long useOrgId = syncRecord.getUseOrgId();
        final Set<Long> dataIds = syncRecord.getDataIds();
        BaseDataResponse response = (new IndividualizeService(entityId){

            private BaseDataResponse individualize() {
                return super.individualizeNotVerifyingRights(useOrgId, dataIds, entityId);
            }
        }).individualize();
        Long syncRecordId = syncRecord.getId();
        DeleteServiceHelper.delete((String)"ctsy_ctrlstrategy_sync", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)syncRecordId)});
        String uid = syncRecord.getUid();
        if (response.isSuccess() && CollectionUtils.isEmpty((Map)response.getResult())) {
            this.markMasterTenantStatusAfterSync(uid, "", CtsyRecordSyncStatus.SUCCESS, () -> null);
        } else {
            String numPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? MASTER_ID_NUMBER : "number";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds), BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)useOrgId)};
            HashMap<Long, String> id2NumMap = new HashMap<Long, String>(dataIds.size());
            try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), entityId, FieldPropUtils.getSelectField("id", numPro), filters);){
                ds.forEach(row -> id2NumMap.put(row.getLong("id"), row.getString(numPro)));
            }
            this.markFailAfterIndividualize(uid, response, id2NumMap);
        }
    }

    private void markMasterTenantStatusAfterSync(String uid, String remark, CtsyRecordSyncStatus status, Supplier<Map<String, Object>> supplier) {
        QFilter[] masterTenantFilters = new QFilter[]{new QFilter("tenanttype", "=", (Object)TenantType.GROUP.getType())};
        DynamicObject masterTenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])masterTenantFilters);
        if (null == masterTenant) {
            return;
        }
        Map<String, Object> params = this.buildMapParams(uid, status.getStatus(), remark, supplier.get());
        this.markMainTenant(masterTenant, params);
    }

    private void markMainTenant(DynamicObject masterTenant, Object body) {
        try {
            String server = masterTenant.getString(PRO_SERVER_IP);
            String web = masterTenant.getString(PRO_WEB_APP);
            String port = masterTenant.getString(PRO_SERVER_PORT);
            String serverUrl = StringUtils.isBlank((CharSequence)port) ? String.format("%s%s", server, web) : String.format("%s:%s%s", server, port, web);
            String accessToken = CtsyUtils.getAccessToken(serverUrl, masterTenant);
            if (null == accessToken) {
                String tenantNumber = masterTenant.getString("number");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u201c%s\u201d\u7684access_token\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"CtsyIndividualizeConsumerService_0", (String)"bos-bd-business", (Object[])new Object[0]), tenantNumber));
            }
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", accessToken);
            String markUrl = String.join((CharSequence)"", serverUrl, API_MAIN_TENANT_MARK);
            LOGGER.debug("ctsy tenant assign url " + markUrl + ", param " + JSON.toJSONString((Object)body));
            String result = HttpClientUtils.postjson((String)markUrl, header, (String)JSON.toJSONString((Object)body));
            LOGGER.debug("ctsy tenant assign result " + result);
        }
        catch (Exception e) {
            LOGGER.error("markMainTenant error! ", (Throwable)e);
        }
    }

    private Map<String, Object> buildMapParams(String uid, String syncStatus, String remark, Map<String, Object> detailedMap) {
        HashMap<String, Object> bodyMsg = new HashMap<String, Object>(10);
        bodyMsg.put("uid", uid);
        bodyMsg.put("syncStatus", syncStatus);
        bodyMsg.put("remark", remark);
        bodyMsg.put("detail", detailedMap);
        HashMap<String, Object> body = new HashMap<String, Object>(1);
        body.put("paramMap", bodyMsg);
        return body;
    }

    private void markFailAfterIndividualize(String uid, BaseDataResponse response, Map<Long, String> dataIdNumMap) {
        if (!response.isSuccess()) {
            this.markFailAfterIndividualize(uid, response.getErrorMsg());
            return;
        }
        Map result = response.getResult();
        String remark = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5206\u914d\u5173\u7cfb\u5931\u8d25\u6570\u636e\u6d89\u53ca%s\u6761\uff0c\u66f4\u8be6\u7ec6\u4fe1\u606f\u53ef\u4ee5\u5230\u5b50\u79df\u6237\u7684\u7ba1\u63a7\u65e5\u5fd7\u4e2d\u67e5\u770b\u3002", (String)"CtsyIndividualizeConsumerService_1", (String)"bos-bd-business", (Object[])new Object[0]), null == result ? 0 : result.size());
        this.markMasterTenantStatusAfterSync(uid, remark, CtsyRecordSyncStatus.FAIL, () -> {
            HashMap<String, String> detailedMap = new HashMap<String, String>(16);
            if (CollectionUtils.isEmpty((Map)result)) {
                return detailedMap;
            }
            for (Map.Entry entry : result.entrySet()) {
                String dataNumber = (String)dataIdNumMap.get(entry.getKey());
                Map value = (Map)entry.getValue();
                if (CollectionUtils.isEmpty((Map)value)) {
                    detailedMap.put(dataNumber, ResManager.loadKDString((String)"\u6267\u884c\u4e2a\u6027\u5316\u65f6\uff0c\u4e1a\u52a1\u6821\u9a8c\u5931\u8d25\u3002", (String)"CtsyIndividualizeConsumerService_2", (String)"bos-bd-business", (Object[])new Object[0]));
                    continue;
                }
                Map.Entry next = value.entrySet().iterator().next();
                detailedMap.put(dataNumber, String.format(ResManager.loadKDString((String)"\u6267\u884c\u4e2a\u6027\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"CtsyIndividualizeConsumerService_3", (String)"bos-bd-business", (Object[])new Object[0]), next.getValue()));
            }
            return detailedMap;
        });
    }

    private void markFailAfterIndividualize(String uid, String remark) {
        if (StringUtils.isBlank((CharSequence)remark)) {
            remark = ResManager.loadKDString((String)"\u540c\u6b65\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyIndividualizeConsumerService_4", (String)"bos-bd-business", (Object[])new Object[0]);
        } else {
            int descLength = 255;
            if (remark.length() > descLength) {
                remark = remark.substring(0, descLength - 1);
            }
        }
        this.markMasterTenantStatusAfterSync(uid, remark, CtsyRecordSyncStatus.FAIL, () -> null);
    }

    private IndividualizedSyncRecord convertToIndividualizedSyncRecord(DynamicObject syncRecordObj) {
        IndividualizedSyncRecord syncRecord = new IndividualizedSyncRecord();
        syncRecord.setId(syncRecordObj.getLong("id"));
        syncRecord.setUid(syncRecordObj.getString("uid"));
        syncRecord.setUseOrgId(AbstractBaseDataService.getLongPropertyFromDynamicObject(syncRecordObj, "oporgid"));
        syncRecord.setAppId(syncRecordObj.getString("appid"));
        syncRecord.setEntityId(syncRecordObj.getString("entityid"));
        syncRecord.setTenantNumber(syncRecordObj.getString("tartenantnumber"));
        Map<Long, String> id2NumberMap = this.getDataNumberMapFromSyncRecordObj(syncRecordObj, syncRecord.getEntityId(), syncRecord.getUseOrgId());
        syncRecord.setDataIds(id2NumberMap.keySet());
        return syncRecord;
    }

    private Map<Long, String> getDataNumberMapFromSyncRecordObj(DynamicObject syncRecord, String entityId, Long assignOrgId) {
        DynamicObjectCollection dataEntry = syncRecord.getDynamicObjectCollection("dataentryentity");
        if (dataEntry.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet numbers = new HashSet(dataEntry.size());
        dataEntry.forEach(o -> numbers.add(o.getString("number")));
        String numPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? MASTER_ID_NUMBER : "number";
        QFilter[] filters = new QFilter[]{new QFilter(numPro, "in", numbers), BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)assignOrgId)};
        HashMap<Long, String> id2NumMap = new HashMap<Long, String>(dataEntry.size());
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), entityId, FieldPropUtils.getSelectField("id", numPro), filters);){
            ds.forEach(row -> id2NumMap.put(row.getLong("id"), row.getString(numPro)));
        }
        return id2NumMap;
    }
}

