/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.ctsy.pojo.AssignSyncRecord;
import kd.bos.bd.ctsy.pojo.CtsyParam;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.SyncOpTypeEnum;
import kd.bos.bd.ctsy.pojo.TenantType;
import kd.bos.bd.ctsy.service.CtsyCommonService;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.IndividualizeService;
import kd.bos.bd.utils.CtsyUtils;
import kd.bos.bd.utils.FieldPropUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyIndividualizeService
extends CtsyCommonService {
    private static final Log LOGGER = LogFactory.getLog(CtsyIndividualizeService.class);
    private final String entityId;
    private final Long useOrgId;
    private final String numberPro;

    public CtsyIndividualizeService(String entityId, Long useOrgId) {
        this.entityId = entityId;
        this.useOrgId = useOrgId;
        this.numberPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? "masterid.number" : "number";
    }

    public void ctsyIndividualize(Set<Long> dataIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])qFilters);
        boolean isMasterTenant = CtsyIndividualizeService.ifCurrentTenantIsMaster(tenantMap);
        if (CollectionUtils.isEmpty((Map)tenantMap) || !isMasterTenant) {
            return;
        }
        if (this.validateParamIsEmpty(this.entityId, this.useOrgId, dataIds)) {
            return;
        }
        ArrayList<AssignSyncRecord> assignSyncRecordList = new ArrayList<AssignSyncRecord>(tenantMap.size());
        HashMap<Long, String> allDataId2Number = new HashMap<Long, String>(dataIds.size());
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)this.entityId, (String)this.numberPro, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
        Set dataNumbers = dataMap.values().stream().map(dataObj -> dataObj.get(this.numberPro)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
        Map<Long, String> dataId2Number = dataMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.valueOf(entry.getKey().toString()), entry -> ((DynamicObject)entry.getValue()).getString(this.numberPro)));
        allDataId2Number.putAll(dataId2Number);
        String selectProps = FieldPropUtils.getSelectField("id", "number");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.useOrgId)});
        if (null == org) {
            LOGGER.error("CtsyIndividualizeService individualize error, org which loadSingleFromCache is null.");
            return;
        }
        HashMap<Long, String> allOrgId2Number = new HashMap<Long, String>(1);
        String useOrgNumber = org.getString("number");
        allOrgId2Number.put(org.getLong("id"), useOrgNumber);
        Map<Long, String> tenantId2NumberMap = tenantMap.values().stream().collect(Collectors.toMap(tenant -> tenant.getLong("id"), tenant -> tenant.getString("number")));
        HashSet<Long> orgIds = new HashSet<Long>(10);
        orgIds.add(this.useOrgId);
        Map<String, Set<String>> tenantNumber2BizOrgNumberMap = this.gerTenantOrgRelationship(allOrgId2Number, orgIds, tenantId2NumberMap);
        Iterator iterator = tenantMap.values().iterator();
        while (iterator.hasNext()) {
            DynamicObject tarTenant = (DynamicObject)iterator.next();
            String tenantNumber = tarTenant.getString("number");
            if (TenantType.GROUP.getType().equals(tarTenant.getString("tenanttype"))) {
                iterator.remove();
                continue;
            }
            Set<String> orgNumberSet = tenantNumber2BizOrgNumberMap.get(tenantNumber);
            if (CollectionUtils.isEmpty(orgNumberSet) || !orgNumberSet.contains(useOrgNumber)) continue;
            long uid = DB.genLongId((String)"t_ctsy_ctrlstrategy_sync");
            assignSyncRecordList.add(new AssignSyncRecord(null, uid + "", this.entityId, this.useOrgId, "", dataIds, orgIds, tenantNumber));
        }
        if (CollectionUtils.isEmpty(assignSyncRecordList)) {
            return;
        }
        Map<String, AssignSyncRecord> tenantNumber2SyncRecord = this.saveIndividualizeSyncRecord(assignSyncRecordList, allDataId2Number);
        for (DynamicObject tarTenant : tenantMap.values()) {
            Set<String> orgNumberSet = tenantNumber2BizOrgNumberMap.get(tarTenant.getString("number"));
            if (CollectionUtils.isEmpty(orgNumberSet) || !orgNumberSet.contains(useOrgNumber)) continue;
            CtsyParam.CSTY_BASE_ASSIGN_THREAD_POOL.execute(() -> this.callIndividualizeToChildTenant(dataNumbers, useOrgNumber, tenantNumber2SyncRecord, tarTenant));
        }
    }

    private void callIndividualizeToChildTenant(Set<String> dataNumbers, String useOrgNumber, Map<String, AssignSyncRecord> tenantNumber2SyncRecord, DynamicObject tarTenant) {
        String tenantNumber = tarTenant.getString("number");
        AssignSyncRecord assignSyncRecord = tenantNumber2SyncRecord.get(tenantNumber);
        if (null == assignSyncRecord) {
            LOGGER.error("CtsyAssignSyncService assignToChildTenant assignSyncRecord is null.");
            return;
        }
        long syncRecordId = assignSyncRecord.getId();
        try {
            String accessToken;
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(tarTenant.getString("serverip"));
            urlBuilder.append(":");
            urlBuilder.append(tarTenant.getString("serverport"));
            if (!StringUtils.isEmpty((CharSequence)tarTenant.getString("web_app"))) {
                urlBuilder.append(tarTenant.getString("web_app"));
            }
            if (null == (accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), tarTenant))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u201c%s\u201d\u7684access_token\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyIndividualizeService_0", (String)"bos-bd-business", (Object[])new Object[0]), tenantNumber);
                throw new KDBizException(new ErrorCode("ERROR_CODE_1", errorMsg), new Object[]{errorMsg});
            }
            urlBuilder.append("/kapi/v2/ctsy/base/individualize");
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", accessToken);
            HashMap<String, Object> bodyMsg = new HashMap<String, Object>(10);
            HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(1);
            map.put("paramMap", bodyMsg);
            bodyMsg.put("entityid", this.entityId);
            bodyMsg.put("appid", "");
            bodyMsg.put("useOrgNumber", useOrgNumber);
            bodyMsg.put("uid", assignSyncRecord.getUid());
            bodyMsg.put("dataNumbers", dataNumbers);
            LOGGER.info("ctsy tenant individualize url " + urlBuilder + ", param " + JSON.toJSONString(map));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(map), (int)defaultConnectionTimeout, (int)defaultReadTimeout);
            LOGGER.info("ctsy tenant individualize result " + result);
        }
        catch (KDBizException e) {
            LOGGER.error("ctsy tenant individualize KDBizException:", (Throwable)e);
            CtsyIndividualizeService.markSyncFail(syncRecordId, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("ctsy tenant individualize error:", (Throwable)e);
            CtsyIndividualizeService.markSyncFail(syncRecordId, ResManager.loadKDString((String)"\u8c03\u7528\u8de8\u79df\u6237\u4e2a\u6027\u5316\u63a5\u53e3\u5f02\u5e38\u3002", (String)"CtsyIndividualizeService_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    private Map<String, AssignSyncRecord> saveIndividualizeSyncRecord(List<AssignSyncRecord> assignSyncRecordList, Map<Long, String> allDataId2Number) {
        ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>(assignSyncRecordList.size());
        for (AssignSyncRecord assignSyncRecord : assignSyncRecordList) {
            Set<Long> dataIds = assignSyncRecord.getDataIds();
            String tenantNumber = assignSyncRecord.getTenantNumber();
            DynamicObject recordObj = BusinessDataServiceHelper.newDynamicObject((String)"ctsy_ctrlstrategy_sync");
            DynamicObjectCollection dataCol = recordObj.getDynamicObjectCollection("dataentryentity");
            for (Long dataId : dataIds) {
                DynamicObject dataObj = dataCol.addNew();
                dataObj.set("dataid", (Object)dataId);
                dataObj.set("number", (Object)allDataId2Number.get(dataId));
            }
            recordObj.set("optype", (Object)SyncOpTypeEnum.OP_INDIVIDUALIZATION.getOpType());
            recordObj.set("entityid", (Object)this.entityId);
            recordObj.set("appid", (Object)"");
            recordObj.set("oporgid", (Object)this.useOrgId);
            recordObj.set("uid", (Object)assignSyncRecord.getUid());
            recordObj.set("dataentryentity", (Object)dataCol);
            recordObj.set("tartenantnumber", (Object)tenantNumber);
            recordObj.set("syncstatus", (Object)CtsyRecordSyncStatus.SYNCHRONIZED.getStatus());
            saveObjList.add(recordObj);
        }
        if (saveObjList.isEmpty()) {
            return Collections.emptyMap();
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ctsy_ctrlstrategy_sync", (DynamicObject[])saveObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            QFilter[] idFilters = new QFilter[]{new QFilter("id", "in", (Object)successPkIds)};
            DynamicObjectCollection assignSyncRecordCol = QueryServiceHelper.query((String)"ctsy_ctrlstrategy_sync", (String)"id,tartenantnumber", (QFilter[])idFilters);
            Map<String, Long> tenantNumber2RecordId = assignSyncRecordCol.stream().collect(Collectors.toMap(obj -> obj.getString("tartenantnumber"), obj -> obj.getLong("id")));
            return assignSyncRecordList.stream().collect(Collectors.toMap(AssignSyncRecord::getTenantNumber, syncRecord -> {
                String tenantNumber = syncRecord.getTenantNumber();
                syncRecord.setId((Long)tenantNumber2RecordId.get(tenantNumber));
                return syncRecord;
            }));
        }
        return Collections.emptyMap();
    }

    public BaseDataResponse handleIndividualizeBeforeSave(DynamicObject data) {
        String number;
        QFilter[] qFilters;
        if (null == data) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u3002", (String)"CtsyIndividualizeService_2", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        final String entity = data.getDataEntityType().getName();
        long srcCreateOrgId = AbstractBaseDataService.getLongPropertyFromDynamicObject(data, "srccreateorg");
        final long createOrgId = AbstractBaseDataService.getLongPropertyFromDynamicObject(data, "createorg");
        if (0L == srcCreateOrgId || createOrgId == srcCreateOrgId || data.getDataEntityState().getFromDatabase()) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u6570\u636e\u662f\u539f\u59cb\u6570\u636e\u3001\u4fee\u6539\u3001\u539f\u521b\u5efa\u7ec4\u7ec7\u4e3a0\uff0c\u4e0d\u5904\u7406\u3002", (String)"CtsyIndividualizeService_3", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        String numberField = BaseDataCommonService.isOtherMasterIdType(entity) ? "masterid.number" : "number";
        String selectFields = FieldPropUtils.getSelectField("id", numberField, BaseDataServiceHelper.getMasterIdPropName((String)entity));
        DynamicObject[] srcData = BusinessDataServiceHelper.load((String)entity, (String)selectFields, (QFilter[])(qFilters = new QFilter[]{new QFilter(numberField, "=", (Object)(number = data.getString(numberField))), new QFilter("createorg", "=", (Object)srcCreateOrgId)}));
        if (srcData.length > 1) {
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s:\u201c\u7f16\u7801\u201d\uff0c\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u7ec4\u5408\u4e0d\u552f\u4e00\uff0c\u4e0d\u5904\u7406\u3002", (String)"CtsyIndividualizeService_4", (String)"bos-bd-business", (Object[])new Object[0]), number));
        }
        if (srcData.length == 0) {
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s:\u201c\u7f16\u7801\u201d\u5728\u201c\u539f\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406\u3002", (String)"CtsyIndividualizeService_5", (String)"bos-bd-business", (Object[])new Object[0]), number));
        }
        Long srcDataId = srcData[0].getLong("id");
        final HashSet<Long> srcDataIds = new HashSet<Long>(1);
        srcDataIds.add(srcDataId);
        final HashSet<Long> orgIds = new HashSet<Long>(1);
        orgIds.add(createOrgId);
        BaseDataResponse assignResponse = (new AssignService(this.entityId){

            private BaseDataResponse executeAssign(Long assignOrgId) {
                return super.assign(assignOrgId, null, (Set<Long>)srcDataIds, orgIds);
            }
        }).executeAssign(srcCreateOrgId);
        if (!assignResponse.isSuccess()) {
            return assignResponse;
        }
        return (new IndividualizeService(entity){

            private BaseDataResponse individualize() {
                return super.individualizeNotVerifyingRights(createOrgId, srcDataIds, entity);
            }
        }).individualize();
    }
}

