/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.service;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.ctsy.pojo.CtsyParam;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.SyncOpTypeEnum;
import kd.bos.bd.ctsy.service.CtsyCommonService;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.CtsyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyRetryService
extends CtsyCommonService {
    private static final Log LOGGER = LogFactory.getLog(CtsyRetryService.class);

    public void retry(List<Long> syncRecordIds) {
        if (CollectionUtils.isEmpty(syncRecordIds)) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])qFilters);
        boolean isMasterTenant = CtsyRetryService.ifCurrentTenantIsMaster(tenantMap);
        if (CollectionUtils.isEmpty((Map)tenantMap) || !isMasterTenant) {
            return;
        }
        Object[] syncRecordIdArr = syncRecordIds.toArray();
        DynamicObject[] syncRecords = BusinessDataServiceHelper.load((Object[])syncRecordIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ctsy_ctrlstrategy_sync"));
        this.markRecordAsSynchronized(syncRecords);
        for (DynamicObject syncRecord : syncRecords) {
            CtsyParam.CSTY_BASE_ASSIGN_THREAD_POOL.execute(() -> {
                String operateType = syncRecord.getString("optype");
                long syncRecordId = syncRecord.getLong("id");
                String uid = syncRecord.getString("uid");
                String entityId = syncRecord.getString("entityid");
                String numberPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? "masterid.number" : "number";
                Long assignOrgId = AbstractBaseDataService.getLongPropertyFromDynamicObject(syncRecord, "oporgid");
                String appId = syncRecord.getString("appid");
                DynamicObjectCollection dataCol = syncRecord.getDynamicObjectCollection("dataentryentity");
                DynamicObjectCollection orgCol = syncRecord.getDynamicObjectCollection("orgentryentity");
                Set<Long> dataIds = dataCol.stream().map(data -> data.getLong("dataid")).collect(Collectors.toSet());
                Set<Long> orgIds = orgCol.stream().map(org -> org.getLong("orgid")).collect(Collectors.toSet());
                String targetTenantNumber = syncRecord.getString("tartenantnumber");
                if (SyncOpTypeEnum.OP_ASSIGN.getOpType().equals(operateType) && this.validateParamIsEmpty(entityId, assignOrgId, dataIds, orgIds) || SyncOpTypeEnum.OP_INDIVIDUALIZATION.getOpType().equals(operateType) && this.validateParamIsEmpty(entityId, assignOrgId, dataIds)) {
                    CtsyRetryService.markSyncFail(syncRecordId, ResManager.loadKDString((String)"\u540c\u6b65\u8bb0\u5f55\u4e2d\u7684\u53c2\u6570\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CtsyRetryService_0", (String)"bos-bd-business", (Object[])new Object[0]));
                    return;
                }
                Map dataMap = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)numberPro, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
                Set<String> dataNumbers = dataMap.values().stream().map(dataObj -> dataObj.get(numberPro)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
                orgIds.add(assignOrgId);
                Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
                orgIds.remove(assignOrgId);
                Set<String> orgNumbers = orgMap.values().stream().map(orgObj -> orgObj.get("number")).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
                String useOrgNumber = Optional.ofNullable(orgMap.get(assignOrgId)).map(org -> org.getString("number")).orElse("");
                orgNumbers.remove(useOrgNumber);
                for (DynamicObject tarTenant : tenantMap.values()) {
                    if (!Objects.equals(targetTenantNumber, tarTenant.getString("number"))) continue;
                    if (SyncOpTypeEnum.OP_ASSIGN.getOpType().equals(operateType)) {
                        this.assignToChildTenant(entityId, appId, dataNumbers, orgNumbers, useOrgNumber, syncRecordId, tarTenant, uid);
                    } else {
                        this.individualizeToChildTenant(entityId, appId, dataNumbers, useOrgNumber, syncRecordId, tarTenant, uid);
                    }
                    return;
                }
                DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)syncRecordId, (String)"ctsy_ctrlstrategy_sync");
                record.set("syncstatus", (Object)CtsyRecordSyncStatus.FAIL.getStatus());
                record.set("remark", (Object)ResManager.loadKDString((String)"\u76ee\u6807\u79df\u6237\u4e0d\u5b58\u5728\u3002", (String)"CtsyRetryService_1", (String)"bos-bd-business", (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            });
        }
    }

    private void individualizeToChildTenant(String entityId, String appId, Set<String> dataNumbers, String useOrgNumber, long syncRecordId, DynamicObject tarTenant, String uid) {
        try {
            String accessToken;
            String tenantNumber = tarTenant.getString("number");
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(tarTenant.getString("serverip"));
            urlBuilder.append(":");
            urlBuilder.append(tarTenant.getString("serverport"));
            if (!StringUtils.isEmpty((CharSequence)tarTenant.getString("web_app"))) {
                urlBuilder.append(tarTenant.getString("web_app"));
            }
            if (null == (accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), tarTenant))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u201c%s\u201d\u7684access_token\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyRetryService_2", (String)"bos-bd-business", (Object[])new Object[0]), tenantNumber);
                throw new KDBizException(new ErrorCode("ERROR_CODE_1", errorMsg), new Object[]{errorMsg});
            }
            urlBuilder.append("/kapi/v2/ctsy/base/individualize");
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", accessToken);
            HashMap<String, Object> bodyMsg = new HashMap<String, Object>(10);
            HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(1);
            map.put("paramMap", bodyMsg);
            bodyMsg.put("entityid", entityId);
            bodyMsg.put("useOrgNumber", useOrgNumber);
            bodyMsg.put("uid", uid);
            bodyMsg.put("appid", appId);
            bodyMsg.put("dataNumbers", dataNumbers);
            LOGGER.info("ctsy tenant retry individualize url " + urlBuilder + ", param " + JSON.toJSONString(map));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(map), (int)defaultConnectionTimeout, (int)defaultReadTimeout);
            LOGGER.info("ctsy tenant retry individualize result " + result);
        }
        catch (KDBizException e) {
            LOGGER.error("ctsy tenant individualize KDBizException:", (Throwable)e);
            CtsyRetryService.markSyncFail(syncRecordId, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("ctsy tenant retry individualize error:", (Throwable)e);
            CtsyRetryService.markSyncFail(syncRecordId, String.format(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u201c%1$s\u201d\u5931\u8d25\uff1a%2$s", (String)"CtsyRetryService_3", (String)"bos-bd-business", (Object[])new Object[0]), tarTenant.getString("number"), e.getMessage()));
        }
    }

    private void assignToChildTenant(String entityId, String appId, Set<String> dataNumbers, Set<String> orgNumbers, String useOrgNumber, long syncRecordId, DynamicObject tarTenant, String uid) {
        try {
            String accessToken;
            String tenantNumber = tarTenant.getString("number");
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(tarTenant.getString("serverip"));
            urlBuilder.append(":");
            urlBuilder.append(tarTenant.getString("serverport"));
            if (!StringUtils.isEmpty((CharSequence)tarTenant.getString("web_app"))) {
                urlBuilder.append(tarTenant.getString("web_app"));
            }
            if (null == (accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), tarTenant))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u201c%s\u201d\u7684access_token\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyRetryService_2", (String)"bos-bd-business", (Object[])new Object[0]), tenantNumber);
                throw new KDBizException(new ErrorCode("ERROR_CODE_1", errorMsg), new Object[]{errorMsg});
            }
            urlBuilder.append("/kapi/v2/ctsy/base/assign");
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", accessToken);
            HashMap<String, Object> bodyMsg = new HashMap<String, Object>(10);
            HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(1);
            map.put("paramMap", bodyMsg);
            bodyMsg.put("entityid", entityId);
            bodyMsg.put("useOrgNumber", useOrgNumber);
            bodyMsg.put("uid", uid);
            bodyMsg.put("appid", appId);
            bodyMsg.put("orgNumbers", orgNumbers);
            bodyMsg.put("dataNumbers", dataNumbers);
            LOGGER.info("ctsy tenant retry assign url " + urlBuilder + ", param " + JSON.toJSONString(map));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(map), (int)defaultConnectionTimeout, (int)defaultReadTimeout);
            LOGGER.info("ctsy tenant retry assign result " + result);
        }
        catch (KDBizException e) {
            LOGGER.error("ctsy tenant assign KDBizException:", (Throwable)e);
            CtsyRetryService.markSyncFail(syncRecordId, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("ctsy tenant retry assign error:", (Throwable)e);
            DynamicObject syncRecord = BusinessDataServiceHelper.loadSingle((Object)syncRecordId, (String)"ctsy_ctrlstrategy_sync");
            syncRecord.set("syncstatus", (Object)CtsyRecordSyncStatus.FAIL.getStatus());
            syncRecord.set("remark", (Object)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u201c%1$s\u201d\u5931\u8d25\uff1a%2$s", (String)"CtsyRetryService_3", (String)"bos-bd-business", (Object[])new Object[0]), tarTenant.getString("number"), e.getMessage()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncRecord});
        }
    }

    private void markRecordAsSynchronized(DynamicObject[] syncRecords) {
        for (DynamicObject syncRecord : syncRecords) {
            syncRecord.set("syncstatus", (Object)CtsyRecordSyncStatus.SYNCHRONIZED.getStatus());
        }
        SaveServiceHelper.save((DynamicObject[])syncRecords);
    }
}

