/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.webapi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bd.ctsy.mq.CtsyUseRecordMQPublisher;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.SyncOpTypeEnum;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

@ApiController(value="AssignWebAPI", desc="MLang_bos-bd-business_AssignWebAPI_0")
public class AssignWebAPI
implements IBillWebApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(AssignWebAPI.class);
    private static final String PARAM_ERROR_CODE = "400";
    private static final String SERVER_ERROR_CODE = "500";
    private static final String UID = "uid";
    private static final String DATA_NUMBERS = "dataNumbers";
    private static final String ORG_NUMBERS = "orgNumbers";
    private static final String USE_ORG_NUMBER = "useOrgNumber";
    private static final String BOS_ORG_ENTITY = "bos_org";
    private static final String SYNC_STATUS = "syncStatus";
    private static final String REMARK = "remark";
    private static final String OP_ORG_ID = "oporgid";
    private static final String DATA_ENTRY_ENTITY = "dataentryentity";
    private static final String ORG_ENTRY_ENTITY = "orgentryentity";
    private static final String ENTITY_ID_LR = "entityid";
    private static final String APP_ID_LR = "appid";

    private static CustomApiResult<String> validateParamIsNotNull(Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"paramMap is empty.");
        }
        if (null == paramMap.get(UID)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"uid is null.");
        }
        if (null == paramMap.get(ORG_NUMBERS)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"orgNumbers is null.");
        }
        if (!(paramMap.get(ORG_NUMBERS) instanceof List)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"orgNumbers isn't List.");
        }
        if (null == paramMap.get(DATA_NUMBERS)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"dataNumbers is null.");
        }
        if (!(paramMap.get(DATA_NUMBERS) instanceof List)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"dataNumbers isn't List.");
        }
        if (StringUtils.isBlank((Object)paramMap.get(USE_ORG_NUMBER))) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"useOrgNumber is null or empty.");
        }
        return CustomApiResult.success(null);
    }

    @ApiPostMapping(value="/base/assign", desc="MLang_bos-bd-business_AssignWebAPI_0")
    public CustomApiResult<String> assign(@ApiParam(value="key is entityId,useOrgNumber,dataNumbers,orgNumbers,uid", required=true) @ApiParam(value="key is entityId,useOrgNumber,dataNumbers,orgNumbers,uid", required=true) Map<String, Object> paramMap) {
        CustomApiResult<String> validatedParamResult = AssignWebAPI.validateParamIsNotNull(paramMap);
        if (!validatedParamResult.isStatus()) {
            return validatedParamResult;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"save_assign_context_tx");){
            String uid = paramMap.get(UID).toString();
            String entityId = Optional.ofNullable(paramMap.get(ENTITY_ID_LR)).map(Object::toString).orElse("");
            this.saveAssignContextInfo(paramMap, uid, entityId);
            CtsyUseRecordMQPublisher.publish(entityId, uid);
            CustomApiResult customApiResult = CustomApiResult.success(null);
            return customApiResult;
        }
        catch (KDBizException e) {
            tx.markRollback();
            LOGGER.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5206\u914d\u4e0a\u4e0b\u6587\u4fe1\u606f\u5931\u8d25...", (String)"AssignWebAPI_1", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            CustomApiResult customApiResult = CustomApiResult.fail((String)SERVER_ERROR_CODE, (String)e.getMessage());
            return customApiResult;
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5206\u914d\u4e0a\u4e0b\u6587\u4fe1\u606f\u5931\u8d25...", (String)"AssignWebAPI_1", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            CustomApiResult customApiResult = CustomApiResult.fail((String)SERVER_ERROR_CODE, (String)String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5206\u914d\u4e0a\u4e0b\u6587\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"AssignWebAPI_2", (String)"bos-bd-business", (Object[])new Object[0]), e.getMessage()));
            return customApiResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void saveAssignContextInfo(Map<String, Object> paramMap, String uid, String entityId) {
        DynamicObject assignContext = BusinessDataServiceHelper.newDynamicObject((String)"ctsy_ctrlstrategy_sync");
        String useOrgNumber = paramMap.get(USE_ORG_NUMBER).toString();
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)useOrgNumber)};
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_ENTITY, (String)"id", (QFilter[])filters);
        if (null == org) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ec4\u7ec7\u5728\u5b50\u79df\u6237\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AssignWebAPI_3", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        assignContext.set(OP_ORG_ID, (Object)org);
        assignContext.set("optype", (Object)SyncOpTypeEnum.OP_ASSIGN.getOpType());
        assignContext.set(ENTITY_ID_LR, (Object)entityId);
        assignContext.set(APP_ID_LR, (Object)Optional.ofNullable(paramMap.get(APP_ID_LR)).map(Object::toString).orElse(""));
        assignContext.set(UID, (Object)uid);
        assignContext.set("syncstatus", (Object)CtsyRecordSyncStatus.SYNCHRONIZED.getStatus());
        DynamicObjectCollection dataEntry = assignContext.getDynamicObjectCollection(DATA_ENTRY_ENTITY);
        List dataNumberObjList = (List)SerializationUtils.fromJsonString((String)paramMap.get(DATA_NUMBERS).toString(), List.class);
        List<String> dataNumberList = dataNumberObjList.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        dataNumberList.forEach(n -> dataEntry.addNew().set("number", n));
        assignContext.set(DATA_ENTRY_ENTITY, (Object)dataEntry);
        DynamicObjectCollection orgEntry = assignContext.getDynamicObjectCollection(ORG_ENTRY_ENTITY);
        List orgNumberObjList = (List)SerializationUtils.fromJsonString((String)paramMap.get(ORG_NUMBERS).toString(), List.class);
        List<String> orgNumberList = orgNumberObjList.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        orgNumberList.forEach(n -> orgEntry.addNew().set("orgnumber", n));
        assignContext.set(ORG_ENTRY_ENTITY, (Object)orgEntry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assignContext});
    }

    @ApiPostMapping(value="/base/afterSyncRecordSave", desc="MLang_bos-bd-business_AssignWebAPI_1")
    public CustomApiResult<String> markAfterSyncRecord(@ApiParam(value="key is syncRecordId", required=true) @ApiParam(value="key is syncRecordId", required=true) Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"paramMap is empty.");
        }
        if (null == paramMap.get(UID)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"uid is null.");
        }
        if (null == paramMap.get(SYNC_STATUS)) {
            return CustomApiResult.fail((String)PARAM_ERROR_CODE, (String)"syncStatus is null.");
        }
        QFilter[] filters = new QFilter[]{new QFilter(UID, "=", (Object)paramMap.get(UID).toString())};
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"ctsy_ctrlstrategy_sync", (QFilter[])filters);
        if (null == record) {
            return CustomApiResult.fail((String)SERVER_ERROR_CODE, (String)"record not exist.");
        }
        record.set("syncstatus", (Object)paramMap.get(SYNC_STATUS).toString());
        record.set(REMARK, paramMap.get(REMARK));
        try {
            Map detail = (Map)paramMap.get("detail");
            if (!CollectionUtils.isEmpty((Map)detail)) {
                DynamicObjectCollection dataEntry = record.getDynamicObjectCollection(DATA_ENTRY_ENTITY);
                for (DynamicObject entry : dataEntry) {
                    String number = entry.getString("number");
                    Object reason = detail.get(number);
                    if (null == reason) continue;
                    entry.set("dataerrormsg", reason);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            return CustomApiResult.success(null);
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u540c\u6b65\u540e\uff0c\u6807\u8bb0\u72b6\u6001\u5931\u8d25...", (String)"AssignWebAPI_5", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            return CustomApiResult.fail((String)SERVER_ERROR_CODE, (String)ResManager.loadKDString((String)"\u540c\u6b65\u540e\uff0c\u6807\u8bb0\u72b6\u6001\u5931\u8d25\u3002", (String)"AssignWebAPI_6", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }
}

