/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.engine;

import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.pojo.UseRelBitDTO;
import kd.bos.bd.utils.KryoSerializerUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public abstract class AbstractBaseDataUseRelEngine {
    private static final Log LOGGER = LogFactory.getLog(AbstractBaseDataUseRelEngine.class);
    static final ThreadPool POOL = ThreadPools.newFixedThreadPool((String)"BASE_DATA_ENGINE", (int)10);
    private static DistributeSessionlessCache BASE_DATA_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BASE_DATA_USE_REL", false);

    public static void removeAllRelBitCache(String entity) {
        String type = AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entity);
        List keys = BASE_DATA_CACHE.getKeys(type);
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return;
        }
        BASE_DATA_CACHE.remove(type, keys.toArray(new String[0]));
    }

    public static void removeRelBitCache(String entity, Long orgId) {
        String type = AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entity);
        BASE_DATA_CACHE.remove(type, orgId.toString());
    }

    static Map<Long, BaseDataUseRelBit> queryUseRelBitFromCache(String entity, Collection<Long> orgIds) throws ExecutionException, InterruptedException {
        if (orgIds.isEmpty()) {
            return new HashMap<Long, BaseDataUseRelBit>(0);
        }
        String[] keys = new String[orgIds.size()];
        int i = 0;
        for (Long orgId : orgIds) {
            keys[i] = String.valueOf(orgId);
            ++i;
        }
        List cacheValues = BASE_DATA_CACHE.get(AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entity), keys);
        cacheValues.removeIf(Objects::isNull);
        if (CollectionUtils.isEmpty((Collection)cacheValues)) {
            return new HashMap<Long, BaseDataUseRelBit>(0);
        }
        HashMap<Long, BaseDataUseRelBit> useRelBitMap = new HashMap<Long, BaseDataUseRelBit>(orgIds.size());
        int size = cacheValues.size();
        if (size < BaseDataCommon.BATCH_MAX) {
            useRelBitMap.putAll(AbstractBaseDataUseRelEngine.cacheDeserializer(cacheValues));
        } else {
            int totalPage = size % BaseDataCommon.BATCH_MAX > 0 ? size / BaseDataCommon.BATCH_MAX + 1 : size / BaseDataCommon.BATCH_MAX;
            ArrayList<Future> futures = new ArrayList<Future>(totalPage);
            for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
                int fromIndex = pageNo * BaseDataCommon.BATCH_MAX;
                int toIndex = Math.min((pageNo + 1) * BaseDataCommon.BATCH_MAX, size);
                List values = cacheValues.subList(fromIndex, toIndex);
                futures.add(POOL.submit(() -> AbstractBaseDataUseRelEngine.cacheDeserializer(values)));
            }
            for (Future future : futures) {
                useRelBitMap.putAll((Map)future.get());
            }
        }
        return useRelBitMap;
    }

    static void updateCacheSingle(String entityId, Long orgId, BaseDataUseRelBit bit) {
        String newCacheValue = new String(KryoSerializerUtils.cacheSerializer(bit), StandardCharsets.ISO_8859_1);
        BASE_DATA_CACHE.put(AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entityId), String.valueOf(orgId), newCacheValue, Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    static void updateCache(String entity, Collection<BaseDataUseRelBit> values) throws ExecutionException, InterruptedException {
        HashMap<String, String> cacheData = new HashMap<String, String>(values.size());
        if (values.size() <= BaseDataCommon.BATCH_MAX) {
            cacheData.putAll(AbstractBaseDataUseRelEngine.cacheDataSerializer(values));
            BASE_DATA_CACHE.put(AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entity), cacheData, Integer.MAX_VALUE, TimeUnit.DAYS);
            return;
        }
        ArrayList<Future> futures = new ArrayList<Future>(10);
        ArrayList<BaseDataUseRelBit> params = new ArrayList<BaseDataUseRelBit>(BaseDataCommon.BATCH_MAX);
        for (BaseDataUseRelBit relBit : values) {
            params.add(relBit);
            if (params.size() != BaseDataCommon.BATCH_MAX.intValue()) continue;
            ArrayList<BaseDataUseRelBit> threadParams = new ArrayList<BaseDataUseRelBit>(params);
            futures.add(POOL.submit(() -> AbstractBaseDataUseRelEngine.cacheDataSerializer(threadParams)));
            params.clear();
        }
        if (!params.isEmpty()) {
            cacheData.putAll(AbstractBaseDataUseRelEngine.cacheDataSerializer(params));
        }
        if (!futures.isEmpty()) {
            for (Future future : futures) {
                cacheData.putAll((Map)future.get());
            }
        }
        BASE_DATA_CACHE.put(AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entity), cacheData, Integer.MAX_VALUE, TimeUnit.DAYS);
    }

    static void deleteCache(String entity, Collection<BaseDataUseRelBit> values) {
        if (values.isEmpty()) {
            return;
        }
        String[] keys = new String[values.size()];
        int index = 0;
        for (BaseDataUseRelBit value : values) {
            keys[index] = value.getOrgId().toString();
            ++index;
        }
        BASE_DATA_CACHE.remove(AbstractBaseDataUseRelEngine.getBaseDataBitCacheType(entity), keys);
    }

    static BaseDataUseRelBit createBaseDataUseRelBit(UseRelBitDTO dto) throws SQLException {
        BaseDataUseRelBit baseDataUseRelBit = new BaseDataUseRelBit();
        baseDataUseRelBit.setOrgId(dto.getOrgId());
        Blob blob = dto.getBlob();
        byte[] bytes = null == blob ? dto.getBytes() : blob.getBytes(1L, (int)blob.length());
        RoaringBitmap roaringBitmap = KryoSerializerUtils.desRoaringBitmapByteArr(bytes);
        if (null != roaringBitmap) {
            roaringBitmap.runOptimize();
        }
        baseDataUseRelBit.setBit(roaringBitmap);
        return baseDataUseRelBit;
    }

    private static Map<Long, BaseDataUseRelBit> cacheDeserializer(List<String> cacheValues) {
        HashMap<Long, BaseDataUseRelBit> useRelBitMap = new HashMap<Long, BaseDataUseRelBit>(cacheValues.size());
        for (String cacheValue : cacheValues) {
            byte[] bytes = cacheValue.getBytes(StandardCharsets.ISO_8859_1);
            BaseDataUseRelBit useRelBit = KryoSerializerUtils.cacheDeserializer(bytes);
            if (null == useRelBit) continue;
            useRelBitMap.put(useRelBit.getOrgId(), useRelBit);
        }
        return useRelBitMap;
    }

    private static Map<String, String> cacheDataSerializer(Collection<BaseDataUseRelBit> useRelBitList) {
        HashMap<String, String> cacheData = new HashMap<String, String>(useRelBitList.size());
        for (BaseDataUseRelBit relBit : useRelBitList) {
            byte[] bytes = KryoSerializerUtils.cacheSerializer(relBit);
            cacheData.put(relBit.getOrgId().toString(), new String(bytes, StandardCharsets.ISO_8859_1));
        }
        return cacheData;
    }

    private static String getBaseDataBitCacheType(String entityId) {
        RequestContext context = RequestContext.get();
        return String.format("bd_%s_%s", context.getAccountId(), entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void useBitTableHandler(String tableName, DBRoute route, String entity) {
        tableName = tableName.toUpperCase();
        String accountId = RequestContext.get().getAccountId();
        String type = String.format("bd_use_bit_table_%s", accountId);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)BASE_DATA_CACHE.get(type, tableName)))) {
            return;
        }
        String lockKey = String.format("bd_use_bit_table_%s_%s", accountId, entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)BASE_DATA_CACHE.get(type, tableName)))) {
                return;
            }
            if (DB.exitsTable((DBRoute)route, (String)tableName)) {
                BASE_DATA_CACHE.put(type, tableName, Boolean.TRUE.toString(), Integer.MAX_VALUE, TimeUnit.DAYS);
                return;
            }
            String createTableSqlFormat = "CREATE TABLE %s (FORGID BIGINT NOT NULL, FDATA BLOB NOT NULL, CONSTRAINT PK_%s PRIMARY KEY (FORGID))";
            String createBitTableSql = String.format(createTableSqlFormat, tableName, tableName);
            DB.execute((DBRoute)route, (String)createBitTableSql);
            BASE_DATA_CACHE.put(type, tableName, Boolean.TRUE.toString(), Integer.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u4f4d\u56fe\u8868\u5931\u8d25...", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    static class UseRelBitDtoDeserializerCallable
    implements Callable<Map<Long, BaseDataUseRelBit>> {
        private List<UseRelBitDTO> dtoList;

        UseRelBitDtoDeserializerCallable(List<UseRelBitDTO> dtoList) {
            this.dtoList = dtoList;
        }

        @Override
        public Map<Long, BaseDataUseRelBit> call() throws Exception {
            HashMap<Long, BaseDataUseRelBit> map = new HashMap<Long, BaseDataUseRelBit>(this.dtoList.size());
            for (UseRelBitDTO useRelBitDTO : this.dtoList) {
                BaseDataUseRelBit baseDataUseRelBit = AbstractBaseDataUseRelEngine.createBaseDataUseRelBit(useRelBitDTO);
                map.put(useRelBitDTO.getOrgId(), baseDataUseRelBit);
            }
            this.dtoList.clear();
            return map;
        }
    }
}

