/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.engine;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.engine.AbstractBaseDataUseRelEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.pojo.UseRelBitDTO;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkPublic;
import org.roaringbitmap.RoaringBitmap;

@SdkPublic
public class BaseDataUseRelQueryEngine
extends AbstractBaseDataUseRelEngine {
    private static final Log LOGGER = LogFactory.getLog(BaseDataUseRelQueryEngine.class);

    public static List<Integer> getUseBaseDataIndexByOrgId(Long orgId, String entityId) throws Exception {
        int[] indexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexArrByOrgId(orgId, entityId);
        return Arrays.stream(indexes).boxed().collect(Collectors.toList());
    }

    public static int[] getUseBaseDataIndexArrByOrgId(Long orgId, String entityId) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(Collections.singletonList(orgId), entityId);
        BaseDataUseRelBit relBit = useRelBitMap.get(orgId);
        if (null == relBit) {
            return new int[0];
        }
        RoaringBitmap bit = relBit.getBit();
        if (null == bit) {
            return new int[0];
        }
        return bit.toArray();
    }

    public static Map<Long, RoaringBitmap> getOrgUseRelBitMapByOrgIds(Collection<Long> orgIds, String entity) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
        HashMap<Long, RoaringBitmap> orgBitMap = new HashMap<Long, RoaringBitmap>(useRelBitMap.size());
        for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
            RoaringBitmap bit;
            BaseDataUseRelBit value = entry.getValue();
            if (null == value || null == (bit = value.getBit())) continue;
            orgBitMap.put(entry.getKey(), bit);
        }
        return orgBitMap;
    }

    public static Set<Integer> getAllUseBitByOrgIds(Collection<Long> orgIds, String entity) {
        try {
            RoaringBitmap resultBit = new RoaringBitmap();
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
            for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
                BaseDataUseRelBit value = entry.getValue();
                RoaringBitmap bit = value.getBit();
                if (null == bit) continue;
                resultBit.or(bit);
                resultBit.runOptimize();
            }
            return Arrays.stream(resultBit.toArray()).boxed().collect(Collectors.toSet());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4f4d\u56fe\u6570\u636e\u5f02\u5e38...", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public static Map<Long, BaseDataUseRelBit> getRelBitMapByOrgIds(Collection<Long> orgIds, String entity) throws Exception {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        String tableName = dt.getAlias() + "_bit";
        return BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity, tableName, DBRoute.of((String)dt.getDBRouteKey()));
    }

    public static Map<Long, BaseDataUseRelBit> getRelBitMapByOrgIds(Collection<Long> orgIds, String entity, String tableName, DBRoute route) throws Exception {
        Map<Long, BaseDataUseRelBit> relBitCache = BaseDataUseRelQueryEngine.queryUseRelBitFromCache(entity, orgIds);
        HashSet<Long> useOrgIds = new HashSet<Long>(orgIds);
        if (relBitCache.size() == useOrgIds.size()) {
            return relBitCache;
        }
        relBitCache.clear();
        return BaseDataUseRelQueryEngine.compensateAndReturnBitData(useOrgIds, entity, tableName, route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, BaseDataUseRelBit> compensateAndReturnBitData(Collection<Long> orgIds, String entity, String tableName, DBRoute route) throws Exception {
        String lockKey = BaseDataCommon.getBaseDataUnifiedLockKey(entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Map<Long, BaseDataUseRelBit> cacheData = BaseDataUseRelQueryEngine.queryUseRelBitFromCache(entity, orgIds);
            if (cacheData.size() == orgIds.size()) {
                Map<Long, BaseDataUseRelBit> map = cacheData;
                return map;
            }
            orgIds.removeAll(cacheData.keySet());
            int batchCount = 5000;
            int size = orgIds.size();
            ArrayList<Long> needCompensateOrgIds = new ArrayList<Long>(orgIds);
            int totalPage = size % batchCount > 0 ? size / batchCount + 1 : size / batchCount;
            for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
                int fromIndex = pageNo * batchCount;
                int toIndex = Math.min((pageNo + 1) * batchCount, size);
                ArrayList<Long> values = new ArrayList<Long>(needCompensateOrgIds.subList(fromIndex, toIndex));
                cacheData.putAll(BaseDataUseRelQueryEngine.batchCompensateBitData(values, entity, tableName, route));
            }
            Map<Long, BaseDataUseRelBit> map = cacheData;
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    private static Map<Long, BaseDataUseRelBit> batchCompensateBitData(Collection<Long> orgIds, String entity, String tableName, DBRoute route) throws Exception {
        Map<Long, BaseDataUseRelBit> dbBitData = BaseDataUseRelQueryEngine.getRelBitMapFromDbByOrgIds(orgIds, entity, tableName, route);
        orgIds.removeAll(dbBitData.keySet());
        if (!dbBitData.isEmpty()) {
            BaseDataUseRelQueryEngine.updateCache(entity, dbBitData.values());
        }
        if (orgIds.isEmpty()) {
            return dbBitData;
        }
        HashMap<Long, BaseDataUseRelBit> emptyBitData = new HashMap<Long, BaseDataUseRelBit>(orgIds.size());
        for (Long orgId : orgIds) {
            BaseDataUseRelBit baseDataUseRelBit = new BaseDataUseRelBit();
            baseDataUseRelBit.setOrgId(orgId);
            RoaringBitmap roaringBitmap = new RoaringBitmap();
            roaringBitmap.runOptimize();
            baseDataUseRelBit.setBit(roaringBitmap);
            emptyBitData.put(orgId, baseDataUseRelBit);
        }
        BaseDataUseRelUpdateEngine.insert(emptyBitData.values(), entity, tableName, route);
        BaseDataUseRelQueryEngine.updateCache(entity, emptyBitData.values());
        emptyBitData.putAll(dbBitData);
        return emptyBitData;
    }

    private static Map<Long, BaseDataUseRelBit> getRelBitMapFromDbByOrgIds(Collection<Long> orgIds, String entity, String tableName, DBRoute route) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, BaseDataUseRelBit>(0);
        }
        BaseDataUseRelQueryEngine.useBitTableHandler(tableName, route, entity);
        int i = 0;
        StringJoiner joiner = new StringJoiner(String.valueOf(','));
        Object[] params = new Object[orgIds.size()];
        for (Long orgId : orgIds) {
            params[i] = orgId;
            joiner.add("?");
            ++i;
        }
        String idCondition = joiner.toString();
        String selectSql = String.format("select forgid,fdata from %s where forgid in (%s);", tableName, idCondition);
        return (Map)DB.query((DBRoute)route, (String)selectSql, (Object[])params, BaseDataUseRelQueryEngine::handleDbResultSet);
    }

    public static Map<Long, BaseDataUseRelBit> getCURelBitMapByEntity(String entity) throws Exception {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            return Collections.emptyMap();
        }
        String selectSql = String.format("select forgid from t_org_structure where fisctrlunit = '1' and fviewid = %s;", ctrlView.getPkValue());
        List orgIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, resultSet -> {
            ArrayList<Long> result = new ArrayList<Long>(10);
            while (resultSet.next()) {
                result.add(resultSet.getLong("forgid"));
            }
            return result;
        });
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return Collections.emptyMap();
        }
        return BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
    }

    public static Map<Long, BaseDataUseRelBit> getAllRelBitMapByEntity(String entity) throws Exception {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            return Collections.emptyMap();
        }
        long viewId = Long.parseLong(ctrlView.getPkValue().toString());
        List orgIds = OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return Collections.emptyMap();
        }
        return BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
    }

    protected static Map<Long, BaseDataUseRelBit> getCURelBitMapByEntityFromDb(String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            return Collections.emptyMap();
        }
        IDataEntityType entityType = ORM.create().newDynamicObject(entity).getDataEntityType();
        String tableName = entityType.getAlias() + "_bit";
        DBRoute route = DBRoute.of((String)entityType.getDBRouteKey());
        BaseDataUseRelQueryEngine.useBitTableHandler(tableName, route, entity);
        String selectSql = String.format("select r.forgid, r.fdata from %s r join t_org_structure o on r.forgid = o.forgid where o.fisctrlunit = '1' and fviewid = %s;", tableName, ctrlView.getPkValue());
        return (Map)DB.query((DBRoute)route, (String)selectSql, null, BaseDataUseRelQueryEngine::handleDbResultSet);
    }

    protected static Map<Long, BaseDataUseRelBit> getAllRelBitMapByEntityFromDb(String entity) {
        IDataEntityType entityType = ORM.create().newDynamicObject(entity).getDataEntityType();
        String tableName = entityType.getAlias() + "_bit";
        DBRoute route = DBRoute.of((String)entityType.getDBRouteKey());
        BaseDataUseRelQueryEngine.useBitTableHandler(tableName, route, entity);
        String selectSql = String.format("select forgid,fdata from %s;", tableName);
        return (Map)DB.query((DBRoute)route, (String)selectSql, null, BaseDataUseRelQueryEngine::handleDbResultSet);
    }

    private static Map<Long, BaseDataUseRelBit> handleDbResultSet(ResultSet resultSet) throws SQLException, ExecutionException, InterruptedException {
        ArrayList<UseRelBitDTO> batchData = new ArrayList<UseRelBitDTO>(BaseDataCommon.BATCH_MAX);
        ArrayList<Future> futures = new ArrayList<Future>(10);
        while (resultSet.next()) {
            Long orgId = resultSet.getLong("forgid");
            batchData.add(new UseRelBitDTO(orgId, null, resultSet.getBytes("fdata")));
            if (batchData.size() % BaseDataCommon.BATCH_MAX != 0) continue;
            AbstractBaseDataUseRelEngine.UseRelBitDtoDeserializerCallable callable = new AbstractBaseDataUseRelEngine.UseRelBitDtoDeserializerCallable(new ArrayList<UseRelBitDTO>(batchData));
            futures.add(POOL.submit((Callable)callable));
            batchData.clear();
        }
        HashMap<Long, BaseDataUseRelBit> result = new HashMap<Long, BaseDataUseRelBit>(16);
        if (!batchData.isEmpty()) {
            for (UseRelBitDTO useRelBitDTO : batchData) {
                result.put(useRelBitDTO.getOrgId(), BaseDataUseRelQueryEngine.createBaseDataUseRelBit(useRelBitDTO));
            }
        }
        if (!futures.isEmpty()) {
            for (Future future : futures) {
                result.putAll((Map)future.get());
            }
        }
        return result;
    }

    public static int[] getUseBaseDataIndexArrByOrgId(List<Long> orgIds, String entityId) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entityId);
        RoaringBitmap bitMap = new RoaringBitmap();
        for (BaseDataUseRelBit baseDataUseRelBit : useRelBitMap.values()) {
            if (baseDataUseRelBit == null || baseDataUseRelBit.getBit() == null) continue;
            bitMap.add(baseDataUseRelBit.getBit().toArray());
        }
        return bitMap.toArray();
    }
}

