/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.engine.AbstractBaseDataUseRelEngine;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.utils.KryoSerializerUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataUseRelUpdateEngine
extends AbstractBaseDataUseRelEngine {
    private static final Log LOGGER = LogFactory.getLog(BaseDataUseRelUpdateEngine.class);

    public static void insert(Collection<BaseDataUseRelBit> newUseRelBits, String entity) throws Exception {
        DynamicObject baseDataEntity = ORM.create().newDynamicObject(entity);
        String tableName = baseDataEntity.getDataEntityType().getAlias() + "_bit";
        String routeKey = baseDataEntity.getDataEntityType().getDBRouteKey();
        BaseDataUseRelUpdateEngine.insert(newUseRelBits, entity, tableName, DBRoute.of((String)routeKey));
    }

    public static void insert(Collection<BaseDataUseRelBit> newUseRelBits, String entity, String tableName, DBRoute route) throws Exception {
        if (!CollectionUtils.isEmpty(newUseRelBits)) {
            String insertSql = String.format("insert into %s (fdata, forgid) values (?,?);", tableName);
            BaseDataUseRelUpdateEngine.saveOrUpdateUseRelBit(newUseRelBits, entity, insertSql, route, tableName);
        }
    }

    public static void update(Collection<BaseDataUseRelBit> useRelBits, String entity, String tableName, DBRoute route) throws Exception {
        if (!CollectionUtils.isEmpty(useRelBits)) {
            String updateSql = String.format("update %s set fdata = ? where forgid = ?;", tableName);
            BaseDataUseRelUpdateEngine.saveOrUpdateUseRelBit(useRelBits, entity, updateSql, route, tableName);
        }
    }

    public static void update(Collection<BaseDataUseRelBit> useRelBits, String entity) throws Exception {
        DynamicObject baseDataEntity = ORM.create().newDynamicObject(entity);
        String routeKey = baseDataEntity.getDataEntityType().getDBRouteKey();
        String tableName = baseDataEntity.getDataEntityType().getAlias() + "_bit";
        BaseDataUseRelUpdateEngine.update(useRelBits, entity, tableName, DBRoute.of((String)routeKey));
    }

    private static void saveOrUpdateUseRelBit(Collection<BaseDataUseRelBit> useRelBits, String entity, String sql, DBRoute route, String tableName) throws Exception {
        int batchMax = BaseDataCommon.getBatchMax();
        BaseDataUseRelUpdateEngine.useBitTableHandler(tableName, route, entity);
        if (useRelBits.size() <= batchMax) {
            BaseDataUseRelUpdateEngine.saveOrUpdateUseRelBitOnTx(entity, sql, useRelBits, route);
            return;
        }
        ArrayList<BaseDataUseRelBit> batchData = null;
        ArrayList<Future> futures = new ArrayList<Future>(10);
        Iterator<BaseDataUseRelBit> iterator = useRelBits.iterator();
        while (iterator.hasNext()) {
            if (null == batchData) {
                batchData = new ArrayList<BaseDataUseRelBit>(batchMax);
            }
            batchData.add(iterator.next());
            iterator.remove();
            if (batchData.size() % batchMax != 0) continue;
            futures.add(POOL.submit((Callable)new UseRelUpdateCallable(entity, sql, batchData, route), RequestContext.get()));
            batchData = null;
        }
        if (!CollectionUtils.isEmpty(batchData)) {
            BaseDataUseRelUpdateEngine.saveOrUpdateUseRelBitOnTx(entity, sql, batchData, route);
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private static void saveOrUpdateUseRelBitOnTx(String entity, String sql, Collection<BaseDataUseRelBit> batchData, DBRoute route) {
        try (TXHandle tx = TX.requiresNew((String)"save_or_update_rel_bit_tx");){
            try {
                BaseDataUseRelUpdateEngine.executeBatchSql(sql, BaseDataUseRelUpdateEngine.buildSqlParams(batchData), route);
                BaseDataUseRelUpdateEngine.updateCache(entity, batchData);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5b58\u50a8\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u5b58\u50a8\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38\u3002", (String)"BaseDataUseRelUpdateEngine_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private static void executeBatchSql(String sql, List<Object[]> paramList, DBRoute route) {
        DB.executeBatch((DBRoute)route, (String)sql, paramList);
        paramList.clear();
    }

    private static List<Object[]> buildSqlParams(Collection<BaseDataUseRelBit> batchData) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(BaseDataCommon.getBatchMax());
        for (BaseDataUseRelBit useRelBit : batchData) {
            params.add(new Object[]{KryoSerializerUtils.serRoaringBitmap(useRelBit.getBit()), useRelBit.getOrgId()});
        }
        return params;
    }

    static class UseRelUpdateCallable
    implements Callable<Boolean> {
        private String entity;
        private String sql;
        private List<BaseDataUseRelBit> batchData;
        private DBRoute route;

        UseRelUpdateCallable(String entity, String sql, List<BaseDataUseRelBit> batchData, DBRoute route) {
            this.entity = entity;
            this.sql = sql;
            this.batchData = batchData;
            this.route = route;
        }

        @Override
        public Boolean call() {
            BaseDataUseRelUpdateEngine.saveOrUpdateUseRelBitOnTx(this.entity, this.sql, this.batchData, this.route);
            this.batchData.clear();
            return true;
        }
    }
}

