/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class OrgSaveEventBDCtrlServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(OrgSaveEventBDCtrlServicePlugin.class);
    private static final String BEC_EVENT_OPERATION_PARAMS = "becEventOperationParams";
    private static final String SYSTEM_TYPE = "bos-bd-business";

    public Object handleEvent(KDBizEvent evt) {
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605\u3011\u5f00\u59cb\u66f4\u65b0\u7ba1\u63a7\u7b56\u7565");
        JSONObject params = this.getBecEventOperationParams(evt);
        if (params == null) {
            return null;
        }
        HashMap<Long, List<String>> addCtrlUnitMap = new HashMap<Long, List<String>>(64);
        HashMap<Long, List<String>> cancelCtrlUnitMap = new HashMap<Long, List<String>>(64);
        this.getChangedData(params, "add", addCtrlUnitMap, cancelCtrlUnitMap);
        this.getChangedData(params, "update", addCtrlUnitMap, cancelCtrlUnitMap);
        Map<Long, Set<Long>> viewOrgMap = this.getViewOrgInfoFromSaveEvt(params);
        if (!viewOrgMap.isEmpty()) {
            this.autoAssignData(viewOrgMap);
            this.afterSetCtrlUintHandle(viewOrgMap);
        }
        try {
            this.saveSetCtrlLog(viewOrgMap);
            this.saveCancelCtrlLog(cancelCtrlUnitMap);
        }
        catch (Exception e) {
            logger.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605\u3011\u5b8c\u6210\u66f4\u65b0\u7ba1\u63a7\u7b56\u7565");
        return null;
    }

    private void saveCancelCtrlLog(Map<Long, List<String>> cancelCtrlUnitMap) {
        if (CollectionUtils.isEmpty(cancelCtrlUnitMap)) {
            return;
        }
        for (Map.Entry<Long, List<String>> entry : cancelCtrlUnitMap.entrySet()) {
            Long viewId = entry.getKey();
            List<Long> orgIds = entry.getValue().stream().map(Long::valueOf).collect(Collectors.toList());
            BDCtrlLogHelper.saveCancelCtrlUnitLog(viewId, orgIds);
        }
    }

    private void saveSetCtrlLog(Map<Long, Set<Long>> viewOrgMap) {
        if (CollectionUtils.isEmpty(viewOrgMap)) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : viewOrgMap.entrySet()) {
            Long viewId = entry.getKey();
            BDCtrlLogHelper.saveSetCtrlUnitLog(viewId, new ArrayList<Long>((Collection)entry.getValue()));
        }
    }

    private void afterSetCtrlUintHandle(Map<Long, Set<Long>> viewOrgMap) {
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605\u3011\u5f00\u59cbafterSetCtrlUintHandle\u5904\u7406\u8bbe\u7f6e\u4e3a\u7ba1\u63a7\u5355\u5143\u540e\u6e05\u9664\u5206\u914d\u6570\u636e\u7684\u64cd\u4f5c");
        for (Map.Entry<Long, Set<Long>> entry : viewOrgMap.entrySet()) {
            List orgIds = entry.getValue().stream().map(Object::toString).collect(Collectors.toList());
            try {
                BaseDataServiceHelper.afterSetCtrlUintHandle((String)entry.getKey().toString(), orgIds);
            }
            catch (Exception e) {
                logger.error("\u8bbe\u7f6e\u4e3a\u7ba1\u63a7\u5355\u5143\u540e\u6e05\u9664\u5206\u914d\u6570\u636e\u7684\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            }
        }
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605\u3011\u5b8c\u6210afterSetCtrlUintHandle\u5904\u7406\u8bbe\u7f6e\u4e3a\u7ba1\u63a7\u5355\u5143\u540e\u6e05\u9664\u5206\u914d\u6570\u636e\u7684\u64cd\u4f5c");
    }

    private void getChangedData(JSONObject params, String operation, Map<Long, List<String>> addCtrlUnitMap, Map<Long, List<String>> cancelCtrlUnitMap) {
        JSONObject opJson = params.getJSONObject(operation);
        if (opJson == null) {
            return;
        }
        Set entries = opJson.entrySet();
        for (Map.Entry orgEntry : entries) {
            JSONObject idJson = (JSONObject)orgEntry.getValue();
            JSONObject entityJson = idJson.getJSONObject("structure");
            if (entityJson == null) continue;
            long id = Long.parseLong((String)orgEntry.getKey());
            this.getChangedProperty(id, entityJson, addCtrlUnitMap, cancelCtrlUnitMap);
        }
    }

    private void getChangedProperty(long id, JSONObject entityJson, Map<Long, List<String>> addCtrlUnitMap, Map<Long, List<String>> cancelCtrlUnitMap) {
        JSONObject proJson = entityJson.getJSONObject("property");
        if (proJson == null) {
            return;
        }
        Set entrySet = proJson.entrySet();
        for (Map.Entry viewEntry : entrySet) {
            JSONObject viewJson = (JSONObject)viewEntry.getValue();
            JSONObject cuJson = viewJson.getJSONObject("isctrlunit");
            if (cuJson == null) continue;
            Object newValue = cuJson.get((Object)"newValue");
            if (StringUtils.isNotBlank((Object)newValue) && Boolean.parseBoolean(newValue.toString())) {
                addCtrlUnitMap.computeIfAbsent(Long.valueOf((String)viewEntry.getKey()), v -> new ArrayList(64)).add(Long.toString(id));
            }
            if (!StringUtils.isNotBlank((Object)newValue) || Boolean.parseBoolean(newValue.toString())) continue;
            cancelCtrlUnitMap.computeIfAbsent(Long.valueOf((String)viewEntry.getKey()), v -> new ArrayList(64)).add(Long.toString(id));
        }
    }

    private JSONObject getBecEventOperationParams(KDBizEvent evt) {
        String evtVariables = evt.getVariables();
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605\u3011\u7ec4\u7ec7\u4fdd\u5b58\u64cd\u4f5c\u4f20\u9012\u7684\u64cd\u4f5c\u53c2\u6570\uff1a" + evtVariables);
        if (StringUtils.isBlank((CharSequence)evtVariables)) {
            return null;
        }
        JSONObject paramJsonObj = JSON.parseObject((String)evtVariables);
        Object opParamJson = paramJsonObj.get((Object)BEC_EVENT_OPERATION_PARAMS);
        if (StringUtils.isBlank((Object)opParamJson)) {
            return null;
        }
        return JSON.parseObject((String)opParamJson.toString());
    }

    private Map<Long, Set<Long>> getViewOrgInfoFromSaveEvt(JSONObject params) {
        JSONObject addJson = params.getJSONObject("add");
        Map<Long, Set<Long>> newViewOrgMap = this.getNewViewOrgMap(addJson);
        HashMap<Long, Set<Long>> ctrlUnitData = new HashMap<Long, Set<Long>>(16);
        JSONObject updateJson = params.getJSONObject("update");
        Map<Long, Set<Long>> updateViewOrgMap = this.getUpdateViewOrgMap(updateJson, ctrlUnitData);
        this.selectCuOrgFromDb(newViewOrgMap, updateViewOrgMap, ctrlUnitData);
        return ctrlUnitData;
    }

    private Map<Long, Set<Long>> getNewViewOrgMap(JSONObject addJson) {
        if (null == addJson) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry entry : addJson.entrySet()) {
            JSONObject proJson;
            JSONObject orgJson = (JSONObject)entry.getValue();
            JSONObject structureJson = orgJson.getJSONObject("structure");
            if (structureJson == null || (proJson = structureJson.getJSONObject("property")) == null) continue;
            long orgId = Long.parseLong((String)entry.getKey());
            proJson.keySet().forEach(e -> result.computeIfAbsent(Long.parseLong(e), k -> new HashSet(16)).add(orgId));
        }
        return result;
    }

    private Map<Long, Set<Long>> getUpdateViewOrgMap(JSONObject updateJson, Map<Long, Set<Long>> ctrlUnitData) {
        if (null == updateJson) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Set<Long>> viewParentOrgMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry entry : updateJson.entrySet()) {
            JSONObject orgJson = (JSONObject)entry.getValue();
            JSONObject structureJson = orgJson.getJSONObject("structure");
            if (structureJson == null) continue;
            long orgId = Long.parseLong((String)entry.getKey());
            JSONObject addJson = structureJson.getJSONObject("add");
            if (null != addJson) {
                addJson.keySet().forEach(e -> result.computeIfAbsent(Long.parseLong(e), k -> new HashSet(16)).add(orgId));
            }
            this.collCtrlUnitData(structureJson.getJSONObject("property"), orgId, ctrlUnitData, viewParentOrgMap);
        }
        this.collectSubOrg(viewParentOrgMap, result);
        return result;
    }

    private void collectSubOrg(Map<Long, Set<Long>> viewParentOrgMap, Map<Long, Set<Long>> viewOrgMap) {
        if (viewParentOrgMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : viewParentOrgMap.entrySet()) {
            List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)entry.getKey(), new ArrayList(entry.getValue()), (boolean)true, (boolean)false);
            if (CollectionUtils.isEmpty((Collection)orgIds)) continue;
            viewOrgMap.computeIfAbsent(entry.getKey(), k -> new HashSet(16)).addAll(orgIds);
        }
    }

    private void collCtrlUnitData(JSONObject proJson, Long orgId, Map<Long, Set<Long>> ctrlUnitData, Map<Long, Set<Long>> viewParentOrgMap) {
        if (null == proJson) {
            return;
        }
        for (Map.Entry viewEntry : proJson.entrySet()) {
            JSONObject parentJson;
            Object newValue;
            Long viewId = Long.valueOf((String)viewEntry.getKey());
            JSONObject viewJson = (JSONObject)viewEntry.getValue();
            JSONObject cuJson = viewJson.getJSONObject("isctrlunit");
            if (null != cuJson && StringUtils.isNotBlank((Object)(newValue = cuJson.get((Object)"newValue"))) && Boolean.parseBoolean(newValue.toString())) {
                ctrlUnitData.computeIfAbsent(viewId, k -> new HashSet(16)).add(orgId);
            }
            if ((parentJson = viewJson.getJSONObject("viewparent")) == null || Objects.equals(parentJson.get((Object)"newValue"), parentJson.get((Object)"oldValue"))) continue;
            viewParentOrgMap.computeIfAbsent(viewId, k -> new HashSet(16)).add(orgId);
        }
    }

    private void selectCuOrgFromDb(Map<Long, Set<Long>> newViewOrgMap, Map<Long, Set<Long>> updateViewOrgMap, Map<Long, Set<Long>> ctrlUnitData) {
        if (newViewOrgMap.isEmpty() && updateViewOrgMap.isEmpty()) {
            return;
        }
        HashSet<Long> viewIds = new HashSet<Long>(newViewOrgMap.keySet());
        viewIds.addAll(updateViewOrgMap.keySet());
        HashSet orgIds = new HashSet(16);
        newViewOrgMap.values().forEach(orgIds::addAll);
        updateViewOrgMap.values().forEach(orgIds::addAll);
        QFilter[] filters = new QFilter[]{new QFilter("view", "in", viewIds), new QFilter("org", "in", orgIds), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE)};
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org_structure", "view, org", filters);){
            for (Row row : ds) {
                Long viewId = row.getLong("view");
                Long orgId = row.getLong("org");
                Set<Long> ids = newViewOrgMap.get(viewId);
                if (!CollectionUtils.isEmpty(ids) && ids.contains(orgId)) {
                    ctrlUnitData.computeIfAbsent(viewId, k -> new HashSet(16)).add(orgId);
                    continue;
                }
                ids = updateViewOrgMap.get(viewId);
                if (CollectionUtils.isEmpty(ids) || !ids.contains(orgId)) continue;
                ctrlUnitData.computeIfAbsent(viewId, k -> new HashSet(16)).add(orgId);
            }
        }
    }

    private void autoAssignData(Map<Long, Set<Long>> viewOrgMap) {
        if (CollectionUtils.isEmpty(viewOrgMap)) {
            return;
        }
        try {
            DynamicObject[] strategies;
            StringJoiner entityNameJoiner = new StringJoiner("\uff0c");
            HashSet<String> viewNames = new HashSet<String>(16);
            HashMap<String, Long> entityViewMap = new HashMap<String, Long>(viewOrgMap.size());
            QFilter[] filters = new QFilter[]{new QFilter("ctrlview", "in", viewOrgMap.keySet()), new QFilter("autoassign", "=", (Object)Boolean.TRUE)};
            for (DynamicObject strategy : strategies = BusinessDataServiceHelper.load((String)"bd_bddefctrlstrtgy", (String)"basedataid, ctrlview", (QFilter[])filters)) {
                DynamicObject view = strategy.getDynamicObject("ctrlview");
                DynamicObject entity = strategy.getDynamicObject("basedataid");
                if (null == view || null == entity) continue;
                entityViewMap.put(entity.getPkValue().toString(), view.getLong("id"));
                entityNameJoiner.add(entity.getString("name"));
                viewNames.add(view.getString("name"));
            }
            if (!entityViewMap.isEmpty()) {
                this.sendAutoAssignTask(viewOrgMap, entityViewMap);
                this.sendAutoAssignMessage(viewNames.size(), entityViewMap.size(), entityNameJoiner.toString(), String.join((CharSequence)"\uff0c", viewNames));
            }
        }
        catch (Exception e) {
            logger.error("\u7ec4\u7ec7\u8c03\u6574\u5f00\u542f\u81ea\u52a8\u5206\u914d\u57fa\u7840\u8d44\u6599\u5927\u4efb\u52a1\u53d1\u751f\u5f02\u5e38...", (Throwable)e);
        }
    }

    private void sendAutoAssignTask(Map<Long, Set<Long>> viewOrgMap, Map<String, Long> entityViewMap) {
        JobInfo createJob = this.createRuntimeJob(viewOrgMap, entityViewMap);
        JobFormInfo jobFormInfo = new JobFormInfo(createJob);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"OrgSaveEventBDCtrlServicePlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("task_source", "event_org_save");
        jobFormInfo.setParams(params);
        jobFormInfo.setClickClassName("kd.bos.bd.task.AutoAssignTaskClick");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)createJob);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskClientProxy.addTask((JobFormInfo)jobFormInfo, (TaskInfo)taskInfo, null);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"BOSSchedule-task-background-monitor", (Runnable)subscriber);
        }
    }

    private JobInfo createRuntimeJob(Map<Long, Set<Long>> viewOrgMap, Map<String, Long> entityViewMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(ResManager.loadKDString((String)"\u7ec4\u7ec7\u66f4\u65b0\uff0c\u81ea\u52a8\u5206\u914d\u5173\u8054\u53d7\u63a7\u8d44\u6599\u4efb\u52a1", (String)"OrgSaveEventBDCtrlServicePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.bos.bd.task.AutoAssignJobTask");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("task_source", "event_org_save");
        params.put("task_view_org", SerializationUtils.toJsonString(viewOrgMap));
        params.put("task_entity_view", SerializationUtils.toJsonString(entityViewMap));
        jobInfo.setParams(params);
        return jobInfo;
    }

    private void sendAutoAssignMessage(int viewSize, int entitySize, String entityName, String viewName) {
        try {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setType("message");
            String title = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u81ea\u52a8\u5206\u914d\u901a\u77e5", (String)"OrgSaveEventBDCtrlServicePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
            messageInfo.setMessageTag((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u914d", (String)"OrgSaveEventBDCtrlServicePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0])));
            String content = ResManager.loadKDString((String)"\u56e0\u5f00\u542f\u4e86\u7ec4\u7ec7\u66f4\u65b0\u81ea\u52a8\u5206\u914d\u57fa\u7840\u8d44\u6599\u7684\u63a7\u5236\uff0c\u672c\u6b21\u7ec4\u7ec7\u4fe1\u606f\u66f4\u65b0\u5171\u6d89\u53ca\u3010%1$s\u3011%2$s\u4e2a\u89c6\u56fe\uff0c\u4f1a\u89e6\u53d1\u3010%3$s\u3011%4$s\u4e2a\u76f8\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u81ea\u52a8\u5206\u914d\uff0c\u8be6\u7ec6\u5206\u914d\u7ed3\u679c\u8bf7\u67e5\u770b\u7ba1\u63a7\u65e5\u5fd7\u3002", (String)"OrgSaveEventBDCtrlServicePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messageInfo.setMessageContent((ILocaleString)new LocaleString(String.format(content, viewName, viewSize, entityName, entitySize)));
            messageInfo.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
            ArrayList<Long> userIds = new ArrayList<Long>(Collections.singletonList(RequestContext.get().getCurrUserId()));
            messageInfo.setUserIds(userIds);
            messageInfo.setEntityNumber("bd_autoassign");
            messageInfo.setNestEntityNumber("bd_autoassign");
            messageInfo.setBizDataId(Long.valueOf(-1L));
            messageInfo.setNestBillId(Long.valueOf(-1L));
            messageInfo.setNestBillno("OrgSaveEventBDCtrlServicePlugin");
            MessageCenterServiceHelper.batchSendMessages(new ArrayList<MessageInfo>(Collections.singletonList(messageInfo)));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u7559\u75d5\u901a\u77e5\u5931\u8d25\uff0c\u8bb0\u5f55\u4e00\u4e0b\u65e5\u5fd7\uff0c\u4e0d\u80fd\u5f71\u54cd\u81ea\u52a8\u5206\u914d\u4e3b\u8981\u6d41\u7a0b.", (Throwable)e);
        }
    }
}

