/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ext.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class BaseDataOrgRelExtService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataOrgRelExtService.class);
    private static final int QUERY_MAX_SIZE = 500;
    private boolean isTreeType;
    private boolean asyncRecord;

    public BaseDataOrgRelExtService(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        FormConfig config = FormMetadataCache.getFormConfig((String)entity);
        if (null == config) {
            throw new KDBizException("the parameters [entity] is not a entity type.");
        }
        entity = config.getEntityTypeId();
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the entity type id is empty.");
        }
        super.init(entity);
        this.isTreeType = BaseDataCommonService.isTreeType(entity);
        this.asyncRecord = this.asyncRecord();
    }

    public void writeOrgRel(Long orgId, List<Long> dataIds) {
        this.writeOrgRel(orgId, dataIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOrgRel(Long orgId, List<Long> dataIds, boolean autoCompletion) {
        if (CollectionUtils.isEmpty(dataIds) || !BaseDataCommonService.isNewModel(this.entity)) {
            return;
        }
        if (autoCompletion) {
            this.writeOrgRelAutoCompletion(orgId, dataIds);
            return;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(dataIds.size());
        Map<Long, List<Integer>> rel = this.getOrgBitIndexMap(orgId, dataIds, indexes);
        String lockKey = BaseDataOrgRelExtService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!rel.isEmpty()) {
                    this.saveOrUpdateRelBit(rel, this.entity);
                }
                if (this.asyncRecord) {
                    BaseDataSolidifyMessageDTO dto = new BaseDataSolidifyMessageDTO(1);
                    BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                    RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])indexes.stream().mapToInt(v -> v).toArray());
                    bit.runOptimize();
                    message.add(this.createAddSolidifyMessage(bit));
                    dto.add(message);
                    this.publish(dto);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u6570\u636e\u65b0\u66fe\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5173\u7cfb\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataOrgRelExtService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOrgRelAutoCompletion(Long orgId, List<Long> dataIds) {
        HashMap<Long, List<Integer>> rel = new HashMap<Long, List<Integer>>(16);
        HashMap<Long, List<Integer>> shareTypeBdMap = new HashMap<Long, List<Integer>>(16);
        AbstractBaseDataService.OpDataContext context = this.getOpDataContext(orgId, dataIds, rel, shareTypeBdMap);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long viewId = (Long)ctrlView.getPkValue();
        this.handleShareTypeBaseData(rel, shareTypeBdMap, viewId);
        BaseDataSolidifyMessageDTO messageDto = this.createAddMessageDto(context, this.asyncRecord, viewId);
        String lockKey = BaseDataOrgRelExtService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.saveOrUpdateRelBit(rel, this.entity);
                if (this.asyncRecord) {
                    this.publish(messageDto);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u6570\u636e\u65b0\u66fe\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5173\u7cfb\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataOrgRelExtService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private AbstractBaseDataService.OpDataContext getOpDataContext(Long orgId, List<Long> dataIds, Map<Long, List<Integer>> rel, Map<Long, List<Integer>> shareTypeBdMap) {
        AbstractBaseDataService.OpDataContext context = new AbstractBaseDataService.OpDataContext();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String billStatusKey = dt.getBillStatus();
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        ArrayList<String> selects = new ArrayList<String>(Arrays.asList("bitindex", "ctrlstrategy"));
        if (!isIgnoreStatus) {
            selects.add(billStatusKey);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)this.entity, (String)String.join((CharSequence)",", selects), (QFilter[])filters);
        for (DynamicObject data : coll) {
            boolean isFree;
            boolean unRecord;
            String strategy = data.getString("ctrlstrategy");
            int index = data.getInt("bitindex");
            boolean bl = unRecord = !this.isTreeType && "6".equals(strategy) || "5".equals(strategy);
            if (!unRecord) {
                rel.computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
            }
            boolean isAudit = isIgnoreStatus || BillStatus.C.name().equals(data.getString(billStatusKey));
            boolean isCuShareData = "6".equals(strategy);
            if (isAudit && isCuShareData && this.isTreeType) {
                shareTypeBdMap.computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
            }
            if (this.asyncRecord) continue;
            boolean isAssign = "1".equals(strategy) || "3".equals(strategy);
            boolean bl2 = isFree = "2".equals(strategy) || "4".equals(strategy);
            if (isAssign || isFree || "7".equals(strategy)) {
                context.getCurrentOrgIndexes().computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
                continue;
            }
            boolean isGlobalData = "5".equals(strategy);
            if (isAudit && isCuShareData) {
                context.getCuShareTypeMap().computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
                continue;
            }
            if (isAudit && isGlobalData) {
                context.getShareTypeMap().computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
                continue;
            }
            if (isAudit || !isGlobalData && !isCuShareData) continue;
            context.getCurrentOrgIndexes().computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
        }
        return context;
    }

    public void deleteOrgRel(Long orgId, List<Long> dataIds) {
        this.deleteOrgRel(orgId, dataIds, false);
    }

    public void deleteOrgRel(Long orgId, List<Long> dataIds, boolean isSynDel) {
        if (CollectionUtils.isEmpty(dataIds) || !BaseDataCommonService.isNewModel(this.entity)) {
            return;
        }
        if (isSynDel) {
            this.synDeleteOrgRel(orgId, dataIds);
            return;
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(dataIds.size());
        Map<Long, List<Integer>> rel = this.getOrgBitIndexMap(orgId, dataIds, indexes);
        DLock lock = DLock.createReentrant((String)BaseDataOrgRelExtService.getBaseDataUnifiedLockKey(this.entity));
        lock.lock();
        TXHandle tx = TX.required((String)"delete_base_data");
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap;
            BaseDataUseRelBit relBit;
            if (!rel.isEmpty() && null != (relBit = (useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(rel.keySet(), this.entity)).get(orgId)) && null != relBit.getBit()) {
                RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])rel.get(orgId).stream().mapToInt(v -> v).toArray());
                delBit.runOptimize();
                RoaringBitmap bit = relBit.getBit();
                bit.andNot(delBit);
                bit.runOptimize();
                BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), this.entity);
            }
            if (this.asyncRecord) {
                RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])indexes.stream().mapToInt(v -> v).toArray());
                bit.runOptimize();
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                message.add(this.createDelSolidifyMessage(bit));
                BaseDataSolidifyMessageDTO dto = new BaseDataSolidifyMessageDTO(1);
                dto.add(message);
                this.publish(dto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u5220\u9664\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataOrgRelExtService_1", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    private void synDeleteOrgRel(Long orgId, List<Long> dataIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long viewId = (Long)ctrlView.getPkValue();
        HashMap<Long, List<Integer>> shareTypeBdMap = new HashMap<Long, List<Integer>>(16);
        HashMap<Long, List<Integer>> rel = new HashMap<Long, List<Integer>>(16);
        AbstractBaseDataService.OpDataContext context = this.getOpDataContext(orgId, dataIds, rel, shareTypeBdMap);
        this.handleShareTypeBaseData(rel, shareTypeBdMap, viewId);
        BaseDataSolidifyMessageDTO messageDto = null;
        if (this.asyncRecord) {
            Map<Long, RoaringBitmap> delUseOrgBitmap = context.buildUseOrgBitmap(viewId, false);
            messageDto = new BaseDataSolidifyMessageDTO(delUseOrgBitmap.size());
            for (Map.Entry<Long, RoaringBitmap> entry : delUseOrgBitmap.entrySet()) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, entry.getKey());
                message.add(this.createDelSolidifyMessage(entry.getValue()));
                messageDto.add(message);
            }
        }
        String lockKey = BaseDataOrgRelExtService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.required((String)"delete_base_data");
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(rel.keySet(), this.entity);
            for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
                RoaringBitmap bit = entry.getValue().getBit();
                Long currOrgId = entry.getKey();
                List indexes = (List)rel.get(currOrgId);
                if (null == bit || CollectionUtils.isEmpty((Collection)indexes)) continue;
                RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])indexes.stream().mapToInt(v -> v).toArray());
                delBit.runOptimize();
                bit.andNot(delBit);
                bit.runOptimize();
            }
            BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), this.entity);
            if (this.asyncRecord) {
                this.publish(messageDto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u5220\u9664\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataOrgRelExtService_1", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    private Map<Long, List<Integer>> getOrgBitIndexMap(Long orgId, List<Long> dataIds, List<Integer> indexes) {
        ArrayList<Integer> bitIndexes = new ArrayList<Integer>(dataIds.size());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        try (DataSet ds = ORM.create().queryDataSet(BaseDataOrgRelExtService.class.getName(), this.entity, "ctrlstrategy, bitindex", filters);){
            for (Row row : ds) {
                boolean unRecord;
                String strategy = row.getString("ctrlstrategy");
                Integer index = row.getInteger("bitindex");
                boolean bl = unRecord = !this.isTreeType && "6".equals(strategy) || "5".equals(strategy);
                if (!unRecord) {
                    bitIndexes.add(index);
                }
                if (!this.asyncRecord) continue;
                indexes.add(index);
            }
        }
        if (!bitIndexes.isEmpty()) {
            HashMap<Long, List<Integer>> rel = new HashMap<Long, List<Integer>>(1);
            rel.put(orgId, bitIndexes);
            return rel;
        }
        return Collections.emptyMap();
    }

    public void drmWithResetViewRoot(Long currOrgId, Long rootOrgId, List<Long> dataIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("ctrlstrategy", "!=", (Object)"7")};
        ArrayList<Long> addDataIds = new ArrayList<Long>(dataIds.size());
        HashMap<String, List<Long>> strategyDataMap = new HashMap<String, List<Long>>(16);
        try (DataSet ds = ORM.create().queryDataSet(BaseDataOrgRelExtService.class.getName(), this.entity, "ctrlstrategy, id", filters);){
            for (Row row : ds) {
                Long dataId = row.getLong("id");
                addDataIds.add(dataId);
                strategyDataMap.computeIfAbsent(row.getString("ctrlstrategy"), k -> new ArrayList(10)).add(dataId);
            }
        }
        TXHandle tx = TX.requiresNew();
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
            if (BaseDataCommonService.isNewModel(this.entity)) {
                this.writeOrgRel(rootOrgId, addDataIds);
            } else {
                String tableName = dt.getAlias();
                DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
                this.updateOrgUseRangData(tableName, route, addDataIds, rootOrgId);
                this.updateOrgUseRegData(tableName, route, strategyDataMap, currOrgId, rootOrgId);
            }
            this.updateOrgProp(dt, currOrgId, rootOrgId, addDataIds);
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error(String.format("\u91cd\u7f6e\u6839\u7ec4\u7ec7\u65f6\uff0c\u5904\u7406\u7ba1\u7406\u6743\u8f6c\u8ba9\u5f02\u5e38\uff0c \u5b9e\u4f53\u4e3a[%s].", this.entity), (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u91cd\u7f6e\u6839\u7ec4\u7ec7\u65f6\u4fee\u590d\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataOrgRelExtService_2", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
    }

    private void updateOrgUseRangData(String tableName, DBRoute route, List<Long> dataIds, Long rootOrgId) {
        String insertSql = " insert into " + tableName + "_U (FUseOrgID, FDataID) values(?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        for (Long dataId : dataIds) {
            params.add(new Object[]{rootOrgId, dataId});
            if (params.size() != 10000) continue;
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
            params = new ArrayList(10000);
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
        }
        HashMap<Long, Boolean> cacheMap = new HashMap<Long, Boolean>(1);
        cacheMap.putIfAbsent(rootOrgId, Boolean.TRUE);
        BaseDataCtrlCache.updateIsHasBaseDataUseRangeBatch((String)this.entity, cacheMap);
    }

    private void updateOrgUseRegData(String tableName, DBRoute route, Map<String, List<Long>> strategyDataMap, Long currOrgId, Long rootOrgId) {
        SqlBuilder builder;
        String regTable = tableName + "usereg";
        String insertSql = " insert into " + regTable + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign, FAssignOrgID) values(?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        ArrayList<Long> distributiveDataIds = new ArrayList<Long>(10);
        ArrayList<Long> shareDataIds = new ArrayList<Long>(10);
        for (Map.Entry<String, List<Long>> entry : strategyDataMap.entrySet()) {
            boolean isGradually;
            String strategy = entry.getKey();
            List<Long> dataIds = entry.getValue();
            boolean isFree = "2".equals(strategy) || "4".equals(strategy);
            boolean bl = isGradually = "1".equals(strategy) || "3".equals(strategy);
            if (isFree || isGradually) {
                distributiveDataIds.addAll(dataIds);
            } else {
                shareDataIds.addAll(dataIds);
            }
            for (Long dataId : dataIds) {
                params.add(new Object[]{rootOrgId, dataId, rootOrgId, rootOrgId, strategy, "0", 0L});
                if (params.size() < 10000) continue;
                DB.executeBatch((DBRoute)route, (String)insertSql, params);
                params = new ArrayList(10000);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
        }
        if (!distributiveDataIds.isEmpty()) {
            builder = new SqlBuilder();
            builder.append("update ", new Object[0]).append(regTable, new Object[0]).append(" set fisassign = '1'", new Object[0]).append(", fassignorgid = ?", new Object[]{rootOrgId}).append(", fcreateorgid = ?", new Object[]{rootOrgId}).append(", fadminorgid = ?", new Object[]{rootOrgId}).append("where", new Object[0]).appendIn("fdataid", distributiveDataIds.toArray()).append("and fuseorgid = ?", new Object[]{currOrgId});
            DB.execute((DBRoute)route, (SqlBuilder)builder);
        }
        if (!shareDataIds.isEmpty()) {
            builder = new SqlBuilder();
            builder.append("update ", new Object[0]).append(regTable, new Object[0]).append("set fassignorgid = ?", new Object[]{rootOrgId}).append(", fcreateorgid = ?", new Object[]{rootOrgId}).append(", fadminorgid = ?", new Object[]{rootOrgId}).append("where", new Object[0]).appendIn("fdataid", shareDataIds.toArray()).append("and fuseorgid = ?", new Object[]{currOrgId});
            DB.execute((DBRoute)route, (SqlBuilder)builder);
        }
    }

    private void updateOrgProp(MainEntityType dt, Long currOrgId, Long rootOrgId, List<Long> dataIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("update ", new Object[0]).append(dt.getAlias(), new Object[0]).append("set fcreateorgid = ?", new Object[]{rootOrgId}).append(",fsrccreateorgid = ?", new Object[]{rootOrgId}).append("where ", new Object[0]).appendIn("fid", dataIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);
        builder = new SqlBuilder();
        builder.append("update ", new Object[0]).append(dt.getAlias(), new Object[0]).append("set fsrccreateorgid = ?", new Object[]{rootOrgId}).append("where ", new Object[0]).appendIn(this.masterIdFieldName, dataIds.toArray()).append("and fid !=" + this.masterIdFieldName, new Object[0]).append("and fsrccreateorgid = ?", new Object[]{currOrgId});
        DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    public Map<Long, Set<Long>> getDataOrgRelation(Collection<Long> dataIds) {
        Long dataId;
        if (CollectionUtils.isEmpty(dataIds) || !BaseDataCommonService.isNewModel(this.entity)) {
            return Collections.emptyMap();
        }
        if (dataIds.size() > 500) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u6b21\u67e5\u8be2\u7684\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc7500\u6761\u3002", (String)"BaseDataOrgRelExtService_3", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("ctrlstrategy", "!=", (Object)"5")};
        HashMap<Integer, Long> index2IdMap = new HashMap<Integer, Long>(16);
        HashMap<Long, List> cuShareOrg2DataMap = new HashMap<Long, List>(0);
        try (DataSet ds = ORM.create().queryDataSet(BaseDataOrgRelExtService.class.getName(), this.entity, "ctrlstrategy, id, bitindex, createorg", filters);){
            for (Row row : ds) {
                Integer n = row.getInteger("bitindex");
                index2IdMap.put(n, row.getLong("id"));
                if (this.isTreeType || !"6".equals(row.getString("ctrlstrategy"))) continue;
                cuShareOrg2DataMap.computeIfAbsent(row.getLong("createorg"), k -> new ArrayList(1)).add(n);
            }
        }
        if (index2IdMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> dataOrgRelMap = new HashMap<Long, Set<Long>>(16);
        try {
            RoaringBitmap currBit = RoaringBitmap.bitmapOf((int[])index2IdMap.keySet().stream().mapToInt(v -> v).toArray());
            currBit.runOptimize();
            Map<Long, BaseDataUseRelBit> relBitMap = BaseDataUseRelQueryEngine.getCURelBitMapByEntity(this.entity);
            for (Map.Entry<Long, BaseDataUseRelBit> entry : relBitMap.entrySet()) {
                BaseDataUseRelBit value = entry.getValue();
                if (null == value || null == value.getBit()) continue;
                Long useOrgId = entry.getKey();
                RoaringBitmap bit = value.getBit();
                bit.and(currBit);
                for (Integer index : bit) {
                    dataId = (Long)index2IdMap.get(index);
                    if (null == dataId) continue;
                    dataOrgRelMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(useOrgId);
                }
            }
            if (cuShareOrg2DataMap.isEmpty()) {
                return dataOrgRelMap;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7279\u5b9a\u7684\u6570\u636e\u90fd\u88ab\u54ea\u4e9b\u7ec4\u7ec7\u4f7f\u7528\uff0c\u5355\u6b21\u8c03\u7528\u65f6dataIds\u6570\u636e\u91cf\u4e0d\u80fd\u5927\u4e8e500\u4e2a\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u88ab\u54ea\u4e9b\u7ec4\u7ec7\u4f7f\u7528\u65f6\u653e\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataOrgRelExtService_4", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        DynamicObject view = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == view) {
            return dataOrgRelMap;
        }
        Map<Long, List<Long>> subOrgMap = this.getAllSubCuOrgMapping((Long)view.getPkValue(), new ArrayList<Long>(cuShareOrg2DataMap.keySet()));
        for (Map.Entry<Long, BaseDataUseRelBit> entry : cuShareOrg2DataMap.entrySet()) {
            Long createOrgId = entry.getKey();
            List indexes = (List)((Object)entry.getValue());
            List<Long> orgIds = subOrgMap.get(createOrgId);
            for (Integer index : indexes) {
                dataId = (Long)index2IdMap.get(index);
                if (null == dataId) continue;
                dataOrgRelMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(createOrgId);
                if (CollectionUtils.isEmpty(orgIds)) continue;
                orgIds.forEach(o -> dataOrgRelMap.computeIfAbsent(dataId, k -> new HashSet(16)).add(o));
            }
        }
        return dataOrgRelMap;
    }
}

