/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.enums.BDCtrlOperateType;
import kd.bos.bd.log.mq.BDCtrlLogMQPublisher;
import kd.bos.bd.log.pojo.BDCtrlLog;
import kd.bos.bd.log.pojo.BDCtrlLogDataEntry;
import kd.bos.bd.log.pojo.BDCtrlLogFailCause;
import kd.bos.bd.log.pojo.BDCtrlLogOrgEntry;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang.time.DateUtils;
import org.jetbrains.annotations.NotNull;

public class BDCtrlLogHelper {
    private static final Log LOGGER = LogFactory.getLog(BDCtrlLogHelper.class);
    private static final String CREATE_ORG = "createOrg";
    private static final String ENTITY_BOS_ORG = "bos_org";
    public static final ThreadLocal<Map<String, Object>> THREAD_LOCAL = new ThreadLocal();
    private static final int NUM_MAX_FAIL_LOG = 1000;
    private static final String MASTER_ID_NUMBER = "masterid.number";
    private static final String MASTER_ID_NAME = "masterid.name";
    private static final String PROP_OPTYPE_ARCHIVE_RETAIN_DAYS = "archiveretaindays";
    private static final String ORG_STRUCTURE = "bos_org_structure";
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String ORG_VIEW_SCHEMA = "bos_org_viewschema";
    private static final String ORG_ID = "org.id";
    private static final String MODIFIER = "modifier";

    private BDCtrlLogHelper() {
    }

    private static String getNameField(String entity) {
        return BaseDataCommonService.isOtherMasterIdType(entity) ? MASTER_ID_NAME : "name";
    }

    private static String getNumberField(String entity) {
        return BaseDataCommonService.isOtherMasterIdType(entity) ? MASTER_ID_NUMBER : "number";
    }

    public static void saveAssignLogNoSource(String entityID, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs, Map<Long, Map<Long, String>> assignCheckResMap, String operationInstruction) {
        String operateSource;
        Map<Object, Object> threadLocalMap = THREAD_LOCAL.get() != null ? THREAD_LOCAL.get() : new HashMap(1);
        String string = operateSource = null != threadLocalMap.get("source") ? threadLocalMap.get("source").toString() : null;
        if (null != operateSource) {
            return;
        }
        BDCtrlLogHelper.saveAssignLog(entityID, assignOrgID, dataIDs, orgIDs, assignCheckResMap, operationInstruction);
    }

    public static void saveAssignLog(String entityID, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs, Map<Long, Map<Long, String>> assignCheckResMap, String operationInstruction) {
        try {
            Map<Object, Object> threadLocalMap;
            boolean isEmptyData;
            boolean bl = isEmptyData = CollectionUtils.isEmpty(dataIDs) || CollectionUtils.isEmpty(orgIDs);
            if (isEmptyData || StringUtils.isBlank((CharSequence)entityID) || null == assignOrgID) {
                return;
            }
            Map<Object, Object> map = threadLocalMap = THREAD_LOCAL.get() != null ? THREAD_LOCAL.get() : new HashMap(1);
            if (null == threadLocalMap.get("source")) {
                return;
            }
            String operateSource = null != threadLocalMap.get("source") ? threadLocalMap.get("source").toString() : BDCtrlOperateSource.OTHER.getValue();
            Long operateSourceId = threadLocalMap.get("operateSourceId") instanceof Long ? Long.valueOf(threadLocalMap.get("operateSourceId").toString()) : null;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityID);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            DynamicObject assignOrg = QueryServiceHelper.queryOne((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assignOrgID)});
            String operateOrgName = null != assignOrg ? assignOrg.getString("name") : null;
            String operateOrgNumber = null != assignOrg ? assignOrg.getString("number") : null;
            long userId = RequestContext.get().getCurrUserId();
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            String operatorName = String.valueOf(userInfo.get("name"));
            String operatorNumber = String.valueOf(userInfo.get("number"));
            String selectFields = BDCtrlLogHelper.getSelectField("id", BDCtrlLogHelper.getNameField(entityID), BDCtrlLogHelper.getNumberField(entityID), CREATE_ORG, "ctrlstrategy");
            DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityID, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIDs)});
            HashMap<Long, DynamicObject> dataIdObjMap = new HashMap<Long, DynamicObject>(dataCol.size());
            HashSet<Long> orgParamList = new HashSet<Long>(orgIDs.size());
            for (DynamicObject data : dataCol) {
                dataIdObjMap.put(data.getLong("id"), data);
                orgParamList.add(data.getLong(CREATE_ORG));
            }
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(orgIDs.size());
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(orgIDs.size());
            orgParamList.addAll(orgIDs);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            HashMap<Long, Integer> orgIdFailNum = new HashMap<Long, Integer>(orgIDs.size());
            List<BDCtrlLogDataEntry> bdCtrlLogDataList = BDCtrlLogHelper.getBdCtrlLogDataList(entityID, dataIDs, dataIdObjMap, idOrgNumberMap, idOrgNameMap);
            List<BDCtrlLogFailCause> bdCtrlLogFailCauseList = BDCtrlLogHelper.getBdCtrlLogFailCauses(dataIDs, assignCheckResMap, dataIdObjMap, idOrgNumberMap, idOrgNameMap, orgIdFailNum);
            List<BDCtrlLogOrgEntry> bdCtrlLogOrgList = BDCtrlLogHelper.getBdCtrlLogOrgList(orgIDs, idOrgNumberMap, idOrgNameMap, orgIdFailNum, bdCtrlLogFailCauseList);
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)assignOrgID.toString());
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.ASSIGN.getId(), BDCtrlOperateType.ASSIGN.getNumber(), operateSource, operateSourceId, BDCtrlOperateType.ASSIGN.getDescription(), entityID, operateObjName, assignOrgID, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, operationInstruction, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.ASSIGN.getNumber()), false, bdCtrlLogDataList, bdCtrlLogOrgList, loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(entityID, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    @NotNull
    private static List<BDCtrlLogDataEntry> getBdCtrlLogDataList(String entity, List<Long> dataIDs, Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap) {
        ArrayList<BDCtrlLogDataEntry> bdCtrlLogDataList = new ArrayList<BDCtrlLogDataEntry>(dataIDs.size());
        for (Long dataId : dataIDs) {
            if (null == dataIdObjMap.get(dataId)) continue;
            String number = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNumberField(entity));
            String name = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNameField(entity));
            Long createOrg = dataIdObjMap.get(dataId).getLong(CREATE_ORG);
            String ctrlStrategy = dataIdObjMap.get(dataId).getString("ctrlstrategy");
            BDCtrlLogDataEntry bdCtrlLogDataEntry = new BDCtrlLogDataEntry(number, name, createOrg, idOrgNumberMap.get(createOrg), idOrgNameMap.get(createOrg), 0L, null, null, ctrlStrategy, "0", null);
            bdCtrlLogDataList.add(bdCtrlLogDataEntry);
        }
        return bdCtrlLogDataList;
    }

    @NotNull
    private static List<BDCtrlLogOrgEntry> getBdCtrlLogOrgList(List<Long> orgIDs, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, Map<Long, Integer> orgIdFailNum, List<BDCtrlLogFailCause> bdCtrlLogFailCauseList) {
        Set<Long> failUseOrgSet = orgIdFailNum.keySet();
        HashMap logFailCaseMap = new HashMap(orgIDs.size());
        bdCtrlLogFailCauseList.forEach(failCause -> {
            logFailCaseMap.putIfAbsent(failCause.getFailCreateOrgId(), new ArrayList(10));
            logFailCaseMap.computeIfPresent(failCause.getFailCreateOrgId(), (key, bdCtrlLogFailCauses) -> {
                bdCtrlLogFailCauses.add(failCause);
                return bdCtrlLogFailCauses;
            });
        });
        ArrayList<BDCtrlLogOrgEntry> bdCtrlLogOrgList = new ArrayList<BDCtrlLogOrgEntry>(orgIDs.size());
        for (Long orgID : orgIDs) {
            String isSuccess = failUseOrgSet.contains(orgID) ? "0" : "1";
            Integer failNum = orgIdFailNum.get(orgID);
            String detail = null == failNum ? null : String.format(ResManager.loadKDString((String)"%s\u6761\u5931\u8d25", (String)"BDCtrlLogHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), failNum);
            BDCtrlLogOrgEntry bdCtrlLogOrgEntry = new BDCtrlLogOrgEntry(orgID, idOrgNumberMap.get(orgID), idOrgNameMap.get(orgID), isSuccess, detail, (List)logFailCaseMap.get(orgID));
            bdCtrlLogOrgList.add(bdCtrlLogOrgEntry);
        }
        return bdCtrlLogOrgList;
    }

    @NotNull
    private static List<BDCtrlLogDataEntry> getBdCtrlLogDataList(String entity, List<Long> dataIDs, Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, Long oldCreateOrgId, Long newCreateOrgId) {
        ArrayList<BDCtrlLogDataEntry> bdCtrlLogDataList = new ArrayList<BDCtrlLogDataEntry>(dataIDs.size());
        for (Long dataId : dataIDs) {
            if (null == dataIdObjMap.get(dataId)) continue;
            String number = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNumberField(entity));
            String name = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNameField(entity));
            String ctrlStrategy = dataIdObjMap.get(dataId).getString("ctrlstrategy");
            BDCtrlLogDataEntry bdCtrlLogDataEntry = new BDCtrlLogDataEntry(number, name, oldCreateOrgId, idOrgNumberMap.get(oldCreateOrgId), idOrgNameMap.get(oldCreateOrgId), newCreateOrgId, idOrgNumberMap.get(newCreateOrgId), idOrgNameMap.get(newCreateOrgId), ctrlStrategy, "1", null);
            bdCtrlLogDataList.add(bdCtrlLogDataEntry);
        }
        return bdCtrlLogDataList;
    }

    @NotNull
    private static List<BDCtrlLogDataEntry> getBdCtrlLogDataList(String entity, List<Long> dataIDs, Long newCreateOrgId, Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, Map<Long, String> failDataMap) {
        ArrayList<BDCtrlLogDataEntry> bdCtrlLogDataList = new ArrayList<BDCtrlLogDataEntry>(dataIDs.size());
        for (Long dataId : dataIDs) {
            if (null == dataIdObjMap.get(dataId)) continue;
            String number = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNumberField(entity));
            String name = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNameField(entity));
            Long createOrg = dataIdObjMap.get(dataId).getLong(CREATE_ORG);
            String ctrlStrategy = dataIdObjMap.get(dataId).getString("ctrlstrategy");
            String dataStatus = null == failDataMap.get(dataId) ? "1" : "0";
            String failureCause = failDataMap.get(dataId);
            BDCtrlLogDataEntry bdCtrlLogDataEntry = new BDCtrlLogDataEntry(number, name, createOrg, idOrgNumberMap.get(createOrg), idOrgNameMap.get(createOrg), newCreateOrgId, idOrgNumberMap.get(newCreateOrgId), idOrgNameMap.get(newCreateOrgId), ctrlStrategy, dataStatus, failureCause);
            bdCtrlLogDataList.add(bdCtrlLogDataEntry);
        }
        return bdCtrlLogDataList;
    }

    @NotNull
    private static List<BDCtrlLogFailCause> getBdCtrlLogFailCauses(List<Long> dataIDs, Map<Long, Map<Long, String>> assignCheckResMap, Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, Map<Long, Integer> orgIdFailNum) {
        ArrayList<BDCtrlLogFailCause> bdCtrlLogFailCauseList = new ArrayList<BDCtrlLogFailCause>(dataIDs.size());
        if (CollectionUtils.isEmpty(assignCheckResMap)) {
            return bdCtrlLogFailCauseList;
        }
        Set<Map.Entry<Long, Map<Long, String>>> entrySet = assignCheckResMap.entrySet();
        for (Map.Entry<Long, Map<Long, String>> entry : entrySet) {
            Long dataId = entry.getKey();
            String dataNumber = null == dataIdObjMap.get(dataId) ? null : dataIdObjMap.get(dataId).getString("number");
            String dataName = null == dataIdObjMap.get(dataId) ? null : dataIdObjMap.get(dataId).getString("name");
            Map<Long, String> failUseOrgMap = entry.getValue();
            Set<Map.Entry<Long, String>> failUseOrgEntrySet = failUseOrgMap.entrySet();
            for (Map.Entry<Long, String> failUseOrgEntry : failUseOrgEntrySet) {
                Long useOrgId = failUseOrgEntry.getKey();
                String failCause = failUseOrgEntry.getValue();
                Integer failDataNum = orgIdFailNum.get(useOrgId);
                failDataNum = null == failDataNum ? 1 : failDataNum + 1;
                orgIdFailNum.put(useOrgId, failDataNum);
                if (bdCtrlLogFailCauseList.size() >= 1000) continue;
                BDCtrlLogFailCause bdCtrlLogFailCause = new BDCtrlLogFailCause(dataNumber, dataName, useOrgId, idOrgNumberMap.get(useOrgId), idOrgNameMap.get(useOrgId), failCause);
                bdCtrlLogFailCauseList.add(bdCtrlLogFailCause);
            }
        }
        return bdCtrlLogFailCauseList;
    }

    public static void setLogSourceType(BDCtrlOperateSource source) {
        if (null != source) {
            HashMap<String, String> threadLocalMap = new HashMap<String, String>(2);
            threadLocalMap.put("source", source.getValue());
            THREAD_LOCAL.set(threadLocalMap);
        }
    }

    public static void saveCancelAssignLog(String entityID, List<Long> dataIDs, List<Long> orgIDs, List<CancelAssignResult> results, String operationInstruction) {
        try {
            if (!BDCtrlLogHelper.hasCancelSuccess(results)) {
                return;
            }
            String operateSource = BDCtrlLogHelper.getOperateSource();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityID);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            long userId = RequestContext.get().getCurrUserId();
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            String operatorName = String.valueOf(userInfo.get("name"));
            String operatorNumber = String.valueOf(userInfo.get("number"));
            String selectFields = BDCtrlLogHelper.getSelectField("id", BDCtrlLogHelper.getNumberField(entityID), BDCtrlLogHelper.getNameField(entityID), CREATE_ORG, "ctrlstrategy");
            DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityID, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIDs)});
            HashMap<Long, DynamicObject> dataIdObjMap = new HashMap<Long, DynamicObject>(dataCol.size());
            dataCol.forEach(data -> dataIdObjMap.put(data.getLong("id"), (DynamicObject)data));
            HashSet<Long> orgParamList = new HashSet<Long>(orgIDs.size());
            dataCol.forEach(data -> orgParamList.add(data.getLong(CREATE_ORG)));
            long operatorOrgId = orgParamList.stream().findAny().orElse(0L);
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(orgIDs.size());
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(orgIDs.size());
            orgParamList.addAll(orgIDs);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            List<BDCtrlLogDataEntry> bdCtrlLogDataList = BDCtrlLogHelper.getBdCtrlLogDataList(entityID, dataIDs, dataIdObjMap, idOrgNumberMap, idOrgNameMap);
            HashMap<Long, Integer> orgIdFailNum = new HashMap<Long, Integer>(results.size());
            List<BDCtrlLogFailCause> bdCtrlLogFailCauseList = BDCtrlLogHelper.getBdCtrlLogFailCauses(dataIDs, orgIDs, results, dataIdObjMap, idOrgNumberMap, idOrgNameMap, orgIdFailNum);
            List<BDCtrlLogOrgEntry> bdCtrlLogOrgList = BDCtrlLogHelper.getBdCtrlLogOrgList(orgIDs, idOrgNumberMap, idOrgNameMap, orgIdFailNum, bdCtrlLogFailCauseList);
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)(operatorOrgId + ""));
            String operateOrgName = (String)idOrgNameMap.get(operatorOrgId);
            String operateOrgNumber = (String)idOrgNumberMap.get(operatorOrgId);
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.UNASSIGN.getId(), BDCtrlOperateType.UNASSIGN.getNumber(), operateSource, null, BDCtrlOperateType.UNASSIGN.getDescription(), entityID, operateObjName, operatorOrgId, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, operationInstruction, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.UNASSIGN.getNumber()), false, bdCtrlLogDataList, bdCtrlLogOrgList, loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(entityID, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    private static boolean hasCancelSuccess(List<CancelAssignResult> results) {
        return results.stream().anyMatch(CancelAssignResult::isSuccess);
    }

    private static String getOperateSource() {
        Map<String, Object> threadLocalMap = THREAD_LOCAL.get();
        String operateSource = null == threadLocalMap ? BDCtrlOperateSource.OTHER.getValue() : (null != threadLocalMap.get("source") ? threadLocalMap.get("source").toString() : BDCtrlOperateSource.OTHER.getValue());
        return operateSource;
    }

    private static List<BDCtrlLogFailCause> getBdCtrlLogFailCauses(List<Long> dataIDs, List<Long> orgIDs, List<CancelAssignResult> results, Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, Map<Long, Integer> orgIdFailNum) {
        ArrayList<BDCtrlLogFailCause> bdCtrlLogFailCauseList = new ArrayList<BDCtrlLogFailCause>(dataIDs.size());
        if (CollectionUtils.isEmpty(results)) {
            return bdCtrlLogFailCauseList;
        }
        for (CancelAssignResult result : results) {
            Long dataId = result.getDataId();
            List useOrgIds = Optional.ofNullable(result.getOrgIds()).orElseGet(Collections::emptyList);
            String failCause = result.getErrorMsg();
            if (!result.isSuccess() && !CollectionUtils.isEmpty((Collection)useOrgIds)) {
                BDCtrlLogHelper.getCancelAssignFailCauses(dataIdObjMap, idOrgNumberMap, idOrgNameMap, bdCtrlLogFailCauseList, dataId, useOrgIds, failCause);
            } else if (!result.isSuccess() && CollectionUtils.isEmpty((Collection)useOrgIds)) {
                BDCtrlLogHelper.getCancelAssignFailCauses(dataIdObjMap, idOrgNumberMap, idOrgNameMap, bdCtrlLogFailCauseList, dataId, orgIDs, failCause);
            }
            if (result.isSuccess()) continue;
            useOrgIds.forEach(useOrgId -> orgIdFailNum.put((Long)useOrgId, orgIdFailNum.computeIfAbsent((Long)useOrgId, k -> 0) + 1));
        }
        return bdCtrlLogFailCauseList;
    }

    private static void getCancelAssignFailCauses(Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, List<BDCtrlLogFailCause> bdCtrlLogFailCauseList, Long dataId, List<Long> useOrgIds, String failCause) {
        for (Long useOrgId : useOrgIds) {
            if (null == dataIdObjMap.get(dataId) || bdCtrlLogFailCauseList.size() >= 1000) continue;
            String number = dataIdObjMap.get(dataId).getString("number");
            String name = dataIdObjMap.get(dataId).getString("name");
            BDCtrlLogFailCause bdCtrlLogFailCause = new BDCtrlLogFailCause(number, name, useOrgId, idOrgNumberMap.get(useOrgId), idOrgNameMap.get(useOrgId), failCause);
            bdCtrlLogFailCauseList.add(bdCtrlLogFailCause);
        }
    }

    public static void saveChangeCtrlStrategyLog(String entityID, Long useOrgId, List<Long> dataIDs, String oldCtrlStrategy, BaseDataResponse response) {
        try {
            String operateSource = BDCtrlLogHelper.getOperateSource();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityID);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            long userId = RequestContext.get().getCurrUserId();
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            String operatorName = String.valueOf(userInfo.get("name"));
            String operatorNumber = String.valueOf(userInfo.get("number"));
            String selectFields = BDCtrlLogHelper.getSelectField("id", BDCtrlLogHelper.getNumberField(entityID), BDCtrlLogHelper.getNameField(entityID), CREATE_ORG, "ctrlstrategy");
            DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityID, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIDs)});
            HashSet<Long> orgParamList = new HashSet<Long>(10);
            orgParamList.add(useOrgId);
            HashMap<Long, DynamicObject> dataIdObjMap = new HashMap<Long, DynamicObject>(dataCol.size());
            for (DynamicObject data : dataCol) {
                dataIdObjMap.put(data.getLong("id"), data);
                orgParamList.add(data.getLong(CREATE_ORG));
            }
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(10);
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(10);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            String newCtrlStrategy = dataCol.isEmpty() ? null : ((DynamicObject)dataCol.get(0)).getString("ctrlstrategy");
            String newCtrlStrategyDes = CtrlStrategyEnum.getEnum(newCtrlStrategy).getDescription();
            String oldCtrlStrategyDes = CtrlStrategyEnum.getEnum(oldCtrlStrategy).getDescription();
            String operationInstruction = String.format(ResManager.loadKDString((String)"\u4ece\u201c%1$s\u201d\u53d8\u66f4\u4e3a\u201c%2$s\u201d", (String)"BDCtrlLogHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), oldCtrlStrategyDes, newCtrlStrategyDes);
            List<BDCtrlLogDataEntry> bdCtrlLogDataList = BDCtrlLogHelper.getBdCtrlLogDataList(entityID, dataIDs, dataIdObjMap, idOrgNumberMap, idOrgNameMap, response);
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)useOrgId.toString());
            String operateOrgName = (String)idOrgNameMap.get(useOrgId);
            String operateOrgNumber = (String)idOrgNumberMap.get(useOrgId);
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.BDCTRLCHANGE.getId(), BDCtrlOperateType.BDCTRLCHANGE.getNumber(), operateSource, null, BDCtrlOperateType.BDCTRLCHANGE.getDescription(), entityID, operateObjName, useOrgId, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, operationInstruction, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.BDCTRLCHANGE.getNumber()), false, bdCtrlLogDataList, Collections.emptyList(), loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(entityID, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    private static List<BDCtrlLogDataEntry> getBdCtrlLogDataList(String entity, List<Long> dataIDs, Map<Long, DynamicObject> dataIdObjMap, Map<Long, String> idOrgNumberMap, Map<Long, String> idOrgNameMap, BaseDataResponse response) {
        ArrayList<BDCtrlLogDataEntry> bdCtrlLogDataList = new ArrayList<BDCtrlLogDataEntry>(dataIDs.size());
        String operationInstruction = response.isSuccess() ? null : response.getErrorMsg();
        String dataStatus = response.isSuccess() ? "1" : "0";
        for (Long dataId : dataIDs) {
            if (null == dataIdObjMap.get(dataId)) continue;
            String number = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNumberField(entity));
            String name = dataIdObjMap.get(dataId).getString(BDCtrlLogHelper.getNameField(entity));
            Long createOrg = dataIdObjMap.get(dataId).getLong(CREATE_ORG);
            String ctrlStrategy = dataIdObjMap.get(dataId).getString("ctrlstrategy");
            BDCtrlLogDataEntry bdCtrlLogDataEntry = new BDCtrlLogDataEntry(number, name, createOrg, idOrgNumberMap.get(createOrg), idOrgNameMap.get(createOrg), 0L, null, null, ctrlStrategy, dataStatus, operationInstruction);
            bdCtrlLogDataList.add(bdCtrlLogDataEntry);
        }
        return bdCtrlLogDataList;
    }

    public static void saveChangeManageRightLog(String entityID, List<Long> dataIDs, Long useOrgId, Long newOrgId) {
        try {
            String operateSource = BDCtrlLogHelper.getOperateSource();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityID);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            long userId = RequestContext.get().getCurrUserId();
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            String operatorName = String.valueOf(userInfo.get("name"));
            String operatorNumber = String.valueOf(userInfo.get("number"));
            String selectFields = BDCtrlLogHelper.getSelectField("id", BDCtrlLogHelper.getNumberField(entityID), BDCtrlLogHelper.getNameField(entityID), CREATE_ORG, "ctrlstrategy");
            DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityID, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIDs)});
            HashSet<Long> orgParamList = new HashSet<Long>(10);
            HashMap<Long, DynamicObject> dataIdObjMap = new HashMap<Long, DynamicObject>(dataCol.size());
            for (DynamicObject data : dataCol) {
                dataIdObjMap.put(data.getLong("id"), data);
                orgParamList.add(data.getLong(CREATE_ORG));
            }
            orgParamList.add(useOrgId);
            orgParamList.add(newOrgId);
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(10);
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(10);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            String oldCreateOrgName = (String)idOrgNameMap.get(useOrgId);
            String newCreateOrgName = (String)idOrgNameMap.get(newOrgId);
            String operationInstruction = String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4ece\u201c%1$s\u201d\u53d8\u66f4\u4e3a\u201c%2$s\u201d", (String)"BDCtrlLogHelper_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), oldCreateOrgName, newCreateOrgName);
            List<BDCtrlLogDataEntry> bdCtrlLogDataList = BDCtrlLogHelper.getBdCtrlLogDataList(entityID, dataIDs, dataIdObjMap, idOrgNumberMap, idOrgNameMap, useOrgId, newOrgId);
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)useOrgId.toString());
            String operateOrgName = (String)idOrgNameMap.get(useOrgId);
            String operateOrgNumber = (String)idOrgNumberMap.get(useOrgId);
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.ORGPERMCHANGE.getId(), BDCtrlOperateType.ORGPERMCHANGE.getNumber(), operateSource, null, BDCtrlOperateType.ORGPERMCHANGE.getDescription(), entityID, operateObjName, useOrgId, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, operationInstruction, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.ORGPERMCHANGE.getNumber()), false, bdCtrlLogDataList, Collections.emptyList(), loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(entityID, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    public static void saveIndividualizeLog(String entityID, List<Long> dataIDs, Long useOrgId, Map<Long, String> failDataMap) {
        if (StringUtils.isBlank((CharSequence)entityID) || null == useOrgId || CollectionUtils.isEmpty(dataIDs)) {
            return;
        }
        try {
            String operateSource = BDCtrlLogHelper.getOperateSource();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityID);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            long userId = RequestContext.get().getCurrUserId();
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            String operatorName = String.valueOf(userInfo.get("name"));
            String operatorNumber = String.valueOf(userInfo.get("number"));
            String selectFields = BDCtrlLogHelper.getSelectField("id", BDCtrlLogHelper.getNumberField(entityID), BDCtrlLogHelper.getNameField(entityID), CREATE_ORG, "ctrlstrategy");
            DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityID, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIDs)});
            HashSet<Long> orgParamList = new HashSet<Long>(10);
            HashMap<Long, DynamicObject> dataIdObjMap = new HashMap<Long, DynamicObject>(dataCol.size());
            for (DynamicObject data : dataCol) {
                dataIdObjMap.put(data.getLong("id"), data);
                orgParamList.add(data.getLong(CREATE_ORG));
            }
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(10);
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(10);
            orgParamList.add(useOrgId);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            List<BDCtrlLogDataEntry> bdCtrlLogDataList = BDCtrlLogHelper.getBdCtrlLogDataList(entityID, dataIDs, useOrgId, dataIdObjMap, idOrgNumberMap, idOrgNameMap, failDataMap);
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)useOrgId.toString());
            String operateOrgName = (String)idOrgNameMap.get(useOrgId);
            String operateOrgNumber = (String)idOrgNumberMap.get(useOrgId);
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.INDIVIDUATION.getId(), BDCtrlOperateType.INDIVIDUATION.getNumber(), operateSource, null, BDCtrlOperateType.INDIVIDUATION.getDescription(), entityID, operateObjName, useOrgId, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, null, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.INDIVIDUATION.getNumber()), false, bdCtrlLogDataList, Collections.emptyList(), loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(entityID, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    public static void saveSetCtrlUnitLog(Long viewId, List<Long> orgIds) {
        try {
            String operateSource = BDCtrlOperateSource.INTERFACE_OP.getValue();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ORG_STRUCTURE);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            DynamicObject orgStructure = BDCtrlLogHelper.getModifyOrgStructure(viewId, orgIds);
            long userId = orgStructure.getLong(MODIFIER);
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            Long operateOrgId = RequestContext.get().getOrgId();
            String operatorName = null != userInfo ? String.valueOf(userInfo.get("name")) : null;
            String operatorNumber = null != userInfo ? String.valueOf(userInfo.get("number")) : null;
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(10);
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(10);
            HashSet<Long> orgParamList = new HashSet<Long>(10);
            orgParamList.addAll(orgIds);
            orgParamList.add(operateOrgId);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            List<BDCtrlLogOrgEntry> bdCtrlLogOrgList = BDCtrlLogHelper.getBdCtrlLogOrgList(orgIds, idOrgNumberMap, idOrgNameMap, Collections.emptyMap(), Collections.emptyList());
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)operateOrgId.toString());
            String operateOrgName = (String)idOrgNameMap.get(operateOrgId);
            String operateOrgNumber = (String)idOrgNumberMap.get(operateOrgId);
            DynamicObject orgView = QueryServiceHelper.queryOne((String)ORG_VIEW_SCHEMA, (String)BDCtrlLogHelper.getSelectField("number"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
            String orgViewNumber = Optional.ofNullable(orgView).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)ORG_VIEW_SCHEMA)).getString("number");
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.SETCTRLUNIT.getId(), BDCtrlOperateType.SETCTRLUNIT.getNumber(), operateSource, null, BDCtrlOperateType.SETCTRLUNIT.getDescription(), ORG_STRUCTURE, operateObjName, operateOrgId, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, orgViewNumber, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.SETCTRLUNIT.getNumber()), false, Collections.emptyList(), bdCtrlLogOrgList, loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(ORG_STRUCTURE, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    public static void saveCancelCtrlUnitLog(Long viewId, List<Long> orgIds) {
        try {
            String operateSource = BDCtrlOperateSource.INTERFACE_OP.getValue();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ORG_STRUCTURE);
            String operateObjName = mainEntityType.getDisplayName().getLocaleValue();
            DynamicObject orgStructure = BDCtrlLogHelper.getModifyOrgStructure(viewId, orgIds);
            long userId = orgStructure.getLong(MODIFIER);
            String loginIP = RequestContext.get().getLoginIP();
            String client = RequestContext.get().getClient();
            Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
            Long operateOrgId = RequestContext.get().getOrgId();
            String operatorName = null != userInfo ? String.valueOf(userInfo.get("name")) : null;
            String operatorNumber = null != userInfo ? String.valueOf(userInfo.get("number")) : null;
            HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(10);
            HashMap<Long, String> idOrgNameMap = new HashMap<Long, String>(10);
            HashSet<Long> orgParamList = new HashSet<Long>(10);
            orgParamList.addAll(orgIds);
            orgParamList.add(operateOrgId);
            DynamicObjectCollection useOrgCol = QueryServiceHelper.query((String)ENTITY_BOS_ORG, (String)BDCtrlLogHelper.getSelectField("id", "number", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgParamList)});
            for (DynamicObject useOrg : useOrgCol) {
                idOrgNumberMap.put(useOrg.getLong("id"), useOrg.getString("number"));
                idOrgNameMap.put(useOrg.getLong("id"), useOrg.getString("name"));
            }
            List<BDCtrlLogDataEntry> bdCtrlLogDataList = Collections.emptyList();
            List<BDCtrlLogOrgEntry> bdCtrlLogOrgList = BDCtrlLogHelper.getBdCtrlLogOrgList(orgIds, idOrgNumberMap, idOrgNameMap, Collections.emptyMap(), Collections.emptyList());
            ArrayList<BDCtrlLog> bdCtrlLogs = new ArrayList<BDCtrlLog>(1);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            String number = CodeRuleServiceHelper.getNumber((String)"bd_log", (DynamicObject)dataInfo, (String)operateOrgId.toString());
            String operateOrgName = (String)idOrgNameMap.get(operateOrgId);
            String operateOrgNumber = (String)idOrgNumberMap.get(operateOrgId);
            DynamicObject orgView = QueryServiceHelper.queryOne((String)ORG_VIEW_SCHEMA, (String)BDCtrlLogHelper.getSelectField("number"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)viewId)});
            String orgViewNumber = Optional.ofNullable(orgView).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)ORG_VIEW_SCHEMA)).getString("number");
            BDCtrlLog bdCtrlLog = new BDCtrlLog(number, BDCtrlOperateType.CANCELCTRLUNIT.getId(), BDCtrlOperateType.CANCELCTRLUNIT.getNumber(), operateSource, null, BDCtrlOperateType.CANCELCTRLUNIT.getDescription(), ORG_STRUCTURE, operateObjName, operateOrgId, operateOrgNumber, operateOrgName, new Date(), userId, operatorName, operatorNumber, orgViewNumber, BDCtrlLogHelper.getArchiveTime(BDCtrlOperateType.CANCELCTRLUNIT.getNumber()), false, bdCtrlLogDataList, bdCtrlLogOrgList, loginIP, client);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogMQPublisher.publish(ORG_STRUCTURE, bdCtrlLogs);
        }
        catch (Exception e) {
            LOGGER.error("\u7ba1\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38...", (Throwable)e);
        }
    }

    private static DynamicObject getModifyOrgStructure(Long viewId, List<Long> orgIds) {
        DynamicObject org = QueryServiceHelper.queryOne((String)ORG_STRUCTURE, (String)BDCtrlLogHelper.getSelectField("id", BDCtrlLogHelper.getSelectField(ORG_ID, MODIFIER)), (QFilter[])new QFilter[]{new QFilter("view.id", "=", (Object)viewId), new QFilter(ORG_ID, "in", orgIds)});
        return null != org ? org : BusinessDataServiceHelper.newDynamicObject((String)ORG_STRUCTURE);
    }

    private static String getSelectField(String ... props) {
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private static Date getArchiveTime(String operateTypeNumber) {
        DynamicObject bdLogOpType = QueryServiceHelper.queryOne((String)"bdlog_optype", (String)PROP_OPTYPE_ARCHIVE_RETAIN_DAYS, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)operateTypeNumber)});
        int archiveRetainDays = 90;
        if (bdLogOpType != null) {
            archiveRetainDays = bdLogOpType.getInt(PROP_OPTYPE_ARCHIVE_RETAIN_DAYS);
        }
        Date currentTime = new Date();
        return DateUtils.addDays((Date)currentTime, (int)archiveRetainDays);
    }
}

