/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.mq;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.log.pojo.BDCtrlLog;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;

public class BDCtrlLogMQPublisher {
    private static final Log LOGGER = LogFactory.getLog(BDCtrlLogMQPublisher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(String entityId, List<BDCtrlLog> bdCtrlLogs) {
        BDCtrlLogHelper.THREAD_LOCAL.remove();
        String appId = BDCtrlLogMQPublisher.getAppId(entityId);
        MessagePublisher publisher = null;
        try {
            publisher = MQFactory.get().createPartitionPublisher("base", "kd.base.bd.bdctrl.bdctrllog_queue", PartitionStrategy.APP_ID);
            publisher.publish(bdCtrlLogs, appId);
        }
        catch (Exception e) {
            LOGGER.error("BDCtrlLogMQPublisher publish error:", (Throwable)e);
        }
        finally {
            if (null != publisher) {
                publisher.close();
            }
        }
    }

    private static String getAppId(String entityId) {
        FormConfig config = FormMetadataCache.getFormConfig((String)entityId);
        String appId = config.getAppId();
        String[] appIds = Instance.getAppIds();
        if (null == appIds || appIds.length == 0) {
            appIds = Instance.getInnerAppIds();
        }
        String defaultAppId = "bos";
        if (null == appIds || appIds.length == 0) {
            return defaultAppId;
        }
        Set collect = Arrays.stream(appIds).collect(Collectors.toSet());
        collect.removeIf(StringUtils::isBlank);
        if (collect.isEmpty()) {
            return defaultAppId;
        }
        return collect.contains(appId) ? appId : (String)collect.iterator().next();
    }
}

