/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.bd.log.pojo.BDCtrlLog;
import kd.bos.bd.log.pojo.BDCtrlLogDataEntry;
import kd.bos.bd.log.pojo.BDCtrlLogFailCause;
import kd.bos.bd.log.pojo.BDCtrlLogOrgEntry;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang.time.DateUtils;

public class BDCtrlLogService {
    private static final Log LOGGER = LogFactory.getLog(BDCtrlLogService.class);

    private BDCtrlLogService() {
    }

    public static void saveLog(List<BDCtrlLog> bdCtrlLogs) {
        DynamicObject[] bdLogs = new DynamicObject[bdCtrlLogs.size()];
        for (int i = 0; i < bdCtrlLogs.size(); ++i) {
            BDCtrlLog bdCtrlLog = bdCtrlLogs.get(i);
            DynamicObject bdLog = BusinessDataServiceHelper.newDynamicObject((String)"bd_log");
            bdLog.set("number", (Object)bdCtrlLog.getNumber());
            bdLog.set("operattype", (Object)bdCtrlLog.getOperateTypeId());
            bdLog.set("operattypenumber", (Object)bdCtrlLog.getOperateTypeNumber());
            bdLog.set("operatsource", (Object)bdCtrlLog.getOperateSource());
            bdLog.set("operatsourceid", (Object)bdCtrlLog.getOperateSourceId());
            bdLog.set("operattypename", (Object)bdCtrlLog.getOperateTypeName());
            bdLog.set("operatobj", (Object)bdCtrlLog.getOperateObj());
            bdLog.set("operatobjname", (Object)bdCtrlLog.getOperateObjName());
            bdLog.set("operatorg", (Object)bdCtrlLog.getOperateOrgId());
            bdLog.set("operatorgnumber", (Object)bdCtrlLog.getOperateOrgNumber());
            bdLog.set("operatorgname", (Object)bdCtrlLog.getOperateOrgName());
            bdLog.set("operattime", (Object)bdCtrlLog.getOperateTime());
            bdLog.set("operator", (Object)bdCtrlLog.getOperatorId());
            bdLog.set("operatorname", (Object)bdCtrlLog.getOperatorName());
            bdLog.set("operatornumber", (Object)bdCtrlLog.getOperatorNumber());
            bdLog.set("operatinstruction", (Object)bdCtrlLog.getOperateInstruction());
            bdLog.set("archivetime", (Object)bdCtrlLog.getArchiveTime());
            bdLog.set("frombackup", (Object)bdCtrlLog.isFromBackup());
            bdLog.set("clienttype", (Object)bdCtrlLog.getClientType());
            bdLog.set("clientip", (Object)bdCtrlLog.getClientIP());
            DynamicObjectCollection dataEntryDoc = bdLog.getDynamicObjectCollection("dataentry");
            for (BDCtrlLogDataEntry bdCtrlLogDataEntry : bdCtrlLog.getBdCtrlLogDataList()) {
                DynamicObject dataEntry = new DynamicObject(dataEntryDoc.getDynamicObjectType());
                dataEntry.set("datanumber", (Object)bdCtrlLogDataEntry.getDataNumber());
                dataEntry.set("dataname", (Object)bdCtrlLogDataEntry.getDataName());
                dataEntry.set("createorg", (Object)bdCtrlLogDataEntry.getCreateOrgId());
                dataEntry.set("createorgnumber", (Object)bdCtrlLogDataEntry.getCreateOrgNumber());
                dataEntry.set("createorgname", (Object)bdCtrlLogDataEntry.getCreateOrgName());
                dataEntry.set("newcreateorg", (Object)bdCtrlLogDataEntry.getNewCreateOrgId());
                dataEntry.set("newcreateorgnumber", (Object)bdCtrlLogDataEntry.getNewCreateOrgNumber());
                dataEntry.set("newcreateorgname", (Object)bdCtrlLogDataEntry.getNewCreateOrgName());
                dataEntry.set("ctrlstrategy", (Object)bdCtrlLogDataEntry.getCtrlStrategy());
                dataEntry.set("datastatus", (Object)bdCtrlLogDataEntry.getDataStatus());
                dataEntry.set("failurecause", (Object)bdCtrlLogDataEntry.getFailureCause());
                dataEntryDoc.add((Object)dataEntry);
            }
            bdLog.set("dataentry", (Object)dataEntryDoc);
            DynamicObjectCollection orgEntryDoc = bdLog.getDynamicObjectCollection("orgentry");
            for (BDCtrlLogOrgEntry bdCtrlLogOrg : bdCtrlLog.getBdCtrlLogOrgList()) {
                DynamicObject orgEntry = new DynamicObject(orgEntryDoc.getDynamicObjectType());
                orgEntry.set("org", (Object)bdCtrlLogOrg.getOrgId());
                orgEntry.set("orgnumber", (Object)bdCtrlLogOrg.getOrgNumber());
                orgEntry.set("orgname", (Object)bdCtrlLogOrg.getOrgName());
                orgEntry.set("orgstatus", (Object)bdCtrlLogOrg.getOrgStatus());
                orgEntry.set("details", (Object)bdCtrlLogOrg.getDetails());
                DynamicObjectCollection failureCauseDetailEntryDoc = orgEntry.getDynamicObjectCollection("failurecausedetail");
                if (!CollectionUtils.isEmpty(bdCtrlLogOrg.getBdCtrlBDCtrlLogFailCauseList())) {
                    for (BDCtrlLogFailCause bdCtrlLogFail : bdCtrlLogOrg.getBdCtrlBDCtrlLogFailCauseList()) {
                        DynamicObject failEntry = new DynamicObject(failureCauseDetailEntryDoc.getDynamicObjectType());
                        failEntry.set("faildatanumber", (Object)bdCtrlLogFail.getFailDataNumber());
                        failEntry.set("faildataname", (Object)bdCtrlLogFail.getFailDataName());
                        failEntry.set("failcreateorg", (Object)bdCtrlLogFail.getFailCreateOrgId());
                        failEntry.set("failcreateorgnumber", (Object)bdCtrlLogFail.getFailCreateOrgNumber());
                        failEntry.set("failcreateorgname", (Object)bdCtrlLogFail.getFailCreateOrgName());
                        failEntry.set("orgfailurecause", (Object)bdCtrlLogFail.getOrgFailureCause());
                        failureCauseDetailEntryDoc.add((Object)failEntry);
                    }
                }
                if (!failureCauseDetailEntryDoc.isEmpty()) {
                    orgEntry.set("failurecausedetail", (Object)failureCauseDetailEntryDoc);
                }
                orgEntryDoc.add((Object)orgEntry);
            }
            bdLog.set("orgentry", (Object)orgEntryDoc);
            bdLogs[i] = bdLog;
        }
        try {
            OperationServiceHelper.executeOperate((String)"save", (String)"bd_log", (DynamicObject[])bdLogs, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            LOGGER.error("BDCtrlLogService saveLog:", (Throwable)e);
        }
    }

    public static List<Long> getNeedArchiveLogIds() {
        Date curentDate = new Date();
        SqlParameter sqlParameter = new SqlParameter(":farchivetime", 91, (Object)curentDate);
        String sql = "select fid, farchivetime from t_bdlog_log where farchivetime < ?";
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new SqlParameter[]{sqlParameter}, rs -> {
            ArrayList<Long> result = new ArrayList<Long>(16);
            while (rs.next()) {
                Long id = rs.getLong("fid");
                result.add(id);
            }
            return result;
        });
    }

    public static List<Long> getNeedArchiveCleanLogIds() {
        Date cleanDate = DateUtils.addDays((Date)new Date(), (int)-30);
        SqlParameter sqlParameter = new SqlParameter(":farchivetime", 91, (Object)cleanDate);
        String sql = "select fid, farchivetime from t_bdlog_archivelog where farchivetime < ?";
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new SqlParameter[]{sqlParameter}, rs -> {
            ArrayList<Long> result = new ArrayList<Long>(16);
            while (rs.next()) {
                Long id = rs.getLong("fid");
                result.add(id);
            }
            return result;
        });
    }
}

