/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.timetask;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bd.log.service.BDCtrlLogService;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;

public class BDCtrlLogArchiveTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(BDCtrlLogArchiveTask.class);
    private static final String TABLE_BDLOG = "T_BDLOG_LOG";
    private static final String TABLE_BDLOG_DATA = "T_BDLOG_DATAENTRY";
    private static final String TABLE_BDLOG_ORG = "T_BDLOG_ORGENTRY";
    private static final String TABLE_BDLOG_DETAIL = "T_BDLOG_FAILCAUSEDETAIL";
    private static final String TABLE_ARCHIVE = "T_BDLOG_ARCHIVELOG";
    private static final String TABLE_ARCHIVE_DATA = "T_BDLOG_ARCHIVEDATAENTRY";
    private static final String TABLE_ARCHIVE_ORG = "T_BDLOG_ARCHIVEORGENTRY";
    private static final String TABLE_ARCHIVE_DETAIL = "T_BDLOG_ARCHIVEFAILDETAIL";
    private static final String BDLOG_FIELDS = "FID, FNUMBER, FOPERATTYPEID, FOPERATTYPENUMBER, FOPERATTYPENAME, FOPERATSOURCE, FOPERATSOURCEID, FOPERATOBJ, FOPERATOBJNAME, FOPERATORGID, FOPERATORGNUMBER, FOPERATORGNAME, FOPERATTIME, FOPERATORID, FOPERATORNAME, FOPERATORNUMBER, FOPERATINSTRUCTION, FCLIENTTYPE, FCLIENTIP, FARCHIVETIME, FFROMBACKUP";
    private static final String BDLOG_DATAENTRY_FIELDS = "FID, FDATAENTRYID, FDATANUMBER, FDATANAME, FCREATEORGID, FCREATEORGNUMBER, FCREATEORGNAME, FNEWCREATEORGID, FNEWCREATEORGNUMBER, FNEWCREATEORGNAME, FCTRLSTRATEGY, FDATASTATUS, FFAILURECAUSE";
    private static final String BDLOG_ORGENTRY_FIELDS = "FID, FORGENTRYID, FORGID, FORGNUMBER, FORGNAME, FORGSTATUS, FDETAILS";
    private static final String BDLOG_DETAILENTRY_FIELDS = "FORGENTRYID, FFAILDETAILID, FFAILDATANUMBER, FFAILDATANAME, FFAILCREATEORGID, FFAILCREATEORGNUMBER, FFAILCREATEORGNAME, FORGFAILURECAUSE";
    private static final String PROP_LOG_ID = "fid";
    private static final String PROP_ENTRY_DATA_ID = "fdataentryid";
    private static final String PROP_ENTRY_ORG_ID = "forgentryid";
    private static final String PROP_ENTRY_DETAIL_ID = "ffaildetailid";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Long> needArchiveLogIds = BDCtrlLogService.getNeedArchiveLogIds();
        if (needArchiveLogIds == null || needArchiveLogIds.isEmpty()) {
            return;
        }
        log.debug("\u7ba1\u63a7\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u542f\u52a8");
        long startTime = System.currentTimeMillis();
        this.doArchive(needArchiveLogIds);
        long spendTime = System.currentTimeMillis() - startTime;
        log.debug("\u7ba1\u63a7\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u5b8c\u6210\u6240\u82b1\u8d39\u65f6\u957f\uff1a" + spendTime);
    }

    private void doArchive(List<Long> archiveIds) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                List<Long> needArchiveOrgEntryIds;
                this.archiveLog(TABLE_BDLOG, TABLE_ARCHIVE, BDLOG_FIELDS, PROP_LOG_ID, archiveIds);
                List<Long> needArchiveDataEntryIds = this.getNeedArchiveEntryIds(TABLE_BDLOG_DATA, archiveIds, PROP_LOG_ID, PROP_ENTRY_DATA_ID);
                if (!CollectionUtils.isEmpty(needArchiveDataEntryIds)) {
                    this.archiveLog(TABLE_BDLOG_DATA, TABLE_ARCHIVE_DATA, BDLOG_DATAENTRY_FIELDS, PROP_ENTRY_DATA_ID, needArchiveDataEntryIds);
                }
                if (!CollectionUtils.isEmpty(needArchiveOrgEntryIds = this.getNeedArchiveEntryIds(TABLE_BDLOG_ORG, archiveIds, PROP_LOG_ID, PROP_ENTRY_ORG_ID))) {
                    this.archiveLog(TABLE_BDLOG_ORG, TABLE_ARCHIVE_ORG, BDLOG_ORGENTRY_FIELDS, PROP_ENTRY_ORG_ID, needArchiveOrgEntryIds);
                    List<Long> needArchiveDetailEntryIds = this.getNeedArchiveEntryIds(TABLE_BDLOG_DETAIL, needArchiveOrgEntryIds, PROP_ENTRY_ORG_ID, PROP_ENTRY_DETAIL_ID);
                    if (!CollectionUtils.isEmpty(needArchiveDetailEntryIds)) {
                        this.archiveLog(TABLE_BDLOG_DETAIL, TABLE_ARCHIVE_DETAIL, BDLOG_DETAILENTRY_FIELDS, PROP_ENTRY_DETAIL_ID, needArchiveDetailEntryIds);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u7ba1\u63a7\u65e5\u5fd7\u5f52\u6863-\u5b9a\u65f6\u4efb\u52a1, \u53d1\u751f\u5f02\u5e38", (Throwable)e);
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private void archiveLog(String originTable, String targetTable, String columns, String idFieldName, List<Long> ids) {
        SqlBuilder insertSql = this.getInsertSql(originTable, targetTable, columns, idFieldName, ids);
        SqlBuilder deleteSql = this.getDeleteSql(originTable, idFieldName, ids);
        DB.execute((DBRoute)DBRoute.log, (SqlBuilder)insertSql);
        DB.execute((DBRoute)DBRoute.log, (SqlBuilder)deleteSql);
    }

    private List<Long> getNeedArchiveEntryIds(String table, List<Long> ids, String idFieldName, String entryIdFieldName) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(entryIdFieldName, new Object[0]).append(" from ", new Object[0]).append(table, new Object[0]).append("where ", new Object[0]).appendIn(idFieldName, ids.toArray());
        return (List)DB.query((DBRoute)DBRoute.log, (SqlBuilder)sqlBuilder, rs -> {
            ArrayList<Long> result = new ArrayList<Long>(10);
            while (rs.next()) {
                result.add(rs.getLong(entryIdFieldName));
            }
            return result;
        });
    }

    private SqlBuilder getInsertSql(String logTable, String archiveTable, String columns, String idFieldName, List<Long> ids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("insert into ", new Object[0]).append(archiveTable, new Object[0]).append(" (", new Object[0]).append(columns, new Object[0]).append(") select ", new Object[0]).append(columns, new Object[0]).append(" from ", new Object[0]).append(logTable, new Object[0]).append(" where ", new Object[0]).appendIn(idFieldName, ids.toArray());
        return sqlBuilder;
    }

    private SqlBuilder getDeleteSql(String table, String idFieldName, List<Long> ids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from ", new Object[0]).append(table, new Object[0]).append(" where ", new Object[0]).appendIn(idFieldName, ids.toArray());
        return sqlBuilder;
    }
}

