/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.mq;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.ConsumeTypeEnum;
import kd.bos.bd.pojo.SolidifyMessage;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.bd.utils.KryoSerializerUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataOrgRelSolidifyConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(BaseDataOrgRelSolidifyConsumer.class);
    private static final String FIELD_SOLIDIFY_OBJ = "solidifyobj";

    public void onMessage(Object body, String mqMsgId, boolean resend, MessageAcker acker) {
        try {
            List messages = (List)body;
            if (CollectionUtils.isEmpty((Collection)messages)) {
                acker.ack(mqMsgId);
                return;
            }
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fid, fuseorgid, fstatus, fentity, foptime from t_bd_solidify_msg where", new Object[0]).appendIn("fid", messages.toArray());
            ArrayList consumedMsgIds = new ArrayList(10);
            HashMap orgMsg = new HashMap(messages.size());
            String entity = (String)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
                String result = null;
                while (rs.next()) {
                    if (StringUtils.isBlank(result)) {
                        result = rs.getString("fentity");
                    }
                    if (!"0".equals(rs.getString("fstatus"))) {
                        consumedMsgIds.add(rs.getLong("fid"));
                        continue;
                    }
                    Long orgId = rs.getLong("fuseorgid");
                    Timestamp opTime = rs.getTimestamp("foptime");
                    Date currDate = (Date)orgMsg.get(orgId);
                    if (null == currDate) {
                        orgMsg.put(orgId, opTime);
                        continue;
                    }
                    if (!currDate.before(opTime)) continue;
                    orgMsg.put(orgId, opTime);
                }
                return result;
            });
            if (orgMsg.isEmpty()) {
                if (consumedMsgIds.isEmpty()) {
                    acker.deny(mqMsgId);
                    LOGGER.info(String.format("\u6267\u884c\u56fa\u5316\u5173\u7cfb\u6570\u636e\u7684\u6d88\u8d39\uff0cMQ\u6d88\u606fID\u4e3a\u3010%s\u3011\uff0c\u6d88\u606f\u8868\u4e2d\u65e0\u6570\u636e.", mqMsgId));
                } else {
                    builder = new SqlBuilder();
                    DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)builder.append("delete from t_bd_solidify_msg where", new Object[0]).appendIn("fid", consumedMsgIds.toArray()));
                    acker.ack(mqMsgId);
                    LOGGER.info(String.format("\u6267\u884c\u56fa\u5316\u5173\u7cfb\u6570\u636e\u7684\u6d88\u8d39\uff0cMQ\u6d88\u606fID\u4e3a\u3010%s\u3011\uff0c\u6d88\u606f\u8868\u7684\u6d88\u606f\u72b6\u6001\u5747\u4e3a\u5df2\u6d88\u8d39.", mqMsgId));
                }
                return;
            }
            String selectFields = "upgradestatus, solidifyobj";
            QFilter[] filters = new QFilter[]{new QFilter("basedataid", "=", (Object)entity)};
            DynamicObject ctrl = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
            String status = ctrl.getString("upgradestatus");
            if (!"2".equals(status)) {
                acker.ack(mqMsgId);
                return;
            }
            ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
            ArrayList<Future> futures = new ArrayList<Future>(orgMsg.size());
            String solidifyObj = ctrl.getDynamicObject(FIELD_SOLIDIFY_OBJ).getPkValue().toString();
            for (Map.Entry entry : orgMsg.entrySet()) {
                Future future = pool.submit(() -> {
                    this.consume(entity, (Long)entry.getKey(), (Date)entry.getValue(), solidifyObj, ConsumeTypeEnum.AUTO);
                    return true;
                }, RequestContext.get());
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
            acker.ack(mqMsgId);
        }
        catch (Throwable e) {
            acker.deny(mqMsgId);
            LOGGER.error(String.format("\u6d88\u606f\u6d88\u8d39\u5931\u8d25\uff0c\u5931\u8d25\u7684\u4e1a\u52a1\u6d88\u606fID\u4e3a\u3010%s\u3011\u3002", JSON.toJSONString((Object)body)), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(String entity, Long orgId, Date opTime, String solidifyObj, ConsumeTypeEnum consumeType) {
        String lockKey = String.format("lock_solidify_%s_%s", entity, orgId);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            SolidifyContext context = this.selectOrgMsgAsc(orgId, entity, opTime, solidifyObj, consumeType);
            List<SolidifyMessage> messages = context.message.getMessages();
            if (messages.isEmpty()) {
                if (consumeType == ConsumeTypeEnum.AUTO && !context.consumedMsgIds.isEmpty()) {
                    this.deleteConsumedMsg(orgId, entity, context.consumedMsgIds);
                }
                return;
            }
            for (SolidifyMessage msg : messages) {
                RoaringBitmap bit = msg.getBit();
                if (null == bit) continue;
                context.build(bit, msg.getOpType());
            }
            this.updateSolidifyInfo(context, consumeType);
        }
        finally {
            lock.unlock();
        }
    }

    private SolidifyContext selectOrgMsgAsc(Long orgId, String entity, Date opTime, String solidifyObj, ConsumeTypeEnum consumeType) {
        SolidifyContext context = new SolidifyContext(solidifyObj);
        String selectSql = "select fid, fstatus, foptype, fbitdata, foptime from t_bd_solidify_msg where fuseorgid = ? and fentity = ? and foptime <= ? order by foptime asc;";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":fuseorgid", -5, (Object)orgId), new SqlParameter(":fentity", 12, (Object)entity), new SqlParameter(":foptime", 91, (Object)opTime)};
        List solidifyMessage = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])parameters, rs -> {
            ArrayList<SolidifyMessage> messages = new ArrayList<SolidifyMessage>(10);
            while (rs.next()) {
                Long msgId = rs.getLong("fid");
                if ("0".equals(rs.getString("fstatus"))) {
                    SolidifyMessage message = new SolidifyMessage(msgId, rs.getString("foptype"));
                    message.setOpTime(rs.getDate("foptime"));
                    RoaringBitmap bit = KryoSerializerUtils.desRoaringBitmapByteArr(rs.getBytes("fbitdata"));
                    message.setBit(bit);
                    messages.add(message);
                }
                if (consumeType != ConsumeTypeEnum.AUTO) continue;
                context.consumedMsgIds.add(msgId);
            }
            return messages;
        });
        BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(entity, orgId);
        message.setMessages(solidifyMessage);
        context.message = message;
        return context;
    }

    public Map<String, Set<Long>> getSolidifyMessage(Object[] pks) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fentity, fuseorgid from t_bd_solidify_msg where", new Object[0]).appendIn("fid", pks);
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            HashMap<String, Set> result = new HashMap<String, Set>(16);
            while (rs.next()) {
                String entity = rs.getString("fentity");
                result.computeIfAbsent(entity, k -> new HashSet(16)).add(rs.getLong("fuseorgid"));
            }
            return result;
        });
    }

    private void updateSolidifyInfo(SolidifyContext context, ConsumeTypeEnum consumeType) {
        BaseDataSolidifyMessage message = context.message;
        IDataEntityType dt = ORM.create().newDynamicObject(context.solidifyObj).getDataEntityType();
        String tableName = dt.getAlias();
        try (TXHandle tx = TX.requiresNew();){
            try {
                Long useOrgId = message.getUseOrgId();
                DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
                this.deleteUseRel(context, tableName, route, useOrgId);
                this.insertUseRel(context, tableName, route, useOrgId);
                String entity = message.getEntity();
                if (consumeType == ConsumeTypeEnum.AUTO) {
                    this.updateSolidifyMsgStatus(consumeType, useOrgId, entity, context.consumedMsgIds);
                } else {
                    this.updateSolidifyMsgStatus(consumeType, useOrgId, entity, message.getMessageIds());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error(String.format("\u66f4\u65b0\u56fa\u5316\u4fe1\u606f\u76f8\u5173\u8868\u5931\u8d25\uff0c\u56fa\u5316\u5b9e\u4f53\u3010%s\u3011\uff0c\u8868\u540d\u3010%s\u3011\uff0c\u7ec4\u7ec7\u3010%s\u3011\u3002", context.solidifyObj, message.getEntity(), message.getUseOrgId()), (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u56fa\u5316\u4fe1\u606f\u76f8\u5173\u8868\u5931\u8d25\u3002", (String)"BaseDataOrgRelSolidifyConsumer_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private void updateSolidifyMsgStatus(ConsumeTypeEnum consumeType, Long orgId, String entity, List<Long> msgIds) {
        try (TXHandle tx = TX.requiresNew((String)"tx_solidify_msg_status");){
            try {
                if (consumeType == ConsumeTypeEnum.AUTO) {
                    this.deleteConsumedMsg(orgId, entity, msgIds);
                } else {
                    SqlBuilder builder = new SqlBuilder();
                    builder.append("update t_bd_solidify_msg set fstatus = '1' where", new Object[0]).append("fuseorgid = ?", new Object[]{orgId}).append("and", new Object[0]).append("fentity = ?", new Object[]{entity}).append("and", new Object[0]).appendIn("fid", msgIds.toArray());
                    DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)builder);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u66f4\u65b0\u56fa\u5316\u6d88\u606f\u8868\u7684\u6d88\u8d39\u72b6\u6001\u53d1\u751f\u5f02\u5e38.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u56fa\u5316\u6d88\u606f\u8868\u7684\u6d88\u8d39\u72b6\u6001\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataOrgRelSolidifyConsumer_1", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private void deleteConsumedMsg(Long orgId, String entity, List<Long> msgIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("delete from t_bd_solidify_msg where", new Object[0]).append("fuseorgid = ?", new Object[]{orgId}).append("and", new Object[0]).append("fentity = ?", new Object[]{entity}).append("and", new Object[0]).appendIn("fid", msgIds.toArray());
        DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)builder);
    }

    private void insertUseRel(SolidifyContext context, String tableName, DBRoute route, Long useOrgId) {
        if (context.adds.isEmpty()) {
            return;
        }
        Set<Integer> indexes = this.getExistIndex(context, tableName, route, useOrgId);
        context.adds.removeAll(indexes);
        if (context.adds.isEmpty()) {
            return;
        }
        String insert = "insert into " + tableName + " (fid, fbitindex, fuseorgid) values (?, ?, ?);";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        for (Integer index : context.adds) {
            params.add(new Object[]{DB.genGlobalLongId(), index, useOrgId});
            if (10000 != params.size()) continue;
            DB.executeBatch((DBRoute)route, (String)insert, params);
            params.clear();
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insert, params);
        }
    }

    private Set<Integer> getExistIndex(SolidifyContext context, String tableName, DBRoute route, Long useOrgId) {
        int pageSize = Integer.getInteger("orm.opt.in.maxsize", 500000);
        if (context.adds.size() <= pageSize) {
            return this.getExistIndex(tableName, route, useOrgId, context.adds);
        }
        HashSet<Integer> indexes = new HashSet<Integer>(16);
        ArrayList adds = new ArrayList(context.adds);
        int size = adds.size();
        int totalPage = size % pageSize > 0 ? size / pageSize + 1 : size / pageSize;
        for (int pageNo = 1; pageNo <= totalPage; ++pageNo) {
            int fromIndex = (pageNo - 1) * pageSize;
            int toIndex = Math.min(pageNo * pageSize, size);
            ArrayList<Integer> value = new ArrayList<Integer>(adds.subList(fromIndex, toIndex));
            indexes.addAll(this.getExistIndex(tableName, route, useOrgId, value));
        }
        return indexes;
    }

    private Set<Integer> getExistIndex(String tableName, DBRoute route, Long useOrgId, Collection<Integer> adds) {
        if (adds.isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder existBuilder = new SqlBuilder();
        existBuilder.append(" select fbitindex from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]);
        existBuilder.append("fuseorgid = ?", new Object[]{useOrgId}).append(" and ", new Object[0]);
        existBuilder.appendIn("fbitindex", adds.toArray());
        return (Set)DB.query((DBRoute)route, (SqlBuilder)existBuilder, rs -> {
            HashSet<Integer> result = new HashSet<Integer>(10);
            while (rs.next()) {
                result.add(rs.getInt("fbitindex"));
            }
            return result;
        });
    }

    private void deleteUseRel(SolidifyContext context, String tableName, DBRoute route, Long orgId) {
        if (context.removes.isEmpty()) {
            return;
        }
        SqlBuilder delete = new SqlBuilder();
        delete.append("delete from ", new Object[0]).append(tableName, new Object[0]).append("where", new Object[0]).append("fuseorgid = ?", new Object[]{orgId}).append("and", new Object[0]).appendIn("fbitindex", context.removes.toArray());
        DB.execute((DBRoute)route, (SqlBuilder)delete);
    }

    private static class SolidifyContext {
        private static final String OP_ADD = "1";
        private static final String UN_CONSUME = "0";
        BaseDataSolidifyMessage message;
        private String solidifyObj;
        private Set<Integer> adds = new HashSet<Integer>(16);
        private Set<Integer> removes = new HashSet<Integer>(16);
        private List<Long> consumedMsgIds = new ArrayList<Long>(0);

        SolidifyContext(String solidifyObj) {
            this.solidifyObj = solidifyObj;
        }

        private void build(RoaringBitmap bit, String opType) {
            List indexes = Arrays.stream(bit.toArray()).boxed().collect(Collectors.toList());
            if (OP_ADD.equals(opType)) {
                this.adds.addAll(indexes);
                this.removes.removeAll(indexes);
            } else {
                this.removes.addAll(indexes);
                this.adds.removeAll(indexes);
            }
        }
    }
}

