/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.pojo;

import java.io.Serializable;
import java.security.SecureRandom;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class CancelAssignProgressInfo
implements Serializable {
    private static final int MAX = 99;
    private static final double DEFAULT_INCR_FACTOR = 0.2;
    private int currPercentage;
    private int pageNo;
    private double segment;
    private boolean finish;

    public CancelAssignProgressInfo() {
    }

    public CancelAssignProgressInfo(double segment) {
        this.segment = segment;
    }

    public boolean incr() {
        if (!new SecureRandom().nextBoolean()) {
            return false;
        }
        int targetNo = this.pageNo + 1;
        int target = (int)Math.min((double)targetNo * this.segment * 100.0, 100.0);
        int sub = target - this.currPercentage;
        int incr = Math.max((int)((double)sub * 0.2), 1);
        int newPercentage = this.currPercentage + incr;
        if (newPercentage <= 99 && newPercentage < target) {
            this.currPercentage = newPercentage;
            return true;
        }
        return false;
    }

    public boolean complete() {
        return this.currPercentage == 100 || this.finish;
    }

    public int getCurrPercentage() {
        return this.currPercentage;
    }

    public void setCurrPercentage(int currPercentage) {
        this.currPercentage = currPercentage;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public double getSegment() {
        return this.segment;
    }

    public void setSegment(double segment) {
        this.segment = segment;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }
}

