/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.StringUtils;

@SdkInternal
public abstract class AbstractBaseService {
    protected static final String BOS_BD_BUSINESS = "bos-bd-business";
    protected static final DistributeSessionlessCache BD_COMMON_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BD_COMMON_CACHE", new DistributeCacheHAPolicy());
    private static DistributeSessionlessCache INDEX_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BASE_DATA_BIT_INDEX", new DistributeCacheHAPolicy());
    private static final CacheConfigInfo CACHE_CONFIG_INFO = new CacheConfigInfo();

    protected static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("BD_LOCAL_CACHE", RequestContext.get().getAccountId(), CACHE_CONFIG_INFO);
    }

    int getMaxBitIndex(String entityId, int dataSize, DBRoute route, String tableName) {
        int bitIndex = 0;
        String key = String.format("BIT_INDEX_%s_%s", entityId, RequestContext.get().getAccountId());
        String cacheValue = (String)INDEX_CACHE.get(key);
        if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
            bitIndex = Integer.parseInt(cacheValue);
        } else {
            String selectSql = String.format("select max(fbitindex) as bitIndex from %s;", tableName);
            int dbIndex = (Integer)DB.query((DBRoute)route, (String)selectSql, resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getInt("bitIndex");
                }
                return 0;
            });
            if (0 != dbIndex) {
                bitIndex = dbIndex;
            }
        }
        if (Integer.MAX_VALUE - dataSize < bitIndex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f4d\u56fe\u7d22\u5f15\u503c\u8d85\u51fa\u6700\u5927\u8303\u56f4\uff0c\u6dfb\u52a0\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractBaseService_0", (String)BOS_BD_BUSINESS, (Object[])new Object[0]));
        }
        return bitIndex;
    }

    protected int getMaxBitIndex(String entityId, int dataSize) {
        IDataEntityType dt = ORM.create().newDynamicObject(entityId).getDataEntityType();
        return this.getMaxBitIndex(entityId, dataSize, DBRoute.of((String)dt.getDBRouteKey()), dt.getAlias());
    }

    protected void updateBaseDataBitIndexCache(String entityId, String binIndex) {
        String key = String.format("BIT_INDEX_%s_%s", entityId, RequestContext.get().getAccountId());
        INDEX_CACHE.put(key, (Object)binIndex);
    }

    protected String getGenIndexLockKey(String entity) {
        return String.format("BASE_DATA_BIT_INDEX_%s_%s", RequestContext.get().getAccountId(), entity);
    }

    static {
        CACHE_CONFIG_INFO.setTimeout(43200);
        CACHE_CONFIG_INFO.setMaxItemSize(1000000);
        CACHE_CONFIG_INFO.setTimeToLive(false);
    }
}

