/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class AssignQueryService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(AssignQueryService.class);

    @Deprecated
    public AssignQueryService() {
    }

    public AssignQueryService(String entity) {
        super.init(entity);
    }

    @Deprecated
    public Collection<Long> queryUnAssignData(String entity, Long selectOrgId) {
        if (StringUtils.isBlank((CharSequence)this.entity)) {
            this.init(entity);
        }
        QFilter filter = this.queryUnAssignDataFilter(selectOrgId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> ids = new ArrayList<Long>(collection.size());
        collection.forEach(data -> ids.add(data.getLong("id")));
        return ids;
    }

    public QFilter queryUnAssignDataFilter(Long selectOrgId, Long useOrgId) {
        boolean isIgnoreStatus;
        Map<Long, RoaringBitmap> useRelBit;
        if (selectOrgId.equals(useOrgId)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        try {
            useRelBit = BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(Arrays.asList(useOrgId, selectOrgId), this.entity);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return new QFilter("id", "in", Collections.emptyList());
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        List supperOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), (long)selectOrgId);
        if (!supperOrgIds.contains(useOrgId)) {
            return this.getUnAssignFilterOnFreeStrategy(selectOrgId, useOrgId, useRelBit);
        }
        RoaringBitmap useBit = useRelBit.remove(useOrgId);
        if (useOrgId == 0L || null == useBit) {
            return new QFilter("bitindex", "in", Collections.emptyList());
        }
        Set<Integer> indexes = this.getHasUsePermAssignIndexes(useOrgId, useBit);
        if (indexes.isEmpty()) {
            return new QFilter("bitindex", "in", indexes);
        }
        HashSet<Long> orgIds = new HashSet<Long>(supperOrgIds.subList(supperOrgIds.indexOf(useOrgId) + 1, supperOrgIds.size()));
        orgIds.add(selectOrgId);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        filterList.add(new QFilter("ctrlstrategy", "in", Arrays.asList("1", "2")));
        filterList.add(new QFilter("createorg", "in", orgIds));
        filterList.add(QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName));
        DynamicObject[] dateArr = BusinessDataServiceHelper.load((String)this.entity, (String)"srcindex, createorg, bitindex", (QFilter[])filterList.toArray(new QFilter[0]));
        HashMap<Integer, Integer> indexSrcMap = new HashMap<Integer, Integer>(16);
        for (DynamicObject data : dateArr) {
            int index = data.getInt("bitindex");
            if (useOrgId.equals(AssignQueryService.getLongPropertyFromDynamicObject(data, "createorg"))) continue;
            indexSrcMap.put(index, data.getInt("srcindex"));
        }
        RoaringBitmap currBit = useRelBit.remove(selectOrgId);
        if (null != currBit) {
            for (Map.Entry entry : indexSrcMap.entrySet()) {
                Integer index = (Integer)entry.getKey();
                if (!currBit.contains(index.intValue())) continue;
                this.removeIndividuationData(index, indexSrcMap, indexes);
            }
            indexes.removeAll(Arrays.stream(currBit.toArray()).boxed().collect(Collectors.toSet()));
        }
        QFilter filter = new QFilter("bitindex", "in", indexes);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String billStatusKey = dt.getBillStatus();
        boolean bl = isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        if (!isIgnoreStatus) {
            filter.and(new QFilter(billStatusKey, "=", (Object)BillStatus.C.name()));
        }
        return filter;
    }

    private Set<Integer> getHasUsePermAssignIndexes(Long useOrgId, RoaringBitmap useBit) {
        String selectFields = "id, ctrlstrategy, createorg, bitindex, " + this.masterIdPropName;
        HashSet<Integer> indexes = new HashSet<Integer>(16);
        QFilter[] filters = new QFilter[]{new QFilter("bitindex", "in", (Object)useBit.toArray()), new QFilter("ctrlstrategy", "in", Arrays.asList("1", "2"))};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entity, (String)selectFields, (QFilter[])filters);
        for (DynamicObject data : collection) {
            if ("2".equals(data.getString("ctrlstrategy"))) {
                Long createOrgId = AssignQueryService.getLongPropertyFromDynamicObject(data, "createorg");
                Long dataId = data.getLong("id");
                if (!useOrgId.equals(createOrgId) || !dataId.equals(AssignQueryService.getLongPropertyFromDynamicObject(data, this.masterIdPropName))) continue;
                indexes.add(data.getInt("bitindex"));
                continue;
            }
            indexes.add(data.getInt("bitindex"));
        }
        return indexes;
    }

    private void removeIndividuationData(Integer index, Map<Integer, Integer> indexSrcMap, Set<Integer> indexes) {
        Integer srcIndex = indexSrcMap.get(index);
        if (null != srcIndex) {
            indexes.remove(srcIndex);
            this.removeIndividuationData(srcIndex, indexSrcMap, indexes);
        }
    }

    private QFilter getUnAssignFilterOnFreeStrategy(Long selectOrgId, Long useOrgId, Map<Long, RoaringBitmap> useRelBit) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String billStatusKey = dt.getBillStatus();
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        QFilter strategyFilter = new QFilter("ctrlstrategy", "=", (Object)"2");
        QFilter[] filters = new QFilter[]{strategyFilter, new QFilter("createorg", "=", (Object)selectOrgId), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)"srcindex", (QFilter[])filters).values();
        HashSet srcIndexes = new HashSet(values.size());
        values.forEach(data -> srcIndexes.add(data.getInt("srcindex")));
        strategyFilter.and(new QFilter("createorg", "=", (Object)useOrgId));
        strategyFilter.and(QFilter.sqlExpress((String)"id", (String)"=", (String)this.masterIdFieldName));
        RoaringBitmap useBit = useRelBit.remove(useOrgId);
        RoaringBitmap currBit = useRelBit.remove(selectOrgId);
        if (null != useBit && null != currBit) {
            currBit.add(srcIndexes.stream().mapToInt(v -> v).toArray());
            currBit.runOptimize();
            useBit.and(currBit);
            strategyFilter.and(new QFilter("bitindex", "not in", (Object)useBit.toArray()));
        }
        if (!isIgnoreStatus) {
            strategyFilter.and(new QFilter(billStatusKey, "=", (Object)BillStatus.C.name()));
        }
        return strategyFilter;
    }

    @Deprecated
    public QFilter queryUnAssignDataFilter(Long selectOrgId) {
        BillEntityType dt;
        String billStatusKey;
        Map<Long, RoaringBitmap> useRelBit;
        if (StringUtils.isBlank((CharSequence)this.entity)) {
            throw new KDBizException("the 'entity' field is empty, please call constructor with parameters to instance the object.");
        }
        long parentOrgId = this.getParentOrgId(selectOrgId, this.entity);
        try {
            useRelBit = BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(Arrays.asList(parentOrgId, selectOrgId), this.entity);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return new QFilter("id", "in", Collections.emptyList());
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        filterList.add(new QFilter("createorg", "=", (Object)selectOrgId));
        filterList.add(new QFilter("ctrlstrategy", "in", Arrays.asList("1", "2")));
        filterList.add(QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName));
        DynamicObject[] dateArr = BusinessDataServiceHelper.load((String)this.entity, (String)"ctrlstrategy, srcindex", (QFilter[])filterList.toArray(new QFilter[0]));
        HashSet<Integer> freeSrcIndexes = new HashSet<Integer>(16);
        HashSet<Integer> assignSrcIndexes = new HashSet<Integer>(16);
        for (DynamicObject dynamicObject : dateArr) {
            int srcIndex = dynamicObject.getInt("srcindex");
            if ("1".equals(dynamicObject.getString("ctrlstrategy"))) {
                assignSrcIndexes.add(srcIndex);
                continue;
            }
            freeSrcIndexes.add(srcIndex);
        }
        QFilter[] filters = new QFilter[]{new QFilter("ctrlstrategy", "=", (Object)"2"), new QFilter("createorg", "!=", (Object)selectOrgId)};
        DynamicObject[] freeDataArr = BusinessDataServiceHelper.load((String)this.entity, (String)"bitindex", (QFilter[])filters);
        HashSet<Integer> indexes = new HashSet<Integer>(freeDataArr.length);
        for (DynamicObject data : freeDataArr) {
            indexes.add(data.getInt("bitindex"));
        }
        indexes.removeAll(freeSrcIndexes);
        RoaringBitmap roaringBitmap = useRelBit.remove(selectOrgId);
        if (null != roaringBitmap) {
            indexes.removeAll(Arrays.stream(roaringBitmap.toArray()).boxed().collect(Collectors.toSet()));
        }
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)(billStatusKey = (dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity)).getBillStatus())) || dt.getProperty(billStatusKey).isDbIgnore();
        QFilter statusFilter = new QFilter(billStatusKey, "=", (Object)BillStatus.C.name());
        RoaringBitmap parentBit = useRelBit.remove(parentOrgId);
        QFilter strategyFilter = new QFilter("ctrlstrategy", "in", Arrays.asList(Character.valueOf('1'), Character.valueOf('2')));
        if (!isIgnoreStatus) {
            strategyFilter.and(statusFilter);
        }
        if (parentOrgId == 0L || null == parentBit) {
            return strategyFilter.and(new QFilter("bitindex", "in", indexes));
        }
        if (null != roaringBitmap) {
            parentBit.andNot(roaringBitmap);
        }
        parentBit.andNot(RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(assignSrcIndexes)));
        if (parentBit.toArray().length > 0) {
            indexes.addAll(Arrays.stream(parentBit.toArray()).boxed().collect(Collectors.toSet()));
        }
        return strategyFilter.and(new QFilter("bitindex", "in", indexes));
    }

    private Long getParentOrgId(Long selectOrgId, String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        QFilter[] orgFilters = new QFilter[]{new QFilter("view", "=", ctrlView.getPkValue()), new QFilter("org", "=", (Object)(selectOrgId == null ? Long.valueOf(0L) : selectOrgId))};
        DynamicObject parOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"parent.id", (QFilter[])orgFilters);
        if (null == parOrg) {
            return 0L;
        }
        return parOrg.getLong("parent.id");
    }

    public Map<Long, Set<Long>> assignQueryByOrg(String entity, Long useOrgId, Set<Long> orgIds) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.entity)) {
            this.init(entity);
        }
        return this.assignQueryByOrg(useOrgId, orgIds, null, -1, null);
    }

    public Map<Long, Set<Long>> assignQueryByOrg(Long useOrgId, Set<Long> orgIds, QFilter customFilter, int selectCount) throws Exception {
        return this.assignQueryByOrg(useOrgId, orgIds, customFilter, selectCount, null);
    }

    public Map<Long, Set<Long>> assignQueryByOrg(Long useOrgId, Set<Long> orgIds, QFilter customFilter, int selectCount, Consumer<Map<Long, DynamicObject>> consumer) throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.entity)) {
            throw new KDBizException("the 'entity' field is empty, please call constructor with parameters to instance the object.");
        }
        if (selectCount == 0) {
            return Collections.emptyMap();
        }
        QueryContext context = new QueryContext(customFilter, this.entity, selectCount);
        if (context.unMatchFilterData()) {
            return context.queryResult;
        }
        orgIds.add(useOrgId);
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
        BaseDataUseRelBit useOrgBit = useRelBitMap.remove(useOrgId);
        if (null == useOrgBit || null == useOrgBit.getBit() || useRelBitMap.isEmpty()) {
            return context.queryResult;
        }
        RoaringBitmap relBit = useOrgBit.getBit();
        Set<Integer> indexes = this.coverIntArr2Collection(relBit.toArray());
        if (!CollectionUtils.isEmpty((Collection)context.searchIndexes)) {
            indexes.retainAll(context.searchIndexes);
        }
        Future future = null;
        if (null != consumer) {
            future = BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
                context.initAbleAssignData(indexes);
                return Boolean.TRUE;
            }, RequestContext.get());
        }
        if (!context.initAbleAssignData(useOrgId, indexes)) {
            return context.queryResult;
        }
        context.initOrgCustomData(useRelBitMap.keySet());
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        HashSet<Long> subCuOrgIds = new HashSet<Long>(this.getDirectSubCuOrgList((Long)ctrlView.getPkValue(), useOrgId));
        ArrayList allAssignTypeDataIndexes = new ArrayList(context.graduallyDataMap.keySet());
        allAssignTypeDataIndexes.addAll(context.freeDataMap.keySet());
        allAssignTypeDataIndexes.addAll(context.customIndex2SrcMap.keySet());
        RoaringBitmap allAssignTypeDataBit = RoaringBitmap.bitmapOf((int[])allAssignTypeDataIndexes.stream().mapToInt(v -> v).toArray());
        allAssignTypeDataBit.runOptimize();
        for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
            BaseDataUseRelBit value = entry.getValue();
            if (null == value || null == value.getBit()) continue;
            RoaringBitmap bit = value.getBit();
            bit.and(allAssignTypeDataBit);
            if (!context.addAssignData(entry.getKey(), bit, subCuOrgIds)) continue;
            break;
        }
        if (null != consumer && null != future) {
            future.get();
            consumer.accept(context.dataMap);
        }
        return context.queryResult;
    }

    public Map<Long, List<Long>> assignQueryByData(String entity, List<Long> dataIds, Long useOrgId, String ctrlStrategy) throws Exception {
        Set<Long> orgIds = this.getTargetCuOrgIds(entity, useOrgId, ctrlStrategy);
        HashMap<Long, List<Long>> assignMap = new HashMap<Long, List<Long>>(dataIds.size());
        assignMap.putAll(this.getAssignDataFromUseBit(entity, dataIds, orgIds, true));
        Map<Long, Set<Long>> personalData = this.selectCustomDataFromDb(entity, dataIds);
        for (Map.Entry<Long, Set<Long>> entry : personalData.entrySet()) {
            Long orgId = entry.getKey();
            if (!orgIds.contains(orgId)) continue;
            assignMap.computeIfAbsent(orgId, k -> new ArrayList(10)).addAll((Collection)entry.getValue());
        }
        return assignMap;
    }

    private Set<Long> getTargetCuOrgIds(String entity, Long useOrgId, String ctrlStrategy) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        Set<Long> orgIds = Collections.emptySet();
        if ("1".equals(ctrlStrategy)) {
            orgIds = this.getAllCuSubordinateOrgIds(viewId, useOrgId);
        } else if ("2".equals(ctrlStrategy)) {
            orgIds = this.getAllCuOrgByViewId(viewId, useOrgId);
        }
        return orgIds;
    }

    public Map<Long, List<Long>> assignQueryByData(List<Long> dataIds, Long useOrgId, String ctrlStrategy) {
        try {
            Set<Long> orgIds = this.getTargetCuOrgIds(this.entity, useOrgId, ctrlStrategy);
            HashMap<Long, List<Long>> assignMap = new HashMap<Long, List<Long>>(dataIds.size());
            assignMap.putAll(this.getAssignDataFromUseBit(this.entity, dataIds, orgIds, false));
            Map<Long, Set<Long>> personalData = this.selectCustomDataFromDb(this.entity, dataIds);
            for (Map.Entry<Long, Set<Long>> entry : personalData.entrySet()) {
                Long orgId = entry.getKey();
                if (!orgIds.contains(orgId)) continue;
                entry.getValue().forEach(dataId -> assignMap.computeIfAbsent((Long)dataId, k -> new ArrayList(10)).add(orgId));
            }
            return assignMap;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u56fe\u4e2d\u83b7\u53d6\u6570\u636e\u5206\u914d\u4fe1\u606f\u5f02\u5e38\u3002", (String)"AssignQueryService_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    public Map<Long, RoaringBitmap> assignQueryByData(String entity, String ctrlStrategy, List<Long> dataIds, Long useOrgId) throws Exception {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        Set<Long> orgIds = Collections.emptySet();
        if ("2".equals(ctrlStrategy)) {
            orgIds = this.getAllCuOrgByViewId(viewId, useOrgId);
        } else if ("1".equals(ctrlStrategy)) {
            orgIds = this.getAllCuSubordinateOrgIds(viewId, useOrgId);
        }
        HashMap<Long, RoaringBitmap> assignMap = new HashMap<Long, RoaringBitmap>(dataIds.size());
        assignMap.putAll(this.getAssignDataFromUseBit(entity, orgIds, dataIds));
        Map<Long, Set<Integer>> personalData = this.selectCustomData(dataIds, entity);
        for (Map.Entry<Long, Set<Integer>> entry : personalData.entrySet()) {
            Long orgId = entry.getKey();
            if (!orgIds.contains(orgId)) continue;
            int[] indexes = this.covertIntegerList2IntArr((Collection<Integer>)entry.getValue());
            RoaringBitmap bit = (RoaringBitmap)assignMap.get(orgId);
            if (bit == null) {
                bit = RoaringBitmap.bitmapOf((int[])indexes);
                assignMap.put(orgId, bit);
            } else {
                bit.add(indexes);
            }
            bit.runOptimize();
        }
        return assignMap;
    }

    private Map<Long, Set<Integer>> selectCustomData(Collection<Long> dataIds, String entity) {
        HashMap<Long, Set<Integer>> personalDataMap = new HashMap<Long, Set<Integer>>(16);
        DynamicObjectCollection collection = this.selectCustomDataCollection(entity, dataIds, "createorg, srcindex");
        for (DynamicObject baseData : collection) {
            Long creator = baseData.getLong("createorg");
            Integer srcBitIndex = baseData.getInt("srcindex");
            personalDataMap.computeIfAbsent(creator, k -> new HashSet(16)).add(srcBitIndex);
        }
        return personalDataMap;
    }

    private Map<Long, List<Long>> getAssignDataFromUseBit(String entity, List<Long> dataIds, Collection<Long> orgIds, boolean isOrgMappingData) throws Exception {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        Map<Long, BaseDataUseRelBit> relBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
        if (CollectionUtils.isEmpty(relBitMap)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Long>> assignMap = new HashMap<Long, List<Long>>(16);
        Map<Integer, Long> index2IdMap = this.getBaseDataBitIndex2IdMap(dataIds, entity);
        int[] bitIndexArr = this.covertIntegerList2IntArr(index2IdMap.keySet());
        RoaringBitmap bitmap = RoaringBitmap.bitmapOf((int[])bitIndexArr);
        bitmap.runOptimize();
        for (Map.Entry<Long, BaseDataUseRelBit> entry : relBitMap.entrySet()) {
            BaseDataUseRelBit useRelBit = entry.getValue();
            RoaringBitmap bit = useRelBit.getBit();
            bit.and(bitmap);
            Long orgId = entry.getKey();
            for (Integer bitIndex : bit) {
                Long dataId = index2IdMap.get(bitIndex);
                if (isOrgMappingData) {
                    assignMap.computeIfAbsent(orgId, k -> new ArrayList(10)).add(dataId);
                    continue;
                }
                assignMap.computeIfAbsent(dataId, k -> new ArrayList(10)).add(orgId);
            }
        }
        return assignMap;
    }

    private Map<Long, RoaringBitmap> getAssignDataFromUseBit(String entity, Collection<Long> orgIds, List<Long> dataIds) throws Exception {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        Map<Long, BaseDataUseRelBit> relBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
        if (CollectionUtils.isEmpty(relBitMap)) {
            return Collections.emptyMap();
        }
        Map<Long, Integer> id2BitIndexMap = this.getBaseDataId2BitIndexMap(dataIds, entity);
        if (id2BitIndexMap.isEmpty()) {
            return Collections.emptyMap();
        }
        int[] bitIndexArr = this.covertIntegerList2IntArr(id2BitIndexMap.values());
        RoaringBitmap andBit = RoaringBitmap.bitmapOf((int[])bitIndexArr);
        andBit.runOptimize();
        HashMap<Long, RoaringBitmap> assignMap = new HashMap<Long, RoaringBitmap>(16);
        for (Map.Entry<Long, BaseDataUseRelBit> entry : relBitMap.entrySet()) {
            BaseDataUseRelBit useRelBit = entry.getValue();
            RoaringBitmap bit = useRelBit.getBit();
            if (null == bit) continue;
            bit.and(andBit);
            bit.runOptimize();
            assignMap.put(entry.getKey(), bit);
        }
        return assignMap;
    }

    public Map<Long, Set<Long>> assignQuery(String entity, Set<Long> dataIds, Set<Long> orgIds) throws Exception {
        Map<Integer, Long> bitIndex2IdMap = this.getBaseDataBitIndex2IdMap(dataIds, entity);
        HashMap<Long, Set<Long>> assignMap = new HashMap<Long, Set<Long>>(dataIds.size());
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity);
        for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
            RoaringBitmap bit = entry.getValue().getBit();
            Long orgId = entry.getKey();
            for (Map.Entry<Integer, Long> indexEntry : bitIndex2IdMap.entrySet()) {
                Integer index = indexEntry.getKey();
                if (!bit.contains(index.intValue())) continue;
                Long dataId = indexEntry.getValue();
                assignMap.computeIfAbsent(orgId, k -> new HashSet(16)).add(dataId);
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", orgIds), new QFilter("sourcedata", "in", dataIds), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)"createorg, sourcedata", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject baseData : collection) {
                assignMap.computeIfAbsent(baseData.getLong("createorg"), k -> new HashSet(16)).add(baseData.getLong("sourcedata"));
            }
        }
        return assignMap;
    }

    @Override
    public Set<Long> getAllCuSubordinateOrgIds(Long viewId, Long excludeOrdId) {
        return super.getAllCuSubordinateOrgIds(viewId, excludeOrdId);
    }

    public List<Long> getAssignTypeDataList(String entity, Long orgId) {
        int[] indexes = new int[]{};
        try {
            indexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexArrByOrgId(orgId, entity);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        if (indexes.length == 0) {
            return Collections.emptyList();
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("select fid, fctrlstrategy, fcreateorgid, %s from %s where ", this.masterIdFieldName, dt.getAlias()), new Object[0]);
        builder.appendIn("fbitindex", Arrays.stream(indexes).boxed().toArray());
        builder.append(" and fctrlstrategy in ('1', '2') order by fnumber;", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            ArrayList<Long> result = new ArrayList<Long>(10);
            while (rs.next()) {
                Long id = rs.getLong("fid");
                String ctrlStrategy = rs.getString("fctrlstrategy");
                if ("1".equals(ctrlStrategy)) {
                    result.add(id);
                    continue;
                }
                if (!id.equals(rs.getLong(this.masterIdFieldName))) continue;
                result.add(id);
            }
            return result;
        });
    }

    public List<Long> checkHasAssignData(Set<Long> dataIds) {
        if (CollectionUtils.isEmpty(dataIds)) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> assignedDataIds = new HashSet<Long>(16);
        assignedDataIds.addAll(new BaseDataCustomService(this.entity).selectCustomDataIds(this.entity, dataIds));
        dataIds.removeAll(assignedDataIds);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid, fcreateorgid, fctrlstrategy from", new Object[0]).append(dt.getAlias(), new Object[0]).append("where", new Object[0]).appendIn("fid", dataIds.toArray()).append(" and fctrlstrategy in ('1', '2')", new Object[0]);
        HashMap<Long, Set> orgDataMap = new HashMap<Long, Set>(16);
        boolean isIncludeFreeAssignData = false;
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);
        Iterator iterator = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                orgDataMap.computeIfAbsent(row.getLong("fcreateorgid"), k -> new HashSet(16)).add(row.getLong("fid"));
                if (!"2".equals(row.getString("fctrlstrategy"))) continue;
                isIncludeFreeAssignData = true;
            }
        }
        catch (Throwable row) {
            iterator = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)((Object)iterator)).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        BaseDataAssignService service = new BaseDataAssignService(this.entity);
        try {
            if (isIncludeFreeAssignData) {
                for (Map.Entry entry : orgDataMap.entrySet()) {
                    assignedDataIds.addAll(service.getAllAssignDataIds((Set)entry.getValue(), (Long)entry.getKey()));
                }
            } else {
                for (Map.Entry entry : orgDataMap.entrySet()) {
                    assignedDataIds.addAll(service.getDirectSubAssignData((Set)entry.getValue(), (Long)entry.getKey()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u914d\u67e5\u8be2\u5931\u8d25...", (Throwable)e);
            throw new KDBizException("assigned query failed.");
        }
        return new ArrayList<Long>(assignedDataIds);
    }

    private static class QueryContext {
        private QFilter customFilter;
        private Set<Integer> searchIndexes;
        private String entity;
        private int selectCount;
        private int size = 0;
        private Map<Integer, Integer> customIndex2SrcMap = new HashMap<Integer, Integer>(16);
        private Map<Integer, Long> graduallyDataMap = new HashMap<Integer, Long>(16);
        private Map<Integer, Long> freeDataMap = new HashMap<Integer, Long>(16);
        private Map<Long, Set<Long>> queryResult = new HashMap<Long, Set<Long>>(16);
        private Map<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        private RoaringBitmap graduallyBit = new RoaringBitmap();
        private RoaringBitmap freeBit = new RoaringBitmap();
        private RoaringBitmap customBit = new RoaringBitmap();

        private QueryContext(QFilter customFilter, String entity, int selectCount) {
            this.entity = entity;
            this.customFilter = customFilter;
            this.selectCount = selectCount;
            this.searchIndexes = this.initCustomSearchDataBitIndexes();
        }

        private Set<Integer> initCustomSearchDataBitIndexes() {
            if (null == this.customFilter) {
                return Collections.emptySet();
            }
            QFilter[] filters = new QFilter[]{this.customFilter, new QFilter("ctrlstrategy", "in", Arrays.asList("1", "2"))};
            DynamicObjectCollection values = QueryServiceHelper.query((String)this.entity, (String)"bitindex", (QFilter[])filters);
            HashSet<Integer> searchIndexes = new HashSet<Integer>(values.size());
            values.forEach(data -> searchIndexes.add(data.getInt("bitindex")));
            return searchIndexes;
        }

        private boolean initAbleAssignData(Long useOrgId, Set<Integer> indexes) {
            if (indexes.isEmpty()) {
                return false;
            }
            IDataEntityType dt = ORM.create().newDynamicObject(this.entity).getDataEntityType();
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fid, fbitindex, fsourcebitindex, fctrlstrategy, fcreateorgid from ", new Object[0]).append(dt.getAlias(), new Object[0]).append("where", new Object[0]).append("fctrlstrategy in ('1', '2') and", new Object[0]).appendIn("fbitindex", indexes.toArray());
            boolean result = (Boolean)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
                while (rs.next()) {
                    Long dataId = rs.getLong("fid");
                    int index = rs.getInt("fbitindex");
                    String strategy = rs.getString("fctrlstrategy");
                    if ("1".equals(strategy)) {
                        this.graduallyDataMap.put(index, dataId);
                        continue;
                    }
                    int srcIndex = rs.getInt("fsourcebitindex");
                    if (index != srcIndex || !useOrgId.equals(rs.getLong("fcreateorgid"))) continue;
                    this.freeDataMap.put(index, dataId);
                }
                return !this.graduallyDataMap.isEmpty() || !this.freeDataMap.isEmpty();
            });
            this.graduallyBit.add(this.graduallyDataMap.keySet().stream().mapToInt(Integer::intValue).toArray());
            this.freeBit.add(this.freeDataMap.keySet().stream().mapToInt(Integer::intValue).toArray());
            return result;
        }

        private void initAbleAssignData(Set<Integer> indexes) {
            QFilter[] filters = new QFilter[]{new QFilter("ctrlstrategy", "in", Arrays.asList("1", "2")), new QFilter("bitindex", "in", indexes)};
            String selectProperties = "id,number,org,bitindex, srcindex, ctrlstrategy, createorg.id, createorg.name,";
            selectProperties = BaseDataCommonService.isTreeType(this.entity) ? selectProperties + "fullname" : selectProperties + "name";
            DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)this.entity, (String)selectProperties, (QFilter[])filters);
            if (null != dataArr && dataArr.length > 0) {
                for (DynamicObject data : dataArr) {
                    this.dataMap.put(data.getLong("id"), data);
                }
            }
        }

        private boolean unMatchFilterData() {
            return null != this.customFilter && this.searchIndexes.isEmpty();
        }

        private void initOrgCustomData(Set<Long> orgIds) {
            QFilter[] filters;
            DynamicObjectCollection collection;
            ArrayList<Integer> srcIndexes = new ArrayList<Integer>(10);
            if (!this.graduallyDataMap.isEmpty()) {
                srcIndexes.addAll(this.graduallyDataMap.keySet());
            }
            if (!this.freeDataMap.isEmpty()) {
                srcIndexes.addAll(this.freeDataMap.keySet());
            }
            if (CollectionUtils.isEmpty((Collection)(collection = QueryServiceHelper.query((String)this.entity, (String)"bitindex, srcindex", (QFilter[])(filters = new QFilter[]{new QFilter("createorg", "in", orgIds), new QFilter("srcindex", "in", srcIndexes)}))))) {
                return;
            }
            for (DynamicObject data : collection) {
                int index = data.getInt("bitindex");
                int srcIndex = data.getInt("srcindex");
                this.customIndex2SrcMap.put(index, srcIndex);
            }
            this.customBit.add(this.customIndex2SrcMap.keySet().stream().mapToInt(Integer::intValue).toArray());
        }

        private boolean addAssignData(Long orgId, RoaringBitmap bit, Set<Long> subCuOrgIds) {
            if (!this.graduallyDataMap.isEmpty() && subCuOrgIds.contains(orgId) && this.addQueryResult(orgId, bit.clone(), this.graduallyDataMap, this.graduallyBit)) {
                return true;
            }
            if (!this.freeDataMap.isEmpty()) {
                return this.addQueryResult(orgId, bit, this.freeDataMap, this.freeBit);
            }
            return false;
        }

        private boolean addQueryResult(Long orgId, RoaringBitmap bit, Map<Integer, Long> index2IdMap, RoaringBitmap assignBit) {
            RoaringBitmap clone = this.customBit.clone();
            clone.and(bit);
            if (!clone.isEmpty()) {
                Set customIndexes = Arrays.stream(clone.toArray()).boxed().collect(Collectors.toSet());
                HashMap<Integer, Integer> customMap = new HashMap<Integer, Integer>(this.customIndex2SrcMap);
                customMap.keySet().retainAll(customIndexes);
                Collection srcIndexes = customMap.values();
                if (!srcIndexes.isEmpty()) {
                    bit.add(srcIndexes.stream().mapToInt(Integer::intValue).toArray());
                }
            }
            bit.and(assignBit);
            if (bit.isEmpty()) {
                return false;
            }
            HashMap<Integer, Long> dataMap = new HashMap<Integer, Long>(index2IdMap);
            Set indexes = dataMap.keySet();
            indexes.retainAll(Arrays.stream(bit.toArray()).boxed().collect(Collectors.toSet()));
            for (Long dataId : dataMap.values()) {
                this.queryResult.computeIfAbsent(orgId, k -> new HashSet(16)).add(dataId);
                if (this.selectCount == -1) continue;
                ++this.size;
                if (this.size < this.selectCount) continue;
                return true;
            }
            return false;
        }
    }
}

