/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.ctsy.service.CtsyAssignSyncService;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.bd.validator.BaseDataAssignValidator;
import kd.bos.bd.validator.FreeStrategyAssignValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AssignService {
    private static final Log LOGGER = LogFactory.getLog(AssignService.class);
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private final String entityId;
    private Long assignOrgId;
    private String masterIdField;
    private String masterIdProp;
    private final String numberPro;
    private boolean autoFillSupNodeId;
    private boolean isTreeType;
    private boolean isAssignUnDetail;
    private Map<Long, Set<Long>> assignMap;
    private Set<Long> orgIds;
    private static final String PARENTID = "parentId";
    private static final String FIELD_NUMBER = "FNUMBER";

    public AssignService(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            throw new KDBizException("entityId is empty");
        }
        this.entityId = entityId;
        this.isTreeType = BaseDataCommonService.isTreeType(entityId);
        if (this.isTreeType) {
            this.autoFillSupNodeId = true;
            this.isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail(entityId);
        }
        this.numberPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? "masterid.number" : "number";
    }

    public AssignService(String entityId, boolean autoFillSupNodeId) {
        this(entityId);
        this.autoFillSupNodeId = this.isTreeType && autoFillSupNodeId;
    }

    public BaseDataResponse assign(Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds, boolean isValidate) {
        BaseDataResponse response;
        try {
            if (isValidate) {
                BaseDataAssignValidator validator = new BaseDataAssignValidator(this.entityId, assignOrgId, appId, dataIds, orgIds);
                response = validator.assignValidate();
            } else {
                response = new BaseDataResponse(true, "");
            }
            this.assign(assignOrgId, dataIds, orgIds, response);
        }
        catch (Exception e) {
            LOGGER.error("BaseDataAssignService assign error:", (Throwable)e);
            return new BaseDataResponse(false, e.getMessage());
        }
        this.saveCtrlLog(assignOrgId, dataIds, orgIds, response);
        new CtsyAssignSyncService(this.entityId, assignOrgId, appId).ctsyAssign(dataIds, orgIds);
        return response;
    }

    protected BaseDataResponse assign(Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        BaseDataResponse response;
        try {
            BaseDataAssignValidator validator = new BaseDataAssignValidator(this.entityId, assignOrgId, appId, dataIds, orgIds){

                @Override
                protected void assignPermValidate(BaseDataResponse response) {
                }
            };
            response = validator.assignValidate();
            this.assign(assignOrgId, dataIds, orgIds, response);
        }
        catch (Exception e) {
            LOGGER.error("BaseDataAssignService assign error:", (Throwable)e);
            return new BaseDataResponse(false, e.getMessage());
        }
        this.saveCtrlLog(assignOrgId, dataIds, orgIds, response);
        new CtsyAssignSyncService(this.entityId, assignOrgId, appId).ctsyAssign(dataIds, orgIds);
        return response;
    }

    private void assign(Long assignOrgId, Set<Long> dataIds, Set<Long> orgIds, BaseDataResponse response) throws Exception {
        if (response.isSuccess()) {
            Map<Long, Map<Long, String>> result;
            this.initAssignData(this.entityId, assignOrgId, orgIds);
            boolean isCuAssign = this.isCuAssign(this.entityId, dataIds);
            if (isCuAssign) {
                this.fillSubordinateOrg(this.entityId, assignOrgId, orgIds);
                this.fillAssignMap(orgIds);
            } else {
                orgIds.remove(assignOrgId);
            }
            if (this.autoFillSupNodeId) {
                dataIds.addAll(this.assignAutoData(dataIds));
            }
            if (BaseDataCommonService.isNewModel(this.entityId)) {
                BaseDataAssignService baseDataAssignService = new BaseDataAssignService(this.entityId);
                baseDataAssignService.setAssignOrgId(assignOrgId);
                if (isCuAssign) {
                    orgIds.remove(assignOrgId);
                    baseDataAssignService.setAssignOrgMap(this.assignMap);
                    result = baseDataAssignService.batchCuAssign(dataIds, orgIds, assignOrgId);
                } else {
                    result = baseDataAssignService.batchAssign(new ArrayList<Long>(dataIds), new ArrayList<Long>(orgIds));
                }
            } else {
                result = this.executeAssignOnOldModel(new ArrayList<Long>(dataIds));
            }
            if (!CollectionUtils.isEmpty(result)) {
                response.setSuccess(false);
                response.setResult(result);
            }
        }
    }

    private void saveCtrlLog(Long assignOrgId, Set<Long> dataIds, Set<Long> orgIds, BaseDataResponse response) {
        boolean isEmptyData;
        boolean bl = isEmptyData = CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(orgIds);
        if (isEmptyData || StringUtils.isBlank((CharSequence)this.entityId) || null == assignOrgId) {
            return;
        }
        String operationInstruction = response.isSuccess() ? null : response.getErrorMsg();
        Map<String, Object> threadLocal = BDCtrlLogHelper.THREAD_LOCAL.get();
        if (null == threadLocal || null == threadLocal.get("source")) {
            BDCtrlLogHelper.setLogSourceType(BDCtrlOperateSource.INTERFACE_OP);
        }
        BDCtrlLogHelper.saveAssignLog(this.entityId, assignOrgId, new ArrayList<Long>(dataIds), new ArrayList<Long>(orgIds), response.getResult(), operationInstruction);
    }

    private void fillAssignMap(Set<Long> orgIds) {
        DynamicObject orgView = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        String viewNumber = orgView.getString("number");
        Map subordinateOrgMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)viewNumber, new ArrayList<Long>(orgIds));
        ArrayList orgList = new ArrayList(subordinateOrgMap.size());
        Set entrySet = subordinateOrgMap.entrySet();
        for (Map.Entry entry : entrySet) {
            HashMap<String, Object> org = new HashMap<String, Object>(2);
            org.put("id", entry.getKey());
            org.put(PARENTID, entry.getValue());
            orgList.add(org);
        }
        this.assignMap = new HashMap<Long, Set<Long>>(orgList.size());
        for (Map map : orgList) {
            Long orgId = Long.valueOf(map.get("id").toString());
            orgIds.add(orgId);
            Long parentOrgId = null == map.get(PARENTID) ? 0L : Long.parseLong(map.get(PARENTID).toString());
            if (this.assignOrgId.equals(orgId)) continue;
            Set<Object> orgIdSet = null == this.assignMap.get(parentOrgId) ? new HashSet(1) : this.assignMap.get(parentOrgId);
            orgIdSet.add(orgId);
            this.assignMap.put(parentOrgId, orgIdSet);
        }
    }

    private void initAssignData(String entityId, Long assignOrgId, Set<Long> orgIds) {
        this.assignOrgId = assignOrgId;
        this.orgIds = orgIds;
        this.masterIdField = BaseDataServiceHelper.getMasterIdFieldName((String)entityId);
        this.masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
    }

    private List<Long> assignAutoData(Set<Long> ids) {
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entityId);
        if (this.isAssignUnDetail) {
            return service.getIntegrityNodeIds(ids, this.assignOrgId);
        }
        return service.getIntegrityTreeNodeIds(ids, this.assignOrgId);
    }

    private boolean isCuAssign(String entityId, Set<Long> dataIds) {
        String selectProperties = "id,masterId,number,createOrg.id,status,ctrlStrategy";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)selectProperties, (QFilter[])filters);
        if (null == obj) {
            return false;
        }
        return "1".equals(obj.getString("ctrlstrategy"));
    }

    private void fillSubordinateOrg(String entityId, Long assignOrgId, Set<Long> orgIds) {
        DynamicObject orgView = BaseDataServiceHelper.getCtrlview((String)entityId);
        Map supMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView.getString("number"), new ArrayList<Long>(orgIds));
        for (List orgList : supMap.values()) {
            if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)orgList)) continue;
            orgIds.addAll(orgList);
        }
        ArrayList<Long> paramList = new ArrayList<Long>(1);
        paramList.add(assignOrgId);
        Map useOrgSupMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView.getString("number"), paramList);
        for (List orgList : useOrgSupMap.values()) {
            if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)orgList)) continue;
            orgIds.removeAll(orgList);
        }
        orgIds.remove(assignOrgId);
    }

    private Map<Long, Map<Long, String>> executeAssignOnOldModel(List<Long> dataIds) {
        QFilter[] filters;
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyMap();
        }
        Map<Long, String> dataIdNumberMap = this.initDataNumber(dataIds);
        HashMap<Long, Map<Long, String>> checkAssignRes = new HashMap(16);
        String selectProperties = this.isTreeType ? "id," + this.masterIdProp + ",number,createOrg.id,status,ctrlStrategy,isLeaf,longNumber" : "id," + this.masterIdProp + ",number,createOrg.id,status,ctrlStrategy";
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)this.entityId, (String)selectProperties, (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)dataIds.get(0))}));
        String firstCtrlStrategy = obj.getString("ctrlstrategy");
        if (firstCtrlStrategy.equals("2")) {
            checkAssignRes = BaseDataServiceHelper.batchAssignWithDetail((String)this.entityId, (Long)this.assignOrgId, dataIds, new ArrayList<Long>(this.orgIds));
        } else {
            String selectFields = String.join((CharSequence)",", "id", "ctrlstrategy", this.numberPro, this.masterIdProp);
            this.handleAssignDataByLevel(this.assignOrgId, checkAssignRes, dataIds, dataIdNumberMap, selectFields);
        }
        this.writOpLog(this.assignOrgId);
        return checkAssignRes;
    }

    private Map<Long, String> initDataNumber(List<Long> dataIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entityId);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid, fnumber from ", new Object[0]).append(dt.getAlias(), new Object[0]).append(" where ", new Object[0]);
        builder.appendIn("fid", dataIds.toArray());
        return (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            HashMap<Long, String> idNumber = new HashMap<Long, String>(16);
            while (rs.next()) {
                idNumber.put(rs.getLong("FID"), rs.getString(FIELD_NUMBER));
            }
            return idNumber;
        });
    }

    private void handleAssignDataByLevel(Long parentId, Map<Long, Map<Long, String>> checkAssignRes, List<Long> dataIds, Map<Long, String> dataIdNumberMap, String selectFields) {
        if (!this.assignMap.containsKey(parentId) || CollectionUtils.isEmpty(dataIds)) {
            return;
        }
        Map<Long, Long> dataIdMasterIdMap = this.getDataIdMasterIdMap(dataIds);
        QFilter[] filters = new QFilter[]{new QFilter(this.masterIdProp, "in", dataIdMasterIdMap.values()), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdField), new QFilter("createorg", "=", (Object)parentId)};
        Map individuation = BusinessDataServiceHelper.loadFromCache((String)this.entityId, (String)selectFields, (QFilter[])filters);
        HashMap<Long, String> personalDataMap = new HashMap<Long, String>(individuation.size());
        for (Object data : individuation.values()) {
            Long mid = AbstractBaseDataService.getLongPropertyFromDynamicObject((DynamicObject)data, this.masterIdProp);
            Object dataId = data.getPkValue();
            personalDataMap.put(mid, dataId + "_" + data.getString("ctrlstrategy"));
            dataIdNumberMap.put((Long)dataId, data.getString(this.numberPro));
        }
        ArrayList<Long> assignDataIds = new ArrayList<Long>(dataIds.size());
        for (Long dataId : dataIds) {
            Long masterId = dataIdMasterIdMap.get(dataId);
            if (!personalDataMap.containsKey(masterId)) {
                assignDataIds.add(dataId);
                continue;
            }
            if (!"1".equals(((String)personalDataMap.get(masterId)).split("_")[1])) continue;
            assignDataIds.add(Long.valueOf(((String)personalDataMap.get(masterId)).split("_")[0]));
        }
        ArrayList subOrgIds = new ArrayList(this.assignMap.get(parentId));
        Map checkAssignReMap = BaseDataServiceHelper.batchAssignWithDetail((String)this.entityId, (Long)parentId, assignDataIds, subOrgIds);
        if (!CollectionUtils.isEmpty((Map)checkAssignReMap)) {
            for (Map.Entry entry : checkAssignReMap.entrySet()) {
                checkAssignRes.computeIfAbsent((Long)entry.getKey(), (Function<Long, Map<Long, String>>)((Function<Long, Map>)k -> new HashMap(16))).putAll((Map)entry.getValue());
            }
        }
        for (Long l : subOrgIds) {
            this.handleAssignDataByLevel(l, checkAssignRes, assignDataIds, dataIdNumberMap, selectFields);
        }
    }

    private Map<Long, Long> getDataIdMasterIdMap(List<Long> dataIds) {
        HashMap<Long, Long> id2MstIdMap = new HashMap<Long, Long>(0);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), this.entityId, "id, " + this.masterIdProp, filters);){
            ds.forEach(row -> id2MstIdMap.put(row.getLong("id"), row.getLong(this.masterIdProp)));
        }
        return id2MstIdMap;
    }

    private void writOpLog(Long opOrg) {
        if (CollectionUtils.isEmpty(this.assignMap)) {
            return;
        }
        BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
            Date opTime = new Date();
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.entityId);
            String appNumber = met.getBizAppNumber();
            AppLogInfo appLogInfo = this.buildAppLogInfo(opTime, opOrg, this.entityId, BizAppServiceHelp.getAppIdByAppNumber((String)appNumber));
            ArrayList<AppLogInfo> logs = new ArrayList<AppLogInfo>(1);
            logs.add(appLogInfo);
            LogServiceHelper.addBatchLog(logs);
            return Boolean.TRUE;
        }, RequestContext.get());
    }

    private AppLogInfo buildAppLogInfo(Date opTime, Long opOrg, String entity, String appId) {
        RequestContext context = RequestContext.get();
        Long userId = context.getCurrUserId();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(userId);
        if (opOrg == null) {
            appLogInfo.setOrgID(Long.valueOf(context.getOrgId()));
        } else {
            appLogInfo.setOrgID(opOrg);
        }
        appLogInfo.setClientIP(context.getLoginIP());
        appLogInfo.setClientType(context.getClient());
        appLogInfo.setClientName(context.getClient());
        appLogInfo.setAccountId(context.getAccountId());
        appLogInfo.setTenantId(context.getTenantId());
        appLogInfo.setLanguage(context.getLang().name());
        appLogInfo.setOpTime(opTime);
        appLogInfo.setOpName("assign_new", BaseDataCommon.getOpName(entity, "assign_new"));
        appLogInfo.setBizObjID(entity);
        appLogInfo.setBizAppID(appId);
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5b8c\u6210\uff0c\u8be6\u60c5\u53ef\u89c1\u7ba1\u63a7\u65e5\u5fd7\uff0c\u5177\u4f53\u8def\u5f84\uff1a\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011-\u3010\u4f01\u4e1a\u5efa\u6a21\u3011-\u3010\u7ba1\u63a7\u7b56\u7565\u3011-\u3010\u7ba1\u63a7\u65e5\u5fd7\u3011\u3002", "AssignService_2", SYSTEM_TYPE), new String[0]);
        return appLogInfo;
    }

    public void autoIndividualOnOriginalModel(Long assignOrgId, List<Long> dataIds, Set<Long> orgIds, Map<Long, Set<Long>> unableAssignMap) {
        if (!this.isAssignUnDetail) {
            return;
        }
        ArrayList<Long> freeDataIds = new ArrayList<Long>(10);
        ArrayList<Long> graduallyDataIds = new ArrayList<Long>(10);
        QFilter[] baseDataFilters = new QFilter[]{new QFilter("id", "in", dataIds)};
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), this.entityId, "id, ctrlstrategy", baseDataFilters);){
            for (Row row : ds) {
                String strategy = row.getString("ctrlstrategy");
                if ("1".equals(strategy)) {
                    graduallyDataIds.add(row.getLong("id"));
                    continue;
                }
                if (!"2".equals(strategy)) continue;
                freeDataIds.add(row.getLong("id"));
            }
        }
        this.masterIdField = BaseDataServiceHelper.getMasterIdFieldName((String)this.entityId);
        this.masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)this.entityId);
        if (!graduallyDataIds.isEmpty()) {
            this.autoIndividualWithGraduallyDataOnOriginalModel(assignOrgId, graduallyDataIds, orgIds, unableAssignMap);
        }
        if (!freeDataIds.isEmpty()) {
            this.autoIndividualWithFreeDataOnOriginalModel(freeDataIds, orgIds, unableAssignMap);
        }
    }

    private void autoIndividualWithGraduallyDataOnOriginalModel(Long assignOrgId, List<Long> dataIds, Set<Long> orgIds, Map<Long, Set<Long>> unableAssignMap) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fisctrlunit = '1' and ", new Object[0]).append("fviewid = ?", new Object[]{ctrlView.getPkValue()}).append("and", new Object[0]).append("fparentid != ?", new Object[]{assignOrgId}).append("and", new Object[0]).appendIn("forgid", orgIds.toArray());
        List unDirectSubOrgIds = (List)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
            ArrayList<Long> result = new ArrayList<Long>(10);
            while (rs.next()) {
                result.add(rs.getLong("forgid"));
            }
            return result;
        });
        Map<Long, Long> id2MstIdMap = this.getDataIdMasterIdMap(dataIds);
        if (unDirectSubOrgIds.isEmpty()) {
            this.individualWithGraduallyDataOnOriginalModel(dataIds, orgIds, unableAssignMap, id2MstIdMap);
            return;
        }
        HashMap<Long, Set<Long>> assignOrgMap = new HashMap<Long, Set<Long>>(unableAssignMap.size() + 1);
        orgIds.removeAll(unDirectSubOrgIds);
        assignOrgMap.put(assignOrgId, orgIds);
        Map superiors = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), (List)unDirectSubOrgIds);
        for (Map.Entry entry : superiors.entrySet()) {
            List suppers = (List)entry.getValue();
            suppers.add(entry.getKey());
            boolean isBuild = false;
            for (int i = 0; i < suppers.size() - 1; ++i) {
                Long supper = (Long)suppers.get(i);
                if (assignOrgId.equals(supper)) {
                    assignOrgMap.computeIfAbsent(assignOrgId, k -> new HashSet(16)).add(suppers.get(i + 1));
                    isBuild = true;
                    continue;
                }
                if (!isBuild) continue;
                assignOrgMap.computeIfAbsent(supper, k -> new HashSet(16)).add(suppers.get(i + 1));
            }
        }
        Set childOrgIds = (Set)assignOrgMap.get(assignOrgId);
        if (!CollectionUtils.isEmpty((Collection)childOrgIds)) {
            this.individualWithGraduallyDataOnOriginalModel(dataIds, childOrgIds, unableAssignMap, id2MstIdMap);
            for (Long childOrgId : childOrgIds) {
                this.eachIndividualWithGraduallyDataOnOriginalModel(assignOrgMap, childOrgId, dataIds, unableAssignMap);
            }
        }
    }

    private void eachIndividualWithGraduallyDataOnOriginalModel(Map<Long, Set<Long>> assignOrgMap, Long assignOrgId, List<Long> dataIds, Map<Long, Set<Long>> unableAssignMap) {
        ArrayList<Long> assignDataIds;
        Set<Long> childOrgIds = assignOrgMap.get(assignOrgId);
        if (CollectionUtils.isEmpty(childOrgIds)) {
            return;
        }
        Map<Long, Long> dataIdMasterIdMap = this.getDataIdMasterIdMap(dataIds);
        QFilter[] filters = new QFilter[]{new QFilter(this.masterIdProp, "in", dataIdMasterIdMap.values()), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdField), new QFilter("createorg", "=", (Object)assignOrgId)};
        HashMap personalized = new HashMap(16);
        DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), this.entityId, "id, " + this.masterIdProp, filters);
        Object object = null;
        try {
            ds.forEach(row -> personalized.put(row.getLong("id"), row.getLong(this.masterIdProp)));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!personalized.isEmpty()) {
            Map<Long, Long> mstId2IdMap = dataIdMasterIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            for (Long masterId : personalized.values()) {
                Long originalId = mstId2IdMap.get(masterId);
                if (null == originalId) continue;
                dataIdMasterIdMap.remove(originalId);
            }
            dataIdMasterIdMap.putAll(personalized);
            assignDataIds = new ArrayList<Long>(dataIdMasterIdMap.keySet());
            this.individualWithGraduallyDataOnOriginalModel(assignDataIds, childOrgIds, unableAssignMap, dataIdMasterIdMap);
        } else {
            assignDataIds = new ArrayList<Long>(dataIds);
        }
        for (Long childOrgId : childOrgIds) {
            this.eachIndividualWithGraduallyDataOnOriginalModel(assignOrgMap, childOrgId, assignDataIds, unableAssignMap);
        }
    }

    private void individualWithGraduallyDataOnOriginalModel(List<Long> dataIds, Set<Long> orgIds, Map<Long, Set<Long>> unableAssignMap, Map<Long, Long> id2MstIdMap) {
        HashMap<Long, Set<Long>> personalizedMap = new HashMap<Long, Set<Long>>(orgIds.size());
        QFilter[] filters = new QFilter[]{QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdField), new QFilter("createorg", "in", orgIds), new QFilter(this.masterIdProp, "in", id2MstIdMap.values())};
        Map<Long, Long> mstId2IdMap = id2MstIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), this.entityId, "createorg, " + this.masterIdProp, filters);){
            for (Row row : ds) {
                Long dataId = mstId2IdMap.get(row.getLong(this.masterIdProp));
                if (null == dataId) continue;
                personalizedMap.computeIfAbsent(row.getLong("createorg"), k -> new HashSet(16)).add(dataId);
            }
        }
        if (!personalizedMap.isEmpty()) {
            new TreeBaseDataCommonService(this.entityId).autoIndividualOnGraduallyStrategy(dataIds, personalizedMap, unableAssignMap, id2MstIdMap);
        }
    }

    private void autoIndividualWithFreeDataOnOriginalModel(List<Long> dataIds, Set<Long> orgIds, Map<Long, Set<Long>> unableAssignMap) {
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", orgIds), new QFilter(this.masterIdProp, "in", dataIds), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdField)};
        HashMap<Long, Set<Long>> personalizedMap = new HashMap<Long, Set<Long>>(orgIds.size());
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), this.entityId, "createorg," + this.masterIdProp, filters);){
            for (Row row : ds) {
                Long orgId = row.getLong("createorg");
                personalizedMap.computeIfAbsent(orgId, k -> new HashSet(10)).add(row.getLong(this.masterIdProp));
            }
        }
        if (!personalizedMap.isEmpty()) {
            new TreeBaseDataCommonService(this.entityId).autoIndividualOnFreeStrategy(dataIds, personalizedMap, unableAssignMap);
        }
    }

    public BaseDataResponse executeAssignOnFreeStrategy(Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        HashSet<Long> copy = new HashSet<Long>(dataIds);
        FreeStrategyAssignValidator validator = new FreeStrategyAssignValidator(this.entityId, assignOrgId, appId, dataIds, orgIds);
        BaseDataResponse response = validator.assignValidate();
        if (!response.isSuccess()) {
            this.saveCtrlLog(assignOrgId, copy, orgIds, response);
            return response;
        }
        try {
            Map<Long, Map<Long, String>> result;
            this.initAssignData(this.entityId, assignOrgId, orgIds);
            this.orgIds.remove(assignOrgId);
            if (BaseDataCommonService.isNewModel(this.entityId)) {
                BaseDataAssignService baseDataAssignService = new BaseDataAssignService(this.entityId);
                baseDataAssignService.setAssignOrgId(assignOrgId);
                result = baseDataAssignService.batchAssign(new ArrayList<Long>(dataIds), new ArrayList<Long>(orgIds));
            } else {
                result = this.assignFreeStrategyOnOldModelWithOutTreeType(new ArrayList<Long>(dataIds));
            }
            if (CollectionUtils.isEmpty(result)) {
                result = new HashMap<Long, Map<Long, String>>(16);
            }
            response.setResult(result);
            Map<Long, String> unEnableAssignFail = validator.getUnEnableAssignFail();
            if (!CollectionUtils.isEmpty(unEnableAssignFail)) {
                for (Map.Entry<Long, String> entry : unEnableAssignFail.entrySet()) {
                    Long dataId = entry.getKey();
                    Map failData = result.computeIfAbsent(dataId, k -> new HashMap(16));
                    orgIds.forEach(orgId -> {
                        String cfr_ignored_0 = (String)failData.put(orgId, entry.getValue());
                    });
                }
            }
            this.saveCtrlLog(assignOrgId, copy, orgIds, response);
            return response;
        }
        catch (Throwable e) {
            LOGGER.error("AssignService.executeAssignOnFreeStrategy error:", e);
            return new BaseDataResponse(false, e.getMessage());
        }
    }

    private Map<Long, Map<Long, String>> assignFreeStrategyOnOldModelWithOutTreeType(List<Long> dataIds) {
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Map<Long, String>> checkAssignRes = this.businessAssignValidate(dataIds, new ArrayList<Long>(this.orgIds));
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entityId);
        ExtActionInfo extActionInfo = ext.handleBeforeAssign(this.entityId, this.assignOrgId, dataIds, new ArrayList<Long>(this.orgIds));
        AssignService.mergeErrorInformation(checkAssignRes, extActionInfo.getData());
        if (!extActionInfo.isExecute()) {
            return checkAssignRes;
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entityId);
        String tableName = dt.getAlias();
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        try (TXHandle h = TX.required();){
            try {
                this.updateOrgUseRegData(tableName, route, dataIds, checkAssignRes);
                this.updateOrgUseRangData(tableName, route, dataIds, checkAssignRes);
            }
            catch (Throwable e) {
                LOGGER.error("\u6279\u91cf\u4fdd\u5b58\u57fa\u7840\u6570\u636e\u4f7f\u7528\u5173\u7cfb\u5931\u8d25", e);
                h.markRollback();
                throw e;
            }
        }
        extActionInfo = ext.handleAfterAssign(this.entityId, this.assignOrgId, dataIds, new ArrayList<Long>(this.orgIds));
        AssignService.mergeErrorInformation(checkAssignRes, extActionInfo.getData());
        this.writOpLog(this.assignOrgId);
        return checkAssignRes;
    }

    private static void mergeErrorInformation(Map<Long, Map<Long, String>> assignCheckResMap, Map<Long, Map<Long, String>> data) {
        for (Map.Entry<Long, Map<Long, String>> entry : data.entrySet()) {
            Map<Long, String> orgMsg = entry.getValue();
            if (null == orgMsg) continue;
            assignCheckResMap.computeIfAbsent(entry.getKey(), k -> new HashMap(16)).putAll(orgMsg);
        }
    }

    private void updateOrgUseRegData(String tableName, DBRoute route, List<Long> dataIds, Map<Long, Map<Long, String>> checkAssignRes) {
        String regTable = tableName + "usereg";
        Map<Long, Set<Long>> existData = this.queryExistData(regTable, route, dataIds);
        String insertSql = " insert into " + regTable + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign, FAssignOrgID) values(?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        for (Long dataId : dataIds) {
            Map<Long, String> verificationFailedData = checkAssignRes.get(dataId);
            for (Long orgId : this.orgIds) {
                Set<Long> existDataIds;
                if (null != verificationFailedData && verificationFailedData.containsKey(orgId) || null != (existDataIds = existData.get(orgId)) && existDataIds.contains(dataId)) continue;
                params.add(new Object[]{orgId, dataId, this.assignOrgId, this.assignOrgId, "2", "1", this.assignOrgId});
                if (params.size() < 10000) continue;
                DB.executeBatch((DBRoute)route, (String)insertSql, params);
                params = new ArrayList(10000);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
        }
    }

    private void updateOrgUseRangData(String tableName, DBRoute route, List<Long> dataIds, Map<Long, Map<Long, String>> checkAssignRes) {
        Map<Long, Set<Long>> allExcData = this.getIndividualizeData(tableName, route, dataIds);
        Map<Long, Set<Long>> alreadyAssignData = this.getAlreadyAssignData(tableName, route, dataIds);
        String insertSql = " insert into " + tableName + "_U (FUseOrgID, FDataID) values(?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        for (Long dataId : dataIds) {
            Map<Long, String> verificationFailedData = checkAssignRes.get(dataId);
            for (Long orgId2 : this.orgIds) {
                Set<Long> assignedDataIds;
                Set<Long> excludeDataIds;
                if (null != verificationFailedData && verificationFailedData.containsKey(orgId2) || null != (excludeDataIds = allExcData.get(orgId2)) && excludeDataIds.contains(dataId) || null != (assignedDataIds = alreadyAssignData.get(orgId2)) && assignedDataIds.contains(dataId)) continue;
                params.add(new Object[]{orgId2, dataId});
                if (params.size() != 10000) continue;
                DB.executeBatch((DBRoute)route, (String)insertSql, params);
                params = new ArrayList(10000);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
        }
        HashMap cacheMap = new HashMap(this.orgIds.size());
        this.orgIds.forEach(orgId -> cacheMap.putIfAbsent(orgId, Boolean.TRUE));
        BaseDataCtrlCache.updateIsHasBaseDataUseRangeBatch((String)this.entityId, cacheMap);
    }

    private Map<Long, Set<Long>> getIndividualizeData(String tableName, DBRoute route, List<Long> dataIds) {
        String excTable = tableName + "Exc";
        return this.queryExistData(excTable, route, dataIds);
    }

    private Map<Long, Set<Long>> getAlreadyAssignData(String tableName, DBRoute route, List<Long> dataIds) {
        String rangTable = tableName + "_U";
        return this.queryExistData(rangTable, route, dataIds);
    }

    private Map<Long, Set<Long>> queryExistData(String tableName, DBRoute route, List<Long> dataIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append(" select fdataid,fuseorgid from ", new Object[0]).append(tableName, new Object[0]).append("  where ", new Object[0]).appendIn("fuseorgid", this.orgIds.toArray()).append("  and ", new Object[0]).appendIn("fdataid", dataIds.toArray());
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(this.orgIds.size());
        try (DataSet ds = DB.queryDataSet((String)AssignService.class.getName(), (DBRoute)route, (SqlBuilder)builder);){
            ds.forEach(r -> result.computeIfAbsent(r.getLong("fuseorgid"), k -> new HashSet(10)).add(r.getLong("fdataid")));
        }
        return result;
    }

    private Map<Long, Map<Long, String>> businessAssignValidate(List<Long> dataIds, List<Long> orgIds) {
        IBaseDataCtrlPlugin plugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityId);
        if (null == plugin) {
            return new HashMap<Long, Map<Long, String>>(0);
        }
        HashMap<Long, Map<Long, String>> assignCheckResMap = plugin.assignCheckWithDetail(dataIds, orgIds);
        if (!CollectionUtils.isEmpty((Map)assignCheckResMap)) {
            return assignCheckResMap;
        }
        Map assignCheckRes = plugin.assignCheck(dataIds, orgIds);
        if (CollectionUtils.isEmpty((Map)assignCheckRes)) {
            return new HashMap<Long, Map<Long, String>>(0);
        }
        String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6821\u9a8c\u5931\u8d25\u3002", (String)"AssignService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        assignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
        for (Map.Entry entry : assignCheckRes.entrySet()) {
            Long dataId = (Long)entry.getKey();
            Map failReason = assignCheckResMap.computeIfAbsent(dataId, k -> new HashMap(16));
            List failOrgIds = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)failOrgIds)) continue;
            failOrgIds.forEach(orgId -> failReason.put(orgId, msg));
        }
        return assignCheckResMap;
    }
}

