/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.pojo.AutoAssignPlanDetail;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.validator.AutoAssignValidator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AutoAssignService {
    private static final Log LOGGER = LogFactory.getLog(AutoAssignService.class);
    private static final String ENTITY_ID = "entityId";
    private static final String APP_ID = "appId";
    public static final String FILTER_CONDITION = "filterCondition";
    public static final String ENTITY_FILTER_CONDITION = "bd_filtercondition";
    public static final String PLAN_DETAIL = "planDetail";
    public static final String ENTITY_BD_AUTO_ASSIGN = "bd_autoassign";
    private static final String FIELD_ENTRY_ID = "fEntryId";
    private static final String ENABLE = "enable";
    private static final String EXECUTE_TIME = "executeTime";
    private static final String ENTITY_ORG_STRUCTURE = "bos_org_structure";
    private static final String RESULT = "result";
    private static final String PLAN_DETAIL_ID = "planDetailId";
    private static final String AUTO_ASSIGN_RESULT = "bd_autoassign_result";
    private static final String SAVE = "save";
    private static final String DELETE = "delete";

    public List<Long> getBaseDataMatch(String entityId, Long assignOrgId, String filterCondition, String ctrlStrategy) {
        return this.getBaseDataMatch(entityId, assignOrgId, filterCondition, ctrlStrategy, null);
    }

    public List<Long> getBaseDataMatch(String entityId, Long assignOrgId, String filterCondition, String ctrlStrategy, Set<Long> dataIds) {
        DynamicObjectCollection coll;
        List<QFilter> filters = this.getConditionQFilters(entityId, filterCondition, assignOrgId, ctrlStrategy);
        if (null != dataIds) {
            filters.add(new QFilter("id", "in", dataIds));
        }
        if (CollectionUtils.isEmpty((Collection)(coll = QueryServiceHelper.query((String)entityId, (String)"id", (QFilter[])filters.toArray(new QFilter[0]))))) {
            return new ArrayList<Long>(0);
        }
        return coll.stream().mapToLong(v -> v.getLong("id")).boxed().collect(Collectors.toList());
    }

    public List<QFilter> getConditionQFilters(String entityId, String filterStr, Long assignOrgId, String ctrlStrategy) {
        BillEntityType dt;
        String billStatusKey;
        boolean isIgnoreStatus;
        QFilter useRangeFilter;
        FilterCondition condition;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        FilterCondition filterCondition = condition = StringUtils.isEmpty((CharSequence)filterStr) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        if (condition != null) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
            filterBuilder.buildFilter();
            qFilters.add(filterBuilder.getQFilter());
        }
        if (0L != assignOrgId && null != (useRangeFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)assignOrgId))) {
            qFilters.add(useRangeFilter);
        }
        if (null != ctrlStrategy) {
            qFilters.add(new QFilter("ctrlstrategy", "=", (Object)ctrlStrategy));
            if (ctrlStrategy.equals("2")) {
                String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
                qFilters.add(new QFilter("createorg", "=", (Object)assignOrgId));
                qFilters.add(QFilter.of((String)("id = " + masterIdPropName), (Object[])new Object[0]));
            }
        }
        boolean bl = isIgnoreStatus = StringUtils.isBlank((CharSequence)(billStatusKey = (dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId)).getBillStatus())) || dt.getProperty(billStatusKey).isDbIgnore();
        if (!isIgnoreStatus) {
            qFilters.add(new QFilter(billStatusKey, "=", (Object)BillStatus.C.name()));
        }
        return qFilters;
    }

    public Map<Long, String> getFilterConditionMap(List<Long> filterConditionIds) {
        String selectFields = "id,name,filterCondition";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", filterConditionIds)};
        DynamicObjectCollection filterConditions = QueryServiceHelper.query((String)ENTITY_FILTER_CONDITION, (String)selectFields, (QFilter[])filters);
        HashMap<Long, String> filterConditionMap = new HashMap<Long, String>(filterConditions.size());
        filterConditions.forEach(e -> filterConditionMap.put(e.getLong("id"), e.getString(FILTER_CONDITION)));
        return filterConditionMap;
    }

    public DynamicObjectCollection getAutoAssignPlan(String entityId) {
        List<String> selectFieldList = Arrays.asList("id", "number", "name", "ctrlstrategy", ENABLE, PLAN_DETAIL, APP_ID, EXECUTE_TIME, ENTITY_ID);
        QFilter[] qFilters = new QFilter[]{new QFilter(ENTITY_ID, "=", (Object)entityId), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        String selectFields = String.join((CharSequence)",", selectFieldList);
        return QueryServiceHelper.query((String)ENTITY_BD_AUTO_ASSIGN, (String)selectFields, (QFilter[])qFilters);
    }

    public DynamicObjectCollection getAutoAssignPlan(String entityId, List<Long> autoPlanKeys) {
        List<String> selectFieldList = Arrays.asList("id", "number", "name", "ctrlstrategy", ENABLE, PLAN_DETAIL, APP_ID, EXECUTE_TIME, ENTITY_ID);
        QFilter[] qFilters = new QFilter[]{new QFilter(ENTITY_ID, "=", (Object)entityId), new QFilter(ENABLE, "=", (Object)Boolean.TRUE), new QFilter("id", "in", autoPlanKeys)};
        String selectFields = String.join((CharSequence)",", selectFieldList);
        return QueryServiceHelper.query((String)ENTITY_BD_AUTO_ASSIGN, (String)selectFields, (QFilter[])qFilters);
    }

    public DynamicObject getAutoAssignPlanById(Long autoPlanKey) {
        List<String> selectFieldList = Arrays.asList("id", "number", "name", "ctrlstrategy", ENABLE, PLAN_DETAIL, APP_ID, EXECUTE_TIME, ENTITY_ID);
        String selectFields = String.join((CharSequence)",", selectFieldList);
        return QueryServiceHelper.queryOne((String)ENTITY_BD_AUTO_ASSIGN, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)autoPlanKey)});
    }

    public DynamicObjectCollection getAutoAssignPlanById(List<Long> autoPlanKeys) {
        List<String> selectFieldList = Arrays.asList("id", "number", "name", "ctrlstrategy", ENABLE, PLAN_DETAIL, APP_ID, EXECUTE_TIME, ENTITY_ID);
        String selectFields = String.join((CharSequence)",", selectFieldList);
        return QueryServiceHelper.query((String)ENTITY_BD_AUTO_ASSIGN, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", autoPlanKeys)});
    }

    public Map<Long, List<AutoAssignPlanDetail>> getPlanDetailMap(List<Long> planDetailIds) {
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fid,fentryid,fisconcludesub,forgfilterschemeid,ffiltercondition,fremark,fassignorgid,fseq from t_bd_autoassign_assignorg where ", new Object[0]);
        querySql.appendIn("fid", planDetailIds.toArray());
        return (Map)DB.query((DBRoute)DBRoute.base, (SqlBuilder)querySql, resultSet -> {
            HashMap tempMap = new HashMap(16);
            while (resultSet.next()) {
                Long id = resultSet.getLong("fid");
                Long entryId = resultSet.getLong(FIELD_ENTRY_ID);
                Boolean isConcludeSub = resultSet.getBoolean("fisconcludesub");
                Long filterConditionId = resultSet.getLong("ffiltercondition");
                String remark = resultSet.getString("fremark");
                Long assignOrgId = resultSet.getLong("fassignorgid");
                int seq = resultSet.getInt("fseq");
                ArrayList<AutoAssignPlanDetail> autoAssignPlanDetails = (ArrayList<AutoAssignPlanDetail>)tempMap.get(entryId);
                if (null == autoAssignPlanDetails) {
                    autoAssignPlanDetails = new ArrayList<AutoAssignPlanDetail>(10);
                }
                AutoAssignPlanDetail planDetail = new AutoAssignPlanDetail(id, entryId, isConcludeSub, filterConditionId, remark, assignOrgId, seq);
                planDetail.setOrgFilterSchemeId(resultSet.getLong("forgfilterschemeid"));
                autoAssignPlanDetails.add(planDetail);
                tempMap.put(entryId, autoAssignPlanDetails);
            }
            return tempMap;
        });
    }

    public List<Long> getFilterConditionIds(DynamicObjectCollection autoAssignPlans, Map<Long, List<AutoAssignPlanDetail>> planDetailMap) {
        if (CollectionUtils.isEmpty((Collection)autoAssignPlans) || CollectionUtils.isEmpty(planDetailMap)) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> filterConditionIds = new ArrayList<Long>(10);
        for (DynamicObject autoAssignPlan : autoAssignPlans) {
            List<AutoAssignPlanDetail> planDetails = planDetailMap.get(autoAssignPlan.getLong(PLAN_DETAIL));
            if (CollectionUtils.isEmpty(planDetails)) continue;
            for (AutoAssignPlanDetail planDetail : planDetails) {
                long filterConditionId = planDetail.getFilterConditionId();
                if (0L == filterConditionId) continue;
                filterConditionIds.add(filterConditionId);
            }
        }
        return filterConditionIds;
    }

    @Deprecated
    public Map<Long, List<Long>> getPlanDetailIdUseOrgIdMap(List<Object> planDetailIds) {
        Object row2;
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select forgfilterschemeid, fassignorgid, fEntryId, fid from t_bd_autoassign_assignorg where", new Object[0]).appendIn(FIELD_ENTRY_ID, planDetailIds);
        HashSet<Long> planIds = new HashSet<Long>(planDetailIds.size());
        ArrayList<Long[]> details = new ArrayList<Long[]>(planDetailIds.size());
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)querySql);){
            for (Object row2 : ds) {
                planIds.add(row2.getLong("fid"));
                details.add(new Long[]{row2.getLong(FIELD_ENTRY_ID), row2.getLong("fassignorgid"), row2.getLong("forgfilterschemeid")});
            }
        }
        if (details.isEmpty()) {
            return Collections.emptyMap();
        }
        querySql = new SqlBuilder();
        querySql.append("select t.fctrlstrategy strategy, t.fentityid entity, o.fentryid entryid from t_bd_autoassign t join t_bd_autoassign_assignorg o on t.fid = o.fid where", new Object[0]);
        querySql.appendIn("t.fid", planIds.toArray());
        HashMap<Long, String> detailStrategyMap = new HashMap<Long, String>(planDetailIds.size());
        HashMap<Long, String> detailEntityMap = new HashMap<Long, String>(planDetailIds.size());
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)querySql);
        row2 = null;
        try {
            for (Row row3 : ds) {
                Long entryId = row3.getLong("entryid");
                detailStrategyMap.put(entryId, row3.getString("strategy"));
                detailEntityMap.put(entryId, row3.getString("entity"));
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (row2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        List<Long> orgFilterSchemeIds = details.stream().mapToLong(v -> v[2]).boxed().collect(Collectors.toList());
        Map<Long, QFilter> schemeOrgFilterMap = this.getAutoAssignFilter(orgFilterSchemeIds);
        HashMap detailViewMap = new HashMap(planDetailIds.size());
        detailEntityMap.forEach((k, v) -> detailViewMap.put(k, BaseDataServiceHelper.getCtrlview((String)v)));
        HashMap<Long, List<Long>> detailOrgMap = new HashMap<Long, List<Long>>(16);
        for (Long[] detail : details) {
            Long viewId;
            List<Long> orgIds;
            QFilter schemeFilter = schemeOrgFilterMap.get(detail[2]);
            DynamicObject view = (DynamicObject)detailViewMap.get(detail[0]);
            if (null == view || (orgIds = this.getAutoAssignUseOrgIds(schemeFilter, viewId = Long.valueOf(view.getLong("id")), (String)detailStrategyMap.get(detail[0]), detail[1])).isEmpty()) continue;
            detailOrgMap.put(detail[0], orgIds);
        }
        return detailOrgMap;
    }

    public Map<Long, List<Long>> getPlanDetailIdUseOrgIdMap(Long viewId, DynamicObjectCollection autoAssignPlans) {
        HashMap detailStrategyMap = new HashMap(autoAssignPlans.size());
        autoAssignPlans.forEach(e -> detailStrategyMap.put(e.getLong(PLAN_DETAIL), e.getString("ctrlstrategy")));
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select forgfilterschemeid, fassignorgid, fEntryId from t_bd_autoassign_assignorg where", new Object[0]).appendIn(FIELD_ENTRY_ID, detailStrategyMap.keySet().toArray());
        ArrayList details = new ArrayList(detailStrategyMap.size());
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)querySql);){
            ds.forEach(r -> details.add(new Long[]{r.getLong(FIELD_ENTRY_ID), r.getLong("fassignorgid"), r.getLong("forgfilterschemeid")}));
        }
        if (details.isEmpty()) {
            return Collections.emptyMap();
        }
        List<Long> orgFilterSchemeIds = details.stream().mapToLong(v -> v[2]).boxed().collect(Collectors.toList());
        Map<Long, QFilter> schemeOrgFilterMap = this.getAutoAssignFilter(orgFilterSchemeIds);
        HashMap<Long, List<Long>> detailOrgMap = new HashMap<Long, List<Long>>(16);
        for (Long[] detail : details) {
            QFilter schemeFilter = schemeOrgFilterMap.get(detail[2]);
            List<Long> orgIds = this.getAutoAssignUseOrgIds(schemeFilter, viewId, (String)detailStrategyMap.get(detail[0]), detail[1]);
            if (orgIds.isEmpty()) continue;
            detailOrgMap.put(detail[0], orgIds);
        }
        return detailOrgMap;
    }

    private List<Long> getAutoAssignUseOrgIds(QFilter schemeFilter, Long viewId, String strategy, Long assignOrgId) {
        ArrayList<Long> useOrgIds = new ArrayList<Long>(10);
        if (null != schemeFilter) {
            QFilter[] filters = new QFilter[]{schemeFilter, this.getOrgJoinFilter(viewId)};
            try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org", "id", filters);){
                ds.forEach(r -> useOrgIds.add(r.getLong("id")));
            }
            if ("1".equals(strategy) && !useOrgIds.isEmpty()) {
                HashSet orgRangList = new HashSet(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, Collections.singletonList(assignOrgId), (boolean)false, (boolean)false));
                useOrgIds.retainAll(orgRangList);
            }
        }
        return useOrgIds;
    }

    public void updateExecuteTime(List<Long> autoAssignPlanIds) {
        if (CollectionUtils.isEmpty(autoAssignPlanIds)) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(autoAssignPlanIds.size());
        for (Long id : autoAssignPlanIds) {
            paramList.add(new Object[]{new Date(), id});
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)"update t_bd_autoassign set fexecuteTime = ? where fid = ?;", paramList);
    }

    public List<Object> getPlanDetailIds(DynamicObjectCollection autoAssignPlans) {
        ArrayList<Object> planDetailIds = new ArrayList<Object>(autoAssignPlans.size());
        for (DynamicObject autoAssignPlan : autoAssignPlans) {
            Long planDetailId = autoAssignPlan.getLong(PLAN_DETAIL);
            planDetailIds.add(planDetailId);
        }
        return planDetailIds;
    }

    public List<Long> getCuOrgIds(Long viewId, List<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("view.id", "=", (Object)viewId), new QFilter("isCtrlUnit", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        ArrayList<Long> cuOrgIds = new ArrayList<Long>(orgIds.size());
        try (DataSet ds = ORM.create().queryDataSet(AutoAssignService.class.getName(), ENTITY_ORG_STRUCTURE, "org.id", filters, "longnumber");){
            for (Row row : ds) {
                Long orgId = row.getLong("org.id");
                if (orgId == null) continue;
                cuOrgIds.add(orgId);
            }
        }
        return cuOrgIds;
    }

    public BaseDataResponse assign(String entityId, Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds, Long planDetailId) {
        this.setAssignLogTypeAndSource(planDetailId);
        BaseDataResponse response = new AutoAssignValidator().validateAssignData(entityId, assignOrgId, appId, dataIds, orgIds);
        AssignService service = new AssignService(entityId);
        if (response.isSuccess()) {
            return service.assign(assignOrgId, appId, dataIds, orgIds);
        }
        HashSet<Long> assignDataIds = new HashSet<Long>(dataIds.size());
        HashSet<Long> assignOrgIds = new HashSet<Long>(orgIds.size());
        Map dataOfUnPass = response.getResult();
        if (CollectionUtils.isEmpty((Map)dataOfUnPass)) {
            return response;
        }
        for (Long dataId : dataIds) {
            Set unPassDataIds = dataOfUnPass.keySet();
            if (!unPassDataIds.contains(dataId)) {
                assignDataIds.add(dataId);
                assignOrgIds.addAll(orgIds);
                continue;
            }
            Map tempOrgMap = (Map)dataOfUnPass.get(dataId);
            if (CollectionUtils.isEmpty((Map)tempOrgMap)) continue;
            Set unPassOrgIds = tempOrgMap.keySet();
            HashSet<Long> passOrgIds = new HashSet<Long>(orgIds);
            passOrgIds.removeAll(unPassOrgIds);
            if (CollectionUtils.isEmpty(passOrgIds)) continue;
            HashSet<Long> tempDataIds = new HashSet<Long>();
            tempDataIds.add(dataId);
            service.assign(assignOrgId, appId, tempDataIds, passOrgIds);
        }
        if (!CollectionUtils.isEmpty(assignDataIds) && !CollectionUtils.isEmpty(assignOrgIds)) {
            service.assign(assignOrgId, appId, assignDataIds, assignOrgIds);
        }
        return response;
    }

    private void setAssignLogTypeAndSource(Long planDetailId) {
        HashMap<String, Object> threadLocalMap = new HashMap<String, Object>(2);
        threadLocalMap.put("source", BDCtrlOperateSource.AUTO_ASSIGN.getValue());
        threadLocalMap.put("operateSourceId", planDetailId);
        BDCtrlLogHelper.THREAD_LOCAL.set(threadLocalMap);
    }

    public void saveAssignResult(String entityId, Long planDetailId, List<BaseDataResponse> assignResults, DynamicObject autoAssignPlan) {
        if (null != autoAssignPlan) {
            this.deleteHistoryExecute(planDetailId);
            DynamicObject[] dataEntities = new DynamicObject[1];
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)AUTO_ASSIGN_RESULT);
            String number = autoAssignPlan.getString("number");
            String name = autoAssignPlan.getString("name");
            String message = this.getAssignMessage(assignResults);
            dynamicObject.set("number", (Object)number);
            dynamicObject.set("name", (Object)name);
            dynamicObject.set(RESULT, (Object)message);
            dynamicObject.set(PLAN_DETAIL_ID, (Object)planDetailId);
            dynamicObject.set(ENTITY_ID, (Object)entityId);
            dynamicObject.set(EXECUTE_TIME, (Object)new Date());
            dataEntities[0] = dynamicObject;
            OperationServiceHelper.executeOperate((String)SAVE, (String)AUTO_ASSIGN_RESULT, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        }
    }

    private String getAssignMessage(List<BaseDataResponse> assignResults) {
        boolean isSuccess = true;
        for (BaseDataResponse assignResult : assignResults) {
            if (assignResult.isSuccess()) continue;
            isSuccess = false;
            break;
        }
        if (isSuccess) {
            return ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f", (String)"AutoAssignService_0", (String)"bos-bd-business", (Object[])new Object[0]);
        }
        long failSize = 0L;
        StringBuilder errorMsgSbd = new StringBuilder();
        for (BaseDataResponse assignResult : assignResults) {
            Map result = assignResult.getResult();
            if (CollectionUtils.isEmpty((Map)result)) {
                errorMsgSbd.append(assignResult.getErrorMsg());
                continue;
            }
            failSize += result.values().parallelStream().map(Map::size).mapToLong(Long::valueOf).sum();
        }
        return 0L == failSize ? errorMsgSbd.toString() : String.format(ResManager.loadKDString((String)"\u5206\u914d\u5b8c\u6210\uff0c\u5171\u5931\u8d25%s\u6761\u6570\u636e", (String)"AutoAssignService_1", (String)"bos-bd-business", (Object[])new Object[0]), failSize);
    }

    private void deleteHistoryExecute(Long planDetailId) {
        QFilter[] filters = new QFilter[]{new QFilter(PLAN_DETAIL_ID, "=", (Object)planDetailId)};
        DynamicObjectCollection autoAssignResults = QueryServiceHelper.query((String)AUTO_ASSIGN_RESULT, (String)"id", (QFilter[])filters);
        ArrayList ids = new ArrayList(autoAssignResults.size());
        if (!autoAssignResults.isEmpty()) {
            autoAssignResults.forEach(autoAssignResult -> ids.add(autoAssignResult.getLong("id")));
            OperationServiceHelper.executeOperate((String)DELETE, (String)AUTO_ASSIGN_RESULT, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
        }
    }

    public void autoAssignAfterOrgChange(Long viewId, Set<Long> currOrgIds, String entity) {
        DynamicObjectCollection autoAssignPlans = this.getAutoAssignPlan(entity);
        if (CollectionUtils.isEmpty((Collection)autoAssignPlans)) {
            return;
        }
        List<Long> autoAssignPlanIds = autoAssignPlans.stream().mapToLong(v -> v.getLong("id")).boxed().collect(Collectors.toList());
        Map<Long, List<AutoAssignPlanDetail>> planDetailMap = this.getPlanDetailMap(autoAssignPlanIds);
        List<Long> filterConditionIds = this.getFilterConditionIds(autoAssignPlans, planDetailMap);
        Map<Long, String> filterConditionMap = this.getFilterConditionMap(filterConditionIds);
        ArrayList<Long> executeAutoPlanIds = new ArrayList<Long>(autoAssignPlans.size());
        for (DynamicObject autoAssignPlan : autoAssignPlans) {
            List<AutoAssignPlanDetail> planDetails = planDetailMap.get(autoAssignPlan.getLong(PLAN_DETAIL));
            if (CollectionUtils.isEmpty(planDetails)) continue;
            for (AutoAssignPlanDetail planDetail : planDetails) {
                this.eachExeDetail(viewId, currOrgIds, entity, filterConditionMap, autoAssignPlan, planDetail);
            }
            executeAutoPlanIds.add(autoAssignPlan.getLong("id"));
        }
        this.updateExecuteTime(executeAutoPlanIds);
    }

    private void eachExeDetail(Long viewId, Set<Long> currOrgIds, String entity, Map<Long, String> filterConditionMap, DynamicObject autoAssignPlan, AutoAssignPlanDetail planDetail) {
        try {
            String appId = autoAssignPlan.getString(APP_ID);
            String ctrlStrategy = autoAssignPlan.getString("ctrlstrategy");
            long assignOrgId = planDetail.getAssignOrgId();
            boolean includeSub = Boolean.TRUE.equals(planDetail.isContainSubordinate());
            Set<Long> useOrgIds = this.getAutoAssignUseOrgIds(ctrlStrategy, assignOrgId, currOrgIds, planDetail.getOrgFilterSchemeId(), viewId, includeSub);
            if (useOrgIds.isEmpty()) {
                return;
            }
            long filterConditionId = planDetail.getFilterConditionId();
            String filterCondition = filterConditionMap.get(filterConditionId);
            HashSet<Long> dataIds = new HashSet<Long>(this.getBaseDataMatch(entity, assignOrgId, filterCondition, ctrlStrategy));
            if (CollectionUtils.isEmpty(dataIds)) {
                return;
            }
            long planDetailId = planDetail.getEntryId();
            BaseDataResponse assignResult = this.assign(entity, assignOrgId, appId, dataIds, new HashSet<Long>(useOrgIds), planDetailId);
            this.saveAssignResult(entity, planDetailId, Collections.singletonList(assignResult), autoAssignPlan);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u81ea\u52a8\u5206\u914d\u5931\u8d25\uff0c\u5b9e\u4f53\u3010%s\u3011\uff0c\u89c6\u56fe\u3010%s\u3011\uff0c\u660e\u7ec6\u5206\u5f55\u3010%s\u3011.", entity, viewId, planDetail.getEntryId()), (Throwable)e);
        }
    }

    private Set<Long> getAutoAssignUseOrgIds(String strategy, long assignOrgId, Set<Long> currOrgIds, Long orgFilterSchemeId, Long viewId, boolean includeSub) {
        QFilter schemeFilter = this.getAutoAssignFilter(orgFilterSchemeId);
        if (null == schemeFilter) {
            return Collections.emptySet();
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        QFilter joinFilter = this.getOrgJoinFilter(viewId);
        filters.add(joinFilter);
        filters.add(schemeFilter);
        HashSet<Long> useOrgIds = new HashSet<Long>(currOrgIds.size());
        if (!includeSub) {
            filters.add(new QFilter("id", "in", currOrgIds));
            try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org", "id", filters.toArray(new QFilter[0]));){
                ds.forEach(r -> useOrgIds.add(r.getLong("id")));
            }
        }
        ArrayList schemeOrgIds = new ArrayList(currOrgIds.size());
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org", "id", filters.toArray(new QFilter[0]));){
            ds.forEach(r -> schemeOrgIds.add(r.getLong("id")));
            useOrgIds.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, schemeOrgIds, (boolean)true, (boolean)false));
            useOrgIds.retainAll(currOrgIds);
        }
        if ("1".equals(strategy) && !useOrgIds.isEmpty()) {
            List<Long> supperOrgIds = Collections.singletonList(assignOrgId);
            HashSet orgRangList = new HashSet(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, supperOrgIds, (boolean)false, (boolean)false));
            useOrgIds.retainAll(orgRangList);
        }
        return useOrgIds;
    }

    private QFilter getOrgJoinFilter(Long viewId) {
        QFilter viewFilter = QFilter.of((String)"bos_org_structure.view = ?", (Object[])new Object[]{viewId});
        QFilter structureFilter = viewFilter.and(new QFilter("bos_org_structure.isctrlunit", "=", (Object)Boolean.TRUE));
        structureFilter.and(new QFilter("bos_org_structure.isfreeze", "=", (Object)Boolean.FALSE));
        return QFilter.join((String)"id", (String)"bos_org_structure.org", (QFilter)structureFilter);
    }

    private QFilter getAutoAssignFilter(Long orgFilterSchemeId) {
        Map<Long, QFilter> orgSchemeFilterMap = this.getAutoAssignFilter(Collections.singletonList(orgFilterSchemeId));
        return orgSchemeFilterMap.get(orgFilterSchemeId);
    }

    private Map<Long, QFilter> getAutoAssignFilter(Collection<Long> orgFilterSchemeIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", orgFilterSchemeIds)};
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)"bd_org_filterscheme", (String)"id, filtercondition, entryentity.selectedorg", (QFilter[])filters);
        if (null == arr || arr.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, QFilter> orgSchemeFilterMap = new HashMap<Long, QFilter>(orgFilterSchemeIds.size());
        for (DynamicObject orgScheme : arr) {
            DynamicObjectCollection coll;
            QFilter schemeFilter = null;
            String conditionFilter = orgScheme.getString("filtercondition");
            if (StringUtils.isNotBlank((CharSequence)conditionFilter)) {
                FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionFilter, FilterCondition.class);
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
                FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
                filterBuilder.buildFilter();
                schemeFilter = filterBuilder.getQFilter();
            }
            if (!CollectionUtils.isEmpty((Collection)(coll = (DynamicObjectCollection)orgScheme.get("entryentity")))) {
                List orgIds = coll.stream().map(v -> {
                    DynamicObject org = v.getDynamicObject("selectedorg");
                    return null == org ? 0L : org.getLong("id");
                }).filter(v -> v != 0L).collect(Collectors.toList());
                QFilter idFilter = new QFilter("id", "in", orgIds);
                QFilter qFilter = schemeFilter = null == schemeFilter ? idFilter : schemeFilter.or(idFilter);
            }
            if (null == schemeFilter) continue;
            orgSchemeFilterMap.put(orgScheme.getLong("id"), schemeFilter);
        }
        return orgSchemeFilterMap;
    }
}

