/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AutoAssignUseOrgUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(AutoAssignUseOrgUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            AutoAssignUseOrgUpgradeService.insertOrgFilterScheme();
            DB.execute((DBRoute)DBRoute.basedata, (String)"update t_bd_autoassign_assignorg set forgfilterschemeid = fentryid where forgfilterschemeid = 0");
            return this.result(true, "info", null);
        }
        catch (KDBizException exception) {
            log.error("\u6267\u884c\u81ea\u52a8\u5206\u914d\u65b9\u6848\u7ec4\u7ec7\u8fc7\u6ee4\u65b9\u6848\u5347\u7ea7\u5f02\u5e38", (Throwable)exception);
            return this.result(false, "error", exception.getMessage());
        }
    }

    private static void insertOrgFilterScheme() {
        final HashMap planDetailEntityMap = new HashMap(16);
        final HashMap planDetailCreatorMap = new HashMap(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fentityid,p.fentryid,a.fcreatorid", new Object[0]);
        sqlBuilder.append(" from t_bd_autoassign a", new Object[0]);
        sqlBuilder.append(" left join t_bd_autoassign_assignorg p", new Object[0]);
        sqlBuilder.append(" on a.fid = p.fid", new Object[0]);
        sqlBuilder.append(" where p.forgfilterschemeid = 0", new Object[0]);
        Set planDetailIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> result = new HashSet<Long>(16);
                while (rs.next()) {
                    Long planDetailId = rs.getLong("fentryid");
                    result.add(planDetailId);
                    String entityId = rs.getString("fentityid");
                    planDetailEntityMap.put(planDetailId, entityId);
                    Long creatorId = rs.getLong("fcreatorid");
                    planDetailCreatorMap.put(planDetailId, creatorId);
                }
                return result;
            }
        });
        Set existSchemeIds = new HashSet(16);
        if (CollectionUtils.isNotEmpty((Collection)planDetailIds)) {
            SqlBuilder existSchemeSql = new SqlBuilder();
            existSchemeSql.append("select fentryid from t_bd_orgfilterscheme where ", new Object[0]);
            existSchemeSql.appendIn("fentryid", planDetailIds.toArray());
            existSchemeIds = (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSchemeSql, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws Exception {
                    HashSet<Long> result = new HashSet<Long>(16);
                    while (rs.next()) {
                        result.add(rs.getLong("fentryid"));
                    }
                    return result;
                }
            });
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        HashMap<String, Integer> entityIndexMap = new HashMap<String, Integer>(16);
        Date createTime = new Date();
        for (Long planDetailId : planDetailIds) {
            if (existSchemeIds.contains(planDetailId)) continue;
            String entityId = (String)planDetailEntityMap.get(planDetailId);
            int index = entityIndexMap.getOrDefault(entityId, 1);
            String schemeName = String.format("ORG%04d", index);
            long creatorId = planDetailCreatorMap.getOrDefault(planDetailId, 0L);
            paramList.add(new Object[]{planDetailId, entityId, schemeName, " ", creatorId, createTime, creatorId, createTime});
            entityIndexMap.put(entityId, ++index);
        }
        if (CollectionUtils.isNotEmpty(paramList)) {
            String sql = "insert into t_bd_orgfilterscheme (fentryid, fentityid, fname, ffiltercondition, fcreatorid, fcreatetime, fmodifierid, fmodifytime) values (?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, paramList);
        }
    }

    private UpgradeResult result(boolean success, String level, String errorInfo) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(success);
        result.setEl(level);
        if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
            result.setErrorInfo(errorInfo);
        }
        return result;
    }
}

