/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataAlterBitTableSuffixService
implements IUpgradeService {
    private static Log LOGGER = LogFactory.getLog(BaseDataAlterBitTableSuffixService.class);
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String BASE_DATA_USE_REL_TABLE_SUFFIX_OLD = "_M";
    private static final String CREATE_TABLE_SQL_FORMAT = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s (  FORGID bigint not null, FDATA blob not null, constraint PK_%s primary key (FORGID))";
    private static final String MIGRATE_SQL_FORMAT = "INSERT INTO %s (FORGID, FDATA) SELECT O.FORGID, O.FDATA FROM %s O WHERE NOT EXISTS(SELECT N.FORGID FROM %s N WHERE N.FORGID = O.FORGID);";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setSuccess(true);
        try {
            result.setLog(ResManager.loadKDString((String)"\u67e5\u8be2\u6240\u6709\u7684\u5df2\u7ecf\u5347\u7ea7\u6a21\u578b\u7684\u8d44\u6599\u3002", (String)"BaseDataAlterBitTableSuffixService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            List<String> types = this.getNewModelBdTypes();
            if (CollectionUtils.isEmpty(types)) {
                result.setLog(ResManager.loadKDString((String)"\u65e0\u65b0\u6a21\u578b\u57fa\u7840\u8d44\u6599\uff0c\u5b8c\u6210\u4f4d\u56fe\u8868\u540e\u7f00\u4fee\u6539\u3002", (String)"BaseDataAlterBitTableSuffixService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return result;
            }
            for (String entity : types) {
                MainEntityType dt;
                try {
                    dt = EntityMetadataCache.getDataEntityType((String)entity);
                }
                catch (KDException e) {
                    LOGGER.error("\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    ErrorCode code = e.getErrorCode();
                    if (BosErrorCode.metaNotFound.getCode().equals(code.getCode())) continue;
                    throw e;
                }
                this.createTable(dt);
                boolean migrateSuccess = this.migrateData(dt);
                if (!migrateSuccess) continue;
                BaseDataUseRelUpdateEngine.removeAllRelBitCache(entity);
            }
            String msg = ResManager.loadKDString((String)"\u5b8c\u6210\u3010%1$s\u3011\u7b49\u8d44\u6599\u4f4d\u56fe\u8868\u540e\u7f00\u4fee\u6539\u3002", (String)"BaseDataAlterBitTableSuffixService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            result.setLog(String.format(msg, JSON.toJSONString(types)));
        }
        catch (Exception e) {
            String errorInfo = ResManager.loadKDString((String)"\u4fee\u6539\u65b0\u6a21\u578b\u4f4d\u56fe\u8868\u540e\u7f00\u5f02\u5e38\uff1a%1$s", (String)"BaseDataAlterBitTableSuffixService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            result.setErrorInfo(String.format(errorInfo, e.getMessage()));
            result.setSuccess(false);
            LOGGER.error(errorInfo, (Throwable)e);
        }
        return result;
    }

    private List<String> getNewModelBdTypes() {
        return (List)DB.query((DBRoute)DBRoute.base, (String)"SELECT FBASEDATAID FROM T_BD_DEFAULTCTRLSTRATEGY WHERE FUPGRADESTATUS = '2';", rs -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (rs.next()) {
                result.add(rs.getString("FBASEDATAID"));
            }
            return result;
        });
    }

    private void createTable(MainEntityType dt) {
        String tableName = this.getBitTableName(dt, "_bit");
        String createBitTableSql = String.format(CREATE_TABLE_SQL_FORMAT, tableName, tableName, tableName);
        DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)createBitTableSql);
        LOGGER.info(String.format("\u5efa\u8868\u5b8c\u6210\uff0c\u5b9e\u4f53\u4e3a\u3010%s\u3011\uff0c\u8868\u540d\u4e3a\u3010%s\u3011\u3002", dt.getName(), tableName));
    }

    private boolean migrateData(MainEntityType dt) {
        String currentBitTable = this.getBitTableName(dt, BASE_DATA_USE_REL_TABLE_SUFFIX_OLD);
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        if (!DB.exitsTable((DBRoute)route, (String)currentBitTable)) {
            return false;
        }
        String newBitTable = this.getBitTableName(dt, "_bit");
        String migrateSql = String.format(MIGRATE_SQL_FORMAT, newBitTable, currentBitTable, newBitTable);
        DB.execute((DBRoute)route, (String)migrateSql);
        LOGGER.info(String.format("\u5b9e\u4f53\u4e3a\u3010%s\u3011\u5efa\u8868\u5b8c\u6210\uff0c\u65b0\u8868\u540d\u4e3a\u3010%s\u3011\uff0c\u5f53\u524d\u8868\u540d\u4e3a\u3010%s\u3011\u3002", dt.getName(), newBitTable, currentBitTable));
        return true;
    }

    private String getBitTableName(MainEntityType dt, String suffix) {
        String tableName = dt.getAlias() + suffix;
        return tableName.toUpperCase();
    }
}

