/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.pojo.AutoIndividualData;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataAssignService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataAssignService.class);
    private String appId;
    private Long opOrgId;
    private String numberPro;
    private Long assignOrgId;
    private Map<Long, Set<Long>> assignOrgMap = new HashMap<Long, Set<Long>>(0);
    private List<CustomDataBaseInfo> customDataBaseInfos = new ArrayList<CustomDataBaseInfo>(0);

    public BaseDataAssignService(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        super.init(entity);
        this.numberPro = BaseDataCommonService.isOtherMasterIdType(entity) ? "masterid.number" : "number";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Map<Long, String>> batchCuAssign(Set<Long> dataIds, Set<Long> orgIds, Long assignOrgId) throws Exception {
        if (!this.assignOrgMap.containsKey(assignOrgId)) {
            return Collections.emptyMap();
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == ctrlView) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%1$s\u5bf9\u5e94\u7684\u63a7\u5236\u89c6\u56fe\u3002", (String)"BaseDataAssignService_0", (String)"bos-bd-business", (Object[])new Object[0]), this.entity));
        }
        AssignContext context = new AssignContext(this.entity);
        String lockKey = BaseDataAssignService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            this.prepareAssignData(dataIds, orgIds, context);
            context.useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
            Set<Long> childOrgIds = this.assignOrgMap.get(assignOrgId);
            ExtActionInfo extActionInfo = this.getBusinessCheckResult(new ArrayList<Long>(dataIds), new ArrayList<Long>(childOrgIds), assignOrgId);
            if (!extActionInfo.isExecute()) {
                Map<Long, Map<Long, String>> map = extActionInfo.getData();
                return map;
            }
            context.assignCheckResMap.putAll(extActionInfo.getData());
            Map<Long, List<Long>> orgDataMap = this.getAbleAssignData(childOrgIds, new ArrayList<Long>(dataIds), context);
            for (Long childOrgId : childOrgIds) {
                List<Long> assignDataIds = orgDataMap.get(childOrgId);
                if (CollectionUtils.isEmpty(assignDataIds)) continue;
                this.assignEachOrgData(assignDataIds, childOrgId, context);
            }
            this.cuAssignOnTransaction(context);
        }
        finally {
            lock.unlock();
        }
        this.writOpLog(context.assignMap, context.indexNumberMap, assignOrgId);
        return context.assignCheckResMap;
    }

    private void cuAssignOnTransaction(AssignContext context) {
        if (context.assignMap.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (this.asyncRecord()) {
                    BaseDataSolidifyMessageDTO messageDto = this.saveOrUpdateRelBitOnAsyncRecord(context);
                    this.updateCustomDataSourceInfo(context);
                    this.publish(messageDto);
                } else {
                    this.saveOrUpdateRelBit(context);
                    this.updateCustomDataSourceInfo(context);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5206\u914d\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataAssignService_7", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private BaseDataSolidifyMessageDTO saveOrUpdateRelBitOnAsyncRecord(AssignContext context) throws Exception {
        Map<Long, BaseDataUseRelBit> dataUseRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(context.assignMap.keySet(), this.entity);
        ArrayList<BaseDataUseRelBit> newBitRelList = new ArrayList<BaseDataUseRelBit>(context.assignMap.size());
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(context.assignMap.size());
        for (Map.Entry entry : context.assignMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            int[] indexArr = this.covertIntegerList2IntArr((Collection)entry.getValue());
            BaseDataUseRelBit useRelBit = dataUseRelBitMap.get(orgId);
            if (null == useRelBit) {
                BaseDataUseRelBit bitRel = new BaseDataUseRelBit();
                RoaringBitmap newBit = RoaringBitmap.bitmapOf((int[])indexArr);
                newBit.runOptimize();
                bitRel.setBit(newBit);
                bitRel.setOrgId(orgId);
                newBitRelList.add(bitRel);
                message.add(this.createAddSolidifyMessage(newBit));
                continue;
            }
            RoaringBitmap bit = useRelBit.getBit();
            RoaringBitmap incrBit = RoaringBitmap.bitmapOf((int[])indexArr);
            incrBit.runOptimize();
            incrBit.andNot(bit);
            if (!incrBit.isEmpty()) {
                incrBit.runOptimize();
                message.add(this.createAddSolidifyMessage(incrBit));
            }
            bit.or(incrBit);
            Set deleteIndexes = (Set)context.deleteBitMap.get(orgId);
            if (!CollectionUtils.isEmpty((Collection)deleteIndexes)) {
                RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(deleteIndexes));
                deleteBit.runOptimize();
                bit.andNot(deleteBit);
                bit.runOptimize();
                message.add(this.createDelSolidifyMessage(deleteBit));
            }
            messageDto.add(message);
        }
        BaseDataUseRelUpdateEngine.update(dataUseRelBitMap.values(), this.entity);
        BaseDataUseRelUpdateEngine.insert(newBitRelList, this.entity);
        return messageDto;
    }

    private void saveOrUpdateRelBit(AssignContext context) throws Exception {
        Map<Long, BaseDataUseRelBit> dataUseRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(context.assignMap.keySet(), this.entity);
        ArrayList<BaseDataUseRelBit> newBitRelList = new ArrayList<BaseDataUseRelBit>(context.assignMap.size());
        for (Map.Entry entry : context.assignMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            int[] indexArr = this.covertIntegerList2IntArr((Collection)entry.getValue());
            BaseDataUseRelBit useRelBit = dataUseRelBitMap.get(orgId);
            if (null == useRelBit) {
                BaseDataUseRelBit bitRel = new BaseDataUseRelBit();
                RoaringBitmap newBit = RoaringBitmap.bitmapOf((int[])indexArr);
                newBit.runOptimize();
                bitRel.setBit(newBit);
                bitRel.setOrgId(orgId);
                newBitRelList.add(bitRel);
                continue;
            }
            RoaringBitmap bit = useRelBit.getBit();
            RoaringBitmap incrBit = RoaringBitmap.bitmapOf((int[])indexArr);
            incrBit.runOptimize();
            bit.or(incrBit);
            Set deleteIndexes = (Set)context.deleteBitMap.get(orgId);
            if (!CollectionUtils.isEmpty((Collection)deleteIndexes)) {
                RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(deleteIndexes));
                deleteBit.runOptimize();
                bit.andNot(deleteBit);
            }
            bit.runOptimize();
        }
        BaseDataUseRelUpdateEngine.update(dataUseRelBitMap.values(), this.entity);
        BaseDataUseRelUpdateEngine.insert(newBitRelList, this.entity);
    }

    private void updateCustomDataSourceInfo(AssignContext context) {
        if (CollectionUtils.isEmpty(this.customDataBaseInfos) || context.enableVersion) {
            return;
        }
        IDataEntityType entityType = ORM.create().getDataEntityType(this.entity);
        String tableName = entityType.getAlias();
        String updateSql = String.format("update %s set fsourcedataid = ?, fsourcebitindex = ? where fid = ?;", tableName);
        ArrayList<Object[]> params = new ArrayList<Object[]>(this.customDataBaseInfos.size());
        for (CustomDataBaseInfo info : this.customDataBaseInfos) {
            Object[] param = new Object[]{info.getSourceId(), info.getSourceIndex(), info.getId()};
            params.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)updateSql, params);
    }

    private void prepareAssignData(Set<Long> dataIds, Set<Long> orgIds, AssignContext context) {
        HashSet<String> selectFields = new HashSet<String>(Arrays.asList("id", this.masterIdPropName, "bitindex", this.numberPro));
        if (context.isAssignUnDetail) {
            selectFields.add("parent");
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entity, (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
        for (DynamicObject baseData : collection) {
            long pid;
            Long id = baseData.getLong("id");
            context.idToMasterIdMap.put(id, baseData.getLong(this.masterIdPropName));
            int index = baseData.getInt("bitindex");
            context.id2BitIndexMap.put(id, index);
            context.mstId2IndexMap.computeIfAbsent(baseData.getLong(this.masterIdPropName), k -> new HashSet(1)).add(index);
            context.indexNumberMap.put(index, baseData.getString(this.numberPro));
            if (!context.isAssignUnDetail || 0L == (pid = baseData.getLong("parent"))) continue;
            context.child2ParentRel.put(id, pid);
        }
        selectFields.addAll(Arrays.asList("createorg", "sourcedata", "ctrlstrategy"));
        this.prepareAssignData(orgIds, context, selectFields, context.idToMasterIdMap.values(), null);
    }

    private void prepareAssignData(Set<Long> orgIds, AssignContext context, Set<String> selectFields, Collection<Long> masterIds, QFilter customFilter) {
        QFilter[] filters = new QFilter[]{customFilter, new QFilter(this.masterIdPropName, "in", masterIds), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.entity, (String)String.join((CharSequence)",", selectFields), (QFilter[])filters);
        for (DynamicObject baseData : dynamicObjects) {
            long pid;
            Long id = baseData.getLong("id");
            int bitIndex = baseData.getInt("bitindex");
            context.id2BitIndexMap.put(id, bitIndex);
            context.idToMasterIdMap.put(id, baseData.getLong(this.masterIdPropName));
            context.idToSourceIdMap.put(id, baseData.getLong("sourcedata"));
            Long masterId = baseData.getLong(this.masterIdPropName);
            Long orgId = baseData.getLong("createorg");
            if (orgIds.contains(orgId)) {
                context.orgMstIdMap.computeIfAbsent(orgId, k -> new HashMap(16)).put(masterId, id);
            }
            context.mstId2IndexMap.computeIfAbsent(masterId, k -> new HashSet(1)).add(bitIndex);
            if (!"1".equals(baseData.getString("ctrlstrategy"))) {
                context.notGraduallyDataIds.add(id);
            }
            if (context.isAssignUnDetail && 0L != (pid = baseData.getLong("parent"))) {
                context.child2ParentRel.put(id, pid);
            }
            context.indexNumberMap.put(bitIndex, baseData.getString(this.numberPro));
        }
    }

    private Map<Long, List<Long>> getAbleAssignData(Set<Long> childOrgIds, List<Long> dataIds, AssignContext context) throws Exception {
        if (CollectionUtils.isEmpty(childOrgIds) || CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyMap();
        }
        this.beforeAbleAssignData(childOrgIds, context, dataIds);
        HashMap<Long, List<Long>> orgDataMap = new HashMap<Long, List<Long>>(childOrgIds.size());
        for (Long dataId : dataIds) {
            List parentDataIds = Collections.emptyList();
            if (context.isAssignUnDetail && !context.enableVersion) {
                parentDataIds = context.getParentDataIds(dataId);
            }
            for (Long childOrgId : childOrgIds) {
                if (context.enableVersion) {
                    this.eachAnalysisAbleData(context, orgDataMap, dataId, childOrgId);
                    continue;
                }
                this.eachAnalysisAbleData(context, orgDataMap, dataId, parentDataIds, childOrgId);
            }
        }
        return orgDataMap;
    }

    private void beforeAbleAssignData(Set<Long> childOrgIds, AssignContext context, List<Long> dataIds) throws Exception {
        if (!context.isAssignUnDetail || context.enableVersion) {
            return;
        }
        ArrayList<Long> masterIds = new ArrayList<Long>(dataIds.size());
        for (Long dataId : dataIds) {
            Long masterId = (Long)context.idToMasterIdMap.get(dataId);
            if (null == masterId) continue;
            masterIds.add(masterId);
        }
        List<String> fields = Arrays.asList("id", this.masterIdPropName, "bitindex", this.numberPro, "createorg", "sourcedata", "ctrlstrategy");
        HashSet<String> selectFields = new HashSet<String>(fields);
        if (context.isAssignUnDetail) {
            selectFields.add("parent");
        }
        QFilter filter = new QFilter("createorg", "in", childOrgIds);
        this.prepareAssignData(childOrgIds, context, selectFields, masterIds, filter);
        if (null == context.useRelBitMap) {
            context.useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(childOrgIds, this.entity);
        } else {
            context.useRelBitMap.putAll(BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(childOrgIds, this.entity));
        }
    }

    private void eachAnalysisAbleData(AssignContext context, Map<Long, List<Long>> orgDataMap, Long dataId, List<Long> parentDataIds, Long orgId) throws Exception {
        ListOrderedMap<Long, AutoIndividualData> autoIndividualizeData;
        boolean hasAutoIndividual;
        Map org2MsgMap = (Map)context.assignCheckResMap.get(dataId);
        if (!CollectionUtils.isEmpty((Map)org2MsgMap) && org2MsgMap.containsKey(orgId)) {
            return;
        }
        Map masterId2IdMap = (Map)context.orgMstIdMap.get(orgId);
        if (context.isAssignUnDetail && (hasAutoIndividual = context.autoIndividual((ListOrderedMap<Long, AutoIndividualData>)(autoIndividualizeData = this.getAutoIndividualizeData(context, parentDataIds, masterId2IdMap)), orgId))) {
            this.afterAutoIndividual(autoIndividualizeData, orgId, context);
        }
        Long masterId = (Long)context.idToMasterIdMap.get(dataId);
        if (!CollectionUtils.isEmpty((Map)masterId2IdMap) && masterId2IdMap.containsKey(masterId)) {
            Long customDataId = (Long)masterId2IdMap.get(masterId);
            if (context.notGraduallyDataIds.contains(customDataId)) {
                return;
            }
            orgDataMap.computeIfAbsent(orgId, k -> new ArrayList(context.id2BitIndexMap.size())).add(customDataId);
            this.collectAssignIndex(context, customDataId, orgId, masterId);
            Long sourceId = (Long)context.idToSourceIdMap.get(customDataId);
            Integer bitIndex = (Integer)context.id2BitIndexMap.get(dataId);
            if (!dataId.equals(sourceId) && null != bitIndex) {
                this.customDataBaseInfos.add(new CustomDataBaseInfo(customDataId, dataId, bitIndex));
            }
            return;
        }
        orgDataMap.computeIfAbsent(orgId, k -> new ArrayList(context.id2BitIndexMap.size())).add(dataId);
        this.collectAssignIndex(context, dataId, orgId, masterId);
    }

    private void eachAnalysisAbleData(AssignContext context, Map<Long, List<Long>> orgDataMap, Long dataId, Long orgId) {
        Map org2MsgMap = (Map)context.assignCheckResMap.get(dataId);
        if (!CollectionUtils.isEmpty((Map)org2MsgMap) && org2MsgMap.containsKey(orgId)) {
            return;
        }
        orgDataMap.computeIfAbsent(orgId, k -> new ArrayList(context.id2BitIndexMap.size())).add(dataId);
        Integer bitIndex = (Integer)context.id2BitIndexMap.get(dataId);
        if (bitIndex != null) {
            context.assignMap.computeIfAbsent(orgId, k -> new ArrayList(10)).add(bitIndex);
        }
    }

    private void afterAutoIndividual(ListOrderedMap<Long, AutoIndividualData> autoIndividualizeData, Long orgId, AssignContext context) throws Exception {
        for (Map.Entry entry : autoIndividualizeData.entrySet()) {
            AutoIndividualData value = (AutoIndividualData)entry.getValue();
            if (!value.isUpdateHierarchy()) continue;
            Long individualId = value.getIndividualId();
            Integer bitIndex = value.getBitIndex();
            Long masterId = (Long)entry.getKey();
            context.id2BitIndexMap.put(individualId, bitIndex);
            context.idToMasterIdMap.put(individualId, masterId);
            context.idToSourceIdMap.put(individualId, value.getSrcId());
            context.orgMstIdMap.computeIfAbsent(orgId, k -> new HashMap(16)).put(masterId, individualId);
            context.mstId2IndexMap.computeIfAbsent(masterId, k -> new HashSet(1)).add(bitIndex);
            if (!value.isGraduallyStrategy()) {
                context.notGraduallyDataIds.add(individualId);
            }
            context.child2ParentRel.put(individualId, value.getParentId());
            context.indexNumberMap.put(bitIndex, value.getNumber());
        }
        if (null == context.useRelBitMap) {
            context.useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(Collections.singleton(orgId), this.entity);
        } else {
            context.useRelBitMap.putAll(BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(Collections.singleton(orgId), this.entity));
        }
    }

    private ListOrderedMap<Long, AutoIndividualData> getAutoIndividualizeData(AssignContext context, List<Long> dataIds, Map<Long, Long> masterId2IdMap) {
        if (!context.isAssignUnDetail || CollectionUtils.isEmpty(masterId2IdMap) || dataIds.isEmpty()) {
            return new ListOrderedMap();
        }
        ListOrderedMap autoIndividualizeMap = new ListOrderedMap();
        boolean isIndividualize = false;
        for (int i = dataIds.size() - 1; i >= 0; --i) {
            boolean hasIndividualizeData;
            Long parentDataId = dataIds.get(i);
            Long masterId = (Long)context.idToMasterIdMap.get(parentDataId);
            Long individualId = masterId2IdMap.get(masterId);
            boolean bl = hasIndividualizeData = null != individualId;
            if (isIndividualize) {
                if (!hasIndividualizeData) {
                    autoIndividualizeMap.put((Object)masterId, (Object)new AutoIndividualData(parentDataId, null, false));
                    continue;
                }
                autoIndividualizeMap.put((Object)masterId, (Object)new AutoIndividualData(null, individualId, true));
                continue;
            }
            isIndividualize = hasIndividualizeData;
            if (!isIndividualize) continue;
            autoIndividualizeMap.put((Object)masterId, (Object)new AutoIndividualData(null, individualId, true));
        }
        return autoIndividualizeMap;
    }

    private void collectAssignIndex(AssignContext context, Long dataId, Long orgId, Long masterId) {
        BaseDataUseRelBit useRelBit;
        Integer bitIndex = (Integer)context.id2BitIndexMap.get(dataId);
        if (bitIndex != null) {
            context.assignMap.computeIfAbsent(orgId, k -> new ArrayList(10)).add(bitIndex);
        }
        if (null == (useRelBit = (BaseDataUseRelBit)context.useRelBitMap.get(orgId))) {
            return;
        }
        Set indexes = (Set)context.mstId2IndexMap.get(masterId);
        RoaringBitmap bit = useRelBit.getBit();
        for (Integer index : indexes) {
            if (!bit.contains(index.intValue()) || index.equals(bitIndex)) continue;
            context.deleteBitMap.computeIfAbsent(orgId, k -> new HashSet(1)).add(index);
            break;
        }
    }

    private void assignEachOrgData(List<Long> dataIds, Long orgId, AssignContext context) throws Exception {
        Set<Long> childOrgIds = this.assignOrgMap.get(orgId);
        if (CollectionUtils.isEmpty(childOrgIds)) {
            return;
        }
        ExtActionInfo extActionInfo = this.getBusinessCheckResult(new ArrayList<Long>(dataIds), new ArrayList<Long>(childOrgIds), orgId);
        if (!extActionInfo.isExecute()) {
            return;
        }
        Map<Long, Map<Long, String>> businessCheckResult = extActionInfo.getData();
        if (!CollectionUtils.isEmpty(businessCheckResult)) {
            for (Map.Entry<Long, Map<Long, String>> entry : businessCheckResult.entrySet()) {
                context.assignCheckResMap.computeIfAbsent(entry.getKey(), k -> new HashMap(16)).putAll(entry.getValue());
            }
        }
        Map<Long, List<Long>> ableAssignData = this.getAbleAssignData(childOrgIds, dataIds, context);
        for (Long childOrgId : childOrgIds) {
            List<Long> assignDataIds = ableAssignData.get(childOrgId);
            if (CollectionUtils.isEmpty(assignDataIds)) continue;
            this.assignEachOrgData(assignDataIds, childOrgId, context);
        }
    }

    public Map<Long, Map<Long, String>> batchAssign(List<Long> dataIds, List<Long> orgIds) throws Exception {
        Map<Long, List<Integer>> excludeData;
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == ctrlView) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%1$s\u5bf9\u5e94\u7684\u63a7\u5236\u89c6\u56fe\u3002", (String)"BaseDataAssignService_0", (String)"bos-bd-business", (Object[])new Object[0]), this.entity));
        }
        HashMap<Long, List<Integer>> excludeIndexes = new HashMap<Long, List<Integer>>(orgIds.size());
        HashMap<Long, Set<Long>> personalizedMap = new HashMap<Long, Set<Long>>(orgIds.size());
        boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion(this.entity);
        if (!enableVersion) {
            QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", orgIds), new QFilter(this.masterIdPropName, "in", dataIds), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.entity, (String)"sourcedata, createorg, srcindex", (QFilter[])filters);
            for (DynamicObject baseData : dynamicObjects) {
                Long orgId = baseData.getLong("createorg");
                excludeIndexes.computeIfAbsent(orgId, k -> new ArrayList(10)).add(baseData.getInt("srcindex"));
                personalizedMap.computeIfAbsent(orgId, k -> new HashSet(10)).add(baseData.getLong("sourcedata"));
            }
        }
        Map<Long, Integer> idToBitIndexMap = this.getBaseDataId2BitIndexMap(dataIds, this.entity);
        HashMap<Long, Set<Long>> notPassedMap = new HashMap<Long, Set<Long>>(16);
        ExtActionInfo extActionInfo = this.getBusinessCheckResult(dataIds, orgIds, this.assignOrgId);
        if (!extActionInfo.isExecute()) {
            return extActionInfo.getData();
        }
        Map<Long, Map<Long, String>> assignCheckResMap = extActionInfo.getData();
        for (Map.Entry<Long, Map<Long, String>> entry : assignCheckResMap.entrySet()) {
            Long dataId = entry.getKey();
            Integer index = idToBitIndexMap.get(dataId);
            Map<Long, String> assignCheckOrgMap = entry.getValue();
            if (null == index || CollectionUtils.isEmpty(assignCheckOrgMap)) continue;
            for (Long orgId : assignCheckOrgMap.keySet()) {
                excludeIndexes.computeIfAbsent(orgId, k -> new ArrayList(10)).add(index);
                notPassedMap.computeIfAbsent(orgId, k -> new HashSet(16)).add(dataId);
            }
        }
        boolean isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail(this.entity);
        if (isAssignUnDetail && !enableVersion && !CollectionUtils.isEmpty(excludeData = new TreeBaseDataCommonService(this.entity).autoIndividualOnFreeStrategy(dataIds, personalizedMap, notPassedMap))) {
            excludeData.forEach((key, value) -> excludeIndexes.computeIfAbsent((Long)key, k -> new ArrayList(10)).addAll(value));
        }
        int[] commonIndexes = this.covertIntegerList2IntArr(idToBitIndexMap.values());
        this.saveOrUpdateRelBit(commonIndexes, excludeIndexes, orgIds);
        this.writOpLog(Collections.emptyMap(), Collections.emptyMap(), this.assignOrgId);
        return assignCheckResMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateRelBit(int[] commonIndexes, Map<Long, List<Integer>> excludeIndexes, List<Long> orgIds) {
        RoaringBitmap commonBit = RoaringBitmap.bitmapOf((int[])commonIndexes);
        commonBit.runOptimize();
        HashMap<Long, BaseDataUseRelBit> newBitRelMap = new HashMap<Long, BaseDataUseRelBit>(orgIds.size());
        for (Long orgId : orgIds) {
            BaseDataUseRelBit bitRel = new BaseDataUseRelBit();
            bitRel.setOrgId(orgId);
            bitRel.setBit(commonBit);
            List<Integer> indexes = excludeIndexes.get(orgId);
            if (!CollectionUtils.isEmpty(indexes)) {
                RoaringBitmap cloneBit = commonBit.clone();
                cloneBit.runOptimize();
                RoaringBitmap excludeBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexes));
                excludeBit.runOptimize();
                cloneBit.andNot(excludeBit);
                cloneBit.runOptimize();
                bitRel.setBit(cloneBit);
            }
            newBitRelMap.put(orgId, bitRel);
        }
        String lockKey = BaseDataAssignService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.assignOnTransaction(newBitRelMap, orgIds);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5206\u914d\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataAssignService_7", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void assignOnTransaction(Map<Long, BaseDataUseRelBit> newBitRelMap, List<Long> orgIds) throws Exception {
        boolean asyncRecord = this.asyncRecord();
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
        ArrayList<BaseDataUseRelBit> needUpdateList = new ArrayList<BaseDataUseRelBit>(10);
        Map<Long, BaseDataUseRelBit> dataUseRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
        for (Map.Entry<Long, BaseDataUseRelBit> entry : dataUseRelBitMap.entrySet()) {
            BaseDataUseRelBit remove = newBitRelMap.remove(entry.getKey());
            if (null == remove) continue;
            BaseDataUseRelBit value = entry.getValue();
            RoaringBitmap bit = value.getBit();
            if (asyncRecord) {
                RoaringBitmap incrBit = remove.getBit().clone();
                incrBit.andNot(bit);
                if (!incrBit.isEmpty()) {
                    BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, remove.getOrgId());
                    message.add(this.createAddSolidifyMessage(incrBit));
                    messageDto.add(message);
                }
            }
            bit.or(remove.getBit());
            needUpdateList.add(value);
        }
        Collection<BaseDataUseRelBit> values = newBitRelMap.values();
        if (asyncRecord && !CollectionUtils.isEmpty(values)) {
            for (BaseDataUseRelBit value : values) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, value.getOrgId());
                message.add(this.createAddSolidifyMessage(value.getBit()));
                messageDto.add(message);
            }
        }
        BaseDataUseRelUpdateEngine.update(needUpdateList, this.entity);
        BaseDataUseRelUpdateEngine.insert(values, this.entity);
        if (asyncRecord) {
            this.publish(messageDto);
        }
    }

    private ExtActionInfo getBusinessCheckResult(List<Long> dataIds, List<Long> orgIds, Long exeAssignOrg) {
        HashMap<Long, Map<Long, String>> assignCheckResMap = new HashMap(16);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = this.getBaseDataCtrlPlugin(this.entity);
        if (baseDataCtrlPlugin != null) {
            Map map = baseDataCtrlPlugin.assignCheckWithDetail(dataIds, orgIds);
            if (!CollectionUtils.isEmpty((Map)map)) {
                assignCheckResMap = map;
            } else {
                this.convertMapWithErrorMsg(dataIds, orgIds, assignCheckResMap, baseDataCtrlPlugin);
            }
        }
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity);
        ExtActionInfo extActionInfo = ext.handleBeforeAssign(this.entity, exeAssignOrg, dataIds, orgIds);
        Map<Long, Map<Long, String>> data = extActionInfo.getData();
        for (Map.Entry entry : assignCheckResMap.entrySet()) {
            Optional.ofNullable(entry.getValue()).ifPresent(data.computeIfAbsent((Long)entry.getKey(), (Function<Long, Map<Long, String>>)((Function<Long, Map>)k -> new HashMap(16)))::putAll);
        }
        return extActionInfo;
    }

    public void cancelAssign(Map<Long, Set<Long>> useOrg2DataMap) throws Exception {
        if (CollectionUtils.isEmpty(useOrg2DataMap)) {
            return;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == ctrlView) {
            return;
        }
        HashSet<Long> dataIds = new HashSet<Long>(16);
        useOrg2DataMap.values().forEach(dataIds::addAll);
        Map<Long, Integer> id2IndexMap = this.getBaseDataId2BitIndexMap(dataIds, this.entity);
        this.executeCancelAssign(useOrg2DataMap, id2IndexMap, useOrg2DataMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCancelAssign(Map<Long, Set<Long>> useOrg2DataMap, Map<Long, Integer> id2IndexMap, Set<Long> orgIds) throws Exception {
        HashMap<Long, List> rel = new HashMap<Long, List>(useOrg2DataMap.size());
        String lockKey = BaseDataAssignService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            boolean asyncRecord = this.asyncRecord();
            BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
            Map<Long, BaseDataUseRelBit> dataUseRelBit = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
            for (Long orgId : orgIds) {
                BaseDataUseRelBit useRelBit;
                Set<Long> selectIds = useOrg2DataMap.get(orgId);
                int[] indexArr = new int[selectIds.size()];
                int i = 0;
                for (Long dataId : selectIds) {
                    indexArr[i] = id2IndexMap.get(dataId);
                    ++i;
                }
                Set indexes = Arrays.stream(indexArr).boxed().collect(Collectors.toSet());
                RoaringBitmap deleteData = RoaringBitmap.bitmapOf((int[])indexArr);
                deleteData.runOptimize();
                if (asyncRecord) {
                    BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                    message.add(this.createDelSolidifyMessage(deleteData));
                    messageDto.add(message);
                }
                if (null == (useRelBit = dataUseRelBit.get(orgId))) continue;
                RoaringBitmap bit = useRelBit.getBit();
                bit.andNot(deleteData);
                bit.runOptimize();
                rel.computeIfAbsent(orgId, k -> new ArrayList()).addAll(indexes);
            }
            this.executeCancelAssignOnTransaction(dataUseRelBit.values(), messageDto);
        }
        finally {
            lock.unlock();
        }
        String appId = EntityMetadataCache.getBizAppNumber((String)this.entity);
        this.writUnAssignOpLogWithDataNumber(this.entity, this.opOrgId, appId);
    }

    private void executeCancelAssignOnTransaction(Collection<BaseDataUseRelBit> relBits, BaseDataSolidifyMessageDTO messageDto) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                BaseDataUseRelUpdateEngine.update(relBits, this.entity);
                this.publish(messageDto);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u53d6\u6d88\u5206\u914d\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataAssignService_11", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    public Map<Long, Set<Long>> getDataAssignInfo(Set<Long> dataIds, Collection<Long> orgIds) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
        Map<Integer, Long> index2IdMap = this.getBaseDataBitIndex2IdMap(dataIds, this.entity);
        RoaringBitmap dataBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(index2IdMap.keySet()));
        dataBit.runOptimize();
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
            Long orgId = entry.getKey();
            RoaringBitmap bit = entry.getValue().getBit();
            bit.and(dataBit);
            for (int index : bit.toArray()) {
                result.computeIfAbsent(index2IdMap.get(index), k -> new HashSet(16)).add(orgId);
            }
        }
        return result;
    }

    public Set<Long> getAllAssignTypeData(Set<Long> dataIds, Long createOrg) throws Exception {
        Set<Long> customDataIds = this.selectCustomDataIds(this.entity, dataIds);
        HashSet<Long> result = new HashSet<Long>(customDataIds);
        dataIds.removeAll(customDataIds);
        if (CollectionUtils.isEmpty(dataIds)) {
            return result;
        }
        result.addAll(this.getAllAssignDataIds(dataIds, createOrg));
        return result;
    }

    public Set<Long> getAllAssignDataIds(Set<Long> dataIds, Long createOrg) throws Exception {
        HashSet<Long> result = new HashSet<Long>(16);
        Map<Long, BaseDataUseRelBit> cuRelBitMap = BaseDataUseRelQueryEngine.getCURelBitMapByEntity(this.entity);
        cuRelBitMap.remove(createOrg);
        if (!cuRelBitMap.isEmpty()) {
            result.addAll(this.getAssignedData(dataIds, cuRelBitMap));
        }
        return result;
    }

    public Set<Long> getAllAssignDataIds(Set<Long> dataIds) throws Exception {
        HashSet<Long> result = new HashSet<Long>(16);
        Map<Long, BaseDataUseRelBit> cuRelBitMap = BaseDataUseRelQueryEngine.getCURelBitMapByEntity(this.entity);
        if (cuRelBitMap.isEmpty()) {
            return result;
        }
        Map<Integer, Long> indexMap = this.getBaseDataBitIndex2IdMap(dataIds, this.entity);
        Set<Integer> dataIndexs = indexMap.keySet();
        HashSet<Integer> existDataIndexs = new HashSet<Integer>(indexMap.size());
        for (BaseDataUseRelBit useRelBit : cuRelBitMap.values()) {
            int[] bitArray;
            for (int bitIndex : bitArray = useRelBit.getBit().toArray()) {
                if (!dataIndexs.contains(bitIndex)) continue;
                if (existDataIndexs.contains(bitIndex)) {
                    result.add(indexMap.get(bitIndex));
                    continue;
                }
                existDataIndexs.add(bitIndex);
            }
        }
        return result;
    }

    public Set<Long> getAssignToDirectSubChildData(Set<Long> dataIds, Long createOrg) throws Exception {
        Set<Long> customDataIds = this.selectCustomDataIds(this.entity, dataIds);
        HashSet<Long> result = new HashSet<Long>(customDataIds);
        dataIds.removeAll(customDataIds);
        if (CollectionUtils.isEmpty(dataIds)) {
            return result;
        }
        result.addAll(this.getDirectSubAssignData(dataIds, createOrg));
        return result;
    }

    public Set<Long> getDirectSubAssignData(Set<Long> dataIds, Long createOrg) throws Exception {
        HashSet<Long> result = new HashSet<Long>(16);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long viewId = (Long)ctrlView.getPkValue();
        List<Long> directSubCuOrgList = this.getDirectSubCuOrgList(viewId, createOrg);
        if (CollectionUtils.isEmpty(directSubCuOrgList)) {
            return Collections.emptySet();
        }
        Map<Long, BaseDataUseRelBit> cuRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(directSubCuOrgList, this.entity);
        result.addAll(this.getAssignedData(dataIds, cuRelBitMap));
        return result;
    }

    private Set<Long> getAssignedData(Set<Long> dataIds, Map<Long, BaseDataUseRelBit> cuRelBitMap) {
        int[] assignIndexes;
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(dataIds.size());
        Map<Integer, Long> indexMap = this.getBaseDataBitIndex2IdMap(dataIds, this.entity);
        RoaringBitmap allBit = new RoaringBitmap();
        for (BaseDataUseRelBit useRelBit : cuRelBitMap.values()) {
            allBit.or(useRelBit.getBit());
        }
        Set<Integer> indexes = indexMap.keySet();
        RoaringBitmap bitIndexes = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexes));
        bitIndexes.and(allBit);
        for (int index : assignIndexes = bitIndexes.toArray()) {
            Long dataId = indexMap.remove(index);
            result.add(dataId);
        }
        return result;
    }

    private void convertMapWithErrorMsg(List<Long> dataIds, List<Long> orgIds, Map<Long, Map<Long, String>> assignCheckResMap, IBaseDataCtrlPlugin baseDataCtrlPlugin) {
        Map assignCheckRes = baseDataCtrlPlugin.assignCheck(dataIds, orgIds);
        if (!CollectionUtils.isEmpty((Map)assignCheckRes)) {
            for (Map.Entry entry : assignCheckRes.entrySet()) {
                Long key = (Long)entry.getKey();
                List tempOrgList = (List)entry.getValue();
                HashMap<Long, String> tempErrMsgMap = new HashMap<Long, String>(tempOrgList.size());
                for (Long tempOrg : tempOrgList) {
                    tempErrMsgMap.put(tempOrg, "");
                }
                assignCheckResMap.put(key, tempErrMsgMap);
            }
        }
    }

    public boolean isAssignData(Long dataId, Long useOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "=", (Object)useOrgId), new QFilter("sourcedata", "=", (Object)dataId), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        if (ORM.create().exists(this.entity, filters)) {
            return true;
        }
        Map<Long, Integer> id2BitIndexMap = this.getBaseDataId2BitIndexMap(Collections.singletonList(dataId), this.entity);
        Integer bitIndex = id2BitIndexMap.get(dataId);
        if (null == bitIndex) {
            return false;
        }
        try {
            List<Integer> useBitIndexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexByOrgId(useOrgId, this.entity);
            return useBitIndexes.contains(bitIndex);
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5224\u65ad\u662f\u5426\u5df2\u7ecf\u5206\u914d\u5f02\u5e38\uff0c\u9ed8\u8ba4\u5f53\u6210\u672a\u5206\u914d\u5904\u7406", (String)"BaseDataAssignService_9", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            return false;
        }
    }

    public boolean isHasAssignData(Long dataId) {
        Set<Long> customDataIds = this.selectCustomDataIds(this.entity, Collections.singletonList(dataId));
        if (!CollectionUtils.isEmpty(customDataIds)) {
            return true;
        }
        String strategy = "";
        Long orgId = 0L;
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)dataId)};
        try (DataSet dataSet = ORM.create().queryDataSet(BaseDataAssignService.class.getName(), this.entity, "ctrlstrategy, createorg", filters);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                strategy = row.getString("ctrlstrategy");
                orgId = row.getLong("createorg");
            }
        }
        if (0L == orgId) {
            return false;
        }
        try {
            Set<Object> dataIds = Collections.emptySet();
            if ("1".equals(strategy)) {
                dataIds = this.getDirectSubAssignData(Collections.singleton(dataId), orgId);
            } else if ("2".equals(strategy)) {
                dataIds = this.getAllAssignDataIds(Collections.singleton(dataId), orgId);
            }
            if (!CollectionUtils.isEmpty(dataIds)) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5224\u65ad\u67d0\u6761\u6570\u636e\u662f\u5426\u88ab\u5206\u914d\u5f02\u5e38...", (Throwable)e);
        }
        return false;
    }

    public Map<Long, Map<Long, String>> batchAssignAdapter(Long assignOrgId, List<Long> dataIds, List<Long> orgIds) {
        HashMap<Long, Map<Long, String>> assignCheckResMap;
        ArrayList<Long> cuAssignDataIds;
        block19: {
            ArrayList<Long> freeDataIds = new ArrayList<Long>(10);
            cuAssignDataIds = new ArrayList<Long>(10);
            ORM orm = ORM.create();
            QFilter[] baseDataFilters = new QFilter[]{new QFilter("id", "in", dataIds)};
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), this.entity, "id, ctrlstrategy", baseDataFilters);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String strategy = row.getString("ctrlstrategy");
                    if ("1".equals(strategy)) {
                        cuAssignDataIds.add(row.getLong("id"));
                        continue;
                    }
                    if (!"2".equals(strategy)) continue;
                    freeDataIds.add(row.getLong("id"));
                }
            }
            assignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
            try {
                if (CollectionUtils.isEmpty(freeDataIds)) break block19;
                this.setAssignOrgId(assignOrgId);
                assignCheckResMap.putAll(this.batchAssign(freeDataIds, orgIds));
            }
            catch (Exception e) {
                LOGGER.error("\u81ea\u7531\u5206\u914d\uff0c\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\u3002", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u81ea\u7531\u5206\u914d\uff0c\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\u3002", (String)"BaseDataAssignService_2", (String)"bos-bd-business", (Object[])new Object[0]);
                for (Long dataId : freeDataIds) {
                    HashMap errorMap = new HashMap(orgIds.size());
                    orgIds.forEach(orgId -> errorMap.put(orgId, msg));
                    assignCheckResMap.put(dataId, errorMap);
                }
            }
        }
        if (!CollectionUtils.isEmpty(cuAssignDataIds)) {
            this.setAssignOrgId(assignOrgId);
            assignCheckResMap.putAll(this.batchCuAssignAdapter(assignOrgId, orgIds, cuAssignDataIds));
        }
        return assignCheckResMap;
    }

    private Map<Long, Map<Long, String>> batchCuAssignAdapter(Long assignOrgId, List<Long> orgIds, List<Long> dataIds) {
        this.setAssignOrgMap(new BaseDataCommonService().getParen2ChildOrgMap(assignOrgId, orgIds, this.entity));
        if (CollectionUtils.isEmpty(this.assignOrgMap)) {
            return Collections.emptyMap();
        }
        HashSet<Long> targetOrgIds = new HashSet<Long>(orgIds.size());
        for (Map.Entry<Long, Set<Long>> entry : this.assignOrgMap.entrySet()) {
            targetOrgIds.addAll((Collection)entry.getValue());
            Long pid = entry.getKey();
            if (assignOrgId.equals(pid)) continue;
            targetOrgIds.add(pid);
        }
        HashMap<Long, Map<Long, String>> assignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
        try {
            Map<Long, Map<Long, String>> assignResult = this.batchCuAssign(new HashSet<Long>(dataIds), targetOrgIds, assignOrgId);
            assignCheckResMap.putAll(assignResult);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u9010\u7ea7\u5206\u914d\uff0c\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\u3002", (String)"BaseDataAssignService_3", (String)"bos-bd-business", (Object[])new Object[0]);
            LOGGER.error(msg, (Object)"bos-bd-business", (Object)e);
            for (Long dataId : dataIds) {
                HashMap errorMap = new HashMap(orgIds.size());
                orgIds.forEach(orgId -> errorMap.put(orgId, msg));
                assignCheckResMap.put(dataId, errorMap);
            }
        }
        return assignCheckResMap;
    }

    private void writOpLog(Map<Long, List<Integer>> assignMap, Map<Integer, String> indexNumberMap, Long opOrg) {
        BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
            Date opTime = new Date();
            String appId = EntityMetadataCache.getBizAppNumber((String)this.entity);
            OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, opOrg, this.entity, appId);
            appLogInfo.setOpName("assign_new", BaseDataCommon.getOpName(this.entity, "assign_new"));
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5b8c\u6210\uff0c\u8be6\u60c5\u53ef\u89c1\u7ba1\u63a7\u65e5\u5fd7\uff0c\u5177\u4f53\u8def\u5f84\uff1a\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011-\u3010\u4f01\u4e1a\u5efa\u6a21\u3011-\u3010\u7ba1\u63a7\u7b56\u7565\u3011-\u3010\u7ba1\u63a7\u65e5\u5fd7\u3011\u3002", "BaseDataAssignService_6", "bos-bd-business"), new String[0]);
            ArrayList<OpLogAppInfo> logs = new ArrayList<OpLogAppInfo>(1);
            logs.add(appLogInfo);
            LogServiceHelper.addBatchLog(logs);
            return Boolean.TRUE;
        }, RequestContext.get());
    }

    @Override
    public void setEntity(String entity) {
        super.setEntity(entity);
    }

    public void setAssignOrgMap(Map<Long, Set<Long>> assignOrgMap) {
        this.assignOrgMap = assignOrgMap;
    }

    public void setOpOrgId(Long opOrgId) {
        this.opOrgId = opOrgId;
    }

    public void setAppId(String appNumber) {
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            this.appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        }
    }

    public void setAssignOrgId(Long assignOrgId) {
        this.assignOrgId = assignOrgId;
    }

    @Deprecated
    public List<Long> dataAssignOrgs(DynamicObjectCollection collection) {
        ArrayList<Object> dataIds = new ArrayList<Object>(collection.size());
        for (DynamicObject obj : collection) {
            dataIds.add(obj.get("id"));
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
        SqlBuilder builder = new SqlBuilder();
        String tableName = dt.getAlias() + "UseReg";
        builder.append("SELECT fuseorgid from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]);
        builder.appendIn("fdataid", dataIds);
        builder.append(" and FisAssign = '1';", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            ArrayList<Long> list = new ArrayList<Long>(8);
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
            return list;
        });
    }

    @Deprecated
    public boolean havePersonaliedData(DynamicObject saveObj, Long useOrgId) {
        String entity = saveObj.getDataEntityType().getName();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        Long masterId = 0L;
        if (saveObj.get(masteridPropName) instanceof Long) {
            masterId = (Long)saveObj.get(masteridPropName);
        } else if (saveObj.get(masteridPropName) instanceof DynamicObject) {
            masterId = (Long)((DynamicObject)saveObj.get(masteridPropName)).getPkValue();
        }
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter("createorg", "=", (Object)useOrgId);
        ORM orm = ORM.create();
        filters[1] = new QFilter(masteridPropName, "=", (Object)masterId);
        DynamicObjectCollection doc = orm.query(entity, "id, " + masteridPropName, filters);
        for (DynamicObject obj : doc) {
            boolean notSaveData;
            Object masterid = obj.get(masteridPropName);
            Object dataId = obj.get("id");
            boolean bl = notSaveData = !saveObj.get("id").equals(dataId);
            if (null == masterid || masterid.equals(dataId) || !notSaveData) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Map<String, String> getOrgNameByOrgId(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> orgNameMap = new HashMap<String, String>(orgIds.size());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", orgIds)};
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)orgMap)) {
            for (Map.Entry entry : orgMap.entrySet()) {
                Object id = entry.getKey();
                DynamicObject org = (DynamicObject)entry.getValue();
                String name = org.getString("name");
                orgNameMap.put(String.valueOf(id), name);
            }
        }
        return orgNameMap;
    }

    @Deprecated
    public Long getOrgIdByOrgNum(String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        long orgId = 0L;
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)orgMap)) {
            for (Map.Entry entry : orgMap.entrySet()) {
                Object id = entry.getKey();
                orgId = Long.parseLong(String.valueOf(id));
            }
        }
        return orgId;
    }

    @Deprecated
    public Map<Long, String> checkTreeDataAssign(List<Long> ids, Long useOrgId, boolean needAll) {
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entity);
        return service.checkTreeDataAssign(ids, useOrgId, needAll);
    }

    @Deprecated
    public Map<Long, String> getAllTreeNode(Collection<DynamicObject> collection, Long useOrgId) {
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entity);
        return service.getAllTreeNode(collection, useOrgId);
    }

    @Deprecated
    public List<TreeNode> getIntegrityNodes(List<String> numberList, Set<Long> leafNodeIds, Long currentOrgId) {
        TreeBaseDataCommonService service = new TreeBaseDataCommonService(this.entity);
        return service.getIntegrityNodes(numberList, leafNodeIds, currentOrgId);
    }

    @Deprecated
    public List<Long> getOrgPersonaliedList(DynamicObject obj, Long useOrgId) {
        return Collections.emptyList();
    }

    static class CustomDataBaseInfo {
        private Long id;
        private Long sourceId;
        private Integer sourceIndex;

        CustomDataBaseInfo(Long id, Long sourceId, Integer sourceIndex) {
            this.id = id;
            this.sourceId = sourceId;
            this.sourceIndex = sourceIndex;
        }

        Long getId() {
            return this.id;
        }

        Long getSourceId() {
            return this.sourceId;
        }

        Integer getSourceIndex() {
            return this.sourceIndex;
        }
    }

    private static class AssignContext {
        private Map<Long, List<Integer>> assignMap = new HashMap<Long, List<Integer>>(16);
        private Map<Long, BaseDataUseRelBit> useRelBitMap;
        private Map<Integer, String> indexNumberMap = new HashMap<Integer, String>(16);
        private Map<Long, Map<Long, String>> assignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
        private Map<Long, Set<Integer>> deleteBitMap = new HashMap<Long, Set<Integer>>(0);
        private Set<Long> notGraduallyDataIds = new HashSet<Long>(0);
        private Map<Long, Set<Integer>> mstId2IndexMap = new HashMap<Long, Set<Integer>>(0);
        private Map<Long, Integer> id2BitIndexMap = new HashMap<Long, Integer>(0);
        private Map<Long, Map<Long, Long>> orgMstIdMap = new HashMap<Long, Map<Long, Long>>(0);
        private Map<Long, Long> idToSourceIdMap = new HashMap<Long, Long>(0);
        private Map<Long, Long> idToMasterIdMap = new HashMap<Long, Long>(0);
        private Map<Long, Long> child2ParentRel = new HashMap<Long, Long>(0);
        private boolean isAssignUnDetail;
        private boolean enableVersion;
        private TreeBaseDataCommonService service;

        private AssignContext(String entity) {
            this.isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail(entity);
            if (this.isAssignUnDetail) {
                this.service = new TreeBaseDataCommonService(entity);
            }
            this.enableVersion = BaseDataBusinessServiceUtils.isEnableVersion(entity);
        }

        private boolean autoIndividual(ListOrderedMap<Long, AutoIndividualData> autoIndividualizeData, Long orgId) {
            if (this.isAssignUnDetail && null != this.service) {
                return this.service.autoIndividualOnGraduallyStrategy(autoIndividualizeData, orgId);
            }
            return false;
        }

        private List<Long> getParentDataIds(Long dataId) {
            if (this.child2ParentRel.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Long> parentIds = new ArrayList<Long>(10);
            parentIds.add(dataId);
            this.collectParentIds(this.child2ParentRel.get(dataId), parentIds);
            return parentIds;
        }

        private void collectParentIds(Long parentId, List<Long> parentIds) {
            if (null == parentId) {
                return;
            }
            parentIds.add(parentId);
            this.collectParentIds(this.child2ParentRel.get(parentId), parentIds);
        }
    }
}

