/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataAuditService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataAuditService.class);
    private boolean auditOp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void baseDataAuditHandler(DynamicObject[] baseDataArr) throws Exception {
        if (baseDataArr == null || baseDataArr.length == 0) {
            return;
        }
        String entity = this.getBaseDataEntity(baseDataArr);
        if (StringUtils.isEmpty((Object)entity)) {
            return;
        }
        this.setAuditOp(true);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        AbstractBaseDataService.OpDataContext context = new AbstractBaseDataService.OpDataContext();
        boolean asyncRecord = this.asyncRecord();
        Map<Long, List<Integer>> rel = this.buildNeedUpdateBitIndexes(baseDataArr, context, asyncRecord, viewId);
        DLock lock = DLock.createReentrant((String)BaseDataAuditService.getBaseDataUnifiedLockKey(entity));
        lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.saveOrUpdateRelBit(rel, entity);
                if (asyncRecord) {
                    BaseDataSolidifyMessageDTO messageDto = this.createAddMessageDto(context, true, viewId);
                    this.publish(messageDto);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5ba1\u6838\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataAuditService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void baseDataUnAuditHandler(DynamicObject[] baseDataArr) throws Exception {
        if (baseDataArr == null || baseDataArr.length == 0) {
            return;
        }
        String entity = this.getBaseDataEntity(baseDataArr);
        if (StringUtils.isEmpty((Object)entity)) {
            return;
        }
        boolean asyncRecord = this.asyncRecord();
        this.setAuditOp(false);
        AbstractBaseDataService.OpDataContext context = new AbstractBaseDataService.OpDataContext();
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        Map<Long, List<Integer>> rel = this.buildNeedUpdateBitIndexes(baseDataArr, context, asyncRecord, viewId);
        DLock lock = DLock.createReentrant((String)BaseDataAuditService.getBaseDataUnifiedLockKey(entity));
        lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!CollectionUtils.isEmpty(rel)) {
                    this.updateRelBit(entity, rel);
                }
                if (asyncRecord) {
                    BaseDataSolidifyMessageDTO messageDto = this.createDelMessageDto(context, viewId);
                    this.publish(messageDto);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u53cd\u5ba1\u6838\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataAuditService_1", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Map<Long, List<Integer>> buildNeedUpdateBitIndexes(DynamicObject[] baseDataArr, AbstractBaseDataService.OpDataContext context, boolean asyncRecord, Long viewId) {
        HashMap<Long, List<Integer>> rel = new HashMap<Long, List<Integer>>(baseDataArr.length);
        HashMap<Long, List<Integer>> shareTypeBdMap = new HashMap<Long, List<Integer>>(16);
        for (DynamicObject data : baseDataArr) {
            boolean recordCurrentOrg;
            String ctrlStrategy = data.getString("ctrlstrategy");
            Long createOrgId = BaseDataAuditService.getLongPropertyFromDynamicObject(data, "createorg");
            boolean needWriteBitRel = this.needWriteBitRel(ctrlStrategy);
            int bitIndex = data.getInt("bitindex");
            if ("6".equals(ctrlStrategy) && needWriteBitRel) {
                shareTypeBdMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
            }
            boolean isFree = "2".equals(ctrlStrategy) || "4".equals(ctrlStrategy);
            boolean isAssign = "1".equals(ctrlStrategy) || "3".equals(ctrlStrategy);
            boolean isPrivate = "7".equals(ctrlStrategy);
            boolean bl = recordCurrentOrg = isFree || isAssign || isPrivate;
            if (this.isAuditOp()) {
                if (!"5".equals(ctrlStrategy) && needWriteBitRel) {
                    rel.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
                }
                if (asyncRecord && recordCurrentOrg) {
                    context.currentOrgIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
                }
            }
            if (!asyncRecord) continue;
            if ("5".equals(ctrlStrategy)) {
                context.shareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
                continue;
            }
            if (!"6".equals(ctrlStrategy)) continue;
            context.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
        }
        this.handleShareTypeBaseData(rel, shareTypeBdMap, viewId);
        return rel;
    }

    private void updateRelBit(String entity, Map<Long, List<Integer>> rel) throws Exception {
        Map<Long, int[]> orgToBitIndexMap = this.convertListToArr(rel);
        Map<Long, BaseDataUseRelBit> dataUseRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(rel.keySet(), entity);
        ArrayList<BaseDataUseRelBit> needUpdateList = new ArrayList<BaseDataUseRelBit>(10);
        for (Map.Entry<Long, int[]> entry : orgToBitIndexMap.entrySet()) {
            RoaringBitmap bit;
            BaseDataUseRelBit useRelBit = dataUseRelBitMap.get(entry.getKey());
            if (null == useRelBit || null == (bit = useRelBit.getBit())) continue;
            RoaringBitmap removeBit = RoaringBitmap.bitmapOf((int[])entry.getValue());
            removeBit.runOptimize();
            bit.andNot(removeBit);
            bit.runOptimize();
            needUpdateList.add(useRelBit);
        }
        if (!CollectionUtils.isEmpty(needUpdateList)) {
            BaseDataUseRelUpdateEngine.update(needUpdateList, entity);
        }
    }

    private Map<Long, int[]> convertListToArr(Map<Long, List<Integer>> rel) {
        HashMap<Long, int[]> result = new HashMap<Long, int[]>(rel.size());
        for (Map.Entry<Long, List<Integer>> entry : rel.entrySet()) {
            List<Integer> bitIndexes = entry.getValue();
            int[] arr = new int[bitIndexes.size()];
            for (int i = 0; i < bitIndexes.size(); ++i) {
                arr[i] = bitIndexes.get(i);
            }
            result.put(entry.getKey(), arr);
        }
        return result;
    }

    private String getBaseDataEntity(DynamicObject[] baseDataArr) {
        String entityId = null;
        for (DynamicObject data : baseDataArr) {
            String dataEntity = data.getDataEntityType().getName();
            if (entityId == null) {
                entityId = dataEntity;
                continue;
            }
            if (entityId.equalsIgnoreCase(dataEntity)) continue;
            throw new KDBizException("DATA ENTITY ARE NOT THE SAME.");
        }
        super.init(entityId);
        return entityId;
    }

    private boolean isAuditOp() {
        return this.auditOp;
    }

    private void setAuditOp(boolean auditOp) {
        this.auditOp = auditOp;
    }
}

