/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.ext.IBaseDataModelExtService;
import kd.bos.bd.service.AbstractBaseService;
import kd.bos.bd.service.BaseDataMaintenanceService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataAutoUpgradeService
extends AbstractBaseService {
    private static Log LOGGER = LogFactory.getLog(BaseDataAutoUpgradeService.class);

    public static boolean isAbleUpgradeModel(String entity) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return false;
        }
        if (BaseDataAutoUpgradeService.isInBlackList(entity)) {
            return false;
        }
        return BaseDataAutoUpgradeService.businessCheck(entity);
    }

    private static boolean isInBlackList(String entity) {
        String app = BizAppServiceHelp.getAppIdByFormNum((String)entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append("SELECT FBIZCLOUDID FROM T_META_BIZAPP WHERE FID = ?", new Object[]{app});
        String cloudId = (String)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            if (rs.next()) {
                return rs.getString("FBIZCLOUDID");
            }
            return null;
        });
        HashSet<String> templates = new HashSet<String>(16);
        Boolean disAble = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"SELECT FBASEDATAID, FBIZAPPID, FBIZCLOUDID, FISTPL FROM T_BD_NEWMODE_BLACKLIST", rs -> {
            while (rs.next()) {
                String appId = rs.getString("FBIZAPPID");
                if (StringUtils.isNotBlank((CharSequence)appId) && appId.equals(app)) {
                    return true;
                }
                String cloud = rs.getString("FBIZCLOUDID");
                if (StringUtils.isNotBlank((CharSequence)cloud) && cloud.equals(cloudId)) {
                    return true;
                }
                String entityType = rs.getString("FBASEDATAID");
                boolean isTpl = rs.getBoolean("FISTPL");
                if (!StringUtils.isNotBlank((CharSequence)entityType)) continue;
                if (isTpl) {
                    templates.add(entityType);
                    continue;
                }
                if (!entityType.equals(entity)) continue;
                return true;
            }
            return false;
        });
        return disAble != false || BaseDataAutoUpgradeService.isInheritTplEntity(templates, entity);
    }

    private static boolean businessCheck(String entity) {
        List<IBaseDataModelExtService> services = BaseDataBusinessServiceUtils.getModelSupportExtService(entity);
        if (!CollectionUtils.isEmpty(services)) {
            for (IBaseDataModelExtService ext : services) {
                if (ext.isSupportNewModel(entity)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInheritTplEntity(Set<String> templates, String entity) {
        if (CollectionUtils.isEmpty(templates)) {
            return false;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid from t_meta_entitydesign where", new Object[0]).appendIn("fnumber", templates.toArray());
        List tplIds = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, rs -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
            return result;
        });
        if (tplIds.isEmpty()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(" or ");
        tplIds.forEach(v -> joiner.add("a.FINHERITPATH like '%" + v + "%'"));
        builder = new SqlBuilder();
        builder.append("select top 1 a.fnumber from t_meta_entitydesign a  left join t_meta_bizapp  app on a.Fbizappid =app.fid ", new Object[0]).append(" where  a.fistemplate = '0'  and app.FDEPLOYSTATUS ='2' and a.fnumber = ?", new Object[]{entity}).append(" AND (", new Object[0]).append(joiner.toString(), new Object[0]).append(")", new Object[0]);
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)builder, ResultSet::next);
    }

    private static boolean isInWhiteList(String entity) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return false;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("SELECT FBASEDATAID FROM T_BD_NEWMODEL_WHITELIST WHERE FBASEDATAID = ?", new Object[]{entity});
        return (Boolean)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, ResultSet::next);
    }

    public boolean generateIndexAndFillBit(String entity) {
        if (!this.autoUpgradeModel(entity)) {
            this.updateCheckStatus(entity);
            return false;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        String tableName = dt.getAlias();
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        this.execute(entity, route, tableName, true, false);
        this.updateUpgradeStatus(entity);
        return true;
    }

    private boolean autoUpgradeModel(String entity) {
        return StringUtils.isNotBlank((CharSequence)entity) && !BaseDataAutoUpgradeService.isInBlackList(entity) && BaseDataAutoUpgradeService.isInWhiteList(entity) && BaseDataAutoUpgradeService.businessCheck(entity);
    }

    public void generateIndexAndFillBitData(String entity) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        this.execute(entity, DBRoute.of((String)dt.getDBRouteKey()), dt.getAlias(), true, false);
    }

    private void execute(String entity, DBRoute route, String tableName, boolean dependencyMetadata, boolean isTreeType) {
        DLock lock = DLock.create((String)String.format("bd_auto_upgrade_%s_%s", RequestContext.get().getAccountId(), entity));
        lock.lock();
        try {
            this.checkAndAddField(route, tableName);
            Map<Long, List<Long>> unUpgradeData = this.selectUnUpgradeData(route, tableName);
            if (!unUpgradeData.isEmpty()) {
                ArrayList<Long> dataIds = new ArrayList<Long>(unUpgradeData.size());
                unUpgradeData.values().forEach(dataIds::addAll);
                Map<Long, Integer> idIndexMap = this.generateIndex(dataIds, route, tableName, entity);
                if (dependencyMetadata) {
                    new BaseDataMaintenanceService(entity).correctOrgUseData(unUpgradeData.keySet());
                } else {
                    new BaseDataMaintenanceService().correctOrgUseData(idIndexMap, entity, route, tableName, isTreeType);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4f4d\u56fe\u4e0d\u5168\u5931\u8d25...", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("500", "correct org's use rang bit data fail..."), new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    void updateCheckStatus(String entity) {
        try (TXHandle h = TX.requiresNew((String)"bd_update_check_status");){
            DB.execute((DBRoute)DBRoute.base, (String)"update T_BD_DefaultCtrlStrategy set fcheckstatus = '1', fmodifytime = ? where FBaseDataID = ?;", (Object[])new Object[]{new Date(), entity});
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_bddefctrlstrtgy");
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
            cacheManager.removeByDt();
        }
    }

    private void createBitMapTable(String tableName, DBRoute route) {
        if (DB.exitsTable((DBRoute)route, (String)(tableName = (tableName + "_bit").toUpperCase()))) {
            return;
        }
        String pkName = this.getIndexName(tableName, "PK_", "");
        String createTableSqlFormat = "CREATE TABLE %s (  FORGID BIGINT NOT NULL, FDATA BLOB NOT NULL, CONSTRAINT " + pkName + " PRIMARY KEY (FORGID))";
        String createBitTableSql = String.format(createTableSqlFormat, tableName, tableName);
        DB.execute((DBRoute)route, (String)createBitTableSql);
    }

    private void checkAndAddField(DBRoute route, String tableName) {
        tableName = tableName.toUpperCase();
        try (TXHandle tx = TX.requiresNew();){
            try {
                try {
                    String addSrcIdSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='FSOURCEDATAID')  ALTER TABLE %s ADD (FSOURCEDATAID BIGINT DEFAULT 0 NOT NULL );", tableName, tableName);
                    DB.execute((DBRoute)route, (String)addSrcIdSql);
                    String indexSrcIdName = this.getIndexName(tableName, "IDX_", "SRCID");
                    String sourceIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( FSOURCEDATAID )";
                    DB.execute((DBRoute)route, (String)String.format(sourceIndexSql, indexSrcIdName, indexSrcIdName, tableName));
                }
                catch (Exception e) {
                    LOGGER.error("\u6dfb\u52a0\u65b0\u6a21\u578b\u5b57\u6bb5FSOURCEDATAID\u5931\u8d25", (Throwable)e);
                }
                try {
                    String addBitIndexSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='FBITINDEX')  ALTER TABLE %s ADD (FBITINDEX INT DEFAULT 0 NOT NULL );", tableName, tableName);
                    DB.execute((DBRoute)route, (String)addBitIndexSql);
                    String indexBitName = this.getIndexName(tableName, "IDX_", "BIT");
                    String bitIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s ( FBITINDEX)";
                    DB.execute((DBRoute)route, (String)String.format(bitIndexSql, indexBitName, indexBitName, tableName));
                }
                catch (Exception e) {
                    LOGGER.error("\u6dfb\u52a0\u65b0\u6a21\u578b\u5b57\u6bb5FBITINDEX\u5931\u8d25", (Throwable)e);
                }
                try {
                    String addSrcBitIndexSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='FSOURCEBITINDEX')  ALTER TABLE %s ADD (FSOURCEBITINDEX INT DEFAULT 0 NOT NULL );", tableName, tableName);
                    DB.execute((DBRoute)route, (String)addSrcBitIndexSql);
                }
                catch (Exception e) {
                    LOGGER.error("\u6dfb\u52a0\u65b0\u6a21\u578b\u5b57\u6bb5FSOURCEBITINDEX\u5931\u8d25", (Throwable)e);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                LOGGER.error("\u6dfb\u52a0\u5b57\u6bb5\u5931\u8d25.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Integer> generateIndex(List<Long> dataIds, DBRoute route, String tableName, String entity) {
        String lockKey = this.getGenIndexLockKey(entity);
        DLock lock = DLock.create((String)lockKey);
        lock.lock();
        HashMap<Long, Integer> idIndexMap = new HashMap<Long, Integer>(dataIds.size());
        try {
            boolean bitIndexHasChange = false;
            int bitIndex = this.getMaxBitIndex(entity, dataIds.size(), route, tableName);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(dataIds.size());
            for (Long dataId : dataIds) {
                paramList.add(new Object[]{++bitIndex, bitIndex, dataId, dataId});
                bitIndexHasChange = true;
                idIndexMap.put(dataId, bitIndex);
            }
            String update = "update " + tableName + " set fbitindex = ?, fsourcebitindex = ?, fsourcedataid = ? where fid = ?;";
            try (TXHandle tx = TX.requiresNew((String)String.format("bd_generate_index_%s", entity));){
                try {
                    DB.executeBatch((DBRoute)route, (String)update, paramList);
                    if (bitIndexHasChange) {
                        this.updateBaseDataBitIndexCache(entity, String.valueOf(bitIndex));
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    String errorInfo = ResManager.loadKDString((String)"\u5347\u7ea7\u65f6\u751f\u6210index\u4fe1\u606f\u5f02\u5e38\uff0c\u5b9e\u4f53\u4e3a\uff1a%1$s", (String)"BaseDataAutoUpgradeService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                    String msg = String.format(errorInfo, entity);
                    LOGGER.error(msg, (Throwable)e);
                    throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return idIndexMap;
    }

    private Map<Long, List<Long>> selectUnUpgradeData(DBRoute route, String tableName) {
        return (Map)DB.query((DBRoute)route, (String)("select fid,fcreateorgid from " + tableName + " where fbitindex = 0 or fbitindex is null;"), rs -> {
            HashMap<Long, List> result = new HashMap<Long, List>(16);
            while (rs.next()) {
                long id = rs.getLong("fid");
                long orgId = rs.getLong("fcreateorgid");
                result.computeIfAbsent(orgId, k -> new ArrayList(10)).add(id);
            }
            return result;
        });
    }

    private void updateUpgradeStatus(String entity) {
        String updateStatusSql = "update T_BD_DefaultCtrlStrategy set fupgradestatus = '2', fcheckstatus = '1', fmodifytime = ? where FBaseDataID = ?;";
        try (TXHandle h = TX.requiresNew((String)"bd_update_check_upgrade_status");){
            DB.execute((DBRoute)DBRoute.base, (String)updateStatusSql, (Object[])new Object[]{new Date(), entity});
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_bddefctrlstrtgy");
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    public UpgradeResult presetCtrlOrgUseRangData(String dbKey, String entity, String tableName, Map<Long, Long> dataOrgMap, boolean isTreeType) {
        if (StringUtils.isBlank((CharSequence)entity) || StringUtils.isBlank((CharSequence)tableName)) {
            return this.result(false, "error", ResManager.loadKDString((String)"\u5b9e\u4f53\u6807\u8bc6\u6216\u8005\u53d7\u63a7\u57fa\u7840\u8d44\u6599\u8868\u540d\u4e3a\u7a7a\u3002", (String)"BaseDataAutoUpgradeService_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        if (!this.isNewModel(entity)) {
            try {
                this.presetOrgUseRangData(entity, tableName, dbKey, dataOrgMap);
                return this.result(true, "info", null);
            }
            catch (Exception e) {
                String errorInfo = ResManager.loadKDString((String)"\u7cfb\u7edf\u5347\u7ea7\u9884\u7f6e\u4f7f\u7528\u8303\u56f4\u8868\u6570\u636e\u5931\u8d25\uff1a%1$s", (String)"BaseDataAutoUpgradeService_3", (String)"bos-bd-business", (Object[])new Object[0]);
                LOGGER.error(errorInfo, (Throwable)e);
                return this.result(false, "error", String.format(errorInfo, e.getMessage()));
            }
        }
        try {
            this.createBitMapTable(tableName, new DBRoute(dbKey));
            this.execute(entity, new DBRoute(dbKey), tableName, false, isTreeType);
            return this.result(true, "info", null);
        }
        catch (Exception e) {
            String errorInfo = ResManager.loadKDString((String)"\u7cfb\u7edf\u5347\u7ea7\u81ea\u52a8\u751f\u6210\u4f4d\u56fe\u5b57\u6bb5\u6570\u636e\u5931\u8d25\uff1a%1$s", (String)"BaseDataAutoUpgradeService_2", (String)"bos-bd-business", (Object[])new Object[0]);
            LOGGER.error(errorInfo, (Throwable)e);
            return this.result(false, "error", String.format(errorInfo, e.getMessage()));
        }
    }

    private UpgradeResult result(boolean success, String el, String errorInfo) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(success);
        result.setEl(el);
        if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
            result.setErrorInfo(errorInfo);
        }
        return result;
    }

    private boolean isNewModel(String entity) {
        String selectSql = "select top 1 fid from T_BD_DefaultCtrlStrategy where fbasedataid = ? and fupgradestatus = '2';";
        Object[] params = new Object[]{entity};
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)selectSql, (Object[])params, ResultSet::next);
    }

    private void presetOrgUseRangData(String entity, String tableName, String dbKey, Map<Long, Long> dataOrgMap) {
        DBRoute route = DBRoute.of((String)dbKey);
        String useRelTable = (tableName + "_U").toUpperCase();
        this.createUseRelTableAndIndex(route, useRelTable);
        if (CollectionUtils.isEmpty(dataOrgMap)) {
            return;
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(dataOrgMap.keySet());
        SqlBuilder builder = new SqlBuilder();
        builder.append(" select fdataid, fuseorgid from ", new Object[0]).append(useRelTable, new Object[0]).append("where", new Object[0]);
        builder.appendIn("fuseorgid", dataOrgMap.values().toArray()).append("  and ", new Object[0]);
        builder.appendIn("fdataid", dataOrgMap.keySet().toArray());
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)route, (SqlBuilder)builder);){
            for (Row row : ds) {
                Long dataId = row.getLong("fdataid");
                Long presetOrgId = dataOrgMap.get(dataId);
                if (null == presetOrgId || !presetOrgId.equals(row.getLong("fuseorgid"))) continue;
                dataOrgMap.remove(dataId);
                if (!dataOrgMap.isEmpty()) continue;
                break;
            }
        }
        if (!CollectionUtils.isEmpty(dataOrgMap)) {
            String insertSql = " insert into " + useRelTable + "(FUseOrgID, FDataID) values(?, ?)";
            ArrayList params = new ArrayList(dataOrgMap.size());
            dataOrgMap.forEach((k, v) -> params.add(new Object[]{v, k}));
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
        }
        try {
            this.fillCuShareRang(entity, tableName, useRelTable, dbKey, dataIds);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u8865\u5145\u4e0b\u7ea7\u7ba1\u63a7\u8303\u56f4\u5171\u4eab\u7ec4\u7ec7\u6570\u636e\u8303\u56f4\u5931\u8d25\uff0c\u8868\u3010%s\u3011\uff0c\u5b9e\u4f53\u3010%s\u3011\u3002", tableName, entity), (Throwable)e);
        }
    }

    private void fillCuShareRang(String entity, String tableName, String useRelTable, String dbKey, List<Long> dataIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 fctrlview from t_bd_defaultctrlstrategy where", new Object[0]).append("fbasedataid = ?", new Object[]{entity});
        Long viewId = 0L;
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)builder);){
            if (ds.hasNext()) {
                viewId = ds.next().getLong("fctrlview");
            }
        }
        if (0L == viewId) {
            return;
        }
        builder = new SqlBuilder();
        builder.append("select fid, fcreateorgid from ", new Object[0]).append(tableName, new Object[0]).append("where fctrlstrategy = '6' and", new Object[0]).appendIn("fid", dataIds.toArray());
        HashMap cuShareDataMap = new HashMap(16);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)builder);){
            ds.forEach(row -> cuShareDataMap.put(row.getLong("fid"), row.getLong("fcreateorgid")));
        }
        if (cuShareDataMap.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> subOrgMap = this.getSubOrgMap(cuShareDataMap.values(), viewId);
        if (subOrgMap.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> existMap = this.existRangData(subOrgMap, useRelTable, dbKey, cuShareDataMap.keySet());
        String insertSql = " insert into " + useRelTable + "(FUseOrgID, FDataID) values(?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (Map.Entry entry : cuShareDataMap.entrySet()) {
            List<Long> subOrgIds = subOrgMap.get(entry.getValue());
            if (CollectionUtils.isEmpty(subOrgIds)) continue;
            Long dataId = (Long)entry.getKey();
            Set existOrgIds = existMap.getOrDefault(dataId, Collections.emptySet());
            for (Long subOrgId : subOrgIds) {
                if (existOrgIds.contains(subOrgId)) continue;
                params.add(new Object[]{subOrgId, dataId});
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)insertSql, params);
                params = new ArrayList(10);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)insertSql, params);
        }
    }

    private Map<Long, Set<Long>> existRangData(Map<Long, List<Long>> subOrgMap, String useRelTable, String dbKey, Collection<Long> dataIds) {
        ArrayList subOrgIds = new ArrayList(10);
        subOrgMap.values().forEach(subOrgIds::addAll);
        HashMap<Long, Set<Long>> existMap = new HashMap<Long, Set<Long>>(16);
        SqlBuilder builder = new SqlBuilder();
        builder.append(" select fdataid, fuseorgid from ", new Object[0]).append(useRelTable, new Object[0]).append("where", new Object[0]);
        builder.appendIn("fuseorgid", subOrgIds.toArray()).append("  and ", new Object[0]);
        builder.appendIn("fdataid", dataIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)builder);){
            ds.forEach(r -> existMap.computeIfAbsent(r.getLong("fdataid"), k -> new HashSet(16)).add(r.getLong("fuseorgid")));
        }
        return existMap;
    }

    private Map<Long, List<Long>> getSubOrgMap(Collection<Long> orgIds, Long viewId) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid, flongnumber from t_org_structure where ", new Object[0]).append("fisctrlunit = ?", new Object[]{Boolean.TRUE}).append("and fviewid  = ?", new Object[]{viewId});
        HashMap orgLnMap = new HashMap(16);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)builder);){
            ds.forEach(r -> orgLnMap.put(r.getLong("forgid"), r.getString("flongnumber")));
        }
        HashMap<Long, List<Long>> subOrgMap = new HashMap<Long, List<Long>>(16);
        HashMap lnmOrgMap = new HashMap(16);
        orgIds.forEach(e -> lnmOrgMap.put(orgLnMap.get(e), e));
        for (Map.Entry entry : orgLnMap.entrySet()) {
            String lnm = (String)entry.getValue();
            if (StringUtils.isBlank((CharSequence)lnm)) continue;
            for (Map.Entry e2 : lnmOrgMap.entrySet()) {
                String longNum = (String)e2.getKey();
                if (!StringUtils.isNotBlank((CharSequence)longNum) || !lnm.startsWith(longNum + "!")) continue;
                subOrgMap.computeIfAbsent((Long)e2.getValue(), (Function<Long, List<Long>>)((Function<Long, List>)k -> new ArrayList(10))).add(entry.getKey());
            }
        }
        return subOrgMap;
    }

    private void createUseRelTableAndIndex(DBRoute route, String useRelTable) {
        if (DB.exitsTable((DBRoute)route, (String)useRelTable)) {
            return;
        }
        String pkName = this.getIndexName(useRelTable, "PK_", "");
        SqlBuilder builder = new SqlBuilder();
        builder.append("create table ", new Object[0]).append(useRelTable, new Object[0]).append(" (  ", new Object[0]);
        builder.append("FDataID bigint not null,  ", new Object[0]);
        builder.append("FCreateOrgID bigint null,  ", new Object[0]);
        builder.append("FUseOrgID bigint not null,  ", new Object[0]);
        builder.append("constraint ", new Object[0]).append(pkName, new Object[0]).append(" primary key (FDataID, FUseOrgID) ) ", new Object[0]);
        DB.execute((DBRoute)route, (SqlBuilder)builder);
        try {
            String indexName = this.getIndexName(useRelTable, "IDX_", "_UO");
            String indexSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s (FUseOrgID ASC)", indexName, indexName, useRelTable);
            DB.execute((DBRoute)route, (String)indexSql);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u7cfb\u7edf\u5347\u7ea7\u3010%s\u3011\u8868\u5efa\u7acb\u7d22\u5f15\u5931\u8d25\u3002", useRelTable), (Throwable)e);
        }
    }

    private String getIndexName(String tableName, String prefix, String suffix) {
        StringJoiner joiner = new StringJoiner("", prefix, suffix);
        int delimiterSize = joiner.length() + tableName.length() - 30;
        return delimiterSize > 0 ? joiner.add(tableName.substring(delimiterSize)).toString() : joiner.add(tableName).toString();
    }

    public boolean addCtrlTableColumns(String dbKey, String tableName) {
        DBRoute route = DBRoute.of((String)dbKey);
        tableName = tableName.toUpperCase();
        try {
            String addSrcOrgSql = String.format("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='FSRCCREATEORGID')  ALTER TABLE %s ADD (FSRCCREATEORGID BIGINT DEFAULT 0 NOT NULL );", tableName, tableName);
            DB.execute((DBRoute)route, (String)addSrcOrgSql);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5b57\u6bb5FSRCCREATEORGID\u5931\u8d25...", (Throwable)e);
            return false;
        }
    }

    public boolean repairNewPropsValue(String entity) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        String tableName = dt.getAlias();
        String dbKey = dt.getDBRouteKey();
        if (!this.addCtrlTableColumns(dbKey, tableName)) {
            return false;
        }
        DBRoute route = DBRoute.of((String)dbKey);
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        SqlBuilder builder = new SqlBuilder();
        try {
            if (DBType.MySQL == DB.getDBType((DBRoute)route)) {
                builder = new SqlBuilder();
                builder.append("update ", new Object[0]).append(tableName, new Object[0]).append("t ", new Object[0]).append("inner join (", new Object[0]).append("select fcreateorgid, ", new Object[0]).append(masterIdFieldName, new Object[0]).append(" from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).append(masterIdFieldName, new Object[0]).append(" = fid", new Object[0]).append(") as temp on ", new Object[0]).append("t." + masterIdFieldName, new Object[0]).append(" = temp." + masterIdFieldName, new Object[0]).append(" set t.fsrccreateorgid = temp.fcreateorgid where t.fsrccreateorgid = 0 or t.fsrccreateorgid is null", new Object[0]);
                DB.execute((DBRoute)route, (SqlBuilder)builder);
            } else {
                builder.append("update", new Object[0]).append(tableName, new Object[0]).append("set fsrccreateorgid = fcreateorgid where fid =", new Object[0]).append(masterIdFieldName, new Object[0]).append(" and (fsrccreateorgid is null or fsrccreateorgid = 0)", new Object[0]);
                DB.execute((DBRoute)route, (SqlBuilder)builder);
                builder = new SqlBuilder();
                builder.append("update ", new Object[0]).append(tableName, new Object[0]).append("t", new Object[0]).append("set fsrccreateorgid = (", new Object[0]).append("select fcreateorgid from ", new Object[0]).append(tableName, new Object[0]).append("where", new Object[0]).append(masterIdFieldName, new Object[0]).append(" = fid and ", new Object[0]).append(masterIdFieldName, new Object[0]).append(" =", new Object[0]).append("t." + masterIdFieldName, new Object[0]).append(") ", new Object[0]).append("where t.fid != ", new Object[0]).append("t." + masterIdFieldName, new Object[0]).append("and (t.fsrccreateorgid is null or t.fsrccreateorgid = 0)", new Object[0]);
                DB.execute((DBRoute)route, (SqlBuilder)builder);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("\u77eb\u6b63\u539f\u521b\u5efa\u7ec4\u7ec7\u5b57\u6bb5\u5931\u8d25...", (Throwable)e);
            return false;
        }
    }
}

