/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.service.BaseDataAutoUpgradeService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.KryoSerializerUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataBitMapUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataBitMapUpgradeService.class);
    public static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    public static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";
    public static final String CTRLSTRATEGY_OU_ASSIGN = "3";
    public static final String CTRLSTRATEGY_OU_FREE_ASSIGN = "4";
    public static final String CTRLSTRATEGY_GLOBAL_SHARE = "5";
    public static final String CTRLSTRATEGY_CU_SHARE = "6";
    public static final String CTRLSTRATEGY_PRIVATE = "7";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    public static final String BASEDATABITMAPSUFFIX = "_bit";

    public void handleBitMapUpgrade(String entityType) {
        if (!BaseDataAutoUpgradeService.isAbleUpgradeModel(entityType)) {
            LOGGER.error("\u8be5\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u652f\u6301\u65b0\u6a21\u578b.", (Throwable)new KDBizException("this basic data type does not support new models."));
            return;
        }
        BaseDataUseRelUpdateEngine.removeAllRelBitCache(entityType);
        this.generateSourceIDBitIndex(entityType);
        this.createBitMapTable(entityType);
        this.generateBitMapData(entityType);
        this.createIndex(entityType);
        this.updateStatus(entityType);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_bddefctrlstrtgy");
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    private void createBitMapTable(String entity) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        String tableName = dt.getAlias() + BASEDATABITMAPSUFFIX;
        tableName = tableName.toUpperCase();
        String createTableSqlFormat = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s (  FORGID bigint not null, FDATA blob not null, constraint PK_%s primary key (FORGID))";
        String createBitTableSql = String.format(createTableSqlFormat, tableName, tableName, tableName);
        DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)createBitTableSql);
    }

    private void createIndex(String entity) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        String tableName = dt.getAlias();
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        try {
            String bitIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_%sBIT') CREATE INDEX IDX_%sBIT ON %s ( FBITINDEX)";
            DB.execute((DBRoute)route, (String)String.format(bitIndexSql, tableName, tableName, tableName));
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efafbitindex\u7d22\u5f15\u5f02\u5e38.", (Throwable)e);
        }
        try {
            String sourceIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_%sSRCID') CREATE INDEX IDX_%sSRCID ON %s ( FSOURCEDATAID )";
            DB.execute((DBRoute)route, (String)String.format(sourceIndexSql, tableName, tableName, tableName));
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efafsourcedataid\u7d22\u5f15\u5f02\u5e38.", (Throwable)e);
        }
    }

    private void updateStatus(String entityType) {
        String updateStatusSql = " update T_BD_DefaultCtrlStrategy set fupgradestatus = '2' where FBaseDataID = ? ";
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.base, (String)updateStatusSql, (Object[])new Object[]{entityType});
        }
    }

    private void generateSourceIDBitIndex(String entityType) {
        Serializable parentID;
        String masteridFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityType);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        String baseDataTableName = dt.getAlias();
        StringBuilder fixMasterIdSql = new StringBuilder();
        fixMasterIdSql.append(" Update ").append(baseDataTableName);
        fixMasterIdSql.append(" set ").append(masteridFieldName).append(" = fid where ");
        fixMasterIdSql.append(masteridFieldName).append(" = 0; ");
        DBRoute dbRoute = null;
        String dbRouteKey = dt.getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)fixMasterIdSql.toString());
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        if (null == ctrlview) {
            return;
        }
        HashMap<Long, Long> parentOrgMap = new HashMap<Long, Long>(16);
        Long orgViewId = (Long)ctrlview.getPkValue();
        QFilter viewFilter = new QFilter("view.id", "=", (Object)orgViewId);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(BaseDataBitMapUpgradeService.class.getName(), "bos_org_structure", "org.id,parent.id", new QFilter[]{viewFilter});){
            Long orgID = null;
            parentID = null;
            for (Row row : ds) {
                orgID = row.getLong("org.id");
                parentID = row.getLong("parent.id");
                parentOrgMap.put(orgID, (Long)parentID);
            }
        }
        int currentIndex = 0;
        String maxBitIndexSql = " select max(FbitIndex) maxBitIndex from " + baseDataTableName;
        DataSet ds = DB.queryDataSet((String)BaseDataBitMapUpgradeService.class.getName(), (DBRoute)dbRoute, (String)maxBitIndexSql, (Object[])new Object[0]);
        parentID = null;
        try {
            if (ds.hasNext()) {
                Row row = ds.next();
                currentIndex = row.getInteger("maxBitIndex");
            }
        }
        catch (Throwable row) {
            parentID = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (parentID != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)parentID).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<String, Long> sourceIdMap = new HashMap<String, Long>(16);
        HashMap<String, Integer> idBitIndexMap = new HashMap<String, Integer>(16);
        StringBuilder initDataSql = new StringBuilder();
        initDataSql.append(" select fid, ").append(masteridFieldName).append(", fcreateorgid, FbitIndex from ");
        initDataSql.append(baseDataTableName).append(" where FbitIndex <> 0 ");
        try (DataSet ds2 = DB.queryDataSet((String)BaseDataBitMapUpgradeService.class.getName(), (DBRoute)dbRoute, (String)initDataSql.toString(), (Object[])new Object[0]);){
            Long id = null;
            Long masterID = null;
            Long createOrgID = null;
            Integer bitIndex = null;
            for (Row row : ds2) {
                id = row.getLong("fid");
                masterID = row.getLong(masteridFieldName);
                createOrgID = row.getLong("fcreateorgid");
                bitIndex = row.getInteger("FbitIndex");
                sourceIdMap.put(createOrgID + "_" + masterID, id);
                idBitIndexMap.put(id.toString(), bitIndex);
            }
        }
        Long sourceID = null;
        Integer sourceIndex = null;
        String updateSourceIdBitIndex = " update " + baseDataTableName + " set FSourceDataID = ?, FBitIndex = ?, FSourceBitIndex = ? where fid = ? ";
        ArrayList<Object[]> updateSourceIdBitIndexParamList = new ArrayList<Object[]>();
        StringBuilder dataSql = new StringBuilder();
        dataSql.append(" select fid, ").append(masteridFieldName).append(", fcreateorgid, fctrlstrategy from ");
        dataSql.append(baseDataTableName).append(" where FbitIndex = 0 order by fid");
        try (DataSet ds3 = DB.queryDataSet((String)BaseDataBitMapUpgradeService.class.getName(), (DBRoute)dbRoute, (String)dataSql.toString(), (Object[])new Object[0]);){
            Long id = null;
            Long masterID = null;
            Long createOrgID = null;
            String ctrlstrategy = null;
            Long parentOrgID = null;
            Iterator iter = ds3.iterator();
            while (iter.hasNext()) {
                sourceID = null;
                ++currentIndex;
                Row row = (Row)iter.next();
                id = row.getLong("fid");
                masterID = row.getLong(masteridFieldName);
                createOrgID = row.getLong("fcreateorgid");
                ctrlstrategy = row.getString("fctrlstrategy");
                if (CTRLSTRATEGY_CU_ASSIGN.equals(ctrlstrategy)) {
                    if (id.equals(masterID)) {
                        sourceID = masterID;
                        sourceIdMap.put(createOrgID + "_" + masterID, sourceID);
                        sourceIndex = currentIndex;
                        idBitIndexMap.put(id.toString(), sourceIndex);
                    } else {
                        Long currentOrgID = createOrgID;
                        while (parentOrgMap.get(currentOrgID) != null && (Long)parentOrgMap.get(currentOrgID) != 0L) {
                            parentOrgID = (Long)parentOrgMap.get(currentOrgID);
                            sourceID = (Long)sourceIdMap.get(parentOrgID + "_" + masterID);
                            if (sourceID != null) {
                                sourceIndex = (Integer)idBitIndexMap.get(sourceID.toString());
                                break;
                            }
                            currentOrgID = parentOrgID;
                        }
                        if (sourceID == null) {
                            sourceID = masterID;
                            sourceIndex = (Integer)idBitIndexMap.get(sourceID.toString());
                        }
                        sourceIdMap.put(createOrgID + "_" + masterID, id);
                        idBitIndexMap.put(id.toString(), currentIndex);
                    }
                } else {
                    sourceID = masterID;
                    if (id.equals(masterID)) {
                        sourceIndex = currentIndex;
                        idBitIndexMap.put(id.toString(), sourceIndex);
                    } else {
                        sourceIndex = (Integer)idBitIndexMap.get(masterID.toString());
                    }
                }
                if (sourceID != null) {
                    updateSourceIdBitIndexParamList.add(new Object[]{sourceID, currentIndex, sourceIndex, id});
                } else {
                    --currentIndex;
                }
                if (updateSourceIdBitIndexParamList.size() != 10000) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)updateSourceIdBitIndex, updateSourceIdBitIndexParamList);
                updateSourceIdBitIndexParamList.clear();
            }
            if (updateSourceIdBitIndexParamList.size() > 0) {
                DB.executeBatch((DBRoute)dbRoute, (String)updateSourceIdBitIndex, updateSourceIdBitIndexParamList);
                updateSourceIdBitIndexParamList.clear();
            }
        }
    }

    private void generateBitMapData(String entityType) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        String baseDataTableName = dt.getAlias();
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute route = DBRoute.of((String)dbRouteKey);
        String baseDataBitMapTableName = baseDataTableName + BASEDATABITMAPSUFFIX;
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)route, (String)(" truncate table " + baseDataBitMapTableName));
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityType);
        if (null == ctrlView) {
            return;
        }
        boolean isTreeType = BaseDataCommonService.isTreeType(entityType);
        HashSet<Integer> globalIndexSet = new HashSet<Integer>(16);
        HashSet<Integer> chShareIndexSet = new HashSet<Integer>(16);
        HashMap<Long, Integer> idIndexMap = new HashMap<Long, Integer>(16);
        String idIndexSql = " select fid, fctrlstrategy ,FbitIndex from  " + baseDataTableName;
        try (DataSet ds = DB.queryDataSet((String)BaseDataBitMapUpgradeService.class.getName(), (DBRoute)route, (String)idIndexSql, (Object[])new Object[0]);){
            for (Row row : ds) {
                Integer index = row.getInteger("FbitIndex");
                idIndexMap.put(row.getLong("fid"), index);
                String strategy = row.getString("fctrlstrategy");
                if (CTRLSTRATEGY_GLOBAL_SHARE.equals(strategy)) {
                    globalIndexSet.add(index);
                    continue;
                }
                if (isTreeType || !CTRLSTRATEGY_CU_SHARE.equals(strategy)) continue;
                chShareIndexSet.add(index);
            }
        }
        if (idIndexMap.isEmpty()) {
            return;
        }
        String insertBitMapSql = " insert into " + baseDataBitMapTableName + "(FORGID, FDATA) values(?,?) ";
        Set<Long> unCuOrgIds = this.getUnCuOrgIds(ctrlView.getLong("id"));
        String baseDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
        String orgSql = " select distinct fuseorgid as forgid from " + baseDataUseRangeTableName;
        try (DataSet ds = DB.queryDataSet((String)BaseDataBitMapUpgradeService.class.getName(), (DBRoute)route, (String)orgSql);){
            ArrayList<Object[]> insertBitMapParamList = new ArrayList<Object[]>();
            String useDataSql = " Select fdataid from " + baseDataUseRangeTableName + " where fuseorgid = ? ";
            for (Row row : ds) {
                Long orgId = row.getLong("forgid");
                if (unCuOrgIds.contains(orgId)) continue;
                ArrayList<Integer> indexList = new ArrayList<Integer>(16);
                DataSet useDataDs = DB.queryDataSet((String)BaseDataBitMapUpgradeService.class.getName(), (DBRoute)route, (String)useDataSql, (Object[])new Object[]{orgId});
                Throwable throwable = null;
                try {
                    for (Row useDataRow : useDataDs) {
                        Long id = useDataRow.getLong("fdataid");
                        Integer index = (Integer)idIndexMap.get(id);
                        boolean unNeedToRecord = globalIndexSet.contains(index) || !isTreeType && chShareIndexSet.contains(index);
                        if (unNeedToRecord || index == null || index <= 0) continue;
                        indexList.add(index);
                    }
                    if (indexList.isEmpty()) continue;
                    insertBitMapParamList.add(new Object[]{orgId, this.generateAndSerializerBitmap(indexList)});
                    if (insertBitMapParamList.size() != 10000) continue;
                    DB.executeBatch((DBRoute)route, (String)insertBitMapSql, insertBitMapParamList);
                    insertBitMapParamList.clear();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (useDataDs == null) continue;
                    if (throwable != null) {
                        try {
                            useDataDs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    useDataDs.close();
                }
            }
            if (!insertBitMapParamList.isEmpty()) {
                DB.executeBatch((DBRoute)route, (String)insertBitMapSql, insertBitMapParamList);
                insertBitMapParamList.clear();
            }
        }
        this.generateUnCuOrgBitMapData(unCuOrgIds, route, baseDataTableName, insertBitMapSql, isTreeType);
    }

    private byte[] generateAndSerializerBitmap(Collection<Integer> indexes) {
        int[] bitArray = new int[indexes.size()];
        int i = 0;
        for (Integer idx : indexes) {
            bitArray[i] = idx;
            ++i;
        }
        RoaringBitmap bitmap = RoaringBitmap.bitmapOf((int[])bitArray);
        return KryoSerializerUtils.serRoaringBitmap(bitmap);
    }

    private void generateUnCuOrgBitMapData(Set<Long> unCuOrgIds, DBRoute route, String tableName, String insertBitMapSql, boolean isTreeType) {
        if (CollectionUtils.isEmpty(unCuOrgIds)) {
            return;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("select fcreateorgid, fbitindex from %s where ", tableName), new Object[0]);
        builder.appendIn("fcreateorgid", unCuOrgIds.toArray());
        if (isTreeType) {
            builder.append(" and fctrlstrategy != '5';", new Object[0]);
        } else {
            builder.append(" and fctrlstrategy not in('5', '6');", new Object[0]);
        }
        Map dataMap = (Map)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
            HashMap<Long, Set> result = new HashMap<Long, Set>(16);
            while (rs.next()) {
                int bitIndex = rs.getInt("fbitindex");
                if (0 == bitIndex) continue;
                result.computeIfAbsent(rs.getLong("fcreateorgid"), k -> new HashSet(16)).add(bitIndex);
            }
            return result;
        });
        if (dataMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> insertBitMapParamList = new ArrayList<Object[]>(dataMap.size());
        for (Map.Entry entry : dataMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Set indexes = (Set)entry.getValue();
            insertBitMapParamList.add(new Object[]{orgId, this.generateAndSerializerBitmap(indexes)});
            if (insertBitMapParamList.size() != 10000) continue;
            DB.executeBatch((DBRoute)route, (String)insertBitMapSql, insertBitMapParamList);
            insertBitMapParamList.clear();
        }
        if (!insertBitMapParamList.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insertBitMapSql, insertBitMapParamList);
            insertBitMapParamList.clear();
        }
    }

    private Set<Long> getUnCuOrgIds(Long viewId) {
        ORM orm = ORM.create();
        HashSet<Long> orgIds = new HashSet<Long>(10);
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", (Object)viewId), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE)};
        String selectField = "org.id";
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), "bos_org_structure", selectField, filters);){
            for (Row row : ds) {
                if (row.getLong(selectField) == null) continue;
                orgIds.add(row.getLong(selectField));
            }
        }
        return orgIds;
    }
}

