/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataAutoUpgradeService;
import kd.bos.bd.service.BaseDataDeleteService;
import kd.bos.bd.service.BaseDataDrmService;
import kd.bos.bd.service.BaseDataOrgUseRangService;
import kd.bos.bd.service.BaseDataStrategyService;
import kd.bos.bd.service.internal.BaseDataSupplementService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.roaringbitmap.RoaringBitmap;

@SdkPublic
public class BaseDataCommonService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataCommonService.class);

    public static boolean isNewModel(String entity) {
        FormConfig config = FormMetadataCache.getFormConfig((String)entity);
        if (null == config) {
            return false;
        }
        entity = config.getEntityTypeId();
        String selectFields = "upgradestatus, checkstatus";
        QFilter[] filters = new QFilter[]{new QFilter("basedataid", "=", (Object)entity)};
        DynamicObject strategyConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
        if (null == strategyConfig) {
            new BaseDataSupplementService().addSrcOrgIdColumn(entity);
            return false;
        }
        boolean isNewModel = BaseDataCommonService.judgmentModel(entity, strategyConfig);
        new BaseDataSupplementService().modelSupplement(isNewModel, entity);
        return isNewModel;
    }

    private static boolean judgmentModel(String entity, DynamicObject dynamicObject) {
        try {
            String status = dynamicObject.getString("upgradestatus");
            if ("2".equals(status)) {
                return true;
            }
            if (dynamicObject.getBoolean("checkstatus")) {
                return false;
            }
            BaseDataAutoUpgradeService service = new BaseDataAutoUpgradeService();
            if (!BaseDataCommonService.isNewTenantByFeatureOfCosmic("6.0")) {
                service.updateCheckStatus(entity);
                LOGGER.info("\u5f53\u524d\u79df\u6237\u4e3a\u5386\u53f2\u8001\u5ba2\u6237\uff0c\u66f4\u65b0\u6a21\u578b\u68c0\u67e5\u72b6\u6001.");
                return false;
            }
            LOGGER.info("\u5f53\u524d\u79df\u6237\u4e3a\u65b0\u4e0a\u7ebf\u5ba2\u6237\uff0c\u9996\u6b21\u52a0\u8f7d\u8d44\u6599\uff0c\u6267\u884c\u6a21\u578b\u5347\u7ea7.");
            return service.generateIndexAndFillBit(entity);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5347\u7ea7\u72b6\u6001\u5f02\u5e38\u76f4\u63a5\u629b\u51fa\uff0c\u9632\u6b62\u4e0d\u786e\u5b9a\u662f\u5426\u5df2\u7ecf\u8fdb\u884c\u5347\u7ea7\u800c\u8fdb\u884c\u4e71\u9009\u6a21\u5f0f\u5bfc\u81f4\u6700\u7ec8\u6570\u636e\u95ee\u9898", (Throwable)e);
            return false;
        }
    }

    @SdkInternal
    public static String getRequestContainerAppId() {
        return BaseDataCommonService.getAppId();
    }

    @SdkInternal
    public static boolean isNewTenantByFeatureOfCosmic(String versionNumber) {
        if (StringUtils.isBlank((CharSequence)versionNumber)) {
            return false;
        }
        String selectSql = "SELECT fparam_value FROM T_BAS_DEFAULT_PARAMS WHERE fid = 11536202212195552 AND fparam_key = 'cosmic_initial_version_6';";
        String value = (String)DB.query((DBRoute)DBRoute.base, (String)selectSql, rs -> rs.next() ? rs.getString("fparam_value") : "");
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (versionNumber.equals(value)) {
            return true;
        }
        List<Integer> versionArray = BaseDataCommonService.getVersionArray(versionNumber);
        if (versionArray.isEmpty()) {
            return false;
        }
        List<Integer> cosmicInitVerArr = BaseDataCommonService.getVersionArray(value);
        if (cosmicInitVerArr.isEmpty()) {
            return true;
        }
        int size = cosmicInitVerArr.size() - 1;
        for (int i = 0; i < versionArray.size(); ++i) {
            if (i > size) {
                return true;
            }
            Integer ver = versionArray.get(i);
            Integer cosmicVer = cosmicInitVerArr.get(i);
            if (ver < cosmicVer) {
                return false;
            }
            if (ver <= cosmicVer && i != size) continue;
            return true;
        }
        return false;
    }

    private static List<Integer> getVersionArray(String versionNumber) {
        ArrayList<Integer> result = new ArrayList<Integer>(3);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < versionNumber.length(); ++i) {
            char c = versionNumber.charAt(i);
            if (Character.isDigit(c)) {
                builder.append(c);
                continue;
            }
            if (builder.length() <= 0) continue;
            result.add(Integer.parseInt(builder.toString()));
            builder = new StringBuilder();
        }
        if (builder.length() > 0) {
            result.add(Integer.parseInt(builder.toString()));
        }
        return result;
    }

    @SdkInternal
    public static boolean isSyncData(String entity) {
        try {
            QFilter[] filters = new QFilter[]{new QFilter("basedataid", "=", (Object)entity)};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)"issyncdata", (QFilter[])filters);
            return dynamicObject.getBoolean("issyncdata");
        }
        catch (Exception e) {
            return false;
        }
    }

    @SdkInternal
    public static boolean isTreeType(String entity) {
        return BaseDataCommonService.isTreeTypeBaseData(entity);
    }

    @SdkInternal
    public static boolean isOtherMasterIdType(String entity) {
        return AbstractBaseDataService.isOtherMasterIdType(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public void handleNewCtrlData(DynamicObject[] objs) throws Exception {
        if (null == objs || objs.length == 0) {
            return;
        }
        String entityId = objs[0].getDataEntityType().getName();
        this.setEntity(entityId);
        boolean asyncRecord = this.asyncRecord();
        AbstractBaseDataService.OpDataContext context = new AbstractBaseDataService.OpDataContext();
        HashMap<Long, List<Integer>> shareTypeBdMap = new HashMap<Long, List<Integer>>(16);
        HashMap<Long, List<Integer>> rel = new HashMap<Long, List<Integer>>(objs.length);
        for (DynamicObject data : objs) {
            this.eachCollectRel(asyncRecord, context, shareTypeBdMap, rel, data);
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        Long viewId = (Long)ctrlView.getPkValue();
        this.handleShareTypeBaseData(rel, shareTypeBdMap, viewId);
        BaseDataSolidifyMessageDTO messageDto = this.createAddMessageDto(context, asyncRecord, viewId);
        String lockKey = BaseDataCommonService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.saveOrUpdateRelBit(rel, this.entity);
                if (asyncRecord) {
                    this.publish(messageDto);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u6570\u636e\u65b0\u66fe\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u5173\u7cfb\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataCommonService_3", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @SdkInternal
    public void saveOrUpdateRelBit(Map<Long, List<Integer>> rel, String entityId) throws Exception {
        super.saveOrUpdateRelBit(rel, entityId);
    }

    private void eachCollectRel(boolean asyncRecord, AbstractBaseDataService.OpDataContext context, Map<Long, List<Integer>> shareTypeBdMap, Map<Long, List<Integer>> rel, DynamicObject data) {
        Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject(data, "createorg");
        int bitIndex = data.getInt("bitindex");
        String ctrlStrategy = data.getString("ctrlstrategy");
        boolean needWriteBitRel = this.needWriteBitRel(ctrlStrategy);
        boolean isGlobalData = "5".equals(ctrlStrategy);
        if (!isGlobalData && needWriteBitRel) {
            rel.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
        }
        if (asyncRecord) {
            boolean isFree;
            boolean isAssign = "1".equals(ctrlStrategy) || "3".equals(ctrlStrategy);
            boolean bl = isFree = "2".equals(ctrlStrategy) || "4".equals(ctrlStrategy);
            if (isAssign || isFree || "7".equals(ctrlStrategy)) {
                context.currentOrgIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
            }
        }
        BillEntityType billEntityType = (BillEntityType)data.getDataEntityType();
        String billStatusKey = billEntityType.getBillStatus();
        String status = "";
        if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
            status = data.getString(billStatusKey);
        }
        boolean isCuShareData = "6".equals(ctrlStrategy);
        if (StringUtils.isBlank((CharSequence)billStatusKey) || BillStatus.C.name().equals(status)) {
            if (isCuShareData) {
                if (needWriteBitRel) {
                    shareTypeBdMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
                }
                if (asyncRecord) {
                    context.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
                }
            }
            if (isGlobalData && asyncRecord) {
                context.shareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
            }
        } else if (asyncRecord && (isGlobalData || isCuShareData)) {
            context.currentOrgIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(bitIndex);
        }
    }

    @SdkInternal
    public void handleSubmitNewCtrlData(DynamicObject[] objs) throws Exception {
        this.handleNewCtrlData(objs);
    }

    @SdkInternal
    public void deleteData(DynamicObject[] dataArr, String entity, Long createOrgId) {
        BaseDataDeleteService service = new BaseDataDeleteService(entity);
        service.deleteData(dataArr, createOrgId);
    }

    @SdkInternal
    public void deleteBitFromOrgUseRel(String entityId, Map<Long, List<Integer>> rel) throws Exception {
        BaseDataDeleteService service = new BaseDataDeleteService(entityId);
        service.deleteBitFromOrgUseRel(rel);
    }

    @SdkInternal
    public void changeStrategyOnNewModel(String entity, String newStrategy, List<Long> dataIds) {
        BaseDataStrategyService service = new BaseDataStrategyService(entity);
        service.changeStrategyOnNewModel(newStrategy, dataIds);
    }

    @SdkInternal
    public void changeOrgPermOnNewModel(String entity, DynamicObject newOrg, List<Long> dataIds, Long createOrgId) {
        BaseDataDrmService dataDrmService = new BaseDataDrmService(entity, createOrgId, newOrg);
        dataDrmService.transferDataManagementRight(dataIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public void afterSetCtrlUintHandle(String entity, List<String> orgIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (CollectionUtils.isEmpty(orgIds) || null == ctrlView) {
            return;
        }
        ArrayList selectOrgIds = new ArrayList(orgIds.size());
        orgIds.forEach(orgId -> selectOrgIds.add(Long.valueOf(orgId)));
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", ctrlView.getPkValue()), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE), new QFilter("org.id", "in", selectOrgIds)};
        ArrayList<Long> unCuOrgIds = new ArrayList<Long>(orgIds.size());
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(BaseDataCommonService.class.getName(), "bos_org_structure", "org.id", filters);){
            for (Row row : ds) {
                unCuOrgIds.add(row.getLong("org.id"));
            }
        }
        if (CollectionUtils.isEmpty(unCuOrgIds)) {
            return;
        }
        String lockKey = BaseDataCommonService.getBaseDataUnifiedLockKey(entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(unCuOrgIds, entity);
            HashSet<Integer> indexes = new HashSet<Integer>(16);
            for (BaseDataUseRelBit useRelBit : useRelBitMap.values()) {
                RoaringBitmap bit = useRelBit.getBit();
                indexes.addAll(Arrays.stream(bit.toArray()).boxed().collect(Collectors.toSet()));
            }
            if (CollectionUtils.isEmpty(indexes)) {
                return;
            }
            QFilter[] baseDataFilters = new QFilter[]{new QFilter("bitindex", "in", indexes), new QFilter("ctrlstrategy", "=", (Object)"6")};
            DataSet ds = orm.queryDataSet(BaseDataCommonService.class.getName(), entity, "bitindex", baseDataFilters);
            Object object = null;
            try {
                for (Row row : ds) {
                    indexes.remove(row.getInteger("bitindex"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (CollectionUtils.isEmpty(indexes)) {
                return;
            }
            RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexes));
            deleteBit.runOptimize();
            for (BaseDataUseRelBit useRelBit : useRelBitMap.values()) {
                RoaringBitmap bit = useRelBit.getBit();
                bit.andNot(deleteBit);
            }
            BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), entity);
        }
        catch (Exception e) {
            LOGGER.error("\u8bbe\u7f6e\u975eCU\u7ec4\u7ec7\u4e3aCU\u7ec4\u7ec7\u540c\u6b65\u53d8\u66f4\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @SdkInternal
    public QFilter getBaseDataProFilter(String entity, Long orgId, String property) {
        return new BaseDataOrgUseRangService(entity).getBaseDataProFilter(orgId, property);
    }

    @SdkInternal
    public QFilter getBaseDataFilter(String entityId, Long orgId) {
        return new BaseDataOrgUseRangService(entityId).getBaseDataFilter(orgId);
    }

    @SdkInternal
    public QFilter getBaseDataFilter(String entityId, List<Long> orgIds, boolean isRemoveDup) {
        return new BaseDataOrgUseRangService(entityId).getBaseDataFilter(orgIds, isRemoveDup);
    }

    @SdkInternal
    public QFilter getBaseDataFuzzQueryFilter(String entityId, List<QFilter> fastFilters, Set<Long> orgIds) {
        return new BaseDataOrgUseRangService(entityId).getBaseDataFuzzQueryFilter(fastFilters, orgIds);
    }

    @SdkInternal
    public Map<Long, Long> getChild2ParentOrgMap(Collection<Long> orgIds, Long topOrgId, String entity) {
        ArrayList<Long> allOrgIds = new ArrayList<Long>(orgIds);
        allOrgIds.add(topOrgId);
        Set<String> allLongNumSet = this.getAllLongNumberSet(allOrgIds, topOrgId, entity);
        HashMap<Long, Long> result = new HashMap<Long, Long>(orgIds.size());
        QFilter[] longNumFilters = this.buildQueryFilters(new QFilter("longnumber", "in", allLongNumSet), entity);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org_structure", "org.id, parent.id, longnumber", longNumFilters, "longnumber");){
            for (Row row : ds) {
                boolean needExcludeData;
                Long orgId = row.getLong("org.id");
                Long pid = row.getLong("parent.id");
                String longNumber = row.getString("longnumber");
                boolean isInvalidData = null == pid || null == orgId || null == longNumber;
                boolean bl = needExcludeData = !topOrgId.equals(pid) && !allLongNumSet.contains(longNumber);
                if (isInvalidData || needExcludeData) continue;
                result.put(orgId, pid);
            }
        }
        return result;
    }

    private QFilter[] buildQueryFilters(QFilter customFilter, String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        QFilter viewFilter = new QFilter("view.id", "=", (Object)viewId);
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter unitFilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        return new QFilter[]{viewFilter, enableFilter, unitFilter, freezeFilter, customFilter};
    }

    Map<Long, Set<Long>> getParen2ChildOrgMap(Long topOrgId, List<Long> orgIds, String entity) {
        HashSet<Long> allOrgIds = new HashSet<Long>(orgIds);
        allOrgIds.add(topOrgId);
        Set<String> allLongNumSet = this.getAllLongNumberSet(allOrgIds, topOrgId, entity);
        HashMap<Long, Set<Long>> assignOrgMap = new HashMap<Long, Set<Long>>(16);
        QFilter[] longNumFilters = this.buildQueryFilters(new QFilter("longnumber", "in", allLongNumSet), entity);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org_structure", "org.id, parent.id, longnumber", longNumFilters, "longnumber");){
            for (Row row : ds) {
                Long pid = row.getLong("parent.id");
                Long orgId = row.getLong("org.id");
                String longNumber = row.getString("longnumber");
                if (null == pid || null == orgId || null == longNumber || !pid.equals(topOrgId) && !allLongNumSet.contains(longNumber)) continue;
                assignOrgMap.computeIfAbsent(pid, k -> new HashSet(1)).add(orgId);
            }
        }
        return assignOrgMap;
    }

    private Set<String> getAllLongNumberSet(Collection<Long> orgIds, Long topOrgId, String entity) {
        String sep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        String assignOrgLongNum = " ";
        HashSet<String> longNumSet = new HashSet<String>(orgIds.size());
        QFilter[] filters = this.buildQueryFilters(new QFilter("org.id", "in", orgIds), entity);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org_structure", "org.id, longnumber", filters);){
            for (Row row : ds) {
                Long orgId = row.getLong("org.id");
                String longNum = row.getString("longnumber");
                if (topOrgId.equals(orgId)) {
                    assignOrgLongNum = longNum;
                    continue;
                }
                longNumSet.add(longNum);
            }
        }
        String childOrgLongNumPrefix = assignOrgLongNum + sep;
        HashSet<String> result = new HashSet<String>(16);
        for (String longNumber : longNumSet) {
            if (!longNumber.startsWith(childOrgLongNumPrefix)) {
                LOGGER.info(longNumber + " is not assignOrg's children org...");
                continue;
            }
            result.add(longNumber);
            while ((longNumber = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)longNumber, (String)sep)).startsWith(assignOrgLongNum) && !assignOrgLongNum.equals(longNumber)) {
                result.add(longNumber);
            }
        }
        return result;
    }

    @SdkInternal
    public DynamicObjectCollection queryBaseData(String entity, Long orgId, QFilter filter, String selectFields) {
        return new BaseDataOrgUseRangService(entity).queryBaseData(orgId, filter, selectFields, null, false);
    }

    @SdkInternal
    public DynamicObjectCollection queryBaseDataByDate(String entity, Long orgId, QFilter filter, String selectFields, Date queryDate) {
        return new BaseDataOrgUseRangService(entity).queryBaseData(orgId, filter, selectFields, queryDate, true);
    }

    @SdkInternal
    public Map<Object, DynamicObject> queryBaseDataFromCache(String entity, Long orgId, QFilter filter, String selectFields) {
        return new BaseDataOrgUseRangService(entity).queryBaseDataFromCache(orgId, filter, selectFields);
    }

    @SdkInternal
    public Long getSupCtrlUnitIfIsUnCtrlUint(String entityId, Long orgId) {
        return new BaseDataOrgUseRangService(entityId).getSupCtrlUnitIfIsUnCtrlUint(orgId);
    }

    @SdkInternal
    public List<Long> getSupCtrlUnitIfIsUnCtrlUint(String entityID, List<Long> orgIds) {
        return new BaseDataOrgUseRangService(entityID).getSupCtrlUnitIfIsUnCtrlUint(orgIds);
    }

    @SdkInternal
    public static boolean checkIsMaterialInfo(DynamicObject data) {
        BasedataEntityType basedataEntityType;
        boolean isMaterialInfo = false;
        IDataEntityType dataEntityType = data.getDataEntityType();
        if (dataEntityType instanceof BasedataEntityType && 2 == (basedataEntityType = (BasedataEntityType)dataEntityType).getMasteridType()) {
            isMaterialInfo = true;
        }
        return isMaterialInfo;
    }

    @SdkInternal
    public static String getLongNumberDLM(String entity) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        if (null == dt) {
            return ".";
        }
        for (IDataEntityProperty property : dt.getProperties()) {
            if (!(property instanceof ParentBasedataProp)) continue;
            return ((ParentBasedataProp)property).getLongNumberDLM();
        }
        return ".";
    }

    @SdkInternal
    public static List<Long> getCtrlViewCuOrgs(String entityID) {
        DynamicObject ctrlViewObj = BaseDataServiceHelper.getCtrlview((String)entityID);
        if (ObjectUtils.isEmpty((Object)ctrlViewObj)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u89c6\u56fe\u4e3a\u7a7a\u3002", (String)"BaseDataCommonService_4", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", ctrlViewObj.getPkValue()), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        ArrayList<Long> cuOrgIds = new ArrayList<Long>(16);
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(BaseDataCommonService.class.getName(), "bos_org_structure", "org.id", filters);){
            for (Row row : ds) {
                Long orgId = row.getLong("org.id");
                if (orgId == null) continue;
                cuOrgIds.add(orgId);
            }
        }
        return cuOrgIds;
    }

    @SdkInternal
    public static boolean isPropertyExists(DynamicObject dynamicObject, String property) {
        IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
        DataEntityPropertyCollection dataEntityPropertyCol = dataEntityType.getProperties();
        List properties = dataEntityPropertyCol.stream().map(IMetadata::getName).collect(Collectors.toList());
        return properties.contains(property);
    }
}

