/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.roaringbitmap.RoaringBitmap;

class BaseDataDeleteService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataDeleteService.class);
    private Set<Integer> allOrgNeedDelIndexes;
    private Set<Integer> allOrgNeedAddIndexes;
    private Set<Integer> currOrgNeedDelIndexes;
    private Set<Integer> currOrgNeedAddIndexes;

    BaseDataDeleteService(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        super.init(entity);
    }

    void deleteBitFromOrgUseRel(Map<Long, List<Integer>> rel) {
        boolean asyncRecord = this.asyncRecord();
        BaseDataSolidifyMessageDTO messageDto = null;
        if (asyncRecord) {
            messageDto = new BaseDataSolidifyMessageDTO(rel.size());
            for (Map.Entry<Long, List<Integer>> entry : rel.entrySet()) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, entry.getKey());
                message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr((Collection<Integer>)entry.getValue()))));
                messageDto.add(message);
            }
        }
        String lockKey = BaseDataDeleteService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.required((String)"delete_base_data");
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(rel.keySet(), this.entity);
            for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
                RoaringBitmap bit;
                BaseDataUseRelBit useRelBit = entry.getValue();
                if (null == useRelBit || null == (bit = useRelBit.getBit())) continue;
                List<Integer> bitIndexes = rel.get(entry.getKey());
                int[] indexArr = this.covertIntegerList2IntArr(bitIndexes);
                RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])indexArr);
                deleteBit.runOptimize();
                bit.andNot(deleteBit);
                bit.runOptimize();
            }
            BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), this.entity);
            if (asyncRecord) {
                this.publish(messageDto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u5220\u9664\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataDeleteService_0", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    void deleteData(DynamicObject[] dataArr, Long createOrgId) {
        if (null == dataArr || dataArr.length == 0) {
            return;
        }
        boolean asyncRecord = this.asyncRecord();
        DeleteOpDataContext context = this.prepareDeleteDataInfo(dataArr, createOrgId, asyncRecord);
        if (context.onlyGlobalShareData) {
            this.recordSolidifyOnTx(context, asyncRecord);
            return;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long viewId = (Long)ctrlView.getPkValue();
        HashSet<Long> allOrgIds = new HashSet<Long>(Collections.singleton(createOrgId));
        if (!this.allOrgNeedDelIndexes.isEmpty()) {
            allOrgIds.addAll(this.getAllCuSubordinateOrgIds(viewId, createOrgId));
        }
        int[] allOrgDelBitArr = this.covertIntegerList2IntArr(this.allOrgNeedDelIndexes);
        int[] allOrgAddBitArr = this.covertIntegerList2IntArr(this.allOrgNeedAddIndexes);
        int[] currOrgDelBitArr = this.covertIntegerList2IntArr(this.currOrgNeedDelIndexes);
        int[] currOrgAddBitArr = this.covertIntegerList2IntArr(this.currOrgNeedAddIndexes);
        BaseDataSolidifyMessageDTO messageDto = null;
        if (asyncRecord) {
            messageDto = this.createSolidifyMessageDTO(context);
        }
        String lockKey = BaseDataDeleteService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.required((String)"delete_base_data");
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(allOrgIds, this.entity);
            RoaringBitmap allOrgDelBit = RoaringBitmap.bitmapOf((int[])allOrgDelBitArr);
            allOrgDelBit.runOptimize();
            for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
                RoaringBitmap bit = entry.getValue().getBit();
                if (null == bit) continue;
                if (createOrgId.equals(entry.getKey())) {
                    RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])allOrgDelBitArr);
                    delBit.add(currOrgDelBitArr);
                    delBit.runOptimize();
                    bit.andNot(delBit);
                    bit.add(currOrgAddBitArr);
                    bit.add(allOrgAddBitArr);
                } else {
                    bit.andNot(allOrgDelBit);
                    bit.add(allOrgAddBitArr);
                }
                bit.runOptimize();
            }
            BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), this.entity);
            if (asyncRecord) {
                this.publish(messageDto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u5220\u9664\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataDeleteService_0", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    private void recordSolidifyOnTx(DeleteOpDataContext context, boolean asyncRecord) {
        try (TXHandle tx = TX.required((String)"delete_base_data");){
            try {
                if (asyncRecord) {
                    BaseDataSolidifyMessageDTO messageDto = this.createSolidifyMessageDTO(context);
                    this.publish(messageDto);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5220\u9664\u6570\u636e\u5f02\u5e38", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"BaseDataDeleteService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private BaseDataSolidifyMessageDTO createSolidifyMessageDTO(DeleteOpDataContext context) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long viewId = (Long)ctrlView.getPkValue();
        Map<Long, RoaringBitmap> delUseOrgBitmap = context.buildDelUseOrgBitmap(viewId);
        Map<Long, RoaringBitmap> addUseOrgBitmap = context.buildAddUseOrgBitmap(viewId);
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(delUseOrgBitmap.size());
        if (!delUseOrgBitmap.isEmpty()) {
            for (Map.Entry<Long, RoaringBitmap> entry : delUseOrgBitmap.entrySet()) {
                Long orgId = entry.getKey();
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                message.add(this.createDelSolidifyMessage(entry.getValue()));
                RoaringBitmap bit = addUseOrgBitmap.remove(orgId);
                if (null != bit) {
                    message.add(this.createAddSolidifyMessage(bit));
                }
                messageDto.add(message);
            }
        }
        if (!addUseOrgBitmap.isEmpty()) {
            for (Map.Entry<Long, RoaringBitmap> entry : addUseOrgBitmap.entrySet()) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, entry.getKey());
                message.add(this.createAddSolidifyMessage(entry.getValue()));
                messageDto.add(message);
            }
        }
        return messageDto;
    }

    private DeleteOpDataContext prepareDeleteDataInfo(DynamicObject[] dataArr, Long createOrgId, boolean asyncRecord) {
        this.allOrgNeedDelIndexes = new HashSet<Integer>(16);
        this.allOrgNeedAddIndexes = new HashSet<Integer>(16);
        this.currOrgNeedDelIndexes = new HashSet<Integer>(16);
        this.currOrgNeedAddIndexes = new HashSet<Integer>(16);
        DeleteOpDataContext context = new DeleteOpDataContext();
        boolean noneCustomEntity = BaseDataServiceHelper.isNoneCustomEntity((String)this.entity);
        Set<Long> existsVersionData = this.existsVersionData(dataArr, createOrgId, context);
        for (DynamicObject data : dataArr) {
            boolean needRestore;
            String ctrlStrategy = data.getString("ctrlstrategy");
            Integer index = data.getInt("bitindex");
            if ("5".equals(ctrlStrategy)) {
                if (!asyncRecord) continue;
                context.shareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                continue;
            }
            context.onlyGlobalShareData = false;
            Long dataId = (Long)data.getPkValue();
            Long masterId = this.getLongDataFromDynamicObject(data.get(this.masterIdPropName));
            Integer customDataSrcBitIndex = data.getInt("srcindex");
            boolean isRawData = noneCustomEntity || dataId.equals(masterId);
            boolean isCuShareData = "6".equals(ctrlStrategy);
            if (!this.needWriteBitRel(ctrlStrategy)) {
                if (asyncRecord) {
                    context.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                }
                if (isRawData) continue;
                this.currOrgNeedDelIndexes.add(index);
                if (context.isEnableVersion() && existsVersionData.contains(masterId)) continue;
                this.currOrgNeedAddIndexes.add(customDataSrcBitIndex);
                if (!asyncRecord) continue;
                context.currOrgAddIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(customDataSrcBitIndex);
                continue;
            }
            if (isCuShareData) {
                this.allOrgNeedDelIndexes.add(index);
                if (asyncRecord) {
                    context.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                }
                boolean bl = needRestore = !isRawData && (!context.isEnableVersion() || !existsVersionData.contains(masterId));
                if (!needRestore) continue;
                this.allOrgNeedAddIndexes.add(customDataSrcBitIndex);
                if (!asyncRecord) continue;
                context.cuShareAddIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(customDataSrcBitIndex);
                continue;
            }
            this.currOrgNeedDelIndexes.add(index);
            if (asyncRecord) {
                context.currentOrgIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
            }
            boolean bl = needRestore = !isRawData && (!context.isEnableVersion() || !existsVersionData.contains(masterId));
            if (!needRestore) continue;
            this.currOrgNeedAddIndexes.add(customDataSrcBitIndex);
            if (!asyncRecord) continue;
            context.currOrgAddIndexes.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(customDataSrcBitIndex);
        }
        return context;
    }

    private Set<Long> existsVersionData(DynamicObject[] dataArr, Long createOrgId, DeleteOpDataContext context) {
        if (!context.isEnableVersion()) {
            return Collections.emptySet();
        }
        Set masterIds = Arrays.stream(dataArr).mapToLong(data -> data.getLong(this.masterIdPropName)).boxed().collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "=", (Object)createOrgId), new QFilter(this.masterIdPropName, "in", masterIds)};
        HashSet<Long> result = new HashSet<Long>(dataArr.length);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), this.entity, this.masterIdPropName, filters);){
            for (Row row : ds) {
                result.add(row.getLong(this.masterIdPropName));
            }
        }
        return result;
    }

    class DeleteOpDataContext
    extends AbstractBaseDataService.OpDataContext {
        Map<Long, List<Integer>> currOrgAddIndexes = new HashMap<Long, List<Integer>>(0);
        Map<Long, List<Integer>> cuShareAddIndexes = new HashMap<Long, List<Integer>>(0);
        boolean onlyGlobalShareData = true;

        DeleteOpDataContext() {
        }

        @Override
        boolean isEnableVersion() {
            return BaseDataBusinessServiceUtils.isEnableVersion(BaseDataDeleteService.this.entity);
        }

        private void clear() {
            this.currOrgAddIndexes.clear();
            this.cuShareAddIndexes.clear();
        }

        Map<Long, RoaringBitmap> buildDelUseOrgBitmap(Long viewId) {
            return super.buildUseOrgBitmap(viewId, false);
        }

        Map<Long, RoaringBitmap> buildAddUseOrgBitmap(Long viewId) {
            HashMap<Long, RoaringBitmap> useRelBit = new HashMap<Long, RoaringBitmap>(16);
            if (!this.cuShareAddIndexes.isEmpty()) {
                Map<Long, List<Long>> subCuOrgMapping = BaseDataDeleteService.this.getAllSubCuOrgMapping(viewId, new ArrayList<Long>(this.cuShareTypeMap.keySet()));
                for (Map.Entry entry : this.cuShareTypeMap.entrySet()) {
                    int[] indexArr = BaseDataDeleteService.this.covertIntegerList2IntArr((Collection)entry.getValue());
                    Long orgId = (Long)entry.getKey();
                    useRelBit.computeIfAbsent(orgId, k -> new RoaringBitmap()).add(indexArr);
                    List<Long> subOrgIds = subCuOrgMapping.get(orgId);
                    if (CollectionUtils.isEmpty(subOrgIds)) continue;
                    subOrgIds.forEach(e -> useRelBit.computeIfAbsent((Long)e, k -> new RoaringBitmap()).add(indexArr));
                }
            }
            for (Map.Entry<Long, List<Integer>> entry : this.currOrgAddIndexes.entrySet()) {
                Long orgId = entry.getKey();
                useRelBit.computeIfAbsent(orgId, k -> new RoaringBitmap()).add(BaseDataDeleteService.this.covertIntegerList2IntArr((Collection<Integer>)entry.getValue()));
            }
            this.clear();
            return useRelBit;
        }
    }
}

