/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.roaringbitmap.RoaringBitmap;

class BaseDataDrmService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataDrmService.class);
    private Long currOrgId;
    private DynamicObject newOrg;
    private boolean isIgnoreStatus;
    private String billStatusKey;

    BaseDataDrmService(String entity, Long currOrgId, DynamicObject newOrg) {
        this.currOrgId = currOrgId;
        this.newOrg = newOrg;
        this.init(entity);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        this.billStatusKey = dt.getBillStatus();
        this.isIgnoreStatus = StringUtils.isBlank((CharSequence)this.billStatusKey) || dt.getProperty(this.billStatusKey).isDbIgnore();
    }

    void transferDataManagementRight(List<Long> dataIds) {
        DynamicObject[] collection;
        String selectFields = "id,ctrlstrategy,bitindex,createorg,org,srccreateorg";
        if (!this.isIgnoreStatus) {
            selectFields = "id,ctrlstrategy,bitindex,createorg,org,srccreateorg," + this.billStatusKey;
        }
        if (null == (collection = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)})) || collection.length == 0) {
            return;
        }
        Long newOrgId = (Long)this.newOrg.getPkValue();
        if (this.currOrgId.equals(newOrgId)) {
            return;
        }
        String currentStrategy = collection[0].getString("ctrlstrategy");
        HashSet<Integer> auditIndexes = new HashSet<Integer>(16);
        HashSet<Integer> unAuditIndexes = new HashSet<Integer>(16);
        int[] indexArr = new int[collection.length];
        for (int i = 0; i < collection.length; ++i) {
            int bitIndex;
            DynamicObject data = collection[i];
            data.set("createorg", (Object)this.newOrg);
            data.set("srccreateorg", (Object)this.newOrg);
            data.set("org", (Object)this.newOrg);
            indexArr[i] = bitIndex = data.getInt("bitindex");
            if (this.isIgnoreStatus || BillStatus.C.name().equals(data.getString(this.billStatusKey))) {
                auditIndexes.add(bitIndex);
                continue;
            }
            unAuditIndexes.add(bitIndex);
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        Long viewId = (Long)ctrlView.getPkValue();
        String lockKey = BaseDataDrmService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.requiresNew((String)"base_data_change_org");
        try {
            switch (currentStrategy) {
                case "6": {
                    this.changeOrgPermOnCuShareType(newOrgId, viewId, auditIndexes, unAuditIndexes, indexArr);
                    break;
                }
                case "2": 
                case "7": 
                case "1": {
                    this.changeOrgPermOnAssignOrPrivateType(newOrgId, indexArr);
                    break;
                }
                case "5": {
                    this.publishSolidifyRel(newOrgId, this.covertIntegerList2IntArr(unAuditIndexes));
                }
            }
            SaveServiceHelper.save((DynamicObject[])collection);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
            SqlBuilder builder = new SqlBuilder();
            builder.append("update ", new Object[0]).append(dt.getAlias(), new Object[0]).append("set fsrccreateorgid = ?", new Object[]{this.newOrg.getPkValue()}).append("where ", new Object[0]).appendIn(this.masterIdFieldName, dataIds.toArray()).append("and fid !=" + this.masterIdFieldName, new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataCommonService_1", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            lock.unlock();
            tx.close();
        }
    }

    private void changeOrgPermOnCuShareType(Long newOrgId, Long viewId, Set<Integer> auditIndexes, Set<Integer> unAuditIndexes, int[] indexArr) throws Exception {
        if (!this.needWriteBitRel("6") && !this.asyncRecord()) {
            return;
        }
        Set<Long> newOrgIds = this.getAllCuSubordinateOrgIds(viewId, newOrgId);
        newOrgIds.add(newOrgId);
        Set<Long> currentOrgIds = this.getAllCuSubordinateOrgIds(viewId, this.currOrgId);
        currentOrgIds.add(this.currOrgId);
        HashSet<Long> orgIds = new HashSet<Long>(newOrgIds);
        orgIds.retainAll(currentOrgIds);
        if (orgIds.isEmpty()) {
            this.changePermOnCuShareType2Sibling(auditIndexes, unAuditIndexes, indexArr, newOrgIds, currentOrgIds, newOrgId);
        } else if (orgIds.size() == newOrgIds.size()) {
            this.changePermOnCuShareType2Subordinate(auditIndexes, unAuditIndexes, indexArr, newOrgIds, currentOrgIds, newOrgId);
        } else if (orgIds.size() == currentOrgIds.size()) {
            this.changePermOnCuShareType2Super(auditIndexes, unAuditIndexes, indexArr, newOrgIds, currentOrgIds, newOrgId);
        }
    }

    private void changePermOnCuShareType2Super(Set<Integer> auditIndexes, Set<Integer> unAuditIndexes, int[] indexArr, Set<Long> newOrgIds, Set<Long> currentOrgIds, Long newOrgId) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = this.getNeedUpdateRel(newOrgIds, currentOrgIds);
        newOrgIds.removeIf(currentOrgIds::contains);
        int[] unAuditArr = unAuditIndexes.stream().mapToInt(v -> v).toArray();
        int[] auditArr = auditIndexes.stream().mapToInt(v -> v).toArray();
        if (this.needWriteBitRel("6")) {
            RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])unAuditArr);
            deleteBit.runOptimize();
            this.changeOrgPermOnCuShareType(newOrgIds, currentOrgIds, useRelBitMap, auditArr, unAuditArr, deleteBit);
        }
        if (!this.asyncRecord()) {
            return;
        }
        BaseDataSolidifyMessageDTO messageDTO = new BaseDataSolidifyMessageDTO(newOrgIds.size());
        for (Long orgId : newOrgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            if (orgId.equals(newOrgId)) {
                message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])indexArr)));
                messageDTO.add(message);
                continue;
            }
            if (auditArr.length <= 0) continue;
            message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])auditArr)));
            messageDTO.add(message);
        }
        if (unAuditArr.length > 0) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, this.currOrgId);
            message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])unAuditArr)));
            messageDTO.add(message);
        }
        this.publish(messageDTO);
    }

    private void changePermOnCuShareType2Subordinate(Set<Integer> auditIndexes, Set<Integer> unAuditIndexes, int[] indexArr, Set<Long> newOrgIds, Set<Long> currentOrgIds, Long newOrgId) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = this.getNeedUpdateRel(newOrgIds, currentOrgIds);
        currentOrgIds.removeIf(newOrgIds::contains);
        int[] auditArr = auditIndexes.stream().mapToInt(v -> v).toArray();
        int[] unAuditArr = unAuditIndexes.stream().mapToInt(v -> v).toArray();
        if (this.needWriteBitRel("6")) {
            RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])auditArr);
            deleteBit.add(unAuditArr);
            deleteBit.runOptimize();
            this.changeOrgPermOnCuShareType(newOrgIds, currentOrgIds, useRelBitMap, auditArr, unAuditArr, deleteBit);
        }
        if (!this.asyncRecord()) {
            return;
        }
        BaseDataSolidifyMessageDTO messageDTO = new BaseDataSolidifyMessageDTO(newOrgIds.size());
        RoaringBitmap auditBit = RoaringBitmap.bitmapOf((int[])auditArr);
        for (Long orgId : currentOrgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            if (orgId.equals(this.currOrgId)) {
                message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])indexArr)));
                messageDTO.add(message);
                continue;
            }
            if (auditArr.length <= 0) continue;
            message.add(this.createDelSolidifyMessage(auditBit));
            messageDTO.add(message);
        }
        if (unAuditArr.length > 0) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, newOrgId);
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])unAuditArr);
            message.add(this.createAddSolidifyMessage(bit));
            messageDTO.add(message);
        }
        this.publish(messageDTO);
    }

    private void changePermOnCuShareType2Sibling(Set<Integer> auditIndexes, Set<Integer> unAuditIndexes, int[] indexArr, Set<Long> newOrgIds, Set<Long> currentOrgIds, Long newOrgId) throws Exception {
        BaseDataSolidifyMessage message;
        int[] auditArr = auditIndexes.stream().mapToInt(v -> v).toArray();
        int[] unAuditArr = unAuditIndexes.stream().mapToInt(v -> v).toArray();
        if (this.needWriteBitRel("6")) {
            Map<Long, BaseDataUseRelBit> useRelBitMap = this.getNeedUpdateRel(newOrgIds, currentOrgIds);
            RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])auditArr);
            deleteBit.add(unAuditArr);
            deleteBit.runOptimize();
            this.changeOrgPermOnCuShareType(newOrgIds, currentOrgIds, useRelBitMap, auditArr, unAuditArr, deleteBit);
        }
        if (!this.asyncRecord()) {
            return;
        }
        RoaringBitmap auditBit = RoaringBitmap.bitmapOf((int[])auditArr);
        BaseDataSolidifyMessageDTO messageDTO = new BaseDataSolidifyMessageDTO(newOrgIds.size());
        for (Long orgId : newOrgIds) {
            message = new BaseDataSolidifyMessage(this.entity, orgId);
            if (newOrgId.equals(orgId)) {
                message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])indexArr)));
                messageDTO.add(message);
                continue;
            }
            if (auditArr.length <= 0) continue;
            message.add(this.createAddSolidifyMessage(auditBit));
            messageDTO.add(message);
        }
        for (Long orgId : currentOrgIds) {
            message = new BaseDataSolidifyMessage(this.entity, orgId);
            if (this.currOrgId.equals(orgId)) {
                message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])indexArr)));
                messageDTO.add(message);
                continue;
            }
            if (auditArr.length <= 0) continue;
            message.add(this.createDelSolidifyMessage(auditBit));
            messageDTO.add(message);
        }
        this.publish(messageDTO);
    }

    private void changeOrgPermOnAssignOrPrivateType(Long newOrgId, int[] indexArr) throws Exception {
        ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
        this.deleteBitFromOrgUseRel(this.entity, indexArr, Collections.singletonList(this.currOrgId), updates);
        List<Long> addBitOrgIds = Collections.singletonList(newOrgId);
        ArrayList<BaseDataUseRelBit> inserts = new ArrayList<BaseDataUseRelBit>(10);
        this.addNewBitToOrgUseRel(this.entity, indexArr, updates, inserts, addBitOrgIds);
        BaseDataUseRelUpdateEngine.update(updates, this.entity);
        BaseDataUseRelUpdateEngine.insert(inserts, this.entity);
        this.publishSolidifyRel(newOrgId, indexArr);
    }

    private void changeOrgPermOnCuShareType(Set<Long> addOrgIds, Set<Long> deleteOrgIds, Map<Long, BaseDataUseRelBit> useRelBitMap, int[] auditArr, int[] unAuditArr, RoaringBitmap deleteBit) throws Exception {
        RoaringBitmap bit;
        BaseDataUseRelBit relBit;
        Long newOrgId = (Long)this.newOrg.getPkValue();
        ArrayList<BaseDataUseRelBit> inserts = new ArrayList<BaseDataUseRelBit>(10);
        for (Long orgId : addOrgIds) {
            relBit = useRelBitMap.get(orgId);
            if (null == relBit) {
                relBit = new BaseDataUseRelBit();
                bit = new RoaringBitmap();
                relBit.setOrgId(orgId);
                relBit.setBit(bit);
                inserts.add(relBit);
            }
            bit = relBit.getBit();
            bit.add(auditArr);
            if (orgId.equals(newOrgId)) {
                bit.add(unAuditArr);
            }
            bit.runOptimize();
        }
        for (Long orgId : deleteOrgIds) {
            relBit = useRelBitMap.get(orgId);
            if (null == relBit) continue;
            bit = relBit.getBit();
            bit.andNot(deleteBit);
            bit.runOptimize();
        }
        BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), this.entity);
        BaseDataUseRelUpdateEngine.insert(inserts, this.entity);
    }

    private Map<Long, BaseDataUseRelBit> getNeedUpdateRel(Set<Long> newOrgIds, Set<Long> currentOrgIds) throws Exception {
        HashSet<Long> allOrgIds = new HashSet<Long>(newOrgIds);
        allOrgIds.addAll(currentOrgIds);
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(allOrgIds, this.entity);
        allOrgIds.clear();
        return useRelBitMap;
    }

    private void publishSolidifyRel(Long newOrgId, int[] indexArr) {
        if (!this.asyncRecord()) {
            return;
        }
        BaseDataSolidifyMessageDTO messageDTO = new BaseDataSolidifyMessageDTO(1);
        RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])indexArr);
        BaseDataSolidifyMessage delMsg = new BaseDataSolidifyMessage(this.entity, this.currOrgId);
        delMsg.add(this.createDelSolidifyMessage(bit));
        messageDTO.add(delMsg);
        BaseDataSolidifyMessage addMsg = new BaseDataSolidifyMessage(this.entity, newOrgId);
        addMsg.add(this.createAddSolidifyMessage(bit));
        messageDTO.add(addMsg);
        this.publish(messageDTO);
    }
}

