/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataMaintenanceService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataMaintenanceService.class);

    BaseDataMaintenanceService() {
    }

    public BaseDataMaintenanceService(String entity) {
        super.init(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void correctOrgUseData(Map<Long, Integer> idIndexMap, String entity, DBRoute route, String tableName, boolean isTreeType) {
        if (CollectionUtils.isEmpty(idIndexMap)) {
            return;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 fsolidifyobj, fctrlview from t_bd_defaultctrlstrategy where", new Object[0]).append("fbasedataid = ?", new Object[]{entity}).append("and", new Object[0]).append("fupgradestatus = ?", new Object[]{"2"}).append("and", new Object[0]).append("fenablesolidify = ?", new Object[]{Boolean.TRUE});
        MaintenanceContext context = new MaintenanceContext(isTreeType, route, tableName);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)builder);){
            if (ds.hasNext()) {
                Row row = ds.next();
                context.asyncRecord = StringUtils.isNotBlank((CharSequence)row.getString("fsolidifyobj"));
                context.viewId = row.getLong("fctrlview");
            }
        }
        this.buildCorrectContext(context, idIndexMap.keySet().toArray());
        if (context.ownerData.isEmpty() && context.shareData.isEmpty() && context.ownerCuShareData.isEmpty()) {
            return;
        }
        DLock lock = DLock.createReentrant((String)("bd_bit_correct_lock_" + entity));
        lock.lock();
        try {
            this.updateOrgBitInfo(entity, context);
        }
        finally {
            lock.unlock();
        }
    }

    private void buildCorrectContext(MaintenanceContext context, Object[] dataIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("SELECT FCREATEORGID, FBITINDEX, FCTRLSTRATEGY FROM", new Object[0]).append(context.tableName, new Object[0]).append("WHERE", new Object[0]).appendIn("FID", dataIds);
        if (!context.asyncRecord) {
            if (context.isTreeType) {
                builder.append("AND FCTRLSTRATEGY != '5'", new Object[0]);
            } else {
                builder.append("AND FCTRLSTRATEGY NOT IN('5', '6')", new Object[0]);
            }
        }
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)context.route, (SqlBuilder)builder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long orgId = row.getLong("FCREATEORGID");
                Integer index = row.getInteger("FBITINDEX");
                if (!context.asyncRecord) {
                    context.ownerData.computeIfAbsent(orgId, k -> new HashSet(10)).add(index);
                    continue;
                }
                String strategy = row.getString("FCTRLSTRATEGY");
                if ("5".equals(strategy)) {
                    context.shareData.computeIfAbsent(orgId, k -> new HashSet(10)).add(index);
                    continue;
                }
                if (context.isTreeType && "6".equals(strategy)) {
                    context.ownerData.computeIfAbsent(orgId, k -> new HashSet(10)).add(index);
                    context.ownerCuShareData.computeIfAbsent(orgId, k -> new HashSet(10)).add(index);
                    continue;
                }
                if (!context.isTreeType && "6".equals(strategy)) {
                    context.ownerCuShareData.computeIfAbsent(orgId, k -> new HashSet(10)).add(index);
                    continue;
                }
                context.ownerData.computeIfAbsent(orgId, k -> new HashSet(10)).add(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrgBitInfo(String entity, MaintenanceContext context) {
        String lockKey = BaseDataMaintenanceService.getBaseDataUnifiedLockKey(entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try (TXHandle tx = TX.requiresNew((String)"bd_ctrl_preset_org_data");){
            Collection orgIds = context.getUseOrgIds();
            String relTableName = (context.tableName + "_bit").toUpperCase();
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, entity, relTableName, context.route);
            if (!context.asyncRecord) {
                this.updateOrgBitInfo(entity, context, useRelBitMap);
                return;
            }
            try {
                BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
                this.shareDataGenerate(entity, context, messageDto);
                List<BaseDataSolidifyMessage> solidifyMessages = this.updateOrgBitInfo(entity, context, useRelBitMap);
                messageDto.addAll(solidifyMessages);
                this.publish(messageDto, context.route.getRouteKey());
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u9884\u7f6e\u6570\u636e\u8865\u5168\u4f4d\u56fe\u5f02\u5e38", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", "correct org use data error."), new Object[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void shareDataGenerate(String entity, MaintenanceContext context, BaseDataSolidifyMessageDTO messageDto) {
        if (context.ownerCuShareData.isEmpty() && context.shareData.isEmpty()) {
            return;
        }
        if (0L == context.viewId) {
            this.shareDataGenerate(entity, context.ownerCuShareData, messageDto);
            this.shareDataGenerate(entity, context.shareData, messageDto);
            return;
        }
        HashMap<Long, String> orgLnMap = new HashMap<Long, String>(16);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid, flongnumber from t_org_structure where ", new Object[0]).append("fisctrlunit = ?", new Object[]{Boolean.TRUE}).append("and fviewid  = ?", new Object[]{context.viewId});
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.base, (SqlBuilder)builder);
        Iterator iterator = null;
        try {
            ds.forEach(r -> orgLnMap.put(r.getLong("forgid"), r.getString("flongnumber")));
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!context.shareData.isEmpty()) {
            ArrayList indexes = new ArrayList(10);
            context.shareData.values().forEach(indexes::addAll);
            for (Long l : orgLnMap.keySet()) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(entity, l);
                int[] addIndexArr = indexes.stream().mapToInt(v -> v).toArray();
                RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])addIndexArr);
                message.add(this.createAddSolidifyMessage(bit));
                messageDto.add(message);
            }
        }
        if (context.ownerCuShareData.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> subOrgMap = this.getSubOrgMap(context, orgLnMap);
        for (Map.Entry entry : context.ownerCuShareData.entrySet()) {
            Long supOrgId = (Long)entry.getKey();
            List<Long> subOrgIds = subOrgMap.get(supOrgId);
            Set indexes = (Set)entry.getValue();
            if (CollectionUtils.isEmpty(subOrgIds) || CollectionUtils.isEmpty((Collection)indexes)) continue;
            int[] addIndexArr = indexes.stream().mapToInt(v -> v).toArray();
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])addIndexArr);
            for (Long orgId : subOrgIds) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(entity, orgId);
                message.add(this.createAddSolidifyMessage(bit));
                messageDto.add(message);
            }
        }
    }

    private Map<Long, List<Long>> getSubOrgMap(MaintenanceContext context, Map<Long, String> orgLnMap) {
        HashMap<Long, List<Long>> subOrgMap = new HashMap<Long, List<Long>>(16);
        context.ownerCuShareData.keySet().forEach(e -> subOrgMap.computeIfAbsent((Long)e, k -> new ArrayList(10)).add(e));
        HashMap lnmOrgMap = new HashMap(context.ownerCuShareData.size());
        context.ownerCuShareData.keySet().forEach(e -> lnmOrgMap.put(orgLnMap.get(e), e));
        for (Map.Entry<Long, String> entry : orgLnMap.entrySet()) {
            String lnm = entry.getValue();
            if (StringUtils.isBlank((CharSequence)lnm)) continue;
            for (Map.Entry e2 : lnmOrgMap.entrySet()) {
                String longNum = (String)e2.getKey();
                if (!StringUtils.isNotBlank((CharSequence)longNum) || !lnm.startsWith(longNum + "!")) continue;
                subOrgMap.computeIfAbsent((Long)e2.getValue(), (Function<Long, List<Long>>)((Function<Long, List>)k -> new ArrayList(10))).add(entry.getKey());
            }
        }
        return subOrgMap;
    }

    private void shareDataGenerate(String entity, Map<Long, Set<Integer>> share, BaseDataSolidifyMessageDTO messageDto) {
        for (Map.Entry<Long, Set<Integer>> entry : share.entrySet()) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(entity, entry.getKey());
            int[] addIndexArr = entry.getValue().stream().mapToInt(v -> v).toArray();
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])addIndexArr);
            message.add(this.createAddSolidifyMessage(bit));
            messageDto.add(message);
        }
    }

    private List<BaseDataSolidifyMessage> updateOrgBitInfo(String entity, MaintenanceContext context, Map<Long, BaseDataUseRelBit> useRelBitMap) throws Exception {
        ArrayList<BaseDataSolidifyMessage> solidifyMessages = new ArrayList<BaseDataSolidifyMessage>(10);
        for (Map.Entry entry : context.ownerData.entrySet()) {
            Long orgId = (Long)entry.getKey();
            BaseDataUseRelBit useRelBit = useRelBitMap.get(orgId);
            int[] addIndexArr = ((Set)entry.getValue()).stream().mapToInt(v -> v).toArray();
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])addIndexArr);
            bit.runOptimize();
            if (null != useRelBit && null != useRelBit.getBit()) {
                RoaringBitmap relBit = useRelBit.getBit();
                relBit.or(bit);
                relBit.runOptimize();
            } else {
                useRelBit = new BaseDataUseRelBit();
                useRelBit.setOrgId(orgId);
                useRelBit.setBit(bit);
            }
            if (!context.asyncRecord) continue;
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(entity, orgId);
            message.add(this.createAddSolidifyMessage(bit));
            solidifyMessages.add(message);
        }
        String relTableName = (context.tableName + "_bit").toUpperCase();
        BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), entity, relTableName, context.route);
        return solidifyMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, int[]> correctOrgUseData(Set<Long> orgIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == ctrlView) {
            return Collections.emptyMap();
        }
        if ((orgIds = this.getCuOrgIds(orgIds, ctrlView)).isEmpty()) {
            return Collections.emptyMap();
        }
        MaintenanceContext context = new MaintenanceContext(this.entity, this.asyncRecord());
        this.collectShareData(context);
        ArrayList<OpLogAppInfo> logInfos = new ArrayList<OpLogAppInfo>(orgIds.size());
        HashMap<Long, int[]> correctOrgUseData = new HashMap<Long, int[]>(orgIds.size());
        DLock lock = DLock.createReentrant((String)("bd_bit_correct_lock_" + this.entity));
        lock.lock();
        try {
            this.initOrgOwnerData(orgIds, context);
            context.presentCuShareBit = this.getOrgPresentBit(orgIds);
            context.presentCuShareBit.retainAll(context.allCuShareIndexes);
            Map allSupers = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), new ArrayList<Long>(orgIds));
            HashSet<Long> allOrgIds = new HashSet<Long>(orgIds);
            allSupers.values().forEach(allOrgIds::addAll);
            BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
            String billStatusKey = dt.getBillStatus();
            boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
            ArrayList<String> fields = new ArrayList<String>(Arrays.asList("fbitindex", this.masterIdFieldName, "fcreateorgid"));
            if (!isIgnoreStatus) {
                fields.add(dt.getProperty(billStatusKey).getAlias());
            }
            SqlBuilder builder = new SqlBuilder();
            builder.append("select ", new Object[0]).append(String.join((CharSequence)String.valueOf(','), fields), new Object[0]).append("from ", new Object[0]).append(dt.getAlias(), new Object[0]).append("where", new Object[0]).append("fctrlstrategy = '6' and", new Object[0]).appendIn("fcreateorgid", allOrgIds.toArray());
            HashMap<Long, Set<DataInfo>> orgDataMap = new HashMap<Long, Set<DataInfo>>(allOrgIds.size());
            Map mstBitIndexMap = (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
                HashMap<Long, Set> result = new HashMap<Long, Set>(16);
                while (rs.next()) {
                    int index = rs.getInt("fbitindex");
                    if (index == 0) continue;
                    Long createOrgId = rs.getLong("fcreateorgid");
                    long masterId = rs.getLong(this.masterIdFieldName);
                    orgDataMap.computeIfAbsent(createOrgId, k -> new HashSet(16)).add(new DataInfo(masterId, index));
                    if (!isIgnoreStatus && !BillStatus.C.name().equals(rs.getString(dt.getProperty(billStatusKey).getAlias()))) continue;
                    result.computeIfAbsent(masterId, k -> new HashSet(16)).add(index);
                }
                return result;
            });
            Date opTime = new Date();
            for (Long orgId : orgIds) {
                int[] indexes = this.updateOrgBitInfo(context, orgId, orgDataMap, mstBitIndexMap, allSupers);
                correctOrgUseData.put(orgId, indexes);
                String opName = ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58", (String)"BaseDataMaintenanceService_1", (String)"bos-bd-business", (Object[])new Object[0]);
                String opDescription = String.format(ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58\u6210\u529f\uff0c\u7ec4\u7ec7\uff1a%1$s\uff0c\u5b9e\u4f53\uff1a%2$s", (String)"BaseDataMaintenanceService_2", (String)"bos-bd-business", (Object[])new Object[0]), orgId, this.entity);
                OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, null, opName, this.entity, BizAppServiceHelp.getAppIdByAppNumber((String)this.entity));
                appLogInfo.setOpDescription(opDescription);
                logInfos.add(appLogInfo);
            }
        }
        finally {
            lock.unlock();
        }
        BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
            LogServiceHelper.addBatchLog((List)logInfos);
            return true;
        }, RequestContext.get());
        return correctOrgUseData;
    }

    private Set<Long> getCuOrgIds(Set<Long> orgIds, DynamicObject view) {
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", view.getPkValue()), new QFilter("org.id", "in", orgIds), new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE)};
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org.id", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)map)) {
            return Collections.emptySet();
        }
        HashSet<Long> cuIds = new HashSet<Long>(map.size());
        map.values().forEach(e -> cuIds.add(e.getLong("org.id")));
        return cuIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] updateOrgBitInfo(MaintenanceContext context, Long orgId, Map<Long, Set<DataInfo>> orgDataMap, Map<Long, Set<Integer>> mstBitIndexMap, Map<Long, List<Long>> allSupers) {
        String lockKey = BaseDataMaintenanceService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap;
            BaseDataUseRelBit useRelBit;
            Set<Integer> cuShareData = Collections.emptySet();
            if (context.isTreeType) {
                cuShareData = this.getNeedAddCuShareBitIndexes(orgId, orgDataMap, mstBitIndexMap, allSupers);
            }
            HashSet<Integer> addIndexes = new HashSet<Integer>(cuShareData);
            Set ownerData = (Set)context.ownerData.get(orgId);
            if (!CollectionUtils.isEmpty((Collection)ownerData)) {
                addIndexes.addAll(ownerData);
            }
            addIndexes.remove(0);
            if (context.asyncRecord && !context.isTreeType) {
                cuShareData = this.getNeedAddCuShareBitIndexes(orgId, orgDataMap, mstBitIndexMap, allSupers);
                Set bitIndexes = (Set)context.ownerCuShareData.get(orgId);
                if (!CollectionUtils.isEmpty((Collection)bitIndexes)) {
                    cuShareData.addAll(bitIndexes);
                }
            }
            if (null != (useRelBit = (useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(Collections.singleton(orgId), this.entity)).get(orgId)) && null != useRelBit.getBit()) {
                int[] nArray = this.updateOrgUseRel(context, addIndexes, useRelBit, orgId, cuShareData);
                return nArray;
            }
            int[] nArray = this.addUseRelBit(context, orgId, addIndexes, cuShareData);
            return nArray;
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u9664\u7f13\u5b58\u6570\u636e\u5f02\u5e38", (Throwable)e);
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            lock.unlock();
        }
    }

    private int[] updateOrgUseRel(MaintenanceContext context, Set<Integer> addIndexes, BaseDataUseRelBit useRelBit, Long orgId, Set<Integer> cuShareData) {
        try (TXHandle tx = TX.requiresNew((String)"correct_org_use_data");){
            RoaringBitmap bit = useRelBit.getBit();
            RoaringBitmap clone = bit.clone();
            if (!CollectionUtils.isEmpty((Collection)context.presentCuShareBit)) {
                RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(context.presentCuShareBit));
                delBit.runOptimize();
                bit.andNot(delBit);
            }
            int[] addIndexArr = this.covertIntegerList2IntArr(addIndexes);
            bit.add(addIndexArr);
            bit.runOptimize();
            BaseDataUseRelUpdateEngine.update(new ArrayList<BaseDataUseRelBit>(Collections.singletonList(useRelBit)), this.entity);
            if (context.asyncRecord) {
                RoaringBitmap tempBit;
                RoaringBitmap incrBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(addIndexes));
                if (!context.isTreeType) {
                    incrBit.add(this.covertIntegerList2IntArr(cuShareData));
                }
                BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(1);
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                if (!context.presentCuShareBit.isEmpty()) {
                    RoaringBitmap deleteBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(context.presentCuShareBit));
                    deleteBit.and(clone);
                    deleteBit.andNot(incrBit);
                    if (!deleteBit.isEmpty()) {
                        message.add(this.createDelSolidifyMessage(deleteBit));
                    }
                }
                incrBit.andNot(clone);
                if (null != context.auditShareData) {
                    incrBit.or(context.auditShareData);
                }
                if (null != (tempBit = (RoaringBitmap)context.tempShareData.get(orgId))) {
                    incrBit.or(tempBit);
                }
                if (!incrBit.isEmpty()) {
                    incrBit.runOptimize();
                    message.add(this.createAddSolidifyMessage(incrBit));
                }
                messageDto.add(message);
                this.publish(messageDto);
            }
            int[] nArray = addIndexArr;
            return nArray;
        }
    }

    private int[] addUseRelBit(MaintenanceContext context, Long orgId, Set<Integer> addIndexes, Set<Integer> cuShareData) {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"correct_org_use_data");){
            if (addIndexes.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            BaseDataUseRelBit useRelBit = new BaseDataUseRelBit();
            useRelBit.setOrgId(orgId);
            int[] indexes = this.covertIntegerList2IntArr(addIndexes);
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])indexes);
            bit.runOptimize();
            useRelBit.setBit(bit);
            BaseDataUseRelUpdateEngine.insert(new ArrayList<BaseDataUseRelBit>(Collections.singleton(useRelBit)), this.entity);
            if (context.asyncRecord) {
                RoaringBitmap tempBit;
                bit = bit.clone();
                if (!context.isTreeType) {
                    bit.add(this.covertIntegerList2IntArr(cuShareData));
                    bit.runOptimize();
                }
                if (null != (tempBit = (RoaringBitmap)context.tempShareData.get(orgId))) {
                    bit.or(tempBit);
                    bit.runOptimize();
                }
                if (null != context.auditShareData) {
                    bit.or(context.auditShareData);
                    bit.runOptimize();
                }
                BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(1);
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                message.add(this.createAddSolidifyMessage(bit));
                messageDto.add(message);
                this.publish(messageDto);
            }
            int[] nArray = indexes;
            return nArray;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                LOGGER.error("\u6e05\u9664\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff0c\u7ec4\u7ec7\u3010{}\u3011", (Object)orgId, (Object)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", "correct org use data error."), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Set<Integer> getNeedAddCuShareBitIndexes(Long orgId, Map<Long, Set<DataInfo>> orgDataMap, Map<Long, Set<Integer>> mstBitIndexMap, Map<Long, List<Long>> allSupers) {
        List<Long> supperOrgIds;
        HashMap<Long, Set> currMstBitIndexMap = new HashMap<Long, Set>(16);
        Set<DataInfo> currDataInfos = orgDataMap.get(orgId);
        if (!CollectionUtils.isEmpty(currDataInfos)) {
            currDataInfos.forEach(v -> currMstBitIndexMap.computeIfAbsent(((DataInfo)v).masterId, k -> new HashSet(16)).add(((DataInfo)v).index));
        }
        if (!CollectionUtils.isEmpty(supperOrgIds = allSupers.get(orgId))) {
            for (Long superOrgId : supperOrgIds) {
                Set<DataInfo> dataInfos = orgDataMap.get(superOrgId);
                if (CollectionUtils.isEmpty(dataInfos)) continue;
                for (DataInfo dataInfo : dataInfos) {
                    Set<Integer> auditIndexes = mstBitIndexMap.get(dataInfo.masterId);
                    if (CollectionUtils.isEmpty(auditIndexes) || !auditIndexes.contains(dataInfo.index)) continue;
                    currMstBitIndexMap.computeIfAbsent(dataInfo.masterId, k -> new HashSet(16)).add(dataInfo.index);
                }
            }
        }
        HashSet<Integer> cuShareData = new HashSet<Integer>(16);
        for (Map.Entry entry : currMstBitIndexMap.entrySet()) {
            Set bitIndexes = (Set)entry.getValue();
            if (bitIndexes.size() > 1) {
                cuShareData.add((Integer)Collections.max(bitIndexes));
                continue;
            }
            cuShareData.addAll(bitIndexes);
        }
        return cuShareData;
    }

    private void initOrgOwnerData(Collection<Long> orgIds, MaintenanceContext context) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        IDataEntityType dt = ORM.create().getDataEntityType(this.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("select fbitindex, fcreateorgid, fctrlstrategy from %s where fctrlstrategy !=  '5' and ", dt.getAlias()), new Object[0]).appendIn("fcreateorgid", orgIds.toArray());
        if (!context.asyncRecord && !context.isTreeType) {
            builder.append(" and fctrlstrategy != '6'", new Object[0]);
        }
        DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            while (rs.next()) {
                int bitIndex = rs.getInt("fbitindex");
                if (0 == bitIndex) continue;
                Long createOrgId = rs.getLong("fcreateorgid");
                if (context.isTreeType) {
                    context.ownerData.computeIfAbsent(createOrgId, k -> new HashSet(16)).add(bitIndex);
                    continue;
                }
                if ("6".equals(rs.getString("fctrlstrategy"))) {
                    context.ownerCuShareData.computeIfAbsent(createOrgId, k -> new HashSet(16)).add(bitIndex);
                    continue;
                }
                context.ownerData.computeIfAbsent(createOrgId, k -> new HashSet(16)).add(bitIndex);
            }
            return true;
        });
    }

    private Set<Integer> getOrgPresentBit(Collection<Long> orgIds) {
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
            HashSet<Integer> allBitIndexes = new HashSet<Integer>(16);
            for (BaseDataUseRelBit useRelBit : useRelBitMap.values()) {
                RoaringBitmap bit = useRelBit.getBit();
                if (null == bit) continue;
                allBitIndexes.addAll(Arrays.stream(bit.toArray()).boxed().collect(Collectors.toSet()));
            }
            return allBitIndexes;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void collectShareData(MaintenanceContext context) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String billStatusKey = dt.getBillStatus();
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        StringBuilder builder = new StringBuilder("SELECT FCREATEORGID, FBITINDEX, FCTRLSTRATEGY");
        if (!isIgnoreStatus) {
            builder.append(", ").append(dt.getProperty(billStatusKey).getAlias());
        }
        builder.append(" FROM ").append(dt.getAlias());
        if (context.asyncRecord) {
            builder.append(" WHERE FCTRLSTRATEGY IN ('5', '6')");
        } else {
            builder.append(" WHERE FCTRLSTRATEGY = '6'");
        }
        context.allCuShareIndexes = new HashSet(16);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)builder.toString());){
            for (Row row : ds) {
                Integer index = row.getInteger("FBITINDEX");
                if ("6".equals(row.getString("FCTRLSTRATEGY"))) {
                    context.allCuShareIndexes.add(index);
                    continue;
                }
                if (!context.asyncRecord) continue;
                if (isIgnoreStatus || BillStatus.C.name().equals(row.getString(dt.getProperty(billStatusKey).getAlias()))) {
                    context.auditShareData.add(index.intValue());
                    continue;
                }
                context.tempShareData.computeIfAbsent(row.getLong("FCREATEORGID"), k -> new RoaringBitmap()).add(index.intValue());
            }
        }
    }

    public boolean clearUnCuOrgBit(Long orgStructureId) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == ctrlView) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6599\u89c6\u56fe\u4e0d\u5b58\u5728\u3002", (String)"BaseDataMaintenanceService_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)orgStructureId), new QFilter("view.id", "=", ctrlView.getPkValue()), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE)};
        DynamicObject orgStructure = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"org.id", (QFilter[])filters);
        if (null == orgStructure) {
            LOGGER.error((Throwable)new KDBizException(String.format("\u6839\u636e\u7ec4\u7ec7\u7ed3\u6784ID:%s, \u89c6\u56feid\uff1a%s\uff0c\u65e0\u6cd5\u67e5\u8be2\u975eCU\u7ec4\u7ec7\u4fe1\u606f", orgStructureId, ctrlView.getPkValue())));
            return false;
        }
        Long orgId = orgStructure.getLong("org.id");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entity, (String)"bitindex", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)orgId)});
        ArrayList<Integer> bitIndexes = new ArrayList<Integer>(collection.size());
        for (DynamicObject data : collection) {
            int index = data.getInt("bitindex");
            if (0 == index) continue;
            bitIndexes.add(index);
        }
        String lockKey = BaseDataMaintenanceService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            BaseDataUseRelBit useRelBit = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(Collections.singleton(orgId), this.entity).get(orgId);
            if (CollectionUtils.isEmpty(bitIndexes) && null == useRelBit) {
                boolean bl = true;
                return bl;
            }
            useRelBit = this.eachClearBit(useRelBit, orgId, bitIndexes);
            BaseDataUseRelUpdateEngine.update(new ArrayList<BaseDataUseRelBit>(Collections.singleton(useRelBit)), this.entity);
            this.writOpLog(Collections.singleton(useRelBit));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("\u6e05\u9664\u5355\u4e2a\u975eCU\u7ec4\u7ec7\u4f4d\u56fe\u5f02\u5e38...", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            lock.unlock();
        }
    }

    public boolean clearAllUnCuOrgBit() {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (null == ctrlView) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6599\u89c6\u56fe\u4e0d\u5b58\u5728\u3002", (String)"BaseDataMaintenanceService_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", ctrlView.getPkValue()), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE)};
        Map orgStructureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org.id,org.number", (QFilter[])filters);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(orgStructureMap.size());
        for (DynamicObject value : orgStructureMap.values()) {
            orgMap.put(value.getLong("org.id"), value.getString("org.number"));
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entity, (String)"createorg, bitindex", (QFilter[])new QFilter[]{new QFilter("createorg", "in", orgMap.keySet())});
        HashMap<Long, Set> indexMap = new HashMap<Long, Set>(16);
        for (DynamicObject data : collection) {
            int index = data.getInt("bitindex");
            if (0 == index) continue;
            Long orgId = this.getLongDataFromDynamicObject(data.get("createorg"));
            indexMap.computeIfAbsent(orgId, k -> new HashSet(16)).add(index);
        }
        Future future = BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
            boolean success = true;
            ArrayList orgIds = new ArrayList(orgMap.keySet());
            int size = orgIds.size();
            int totalPage = size % BaseDataCommon.BATCH_MAX > 0 ? size / BaseDataCommon.BATCH_MAX + 1 : size / BaseDataCommon.BATCH_MAX;
            for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
                int toIndex;
                int fromIndex = pageNo * BaseDataCommon.BATCH_MAX;
                List<Long> values = orgIds.subList(fromIndex, toIndex = Math.min((pageNo + 1) * BaseDataCommon.BATCH_MAX, size));
                if (this.batchClearUnCuOrgBit(values, indexMap)) continue;
                success = false;
            }
            return success;
        }, RequestContext.get());
        try {
            long timeout = this.getThreadWaitTimeOut();
            return (Boolean)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u6b65\u6e05\u9664\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchClearUnCuOrgBit(List<Long> orgIds, Map<Long, Set<Integer>> indexMap) {
        String lockKey = BaseDataMaintenanceService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
            ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(useRelBitMap.size());
            for (Map.Entry<Long, BaseDataUseRelBit> entry : useRelBitMap.entrySet()) {
                Long orgId = entry.getKey();
                BaseDataUseRelBit value = entry.getValue();
                Set<Integer> indexes = indexMap.get(orgId);
                if (null == value) continue;
                updates.add(this.eachClearBit(value, orgId, indexes));
            }
            if (!updates.isEmpty()) {
                BaseDataUseRelUpdateEngine.update(new ArrayList<BaseDataUseRelBit>(updates), this.entity);
                this.writOpLog(updates);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u6279\u91cf\u6e05\u9664\u975eCU\u7ec4\u7ec7\u4f4d\u56fe\u5f02\u5e38\uff0c\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u3010%s\u3011", JSON.toJSONString(orgIds)), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private BaseDataUseRelBit eachClearBit(BaseDataUseRelBit useRelBit, Long orgId, Collection<Integer> indexes) {
        RoaringBitmap bit = CollectionUtils.isEmpty(indexes) ? new RoaringBitmap() : RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexes));
        bit.runOptimize();
        if (null == useRelBit) {
            useRelBit = new BaseDataUseRelBit();
            useRelBit.setOrgId(orgId);
        }
        useRelBit.setBit(bit);
        return useRelBit;
    }

    private void writOpLog(Collection<BaseDataUseRelBit> useRelBits) {
        ArrayList<OpLogAppInfo> logInfos = new ArrayList<OpLogAppInfo>(10);
        Date opTime = new Date();
        for (BaseDataUseRelBit useRelBit : useRelBits) {
            OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, null, "clear_un_cu_org_bit", this.entity, BizAppServiceHelp.getAppIdByAppNumber((String)this.entity));
            appLogInfo.setOpDescription(String.format("execute clear_un_cu_org_bit [Org:%s, Entity:%s]", useRelBit.getOrgId(), this.entity));
            logInfos.add(appLogInfo);
        }
        LogServiceHelper.addBatchLog(logInfos);
    }

    private long getThreadWaitTimeOut() {
        String timeout = System.getProperty("bit.clear.timeout");
        if (StringUtils.isBlank((CharSequence)timeout)) {
            return 300000L;
        }
        return Long.parseLong(timeout);
    }

    private static final class DataInfo {
        private Long masterId;
        private Integer index;

        private DataInfo(Long masterId, int index) {
            this.masterId = masterId;
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DataInfo) {
                return Objects.equals(this.index, ((DataInfo)obj).index);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.index);
        }
    }

    private static final class MaintenanceContext {
        private boolean isTreeType;
        private boolean asyncRecord;
        private Set<Integer> allCuShareIndexes;
        private Set<Integer> presentCuShareBit;
        private Map<Long, Set<Integer>> ownerData = new HashMap<Long, Set<Integer>>(16);
        private Map<Long, Set<Integer>> ownerCuShareData = new HashMap<Long, Set<Integer>>(16);
        private Map<Long, Set<Integer>> shareData;
        private Map<Long, RoaringBitmap> tempShareData;
        private RoaringBitmap auditShareData;
        private Long viewId = 0L;
        private DBRoute route;
        private String tableName;

        private MaintenanceContext(String entity, boolean asyncRecord) {
            this.asyncRecord = asyncRecord;
            this.isTreeType = AbstractBaseDataService.isTreeTypeBaseData(entity);
            this.allCuShareIndexes = new HashSet<Integer>(16);
            this.presentCuShareBit = new HashSet<Integer>(16);
            this.tempShareData = new HashMap<Long, RoaringBitmap>(16);
            this.auditShareData = new RoaringBitmap();
        }

        private MaintenanceContext(boolean isTreeType, DBRoute route, String tableName) {
            this.isTreeType = isTreeType;
            this.route = route;
            this.tableName = tableName;
            this.shareData = new HashMap<Long, Set<Integer>>(16);
        }

        private Collection<Long> getUseOrgIds() {
            HashSet<Long> orgIds = new HashSet<Long>(10);
            orgIds.addAll(this.ownerData.keySet());
            orgIds.addAll(this.ownerCuShareData.keySet());
            if (!CollectionUtils.isEmpty(this.shareData)) {
                orgIds.addAll(this.shareData.keySet());
            }
            return orgIds;
        }
    }
}

