/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.pojo.SolidifyProgressInfo;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataRelBitRestoreService
extends AbstractBaseDataService {
    private static Log LOGGER = LogFactory.getLog(BaseDataRelBitRestoreService.class);
    private Long ctrlViewId;

    public BaseDataRelBitRestoreService(String entity) {
        super.init(entity);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        this.ctrlViewId = (Long)ctrlView.getPkValue();
    }

    public static SolidifyProgressInfo getSolidifyProgressInfo(String entity) {
        String cacheValue = (String)BD_COMMON_CACHE.get(BaseDataRelBitRestoreService.getCacheType(entity), entity);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return null;
        }
        return (SolidifyProgressInfo)SerializationUtils.fromJsonString((String)cacheValue, SolidifyProgressInfo.class);
    }

    public static boolean manualInterrupt(String entity) {
        return StringUtils.isNotBlank((CharSequence)((CharSequence)BD_COMMON_CACHE.get(BaseDataRelBitRestoreService.getCacheType(entity), entity + "_stop")));
    }

    public static void stop(String entity) {
        String type = BaseDataRelBitRestoreService.getCacheType(entity);
        BD_COMMON_CACHE.put(type, entity + "_stop", (Object)Boolean.TRUE.toString());
        BD_COMMON_CACHE.remove(type, entity);
    }

    private static boolean isStop(String entity) {
        String value = (String)BD_COMMON_CACHE.get(BaseDataRelBitRestoreService.getCacheType(entity), entity + "_stop");
        return !StringUtils.isBlank((CharSequence)value) && Boolean.parseBoolean(value);
    }

    private void reset() {
        String type = BaseDataRelBitRestoreService.getCacheType(this.entity);
        BD_COMMON_CACHE.remove(type, this.entity + "_stop");
        BD_COMMON_CACHE.remove(type, this.entity);
    }

    private static String getCacheType(String entity) {
        RequestContext context = RequestContext.get();
        return String.format("bd_solidify_pro_%s_%s", entity, context.getAccountId());
    }

    private void cacheSolidifyProgressInfo(SolidifyProgressInfo info) {
        String value = SerializationUtils.toJsonString((Object)info);
        BD_COMMON_CACHE.put(BaseDataRelBitRestoreService.getCacheType(this.entity), this.entity, (Object)value);
    }

    public void relBitRestore() {
        Map<Long, BaseDataUseRelBit> useRelBitMap;
        this.writOpLog();
        SolidifyProgressInfo progressInfo = BaseDataRelBitRestoreService.getSolidifyProgressInfo(this.entity);
        if (null != progressInfo) {
            return;
        }
        DynamicObject config = this.validate();
        Set<Long> allCuOrgIds = this.getAllCuOrgByViewId(this.ctrlViewId, null);
        try {
            useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(allCuOrgIds, this.entity);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7ec4\u7ec7\u4f4d\u56fe\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ec4\u7ec7\u4f4d\u56fe\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataRelBitRestoreService_4", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        this.reset();
        DynamicObject solidifyObj = config.getDynamicObject("solidifyobj");
        String solidifyEntity = solidifyObj.getPkValue().toString();
        IDataEntityType dt = ORM.create().newDynamicObject(solidifyEntity).getDataEntityType();
        String tableName = dt.getAlias();
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        DB.execute((DBRoute)route, (String)("delete from " + tableName));
        progressInfo = new SolidifyProgressInfo(allCuOrgIds.size());
        this.cacheSolidifyProgressInfo(progressInfo);
        ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
        pool.execute((Runnable)new SolidifyRunnable(tableName, useRelBitMap, allCuOrgIds, route), RequestContext.get());
    }

    private void insert(RestoreOpDataContext context, String sql, Long orgId, RoaringBitmap bit, DBRoute route) {
        RoaringBitmap insertBit = new RoaringBitmap();
        if (null != bit) {
            insertBit.or(bit);
        }
        this.addBit(context.auditShares, insertBit);
        this.addBit((List)context.unAuditShareMap.get(orgId), insertBit);
        this.addBit((List)context.unAuditCuShareMap.get(orgId), insertBit);
        this.addBit((List)context.cuShareTypeMap.get(orgId), insertBit);
        this.collParentData(orgId, insertBit, context);
        if (!context.stop) {
            this.execute(sql, orgId, insertBit.toArray(), route, context);
        }
    }

    private void collParentData(Long orgId, RoaringBitmap bit, RestoreOpDataContext context) {
        Long pId = (Long)context.supOrgMap.get(orgId);
        if (null == pId || 0L == pId) {
            return;
        }
        this.addBit((List)context.cuShareTypeMap.get(pId), bit);
        this.collParentData(pId, bit, context);
    }

    private void addBit(List<Integer> indexes, RoaringBitmap bit) {
        if (!CollectionUtils.isEmpty(indexes)) {
            bit.add(this.covertIntegerList2IntArr(indexes));
        }
    }

    private void execute(String sql, Long orgId, int[] indexes, DBRoute route, RestoreOpDataContext context) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        long[] ids = DB.genGlobalLongIds((int)indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            if (context.stop) {
                return;
            }
            params.add(new Object[]{ids[i], indexes[i], orgId});
            if (10000 != params.size() || context.stop) continue;
            DB.executeBatch((DBRoute)route, (String)sql, params);
            params.clear();
        }
        if (!context.stop && !params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)sql, params);
        }
    }

    private DynamicObject validate() {
        String selectFields = "upgradestatus, checkstatus, solidifyobj, enablesolidify, solidifystatus";
        QFilter[] filters = new QFilter[]{new QFilter("basedataid", "=", (Object)this.entity)};
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
        if (!"2".equals(config.getString("upgradestatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662f\u65b0\u6a21\u578b\uff0c\u4e0d\u80fd\u6267\u884c\u56fa\u5316\u8fd8\u539f\u64cd\u4f5c\u3002", (String)"BaseDataRelBitRestoreService_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        if (!config.getBoolean("enablesolidify")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5f00\u542f\u6c34\u5e73\u5206\u8868\uff0c\u4e0d\u80fd\u6267\u884c\u56fa\u5316\u8fd8\u539f\u3002", (String)"BaseDataRelBitRestoreService_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        if (config.getBoolean("solidifystatus")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5316\u8fd8\u539f\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u3002", (String)"BaseDataRelBitRestoreService_2", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)config.get("solidifyobj"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5316\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u914d\u7f6e\u56fa\u5316\u5bf9\u8c61\u3002", (String)"BaseDataRelBitRestoreService_3", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        return config;
    }

    private void writOpLog() {
        String entity = "bd_bdctrstratege_formcard";
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)entity);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u56fa\u5316\u8fd8\u539f", "BaseDataRelBitRestoreService_7", "bos-bd-business");
        OpLogAppInfo appLogInfo = this.buildAppLogInfo(new Date(), null, "Bit Restore", opName, entity, appId);
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u6267\u884c\u4f4d\u56fe\u56fa\u5316\u8fd8\u539f\u64cd\u4f5c\u3002", "BaseDataRelBitRestoreService_6", "bos-bd-business"), new String[0]);
        ArrayList<OpLogAppInfo> logInfos = new ArrayList<OpLogAppInfo>(1);
        logInfos.add(appLogInfo);
        LogServiceHelper.addBatchLog(logInfos);
    }

    private class RestoreOpDataContext {
        private boolean stop;
        private List<Integer> auditShares = new ArrayList<Integer>(10);
        private Map<Long, List<Integer>> unAuditShareMap = new HashMap<Long, List<Integer>>(0);
        private Map<Long, List<Integer>> unAuditCuShareMap = new HashMap<Long, List<Integer>>(0);
        private Map<Long, List<Integer>> cuShareTypeMap = new HashMap<Long, List<Integer>>(0);
        private Map<Long, Long> supOrgMap = new HashMap<Long, Long>(16);

        private RestoreOpDataContext(Collection<Long> allCuOrgIds) {
            QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", (Object)BaseDataRelBitRestoreService.this.ctrlViewId), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("org.id", "in", allCuOrgIds)};
            try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org_structure", "org.id, parent.id", filters);){
                for (Row row : ds) {
                    this.supOrgMap.put(row.getLong("org.id"), row.getLong("parent.id"));
                }
            }
            this.initShareTypeData(BaseDataRelBitRestoreService.this.entity);
        }

        private void initShareTypeData(String entity) {
            BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
            String billStatusKey = dt.getBillStatus();
            boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fbitindex, fcreateorgid, fctrlstrategy", new Object[0]);
            if (!isIgnoreStatus) {
                String statusField = dt.getProperty(billStatusKey).getAlias();
                builder.append(", ", new Object[0]).append(statusField, new Object[0]);
            }
            builder.append("from", new Object[0]).append(dt.getAlias(), new Object[0]).append(" where ", new Object[0]).append("fctrlstrategy in ('5', '6')", new Object[0]);
            DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
                while (rs.next()) {
                    int index = rs.getInt("fbitindex");
                    if (0 == index) continue;
                    String ctrlStrategy = rs.getString("fctrlstrategy");
                    Long createOrgId = rs.getLong("fcreateorgid");
                    if (isIgnoreStatus) {
                        if ("5".equals(ctrlStrategy)) {
                            this.auditShares.add(index);
                            continue;
                        }
                        this.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                        continue;
                    }
                    String statusField = dt.getProperty(billStatusKey).getAlias();
                    if (BillStatus.C.name().equals(rs.getString(statusField))) {
                        if ("5".equals(ctrlStrategy)) {
                            this.auditShares.add(index);
                            continue;
                        }
                        this.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                        continue;
                    }
                    if ("5".equals(ctrlStrategy)) {
                        this.unAuditShareMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                        continue;
                    }
                    this.unAuditCuShareMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(index);
                }
                return true;
            });
        }
    }

    private class SolidifyRunnable
    implements Runnable {
        private Map<Long, BaseDataUseRelBit> useRelBitMap;
        private Collection<Long> orgIds;
        private DBRoute route;
        private String insertSql;
        private RestoreOpDataContext context;

        private SolidifyRunnable(String tableName, Map<Long, BaseDataUseRelBit> useRelBitMap, Collection<Long> orgIds, DBRoute route) {
            this.useRelBitMap = useRelBitMap;
            this.orgIds = orgIds;
            this.route = route;
            this.insertSql = "insert into " + tableName + " (fid, fbitindex, fuseorgid) values (?, ?, ?);";
        }

        @Override
        public void run() {
            LOGGER.info("--------------\u5f02\u6b65\u56fa\u5316\u4efb\u52a1\u5f00\u59cb\u6267\u884c--------------------");
            this.context = new RestoreOpDataContext(this.orgIds);
            for (Map.Entry<Long, BaseDataUseRelBit> entry : this.useRelBitMap.entrySet()) {
                if (BaseDataRelBitRestoreService.isStop(BaseDataRelBitRestoreService.this.entity)) {
                    this.context.stop = true;
                    return;
                }
                this.executeOrgRelBitSolidify(entry.getKey(), entry.getValue());
            }
            this.updateSolidifyStatus();
            LOGGER.info("--------------\u5f02\u6b65\u56fa\u5316\u4efb\u52a1\u6267\u884c\u7ed3\u675f--------------------");
        }

        private void executeOrgRelBitSolidify(Long orgId, BaseDataUseRelBit value) {
            SolidifyProgressInfo info = BaseDataRelBitRestoreService.getSolidifyProgressInfo(BaseDataRelBitRestoreService.this.entity);
            if (null == info) {
                LOGGER.error("\u8fdb\u5ea6\u4fe1\u606f\u4e22\u5931.", (Throwable)new KDBizException("progress information loss."));
                return;
            }
            try {
                LOGGER.info("--------------\u5f00\u59cb\u6267\u884c\u7ec4\u7ec7\u3010" + orgId + "\u3011\u7684\u56fa\u5316\u8fd8\u539f--------------------");
                BaseDataRelBitRestoreService.this.insert(this.context, this.insertSql, orgId, value.getBit(), this.route);
                if (this.context.stop) {
                    return;
                }
                info.incr(1);
                BaseDataRelBitRestoreService.this.cacheSolidifyProgressInfo(info);
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u56fa\u5316\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\u5f02\u5e38\uff0c\u3010%s\u3011", orgId), (Throwable)e);
                info.setMessage(e.getMessage());
                info.setSuccess(false);
                BaseDataRelBitRestoreService.this.cacheSolidifyProgressInfo(info);
            }
        }

        private void updateSolidifyStatus() {
            QFilter[] filters = new QFilter[]{new QFilter("basedataid", "=", (Object)BaseDataRelBitRestoreService.this.entity)};
            String prop = "solidifystatus";
            DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)prop, (QFilter[])filters);
            config.set(prop, (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
            BaseDataRelBitRestoreService.this.reset();
        }
    }
}

