/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataRepairService {
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    private static Log logger = LogFactory.getLog(BaseDataRepairService.class);
    private static final String ENABLE = "enable";
    private static final String NUMBER = "number";
    private static final String CTRLVIEW_TREETYPE = "ctrlview.treetype";
    private static final String ENTITYID_BASEDATAVIEW = "bd_basedataview";
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String CREATEORG_ID = "createorg.id";
    private static final String PARENT_ID = "parent.id";

    public boolean checkHasDuplicateData(String entityType) {
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityType);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        String baseDataTableName = dt.getAlias();
        String useRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
        StringBuilder builder = new StringBuilder();
        builder.append(" select top 1 u.FUseOrgID forgid , t.").append(masterIdFieldName).append(" ").append(masterIdFieldName);
        builder.append(", count(t.").append(masterIdFieldName).append(") from ");
        builder.append(useRangeTableName).append(" u inner join ").append(baseDataTableName);
        builder.append(" t on u.FDataID = t.fid group by u.FUseOrgID, t.").append(masterIdFieldName);
        builder.append(" having count(t.").append(masterIdFieldName).append(") > 1 ");
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        try (DataSet ds = DB.queryDataSet((String)BaseDataRepairService.class.getName(), (DBRoute)dbRoute, (String)builder.toString(), (Object[])new Object[0]);){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    public boolean dataRepair(String entityType) {
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityType);
        if (StringUtils.isEmpty((CharSequence)masterIdFieldName)) {
            return false;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        String baseDataTableName = dt.getAlias();
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        this.fixMasterId(entityType, masterIdFieldName, baseDataTableName, dbRoute);
        String baseDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
        String baseDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
        this.repairSelfCreateData(dbRoute, baseDataTableName, baseDataExcTableName, baseDataUseRangeTableName);
        this.repairSelCreateUnSaveUseRange(dbRoute, baseDataTableName, baseDataUseRangeTableName);
        BaseDataCtrlCacheMrg.clearCache((String)(BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityType));
        boolean hasDuplicateData = this.checkHasDuplicateData(entityType);
        if (!hasDuplicateData) {
            return true;
        }
        this.deleteExcedUseRange(dbRoute, baseDataUseRangeTableName, baseDataExcTableName);
        this.repairDupUseRang(entityType, dbRoute, baseDataTableName, baseDataExcTableName, baseDataUseRangeTableName, null, null);
        return true;
    }

    private void fixMasterId(String entityType, String masterIdFieldName, String tableName, DBRoute dbRoute) {
        if (BaseDataCommonService.isOtherMasterIdType(entityType) && ("FMASTERID".equalsIgnoreCase(masterIdFieldName) || "MASTERID".equalsIgnoreCase(BaseDataServiceHelper.getMasterIdPropName((String)entityType)))) {
            String msg = ResManager.loadKDString((String)"\u8be5\u57fa\u7840\u8d44\u6599\u5bf9\u5e94\u7684\u7ba1\u63a7\u7b56\u7565masterId\u76f8\u5173\u5c5e\u6027\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataRepairService_0", (String)"bos-bd-business", (Object[])new Object[0]);
            KDBizException e = new KDBizException(msg);
            logger.error((Throwable)e);
            throw e;
        }
        StringBuilder fixMasterIdSql = new StringBuilder();
        fixMasterIdSql.append(" Update ").append(tableName).append(" set ").append(masterIdFieldName);
        fixMasterIdSql.append(" = fid where ").append(masterIdFieldName).append(" = 0 ");
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)fixMasterIdSql.toString());
        }
    }

    private void repairSelCreateUnSaveUseRange(DBRoute dbRoute, String baseDataTableName, String bsaeDataUseRangeTableName) {
        StringBuilder insertUseRangeSql = new StringBuilder();
        insertUseRangeSql.append(" insert into ").append(bsaeDataUseRangeTableName);
        insertUseRangeSql.append(" (fdataid, fcreateorgid, fuseorgid) ");
        insertUseRangeSql.append("select t.fid fdataid, t.fcreateorgid fcreateorgid,t.fcreateorgid fuseorgid from ");
        insertUseRangeSql.append(baseDataTableName).append(" t ");
        insertUseRangeSql.append("where not exists ");
        insertUseRangeSql.append("(select fdataid from ").append(bsaeDataUseRangeTableName).append(" u ");
        insertUseRangeSql.append("where u.FDataID = t.fid and u.FUseOrgID = t.FCREATEORGID)");
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)insertUseRangeSql.toString());
        }
    }

    private void repairSelfCreateData(DBRoute dbRoute, String baseDataTableName, String bsaeDataExcTableName, String bsaeDataUseRangeTableName) {
        StringBuilder insertUseRangeSql = new StringBuilder();
        insertUseRangeSql.append(" insert into ").append(bsaeDataUseRangeTableName).append(" (fdataid, fcreateorgid, fuseorgid) ").append(" select fdataid, fcreateorgid, fuseorgid from ").append(bsaeDataExcTableName).append(" e where exists(select fid from ").append(baseDataTableName).append(" where fcreateorgid = fuseorgid and fid = fdataid) ").append(" and not exists (select fdataid from ").append(bsaeDataUseRangeTableName).append(" u where u.FUseOrgID = e.FUSEORGID and u.FDataID = e.FDATAID) ");
        StringBuilder deleteExcSql = new StringBuilder();
        deleteExcSql.append(" delete from ").append(bsaeDataExcTableName).append(" where exists(select fid from ").append(baseDataTableName).append(" where fcreateorgid = fuseorgid and fid = fdataid); ");
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)insertUseRangeSql.toString());
            DB.execute((DBRoute)dbRoute, (String)deleteExcSql.toString());
        }
    }

    public void repairDupUseRang(String entityType, List<Long> useOrgIds, List<Long> dataIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        String baseDataTableName = dt.getAlias();
        String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
        String bsaeDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
        DBRoute dbRoute = null;
        String dbRouteKey = dt.getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        this.repairDupUseRang(entityType, dbRoute, baseDataTableName, bsaeDataExcTableName, bsaeDataUseRangeTableName, useOrgIds, dataIds);
    }

    /*
     * WARNING - void declaration
     */
    public void repairDupUseRang(String entityType, DBRoute dbRoute, String baseDataTableName, String bsaeDataExcTableName, String bsaeDataUseRangeTableName, List<Long> useOrgIds, List<Long> masterIds) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        if (null == ctrlview) {
            return;
        }
        Map<String, Set<String>> useOrgDataMap = this.queryDupUseRange(entityType, dbRoute, bsaeDataUseRangeTableName, useOrgIds, masterIds);
        if (useOrgDataMap.size() == 0) {
            return;
        }
        Long orgViewId = (Long)ctrlview.getPkValue();
        HashMap<String, String> orgLongNumberMap = new HashMap<String, String>(16);
        StringBuilder orgLongNumberSql = new StringBuilder(" select forgid, flongnumber from t_org_structure where fviewid = ?");
        ArrayList<Long> params = new ArrayList<Long>(16);
        params.add(orgViewId);
        HashSet<Long> allOrgs = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(useOrgIds)) {
            allOrgs.addAll(useOrgIds);
        }
        HashSet<Long> allDataIds = new HashSet<Long>(16);
        String[] strArr = null;
        Set<String> tempDataIdSet = null;
        Long tempUseOrgID = null;
        Long tempCreateOrgID = null;
        for (Map.Entry<String, Set<String>> entry : useOrgDataMap.entrySet()) {
            String key = entry.getKey();
            tempDataIdSet = entry.getValue();
            strArr = key.split("_");
            tempUseOrgID = Long.parseLong(strArr[0]);
            allOrgs.add(tempUseOrgID);
            for (String value : tempDataIdSet) {
                strArr = value.split("_");
                tempCreateOrgID = Long.parseLong(strArr[0]);
                allOrgs.add(tempCreateOrgID);
                allDataIds.add(Long.valueOf(strArr[1]));
            }
        }
        Set<Long> enableDataIds = this.getEnableDataIds(allDataIds, dbRoute, baseDataTableName);
        StringBuilder useOrgParams = new StringBuilder();
        if (!CollectionUtils.isEmpty(allOrgs)) {
            allOrgs.stream().forEach(orgId -> useOrgParams.append("?,"));
            orgLongNumberSql.append(" and FOrgID in(").append(useOrgParams.substring(0, useOrgParams.length() - 1)).append(")");
            params.addAll(allOrgs);
        }
        DataSet ds = DB.queryDataSet((String)BaseDataRepairService.class.getName(), (DBRoute)DBRoute.base, (String)orgLongNumberSql.toString(), (Object[])params.toArray(new Object[0]));
        Object object = null;
        try {
            Long orgID = null;
            String longNumber = null;
            for (Row row : ds) {
                orgID = row.getLong("forgid");
                longNumber = row.getString("flongnumber");
                orgLongNumberMap.put(orgID.toString(), longNumber);
            }
        }
        catch (Throwable orgID) {
            object = orgID;
            throw orgID;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable orgID) {
                        ((Throwable)object).addSuppressed(orgID);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Set<String> dataIdSet = null;
        String[] strArray = null;
        String useOrgIDStr = null;
        String createOrgIDStr = null;
        String dataIDStr = null;
        Long useOrgID = null;
        Long createOrgID = null;
        Long dataID = null;
        String insertExcSql = "insert into " + bsaeDataExcTableName + " (FUSEORGID, FDATAID, FCREATEORGID) values(?,?,?)";
        String bsaeDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String deleteUseRegSql = "delete from " + bsaeDataUseRegTableName + " where FUseOrgID = ? and FDataID = ?";
        String deleteUseRangeSql = "delete from " + bsaeDataUseRangeTableName + " where FUseOrgID = ? and FDataID = ?";
        ArrayList<Object[]> insertExcParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> deleteParamList = new ArrayList<Object[]>();
        HashSet<String> createOrgSet = new HashSet<String>(16);
        for (Map.Entry<String, Set<String>> entry : useOrgDataMap.entrySet()) {
            String key = entry.getKey();
            dataIdSet = entry.getValue();
            strArray = key.split("_");
            useOrgIDStr = strArray[0];
            useOrgID = Long.parseLong(useOrgIDStr);
            boolean isSameCreataorg = false;
            createOrgSet.clear();
            String lastCreateOrg = null;
            Long maxId = 0L;
            for (String string : dataIdSet) {
                strArray = string.split("_");
                createOrgIDStr = strArray[0];
                dataIDStr = strArray[1];
                createOrgID = Long.parseLong(createOrgIDStr);
                dataID = Long.parseLong(dataIDStr);
                createOrgSet.add(createOrgIDStr);
                if (maxId.equals(0L)) {
                    maxId = dataID;
                }
                if (!isSameCreataorg && createOrgIDStr.equals(lastCreateOrg)) {
                    isSameCreataorg = true;
                }
                lastCreateOrg = createOrgIDStr;
                if (dataID <= maxId) continue;
                maxId = dataID;
            }
            if (createOrgSet.size() == 1) {
                isSameCreataorg = true;
            }
            if (isSameCreataorg) {
                Object orgDataIdStr22;
                if (dataIdSet.size() == 1) continue;
                boolean isMaxDataEnable = enableDataIds.contains(maxId);
                if (isMaxDataEnable) {
                    for (Object orgDataIdStr22 : dataIdSet) {
                        String[] stringArray = ((String)orgDataIdStr22).split("_");
                        createOrgID = Long.valueOf(stringArray[0]);
                        dataID = Long.valueOf(stringArray[1]);
                        if (maxId.equals(dataID)) continue;
                        insertExcParamList.add(new Object[]{useOrgID, dataID, createOrgID});
                        deleteParamList.add(new Object[]{useOrgID, dataID});
                    }
                    continue;
                }
                HashSet<Long> hashSet = new HashSet<Long>(dataIdSet.size());
                orgDataIdStr22 = dataIdSet.iterator();
                while (orgDataIdStr22.hasNext()) {
                    String string = (String)orgDataIdStr22.next();
                    String[] orgDataArr = string.split("_");
                    createOrgID = Long.valueOf(orgDataArr[0]);
                    dataID = Long.valueOf(orgDataArr[1]);
                    hashSet.add(dataID);
                }
                Long enableData = 0L;
                for (Long excDataId2 : hashSet) {
                    if (!enableDataIds.contains(excDataId2)) continue;
                    enableData = excDataId2;
                    break;
                }
                if (enableData.equals(0L)) {
                    for (Long excDataId : hashSet) {
                        if (excDataId.equals(maxId)) continue;
                        insertExcParamList.add(new Object[]{useOrgID, excDataId, createOrgID});
                        deleteParamList.add(new Object[]{useOrgID, excDataId});
                    }
                } else {
                    for (Long excDataId : hashSet) {
                        if (enableData.equals(excDataId)) continue;
                        insertExcParamList.add(new Object[]{useOrgID, excDataId, createOrgID});
                        deleteParamList.add(new Object[]{useOrgID, excDataId});
                    }
                }
            } else {
                String maxLongNumber = "";
                Long l = 0L;
                for (String string : dataIdSet) {
                    strArray = string.split("_");
                    createOrgIDStr = strArray[0];
                    dataIDStr = strArray[1];
                    createOrgID = Long.parseLong(createOrgIDStr);
                    dataID = Long.parseLong(dataIDStr);
                    String longNumber = (String)orgLongNumberMap.get(createOrgIDStr);
                    if (createOrgID.equals(useOrgID)) {
                        maxLongNumber = longNumber;
                        Long l2 = createOrgID;
                        break;
                    }
                    boolean isSupOrg = OrgUnitServiceHelper.isParentOrg((String)ctrlview.getString(NUMBER), (long)createOrgID, (long)useOrgID);
                    if (longNumber == null || longNumber.length() <= maxLongNumber.length() || !isSupOrg) continue;
                    maxLongNumber = longNumber;
                    Long l3 = createOrgID;
                }
                for (String string : dataIdSet) {
                    void var44_57;
                    strArray = string.split("_");
                    createOrgIDStr = strArray[0];
                    dataIDStr = strArray[1];
                    createOrgID = Long.parseLong(createOrgIDStr);
                    dataID = Long.parseLong(dataIDStr);
                    if (createOrgID.equals(var44_57)) continue;
                    deleteParamList.add(new Object[]{useOrgID, dataID});
                }
            }
            if (insertExcParamList.size() >= 1000) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertExcSql, insertExcParamList);
                insertExcParamList.clear();
            }
            if (deleteParamList.size() < 1000) continue;
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql, deleteParamList);
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, deleteParamList);
            deleteParamList.clear();
        }
        if (!insertExcParamList.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)insertExcSql, insertExcParamList);
        }
        if (!deleteParamList.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql, deleteParamList);
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, deleteParamList);
        }
    }

    private Set<Long> getEnableDataIds(Set<Long> dataIds, DBRoute route, String tableName) {
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("select fid from %s where fenable = '1' ", tableName), new Object[0]).append(" and ", new Object[0]);
        builder.appendIn("fid", dataIds.toArray());
        return (Set)DB.query((DBRoute)route, (SqlBuilder)builder, rs -> {
            HashSet<Long> enableDataIds = new HashSet<Long>(16);
            while (rs.next()) {
                enableDataIds.add(rs.getLong("fid"));
            }
            return enableDataIds;
        });
    }

    private Map<String, Set<String>> queryDupUseRange(String entityType, DBRoute dbRoute, String baseDataUseRangeTableName, List<Long> useOrgIds, List<Long> masterIds) {
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityType);
        QFilter[] qFilters = CollectionUtils.isEmpty(masterIds) ? new QFilter[]{QFilter.of((String)("id <> " + masterIdPropName), (Object[])new Object[0])} : new QFilter[]{new QFilter(masterIdPropName, "in", masterIds), QFilter.of((String)("id <> " + masterIdPropName), (Object[])new Object[0])};
        String selectFields = BaseDataRepairService.getSelectField("id", masterIdPropName, "createorg");
        DynamicObjectCollection individualizedDataCol = QueryServiceHelper.query((String)entityType, (String)selectFields, (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)individualizedDataCol)) {
            return Collections.emptyMap();
        }
        Set individualizedMasterIds = individualizedDataCol.stream().map(data -> data.getLong(masterIdPropName)).collect(Collectors.toSet());
        QFilter[] masterIdFilters = new QFilter[]{new QFilter(masterIdPropName, "in", individualizedMasterIds)};
        DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityType, (String)selectFields, (QFilter[])masterIdFilters);
        Map<Object, DynamicObject> idDataMap = dataCol.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data));
        HashMap<String, Set> useOrgDataMap = new HashMap<String, Set>(100000);
        ArrayList<Object> individualizedDataIds = new ArrayList<Object>(idDataMap.keySet());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fdataid,fuseorgid from ", new Object[0]).append(baseDataUseRangeTableName, new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.appendIn(" fdataid", individualizedDataIds);
        if (!CollectionUtils.isEmpty(useOrgIds)) {
            sqlBuilder.append(" and ", new Object[0]);
            sqlBuilder.appendIn("fuseorgid", useOrgIds.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)BaseDataRepairService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);){
            for (Row row : ds) {
                Long dataID = row.getLong("fdataid");
                Long useOrgID = row.getLong("fuseorgid");
                DynamicObject data2 = idDataMap.get(dataID);
                Long masterID = null != data2 ? data2.getLong(masterIdPropName) : 0L;
                Long createOrgID = null != data2 ? BaseDataCommonService.getLongPropertyFromDynamicObject(data2, "createorg") : 0L;
                String key = useOrgID + "_" + masterID;
                String value = createOrgID + "_" + dataID;
                useOrgDataMap.computeIfAbsent(key, k -> new HashSet()).add(value);
            }
        }
        return useOrgDataMap.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String getSelectField(String ... props) {
        StringJoiner stringJoiner = new StringJoiner(",");
        Stream.of(props).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private void deleteExcedUseRange(DBRoute dbRoute, String bsaeDataUseRangeTableName, String bsaeDataExcTableName) {
        StringBuilder deleteExcedUseRangeSql = new StringBuilder();
        deleteExcedUseRangeSql.append(" DELETE FROM ").append(bsaeDataUseRangeTableName);
        deleteExcedUseRangeSql.append(" AS u WHERE EXISTS (SELECT e.fdataid FROM ").append(bsaeDataExcTableName);
        deleteExcedUseRangeSql.append(" AS e WHERE (u.FUseOrgID=e.FUSEORGID AND u.FDataID=e.FDATAID)) ");
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)deleteExcedUseRangeSql.toString());
        }
    }

    public void fixExcTable(String entityID, List<Long> orgIDs) {
        List<Object[]> fixHistoryExcList = this.getUnInsertExcHistory(entityID, orgIDs);
        if (fixHistoryExcList.size() > 0) {
            String dbRouteKey = ORM.create().getDataEntityType(entityID).getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            String baseDataTableName = ORM.create().getDataEntityType(entityID).getAlias();
            String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
            String bsaeDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
            StringBuilder insertExcSQL = new StringBuilder();
            insertExcSQL.append("insert into ").append(bsaeDataExcTableName);
            insertExcSQL.append("(fuseorgid, fdataid, fcreateorgid) values (?,?,?)");
            DB.executeBatch((DBRoute)dbRoute, (String)insertExcSQL.toString(), fixHistoryExcList);
            StringBuilder deleteUseRangeql = new StringBuilder();
            deleteUseRangeql.append("delete from ").append(bsaeDataUseRangeTableName);
            deleteUseRangeql.append(" where FDataID = ? and fuseorgid = ? ");
            ArrayList<Object[]> parmList = new ArrayList<Object[]>(fixHistoryExcList.size());
            for (Object[] objArr : fixHistoryExcList) {
                Object useOrgId = objArr[0];
                Object dataId = objArr[1];
                parmList.add(new Object[]{dataId, useOrgId});
            }
            try (TXHandle h = TX.required();){
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeql.toString(), parmList);
            }
        }
    }

    public List<Object[]> getUnInsertExcHistory(String entityID, List<Long> uesOrgIDs) {
        String masteridFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityID);
        String baseDataTableName = ORM.create().getDataEntityType(entityID).getAlias();
        String dbRouteKey = ORM.create().getDataEntityType(entityID).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String bsaeDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
        Object[] paramList = new Object[]{};
        StringBuilder sql = new StringBuilder();
        sql.append("select ur.fuseorgid fuseorgid, ur.fdataid fdataid, ur.fcreateorgid fcreateorgid from ");
        sql.append(bsaeDataUseRegTableName).append(" ur ");
        sql.append("inner join ").append(baseDataTableName).append(" s ");
        sql.append("on s.fid = ur.fdataid and ur.fisassign = '1' ");
        sql.append("inner join ").append(baseDataTableName).append(" t");
        sql.append(" on t.").append(masteridFieldName).append(" = s.").append(masteridFieldName);
        sql.append(" and t.fcreateorgid = ur.fuseorgid ");
        sql.append("where ");
        if (!uesOrgIDs.isEmpty()) {
            sql.append("ur.fuseorgid in(");
            for (int i = 0; i < uesOrgIDs.size(); ++i) {
                sql.append(uesOrgIDs.get(i));
                if (i >= uesOrgIDs.size() - 1) continue;
                sql.append(',');
            }
            sql.append(") and");
        }
        sql.append(" ur.fisassign = '1' and not exists ");
        sql.append("(select fdataid,fcreateorgid,fuseorgid from ");
        sql.append(bsaeDataExcTableName).append(" exc ");
        sql.append("where exc.fuseorgid = ur.fuseorgid and exc.fdataid = ur.fdataid);");
        return (List)DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])paramList, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> resultList = new ArrayList<Object[]>(rs.getFetchSize());
                while (rs.next()) {
                    Object[] resultObj = new Object[]{rs.getLong(1), rs.getLong(2), rs.getLong(3)};
                    resultList.add(resultObj);
                }
                return resultList;
            }
        });
    }

    public void fixTreeBasedataLeaf(String entityID) {
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityID);
        String masteridFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityID);
        StringBuilder getAllErrorDataSQL = new StringBuilder();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        DBRoute dbRoute = null;
        String dbRouteKey = dt.getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        String baseDataTableName = dt.getAlias();
        getAllErrorDataSQL.append("select t.fid as pfid,t.").append(masteridFieldName);
        getAllErrorDataSQL.append(" as ").append(masteridFieldName).append(",t.fnumber as pfnumber,t.fcreateorgid as pfcreateorgid,t.fctrlstrategy as pfctrlstrategy,");
        getAllErrorDataSQL.append(" t.fparentid as pfparentid,t.fisleaf as pfisleaf,a.fid,a.fcreateorgid,a.fparentid,a.fisleaf,a.fctrlstrategy");
        getAllErrorDataSQL.append(" from ").append(baseDataTableName);
        getAllErrorDataSQL.append(" t inner join ").append(baseDataTableName);
        getAllErrorDataSQL.append(" a on t.fid = a.fparentid");
        getAllErrorDataSQL.append(" where t.fcreateorgid <> a.fcreateorgid and t.fctrlstrategy <> '5'");
        ArrayList<DynamicObject[]> allErrorDatas = new ArrayList<DynamicObject[]>(1000);
        ArrayList<Long> pIds = new ArrayList<Long>(1000);
        ArrayList<Long> masterids = new ArrayList<Long>(1000);
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)getAllErrorDataSQL.toString(), null);){
            for (Row row : ds) {
                Long pId = row.getLong("pfid");
                Long masterid = row.getLong(masteridFieldName);
                String pNumber = row.getString("pfnumber");
                Long pCreateOrgId = row.getLong("pfcreateorgid");
                String pCtrlstrategy = row.getString("pfctrlstrategy");
                Long pParentId = row.getLong("pfparentid");
                String pIsleaf = row.getString("pfisleaf");
                Long l = row.getLong("fid");
                Long createOrgId = row.getLong("fcreateorgid");
                Long parentId = row.getLong("fparentid");
                Long isLeaf = row.getLong("fisleaf");
                Long ctrlstrategy = row.getLong("fctrlstrategy");
                DynamicObject[] tempMap = new HashMap<String, Object>(12);
                tempMap.put("pfid", pId);
                tempMap.put(masteridFieldName, masterid);
                tempMap.put("pfnumber", pNumber);
                tempMap.put("pfcreateorgid", pCreateOrgId);
                tempMap.put("pfctrlstrategy", pCtrlstrategy);
                tempMap.put("pfparentid", pParentId);
                tempMap.put("pfisleaf", pIsleaf);
                tempMap.put("fid", l);
                tempMap.put("fcreateorgid", createOrgId);
                tempMap.put("fparentid", parentId);
                tempMap.put("fisleaf", isLeaf);
                tempMap.put("fctrlstrategy", ctrlstrategy);
                allErrorDatas.add(tempMap);
                pIds.add(pId);
                masterids.add(masterid);
            }
        }
        if (!CollectionUtils.isEmpty(allErrorDatas)) {
            Map baseDatas = BusinessDataServiceHelper.loadFromCache((Object[])pIds.toArray(), (String)entityID);
            String selectProps = "id,createorg," + masteridPropName;
            QFilter filter3 = new QFilter(masteridPropName, "in", masterids);
            QFilter[] allFilters = new QFilter[]{filter3};
            DynamicObject[] alldatas = BusinessDataServiceHelper.load((String)entityID, (String)selectProps, (QFilter[])allFilters);
            String selectProperties2 = "id," + masteridPropName + ",parent,createorg.id";
            QFilter filter2 = new QFilter(PARENT_ID, "in", pIds);
            QFilter[] filters2 = new QFilter[]{filter2};
            DynamicObject[] childs = BusinessDataServiceHelper.load((String)entityID, (String)selectProperties2, (QFilter[])filters2);
            Long pfid = 0L;
            for (Map map : allErrorDatas) {
                Long pCreateOrgId;
                DynamicObject tempChild;
                DynamicObject baseData = (DynamicObject)baseDatas.get(map.get("pfid"));
                if (null == baseData || null != (tempChild = this.getChilds(pfid = Long.valueOf(String.valueOf(map.get("pfid"))), childs, pCreateOrgId = Long.valueOf(map.get("pfcreateorgid").toString())))) continue;
                baseData.set("useorg", (Object)pCreateOrgId);
                baseData.set("isleaf", (Object)"0");
                boolean ifIdentify = false;
                for (DynamicObject dynamicObject : alldatas) {
                    if (!pCreateOrgId.equals(Long.valueOf(dynamicObject.get(CREATEORG_ID).toString())) || !baseData.get(masteridPropName).equals(dynamicObject.get(masteridPropName))) continue;
                    ifIdentify = true;
                }
                if (ifIdentify) continue;
                BaseDataServiceHelper.handleModify((DynamicObject)baseData);
            }
            String selectProperties = "id,createorg," + masteridPropName;
            QFilter qFilter = new QFilter(masteridPropName, "in", masterids);
            QFilter[] filters = new QFilter[]{qFilter};
            DynamicObject[] newParents = BusinessDataServiceHelper.load((String)entityID, (String)selectProperties, (QFilter[])filters);
            ArrayList<Object[]> params = new ArrayList<Object[]>(allErrorDatas.size());
            for (Map map : allErrorDatas) {
                DynamicObject baseData = (DynamicObject)baseDatas.get(map.get("pfid"));
                if (null == baseData) continue;
                Long l = Long.valueOf(map.get(masteridFieldName).toString());
                Long id = Long.valueOf(map.get("fid").toString());
                Long createorg = Long.valueOf(map.get("fcreateorgid").toString());
                Long newParentId = this.getNewParentId(l, createorg, newParents, masteridPropName);
                if (null == newParentId) continue;
                Object[] param = new Object[]{newParentId, id, createorg};
                params.add(param);
            }
            if (!CollectionUtils.isEmpty(params)) {
                StringBuilder updateParentIdSQL = new StringBuilder();
                updateParentIdSQL.append("update ").append(baseDataTableName);
                updateParentIdSQL.append(" set fparentid  = ? where fid  = ? and fcreateorgid = ?");
                DB.executeBatch((DBRoute)dbRoute, (String)updateParentIdSQL.toString(), params);
            }
            ArrayList<Long> updateLeafParamsList = new ArrayList<Long>();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map map : allErrorDatas) {
                Long pid;
                DynamicObject tempChild;
                DynamicObject baseData = (DynamicObject)baseDatas.get(map.get("pfid"));
                if (null == baseData || null != (tempChild = this.getChilds(pid = Long.valueOf(map.get("pfid").toString()), childs))) continue;
                updateLeafParamsList.add(pid);
                stringBuilder.append("?,");
            }
            if (!CollectionUtils.isEmpty(updateLeafParamsList)) {
                SqlBuilder updateIsLeafSQL = new SqlBuilder();
                updateIsLeafSQL.append("update ", new Object[0]).append(baseDataTableName, new Object[0]);
                updateIsLeafSQL.append(" set  fisleaf  = '1'  where ", new Object[0]);
                updateIsLeafSQL.appendIn("fid", updateLeafParamsList);
                DB.execute((DBRoute)dbRoute, (SqlBuilder)updateIsLeafSQL);
            }
        }
        StringBuilder getHaveNoParentSQL = new StringBuilder();
        getHaveNoParentSQL.append("select fid from ").append(baseDataTableName);
        getHaveNoParentSQL.append(" p where fisleaf = '0' and not exists ( select fid from ");
        getHaveNoParentSQL.append(baseDataTableName);
        getHaveNoParentSQL.append(" c where c.fparentid = p.fid and c.fcreateorgid = p.fcreateorgid)");
        ArrayList<Long> haveNoParentList = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)getHaveNoParentSQL.toString(), null);){
            for (Row row : ds) {
                Long id = row.getLong("fid");
                haveNoParentList.add(id);
            }
        }
        if (!CollectionUtils.isEmpty(haveNoParentList)) {
            SqlBuilder updateIsLeafSQL = new SqlBuilder();
            updateIsLeafSQL.append("update ", new Object[0]).append(baseDataTableName, new Object[0]);
            updateIsLeafSQL.append(" set  fisleaf  = '1'  where ", new Object[0]);
            updateIsLeafSQL.appendIn("fid", haveNoParentList);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)updateIsLeafSQL);
        }
    }

    private DynamicObject getChilds(Long pid, DynamicObject[] childs) {
        for (DynamicObject child : childs) {
            if (!pid.equals(child.get(PARENT_ID))) continue;
            return child;
        }
        return null;
    }

    private DynamicObject getChilds(Long pid, DynamicObject[] childs, Long createOrgId) {
        for (DynamicObject child : childs) {
            if (!pid.equals(child.get(PARENT_ID)) || !createOrgId.equals(child.getLong(CREATEORG_ID))) continue;
            return child;
        }
        return null;
    }

    private Long getNewParentId(Long masterid, Long createorg, DynamicObject[] newParents, String masteridPropName) {
        Long newParentId = null;
        for (DynamicObject newParent : newParents) {
            Long newParentCreateOrgId = Long.valueOf(newParent.get(CREATEORG_ID).toString());
            Long newParentMasterId = newParent.getLong(masteridPropName);
            if (null == newParent.getPkValue() || !createorg.equals(newParentCreateOrgId) || !masterid.equals(newParentMasterId)) continue;
            newParentId = Long.valueOf(newParent.getPkValue().toString());
            return newParentId;
        }
        return newParentId;
    }

    public boolean checkIsLackingOfData(String entityType) {
        boolean hasSameMasterIdInUseRange;
        boolean isLackingOfData = false;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        String baseDataTableName = dt.getAlias();
        String bsaeDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
        String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
        DBRoute dbRoute = null;
        String dbRouteKey = dt.getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        String masteridFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityType);
        StringBuilder checkSql = new StringBuilder();
        checkSql.append("select t.fid dataid, t.fcreateorgid createorgid,t.fcreateorgid useorgid,t.").append(masteridFieldName).append(" masterid from ");
        checkSql.append(baseDataTableName).append(" t ");
        checkSql.append("where not exists ");
        checkSql.append("(select fdataid from ").append(bsaeDataUseRangeTableName).append(" u ");
        checkSql.append("where u.FDataID = t.fid and u.FUseOrgID = t.FCREATEORGID)");
        checkSql.append(" and not exists (select fdataid from ").append(bsaeDataExcTableName).append(" exc ");
        checkSql.append(" where exc.fdataid = t.fid and exc.fuseorgid = t.fcreateorgid)");
        ArrayList<Object[]> checkResult = new ArrayList<Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)BaseDataRepairService.class.getName(), (DBRoute)dbRoute, (String)checkSql.toString());){
            for (Row row : ds) {
                Long dataId = row.getLong("dataid");
                Long useOrgId = row.getLong("useorgid");
                Long masterid = row.getLong("masterid");
                checkResult.add(new Object[]{dataId, useOrgId, masterid});
            }
        }
        catch (Exception e) {
            logger.info("BaseDataRepairService checkIsLackingOfData ERROR:" + e);
        }
        if (!checkResult.isEmpty() && !(hasSameMasterIdInUseRange = this.checkHasSameMasterIdInUseRange(checkResult, dbRoute, baseDataTableName, bsaeDataUseRangeTableName, masteridFieldName))) {
            isLackingOfData = true;
        }
        return isLackingOfData;
    }

    private boolean checkHasSameMasterIdInUseRange(List<Object[]> checkParams, DBRoute dbRoute, String baseDataTableName, String bsaeDataUseRangeTableName, String masteridFieldName) {
        ArrayList<Object> useOrgIds = new ArrayList<Object>(checkParams.size());
        ArrayList<Object> masterIds = new ArrayList<Object>(checkParams.size());
        for (Object[] param : checkParams) {
            useOrgIds.add(param[1]);
            masterIds.add(param[2]);
        }
        SqlBuilder checkSql = new SqlBuilder();
        checkSql.append("select t.fid dataid,u.fuseorgid useorgid,t.", new Object[0]).append(masteridFieldName, new Object[0]).append(" masterid from ", new Object[0]);
        checkSql.append(baseDataTableName, new Object[0]);
        checkSql.append(" t inner join ", new Object[0]).append(bsaeDataUseRangeTableName, new Object[0]);
        checkSql.append(" u on t.fid = u.fdataid where ", new Object[0]);
        checkSql.appendIn("u.fuseorgid", useOrgIds);
        checkSql.append(" and ", new Object[0]);
        checkSql.appendIn(String.format("t.%s", masteridFieldName), masterIds);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            DataSet ds = DB.queryDataSet((String)BaseDataRepairService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)checkSql);
            Object object = null;
            try {
                for (Row row : ds) {
                    String dataId = row.getString("dataid");
                    String useOrgId = row.getString("useorgid");
                    String masterId = row.getString("masterid");
                    resultMap.put(useOrgId + masterId, dataId);
                }
            }
            catch (Throwable iter) {
                object = iter;
                throw iter;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iter) {
                            ((Throwable)object).addSuppressed(iter);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info("BaseDataRepairService checkHasSameMasterIdInUseRange ERROR:" + e);
        }
        boolean hasSameMasterIdInUseRange = false;
        for (Object[] param : checkParams) {
            String useOrgId = String.valueOf(param[1]);
            String masterId = String.valueOf(param[2]);
            String dataId = (String)resultMap.get(useOrgId + masterId);
            if (!StringUtils.isEmpty((CharSequence)dataId)) continue;
            return hasSameMasterIdInUseRange;
        }
        return true;
    }

    public void repairCushare(String entityID, List<Long> orgIds) {
        if (StringUtils.isEmpty((CharSequence)entityID) || CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        if (null == BaseDataServiceHelper.checkBaseDataCtrl((String)entityID)) {
            return;
        }
        int batchSize = 1000;
        if (orgIds.size() <= batchSize) {
            this.refreshBDUseRangeThread(entityID, new ArrayList<Long>(orgIds));
            return;
        }
        ArrayList<Long> batchOrgIds = new ArrayList<Long>(batchSize);
        for (Long orgId : orgIds) {
            batchOrgIds.add(orgId);
            if (batchOrgIds.size() != batchSize) continue;
            this.refreshBDUseRangeThread(entityID, batchOrgIds);
            batchOrgIds = new ArrayList(batchSize);
        }
        if (!batchOrgIds.isEmpty()) {
            this.refreshBDUseRangeThread(entityID, batchOrgIds);
        }
    }

    private void refreshBDUseRangeThread(String entityID, List<Long> orgIds) {
        try {
            ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
            pool.submit(() -> {
                BaseDataServiceHelper.refreshBaseDataUseRange((String)entityID, (List)orgIds);
                return null;
            }, RequestContext.get());
        }
        catch (Exception e) {
            logger.error("BaseDataRepairService refreshBDUseRangeThread error:", (Throwable)e);
        }
    }

    public void orgSaveHandler(List<Long> orgIds) {
        ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
        pool.submit(() -> {
            this.excuteRefreshBaseDataUseRange(orgIds);
            return null;
        }, RequestContext.get());
    }

    protected void excuteRefreshBaseDataUseRange(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((Object)orgIds.get(0), (String)"bos_org");
        String selectFields = "id,fnumber number,fname name,ffieldname,propertyname";
        QFilter qFilter1 = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        QFilter qFilter2 = new QFilter("visiable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2};
        DynamicObjectCollection orgBizCol = QueryServiceHelper.query((String)"bos_org_biz", (String)selectFields, (QFilter[])filters);
        if (orgBizCol == null || orgBizCol.isEmpty()) {
            logger.info("\u5f02\u5e38\uff0c\u7ec4\u7ec7\u804c\u80fd\u5217\u8868\u4e3a\u7a7a\u3002");
            return;
        }
        for (DynamicObject orgBiz : orgBizCol) {
            String orgType = orgBiz.getString(NUMBER);
            String propertyname = orgBiz.getString("propertyname");
            if (propertyname != null && !StringUtils.isEmpty((CharSequence)propertyname.trim()) && !orgInfo.getBoolean(propertyname)) continue;
            selectFields = "id,basedata.id entityID,ctrlview.treetype,ctrlview.id,ctrlview.number";
            QFilter orgTypeFilter = new QFilter(CTRLVIEW_TREETYPE, "=", (Object)orgType);
            filters = new QFilter[]{orgTypeFilter};
            DynamicObjectCollection baseDataTypeCol = QueryServiceHelper.query((String)ENTITYID_BASEDATAVIEW, (String)selectFields, (QFilter[])filters);
            if (baseDataTypeCol == null || baseDataTypeCol.isEmpty()) continue;
            for (DynamicObject baseDataType : baseDataTypeCol) {
                try {
                    String entityID = baseDataType.getString("entityID");
                    Long viewId = baseDataType.getLong("ctrlview.id");
                    String viewNumber = baseDataType.getString("ctrlview.number");
                    List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)viewNumber, orgIds);
                    List<Long> tempOrgs = new ArrayList<Long>(orgIds);
                    tempOrgs.addAll(superiorOrgs);
                    tempOrgs = this.getCuOrgs(viewId, tempOrgs);
                    this.repairCushare(entityID, tempOrgs);
                }
                catch (Exception e) {
                    logger.error("BaseDataRepairService excuteRefreshBaseDataUseRange error:", (Throwable)e);
                }
            }
        }
    }

    private List<Long> getCuOrgs(Long viewId, List<Long> orgIds) {
        QFilter f1 = new QFilter("org", "in", orgIds);
        QFilter f2 = new QFilter("view.id", "=", (Object)viewId);
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter f4 = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        qfilters = new QFilter[]{f1, f2, f3, f4};
        ArrayList<Long> cuOrgIds = new ArrayList<Long>(16);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(BaseDataRepairService.class.getName(), ENTITYID_ORG_STRUCTURE, "org.id", qfilters);){
            for (Row row : ds) {
                Long orgId = row.getLong("org.id");
                if (orgId == null) continue;
                cuOrgIds.add(orgId);
            }
        }
        return cuOrgIds;
    }
}

