/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgTreeOrder;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.roaringbitmap.RoaringBitmap;

class BaseDataStrategyService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataStrategyService.class);
    private Long ctrlViewId;
    private Map<Long, Integer> cusId2IndexMap = new HashMap<Long, Integer>(16);
    private Map<Long, Long> cusMstId2IdMap = new HashMap<Long, Long>(16);
    private Map<Integer, Integer> indexSrcMap = new HashMap<Integer, Integer>(16);
    private Map<Integer, Long> cusIndex2mstIdMap = new HashMap<Integer, Long>(16);

    BaseDataStrategyService(String entity) {
        this.init(entity);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        this.ctrlViewId = (Long)ctrlView.getPkValue();
    }

    void changeStrategyOnNewModel(String newStrategy, List<Long> dataIds) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String billStatusKey = dt.getBillStatus();
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        ArrayList<String> selectFields = new ArrayList<String>(Arrays.asList("ctrlstrategy", "createorg", "bitindex", this.masterIdPropName, "srcindex"));
        if (!isIgnoreStatus) {
            selectFields.add(billStatusKey);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.entity, (String)String.join((CharSequence)",", selectFields), (QFilter[])filters);
        if (null == collection || collection.length == 0) {
            return;
        }
        String currentStrategy = collection[0].getString("ctrlstrategy");
        Long createOrgId = BaseDataStrategyService.getLongPropertyFromDynamicObject(collection[0], "createorg");
        ArrayList<Integer> indexList = new ArrayList<Integer>(collection.length);
        HashSet<Integer> auditDataIndexes = new HashSet<Integer>(collection.length);
        HashSet<Integer> unAuditDataIndexes = new HashSet<Integer>(collection.length);
        for (DynamicObject data : collection) {
            data.set("ctrlstrategy", (Object)newStrategy);
            int index = data.getInt("bitindex");
            if (!isIgnoreStatus && BillStatus.C.name().equals(data.getString(billStatusKey))) {
                auditDataIndexes.add(index);
            } else {
                unAuditDataIndexes.add(index);
            }
            Long dataId = data.getLong("id");
            Long masterId = this.getLongDataFromDynamicObject(data.get(this.masterIdPropName));
            if ("6".equals(newStrategy) && !dataId.equals(masterId)) {
                this.cusId2IndexMap.put(dataId, index);
                this.cusMstId2IdMap.put(masterId, dataId);
                this.indexSrcMap.put(index, data.getInt("srcindex"));
                continue;
            }
            indexList.add(index);
        }
        int[] indexArr = this.covertIntegerList2IntArr(indexList);
        String lockKey = BaseDataStrategyService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.requiresNew((String)"base_data_change_strategy");
        try {
            switch (currentStrategy) {
                case "2": 
                case "7": 
                case "1": {
                    this.changeAssignOrPrivateToOtherType(newStrategy, createOrgId, indexArr, auditDataIndexes, unAuditDataIndexes);
                    break;
                }
                case "5": {
                    this.changeGlobalShareToOtherType(newStrategy, createOrgId, unAuditDataIndexes, auditDataIndexes);
                    break;
                }
                case "6": {
                    this.changeCuShareToOtherType(newStrategy, createOrgId, indexArr, auditDataIndexes);
                    break;
                }
            }
            SaveServiceHelper.save((DynamicObject[])collection);
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BaseDataCommonService_2", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    private void changeAssignOrPrivateToOtherType(String newStrategy, Long createOrgId, int[] indexArr, Collection<Integer> auditDataIndexes, Collection<Integer> unAuditDataIndexes) throws Exception {
        if ("5".equals(newStrategy)) {
            ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
            this.deleteBitFromOrgUseRel(this.entity, indexArr, Collections.singletonList(createOrgId), updates);
            BaseDataUseRelUpdateEngine.update(updates, this.entity);
            if (!auditDataIndexes.isEmpty() && this.asyncRecord()) {
                Set<Long> allCuOrgIds = this.getAllCuOrgByViewId(this.ctrlViewId, createOrgId);
                RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(auditDataIndexes));
                BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(allCuOrgIds.size());
                for (Long orgId : allCuOrgIds) {
                    BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                    message.add(this.createAddSolidifyMessage(bit));
                    messageDto.add(message);
                }
                this.publish(messageDto);
            }
            return;
        }
        if ("6".equals(newStrategy)) {
            if (BaseDataStrategyService.isTreeTypeBaseData(this.entity)) {
                this.changeAssignOrPrivateToCuShareType(createOrgId, this.covertIntegerList2IntArr(auditDataIndexes));
            } else {
                this.changeAssignOrPrivateToCuShareType(createOrgId, auditDataIndexes, unAuditDataIndexes);
            }
        }
    }

    private void changeAssignOrPrivateToCuShareType(Long createOrgId, Collection<Integer> auditDataIndexes, Collection<Integer> unAuditDataIndexes) throws Exception {
        ArrayList<Integer> indexes = new ArrayList<Integer>(auditDataIndexes);
        indexes.addAll(unAuditDataIndexes);
        int[] indexArr = this.covertIntegerList2IntArr(indexes);
        ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
        this.deleteBitFromOrgUseRel(this.entity, indexArr, Collections.singletonList(createOrgId), updates);
        BaseDataUseRelUpdateEngine.update(updates, this.entity);
        boolean asyncRecord = this.asyncRecord();
        if (!asyncRecord || auditDataIndexes.isEmpty()) {
            return;
        }
        Set<Long> orgIds = this.getAllCuSubordinateOrgIds(this.ctrlViewId, createOrgId);
        DynamicObjectCollection collection = this.selectCustomDataColl(createOrgId);
        if (collection.isEmpty()) {
            if (CollectionUtils.isEmpty(this.cusMstId2IdMap)) {
                this.recordSolidifyMsg(orgIds, this.covertIntegerList2IntArr(auditDataIndexes));
            } else {
                this.recordSolidifyMsg(auditDataIndexes, orgIds, this.covertIntegerList2IntArr(this.indexSrcMap.values()));
            }
            return;
        }
        HashMap<Long, List<Integer>> otherOrgCustomDataMap = new HashMap<Long, List<Integer>>(collection.size());
        for (DynamicObject data : collection) {
            Long customOrgId = data.getLong("createorg");
            int bitIndex = data.getInt("bitindex");
            otherOrgCustomDataMap.computeIfAbsent(customOrgId, k -> new ArrayList(10)).add(bitIndex);
            this.indexSrcMap.put(bitIndex, data.getInt("srcindex"));
            this.cusIndex2mstIdMap.put(bitIndex, data.getLong(this.masterIdPropName));
        }
        HashSet<Long> customOrgIds = new HashSet<Long>(otherOrgCustomDataMap.keySet());
        customOrgIds.retainAll(orgIds);
        if (customOrgIds.isEmpty()) {
            HashSet<Integer> deletes = new HashSet<Integer>(this.indexSrcMap.values());
            this.indexSrcMap.keySet().removeAll(this.cusId2IndexMap.values());
            deletes.addAll(this.indexSrcMap.keySet());
            this.recordSolidifyMsg(auditDataIndexes, orgIds, this.covertIntegerList2IntArr(deletes));
            return;
        }
        this.changeStrategyToCuShareTypeIncludeCustomData(orgIds, otherOrgCustomDataMap, auditDataIndexes, customOrgIds);
    }

    private void changeStrategyToCuShareTypeIncludeCustomData(Set<Long> orgIds, Map<Long, List<Integer>> otherOrgCustomDataMap, Collection<Integer> auditDataIndexes, Set<Long> customOrgIds) {
        HashSet<Long> unnecessaryChangeCustomIndexOrgIds = new HashSet<Long>(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)this.ctrlViewId, new ArrayList<Long>(customOrgIds), (boolean)true));
        HashSet<Integer> deletes = new HashSet<Integer>(this.indexSrcMap.values());
        this.indexSrcMap.keySet().removeAll(this.cusId2IndexMap.values());
        deletes.addAll(this.indexSrcMap.keySet());
        RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(deletes));
        Map<Long, List<Long>> subCuOrgMap = this.getAllSubCuOrgMapping(this.ctrlViewId, new ArrayList<Long>(customOrgIds));
        HashMap<Long, RoaringBitmap> deleteBit = new HashMap<Long, RoaringBitmap>(16);
        HashMap<Long, List> excludes = new HashMap<Long, List>(16);
        for (Long customOrgId : customOrgIds) {
            List<Integer> customIndexes = otherOrgCustomDataMap.get(customOrgId);
            RoaringBitmap bit = (RoaringBitmap)deleteBit.get(customOrgId);
            if (null == bit) {
                bit = delBit.clone();
                deleteBit.put(customOrgId, bit);
            }
            bit.andNot(RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(customIndexes)));
            ArrayList<Integer> indexes = new ArrayList<Integer>(10);
            for (Integer customIndex : customIndexes) {
                Long masterId = this.cusIndex2mstIdMap.get(customIndex);
                Long id = this.cusMstId2IdMap.get(masterId);
                Integer index = this.cusId2IndexMap.get(id);
                if (!auditDataIndexes.contains(index)) continue;
                excludes.computeIfAbsent(customOrgId, k -> new ArrayList(10)).add(index);
                indexes.add(index);
            }
            List<Long> childrenList = subCuOrgMap.get(customOrgId);
            if (CollectionUtils.isEmpty(childrenList) || CollectionUtils.isEmpty(indexes)) continue;
            RoaringBitmap remove = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexes));
            for (Long orgId : childrenList) {
                excludes.computeIfAbsent(orgId, k -> new ArrayList(10)).addAll(indexes);
                RoaringBitmap bitmap = (RoaringBitmap)deleteBit.get(orgId);
                if (null == bitmap) {
                    bitmap = delBit.clone();
                    deleteBit.put(orgId, bitmap);
                }
                bitmap.andNot(remove);
            }
        }
        int[] auditIndexArr = this.covertIntegerList2IntArr(auditDataIndexes);
        RoaringBitmap addBit = RoaringBitmap.bitmapOf((int[])auditIndexArr);
        addBit.runOptimize();
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
        for (Long orgId : orgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            List excludeIndexes = (List)excludes.get(orgId);
            if (CollectionUtils.isEmpty((Collection)excludeIndexes)) {
                message.add(this.createAddSolidifyMessage(addBit));
                message.add(this.createDelSolidifyMessage(delBit));
            } else {
                RoaringBitmap clone = addBit.clone();
                RoaringBitmap excludeBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(excludeIndexes));
                excludeBit.runOptimize();
                clone.andNot(excludeBit);
                message.add(this.createAddSolidifyMessage(clone));
                RoaringBitmap bit = (RoaringBitmap)deleteBit.get(orgId);
                if (null != bit) {
                    message.add(this.createDelSolidifyMessage(bit));
                }
            }
            messageDto.add(message);
        }
        this.updateCustomDataSrcIdAndSrcIndex(unnecessaryChangeCustomIndexOrgIds);
        this.publish(messageDto);
    }

    private void recordSolidifyMsg(Collection<Integer> auditDataIndexes, Set<Long> orgIds, int[] delIndexes) {
        RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(auditDataIndexes));
        RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])delIndexes);
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
        for (Long orgId : orgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            message.add(this.createAddSolidifyMessage(bit));
            message.add(this.createDelSolidifyMessage(delBit));
            messageDto.add(message);
        }
        this.publish(messageDto);
    }

    private void recordSolidifyMsg(Set<Long> orgIds, int[] indexArr) {
        boolean asyncRecord = this.asyncRecord();
        if (!asyncRecord || indexArr.length <= 0) {
            return;
        }
        RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])indexArr);
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(indexArr.length);
        for (Long orgId : orgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            message.add(this.createAddSolidifyMessage(bit));
            messageDto.add(message);
        }
        this.publish(messageDto);
    }

    private void changeAssignOrPrivateToCuShareType(Long createOrgId, int[] auditIndexArr) throws Exception {
        Set<Long> orgIds = this.getAllCuSubordinateOrgIds(this.ctrlViewId, createOrgId);
        if (CollectionUtils.isEmpty(this.cusMstId2IdMap)) {
            this.addBitIndex(auditIndexArr, orgIds);
            this.recordSolidifyMsg(orgIds, auditIndexArr);
            return;
        }
        DynamicObjectCollection collection = this.selectCustomDataColl(createOrgId);
        if (collection.isEmpty()) {
            List<Integer> indexList = Arrays.stream(auditIndexArr).boxed().collect(Collectors.toList());
            indexList.addAll(this.cusId2IndexMap.values());
            auditIndexArr = this.covertIntegerList2IntArr(indexList);
            this.addBitIndex(auditIndexArr, orgIds);
            this.recordSolidifyMsg(orgIds, auditIndexArr);
            return;
        }
        HashSet<Long> customOrgIds = new HashSet<Long>(collection.size());
        HashMap<Long, Integer> otherOrgCustomDataMap = new HashMap<Long, Integer>(collection.size());
        for (DynamicObject data : collection) {
            Long customOrgId = data.getLong("createorg");
            otherOrgCustomDataMap.put(customOrgId, data.getInt("bitindex"));
            customOrgIds.add(customOrgId);
        }
        customOrgIds.retainAll(orgIds);
        if (customOrgIds.isEmpty()) {
            int[] deleteArr = this.covertIntegerList2IntArr(otherOrgCustomDataMap.values());
            this.changeStrategyToCuShareTypeWithNoneCustomData(orgIds, deleteArr, auditIndexArr);
            return;
        }
        this.changeStrategyToCuShareTypeIncludeCustomData(auditIndexArr, orgIds, customOrgIds, otherOrgCustomDataMap);
    }

    private DynamicObjectCollection selectCustomDataColl(Long createOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter(this.masterIdPropName, "in", this.cusMstId2IdMap.keySet()), new QFilter("createorg", "!=", (Object)createOrgId), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        return QueryServiceHelper.query((String)this.entity, (String)("id, createorg, bitindex, srcindex, " + this.masterIdPropName), (QFilter[])filters);
    }

    private void changeStrategyToCuShareTypeIncludeCustomData(int[] indexArr, Set<Long> orgIds, Set<Long> customOrgIds, Map<Long, Integer> otherOrgCustomDataMap) throws Exception {
        HashSet<Long> unnecessaryChangeCustomIndexOrgIds = new HashSet<Long>(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)this.ctrlViewId, new ArrayList<Long>(customOrgIds), (boolean)true));
        unnecessaryChangeCustomIndexOrgIds.forEach(otherOrgCustomDataMap::remove);
        int[] deleteArr = this.covertIntegerList2IntArr(otherOrgCustomDataMap.values());
        boolean needDeleteIndex = deleteArr != null && deleteArr.length > 0;
        RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])deleteArr);
        delBit.runOptimize();
        int[] customDataIndexArr = this.covertIntegerList2IntArr(this.cusId2IndexMap.values());
        ArrayList<BaseDataUseRelBit> inserts = new ArrayList<BaseDataUseRelBit>(10);
        ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
        boolean asyncRecord = this.asyncRecord();
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
        for (Long orgId : orgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            BaseDataUseRelBit relBit = useRelBitMap.remove(orgId);
            if (null == relBit) {
                RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])indexArr);
                if (!unnecessaryChangeCustomIndexOrgIds.contains(orgId)) {
                    bit.add(customDataIndexArr);
                }
                bit.runOptimize();
                relBit = new BaseDataUseRelBit();
                relBit.setOrgId(orgId);
                relBit.setBit(bit);
                inserts.add(relBit);
                if (!asyncRecord) continue;
                message.add(this.createAddSolidifyMessage(bit));
                messageDto.add(message);
                continue;
            }
            RoaringBitmap addBit = RoaringBitmap.bitmapOf((int[])indexArr);
            if (!unnecessaryChangeCustomIndexOrgIds.contains(orgId)) {
                addBit.add(customDataIndexArr);
            }
            addBit.runOptimize();
            RoaringBitmap bit = relBit.getBit();
            bit.or(addBit);
            bit.runOptimize();
            if (needDeleteIndex) {
                bit.andNot(delBit);
            }
            bit.runOptimize();
            updates.add(relBit);
            if (!asyncRecord) continue;
            message.add(this.createAddSolidifyMessage(addBit));
            if (needDeleteIndex) {
                message.add(this.createDelSolidifyMessage(delBit));
            }
            messageDto.add(message);
        }
        BaseDataUseRelUpdateEngine.insert(inserts, this.entity);
        BaseDataUseRelUpdateEngine.update(updates, this.entity);
        this.updateCustomDataSrcIdAndSrcIndex(unnecessaryChangeCustomIndexOrgIds);
        if (asyncRecord) {
            this.publish(messageDto);
        }
    }

    private void updateCustomDataSrcIdAndSrcIndex(Set<Long> orgIds) {
        DynamicObject[] collection;
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid, fparentid from t_org_structure where", new Object[0]).append("fviewid = ?", new Object[]{this.ctrlViewId}).append(" and ", new Object[0]).appendIn("forgid", new ArrayList<Long>(orgIds));
        List orgInfos = (List)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, rs -> {
            ArrayList result = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, Long> map = new HashMap<String, Long>(2);
                map.put("id", rs.getLong("forgid"));
                map.put("parentId", rs.getLong("fparentid"));
                result.add(map);
            }
            return result;
        });
        Map order = new OrgTreeOrder(orgInfos).order();
        Set updateSrcInfoOrgIds = order.keySet();
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", updateSrcInfoOrgIds), new QFilter(this.masterIdPropName, "in", this.cusMstId2IdMap.keySet()), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        for (DynamicObject data : collection = BusinessDataServiceHelper.load((String)this.entity, (String)("id, " + this.masterIdPropName + ", srcindex, sourcedata"), (QFilter[])filters)) {
            Long masterId = this.getLongDataFromDynamicObject(data.get(this.masterIdPropName));
            Long newSrcId = this.cusMstId2IdMap.get(masterId);
            Integer newSrcIndex = this.cusId2IndexMap.get(newSrcId);
            if (null == newSrcId || null == newSrcIndex) continue;
            data.set("sourcedata", (Object)newSrcId);
            data.set("srcindex", (Object)newSrcIndex);
        }
        SaveServiceHelper.save((DynamicObject[])collection);
    }

    private void changeStrategyToCuShareTypeWithNoneCustomData(Set<Long> orgIds, int[] deleteArr, int[] indexArr) throws Exception {
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
        boolean needDeleteIndex = deleteArr != null && deleteArr.length > 0;
        RoaringBitmap newBit = RoaringBitmap.bitmapOf((int[])indexArr);
        newBit.add(this.covertIntegerList2IntArr(this.cusId2IndexMap.values()));
        newBit.runOptimize();
        RoaringBitmap delBit = RoaringBitmap.bitmapOf((int[])deleteArr);
        delBit.runOptimize();
        ArrayList<BaseDataUseRelBit> inserts = new ArrayList<BaseDataUseRelBit>(10);
        ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
        boolean asyncRecord = this.asyncRecord();
        for (Long orgId : orgIds) {
            BaseDataUseRelBit relBit = useRelBitMap.remove(orgId);
            if (asyncRecord) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                message.add(this.createAddSolidifyMessage(newBit));
                if (needDeleteIndex && null != relBit) {
                    message.add(this.createDelSolidifyMessage(delBit));
                }
                messageDto.add(message);
            }
            if (null == relBit) {
                relBit = new BaseDataUseRelBit();
                relBit.setOrgId(orgId);
                relBit.setBit(newBit);
                inserts.add(relBit);
                continue;
            }
            RoaringBitmap bit = relBit.getBit();
            bit.or(newBit);
            if (needDeleteIndex) {
                bit.andNot(delBit);
            }
            bit.runOptimize();
            updates.add(relBit);
        }
        BaseDataUseRelUpdateEngine.insert(inserts, this.entity);
        BaseDataUseRelUpdateEngine.update(updates, this.entity);
        if (asyncRecord) {
            this.publish(messageDto);
        }
    }

    private void changeGlobalShare2AssignOrPrivate(Long createOrgId, Set<Integer> unAuditDataIndexes, Set<Integer> auditDataIndexes) throws Exception {
        List<Long> orgIds = Collections.singletonList(createOrgId);
        unAuditDataIndexes.addAll(auditDataIndexes);
        this.addBitIndex(this.covertIntegerList2IntArr(unAuditDataIndexes), orgIds);
        if (auditDataIndexes.isEmpty() || !this.asyncRecord()) {
            return;
        }
        AbstractBaseDataService.OpDataContext context = new AbstractBaseDataService.OpDataContext();
        context.shareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).addAll(auditDataIndexes);
        BaseDataSolidifyMessageDTO messageDto = this.createDelMessageDto(context, this.ctrlViewId);
        this.publish(messageDto);
    }

    private void changeGlobalShareToOtherType(String newStrategy, Long createOrgId, Set<Integer> unAuditDataIndexes, Set<Integer> auditDataIndexes) throws Exception {
        if (!"6".equals(newStrategy)) {
            this.changeGlobalShare2AssignOrPrivate(createOrgId, unAuditDataIndexes, auditDataIndexes);
            return;
        }
        if (this.needWriteBitRel(newStrategy)) {
            if (CollectionUtils.isEmpty(auditDataIndexes)) {
                this.addBitIndex(this.covertIntegerList2IntArr(unAuditDataIndexes), Collections.singletonList(createOrgId));
            } else {
                this.changeGlobalShare2CuShare(createOrgId, unAuditDataIndexes, auditDataIndexes);
            }
        }
        if (auditDataIndexes.isEmpty() || !this.asyncRecord()) {
            return;
        }
        Set<Long> orgIds = this.getAllCuOrgByViewId(this.ctrlViewId, createOrgId);
        Set<Long> subOrgIds = this.getAllCuSubordinateOrgIds(this.ctrlViewId, createOrgId);
        orgIds.removeAll(subOrgIds);
        if (orgIds.isEmpty()) {
            return;
        }
        RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(auditDataIndexes));
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(orgIds.size());
        for (Long orgId : orgIds) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
            message.add(this.createDelSolidifyMessage(bit));
            messageDto.add(message);
        }
        this.publish(messageDto);
    }

    private void changeGlobalShare2CuShare(Long createOrgId, Set<Integer> unAuditDataIndexes, Set<Integer> auditDataIndexes) throws Exception {
        unAuditDataIndexes.addAll(auditDataIndexes);
        Set<Long> orgIds = this.getAllCuSubordinateOrgIds(this.ctrlViewId, createOrgId);
        orgIds.add(createOrgId);
        Map<Long, BaseDataUseRelBit> useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, this.entity);
        int[] indexArr = this.covertIntegerList2IntArr(auditDataIndexes);
        RoaringBitmap newBit = RoaringBitmap.bitmapOf((int[])indexArr);
        newBit.runOptimize();
        ArrayList<BaseDataUseRelBit> inserts = new ArrayList<BaseDataUseRelBit>(10);
        for (Long orgId : orgIds) {
            RoaringBitmap bit;
            BaseDataUseRelBit relBit = useRelBitMap.get(orgId);
            if (createOrgId.equals(orgId)) {
                if (null == relBit) {
                    relBit = new BaseDataUseRelBit();
                    relBit.setOrgId(orgId);
                    relBit.setBit(RoaringBitmap.bitmapOf((int[])indexArr));
                    inserts.add(relBit);
                }
                bit = relBit.getBit();
                bit.add(this.covertIntegerList2IntArr(unAuditDataIndexes));
                bit.runOptimize();
                continue;
            }
            if (null != relBit) {
                bit = relBit.getBit();
                bit.add(indexArr);
                bit.runOptimize();
                continue;
            }
            relBit = new BaseDataUseRelBit();
            relBit.setOrgId(orgId);
            relBit.setBit(newBit);
            inserts.add(relBit);
        }
        BaseDataUseRelUpdateEngine.insert(inserts, this.entity);
        BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), this.entity);
    }

    private void changeCuShareToOtherType(String newStrategy, Long createOrgId, int[] indexArr, Set<Integer> auditDataIndexes) throws Exception {
        BaseDataSolidifyMessageDTO messageDto;
        List<Long> orgIds;
        if (BaseDataStrategyService.isTreeTypeBaseData(this.entity)) {
            orgIds = new ArrayList<Long>(this.getAllCuSubordinateOrgIds(this.ctrlViewId, createOrgId));
            if ("5".equals(newStrategy)) {
                orgIds.add(createOrgId);
            }
            ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
            this.deleteBitFromOrgUseRel(this.entity, indexArr, orgIds, updates);
            BaseDataUseRelUpdateEngine.update(updates, this.entity);
        } else if (!"5".equals(newStrategy) && this.needWriteBitRel(newStrategy)) {
            orgIds = Collections.singletonList(createOrgId);
            this.addBitIndex(indexArr, orgIds);
        }
        if (auditDataIndexes.isEmpty() || !this.asyncRecord()) {
            return;
        }
        if ("5".equals(newStrategy)) {
            Set<Long> currOrgIds = this.getAllCuSubordinateOrgIds(this.ctrlViewId, createOrgId);
            Set<Long> orgIds2 = this.getAllCuOrgByViewId(this.ctrlViewId, createOrgId);
            orgIds2.removeAll(currOrgIds);
            messageDto = new BaseDataSolidifyMessageDTO(orgIds2.size());
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(auditDataIndexes));
            for (Long orgId : orgIds2) {
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                message.add(this.createAddSolidifyMessage(bit));
                messageDto.add(message);
            }
        } else {
            AbstractBaseDataService.OpDataContext context = new AbstractBaseDataService.OpDataContext();
            context.cuShareTypeMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).addAll(auditDataIndexes);
            messageDto = this.createDelMessageDto(context, this.ctrlViewId);
        }
        this.publish(messageDto);
    }

    private void addBitIndex(int[] indexArr, Collection<Long> orgIds) throws Exception {
        ArrayList<BaseDataUseRelBit> inserts = new ArrayList<BaseDataUseRelBit>(10);
        ArrayList<BaseDataUseRelBit> updates = new ArrayList<BaseDataUseRelBit>(10);
        this.addNewBitToOrgUseRel(this.entity, indexArr, updates, inserts, orgIds);
        BaseDataUseRelUpdateEngine.insert(inserts, this.entity);
        BaseDataUseRelUpdateEngine.update(updates, this.entity);
    }
}

