/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.form.FormMetadataCache;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.sdk.annotation.SdkInternal;
import org.jetbrains.annotations.Nullable;

@SdkInternal
public class ChangeCtrlStrategyService {
    private static final Log logger = LogFactory.getLog(ChangeCtrlStrategyService.class);
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String CREATEORG = "createorg";
    private static final String NUMBER = "number";
    private static final String MASTERID_NUMBER = "masterid.number";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String LONGNUMBER = "longnumber";
    private static final String LEVEL = "level";
    private final String numberField;
    private final String masterIdPropName;
    private static final String ORG_ENTITY = "bos_org";
    private static final String BD_CTRL_CHANGE_PERMITERM = "/IN0GIK354+3";
    private static final String ID = "id";
    private static final String CREATEORG_ID = "createorg.id";
    private static final String BASEDATAUSEREGSUFFIX = "UseReg";
    private static final String BASEDATAEXCSUFFIX = "Exc";
    private static final String BASEDATAUSERANGESUFFIX = "_U";
    private final String entityId;
    private static final String KEY_USE_ORG = "keyUseOrg";
    private static final String KEY_CREATE_ORG = "keyCreateOrg";
    private static final String KEY_DATA_ID = "keyDataId";

    public ChangeCtrlStrategyService(String entityId) {
        this.entityId = entityId;
        boolean isOtherMasterIdType = BaseDataCommonService.isOtherMasterIdType(entityId);
        this.numberField = isOtherMasterIdType ? MASTERID_NUMBER : NUMBER;
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
    }

    public BaseDataResponse changeCtrlStrategy(Set<Long> dataIds, String ctrlStrategy, String appId, Long useOrgId, boolean isValidate) {
        List allCreateOrgIds;
        IBaseDataCtrlPlugin baseDataCtrlPlugin;
        BaseDataResponse response;
        BaseDataResponse response2;
        boolean isSuccess;
        if (isValidate && !(isSuccess = Optional.ofNullable(response2 = this.validate(dataIds, ctrlStrategy, appId, useOrgId)).orElseGet(() -> new BaseDataResponse(true, "")).isSuccess())) {
            return response2;
        }
        String oldCtrlStrategy = this.getOldCtrlStrategy(dataIds);
        ArrayList<Long> changeDataIds = new ArrayList<Long>(dataIds);
        boolean isTreeType = BaseDataCommonService.isTreeType(this.entityId);
        DynamicObject[] allNodes = null;
        if (isTreeType) {
            List<String> fields = Arrays.asList(ID, CTRLSTRATEGY, CREATEORG, this.masterIdPropName, NUMBER, LEVEL, LONGNUMBER);
            List<DynamicObject> nodes = new TreeBaseDataCommonService(this.entityId).getChildNodesByParentIds(changeDataIds, null, fields, true);
            allNodes = nodes.toArray(new DynamicObject[0]);
            ArrayList<Long> allChildIds = new ArrayList<Long>(allNodes.length);
            for (DynamicObject child : allNodes) {
                allChildIds.add(child.getLong(ID));
            }
            changeDataIds = allChildIds;
        }
        if ((response = this.executeChangeCtrlStrategy(changeDataIds, allNodes, ctrlStrategy, useOrgId)).isSuccess() && (baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityId)) != null) {
            ThreadPool threadPool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
            ArrayList<Long> finalChangeDataIds = changeDataIds;
            threadPool.execute(() -> baseDataCtrlPlugin.afterChangeCtrlStrategy(this.entityId, finalChangeDataIds, ctrlStrategy));
        }
        if (CtrlStrategyEnum.GLOBAL_SHARE.getCtrlStrategy().equals(ctrlStrategy) && !(allCreateOrgIds = BaseDataCtrlCache.getGlobalShareDataCreateOrg((String)this.entityId)).contains(useOrgId)) {
            ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
            createOrgIds.add(useOrgId);
            BaseDataCtrlCache.updateGlobalShareDataCreateOrg((String)this.entityId, createOrgIds);
            BaseDataCtrlCache.cleanHasGlobalShareData((String)this.entityId);
        }
        BDCtrlLogHelper.saveChangeCtrlStrategyLog(this.entityId, useOrgId, changeDataIds, oldCtrlStrategy, response);
        return response;
    }

    private String getOldCtrlStrategy(Set<Long> dataIds) {
        String selectProperties = "id,number,ctrlStrategy";
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", dataIds)};
        DynamicObject dataObj = QueryServiceHelper.queryOne((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        return dataObj.getString(CTRLSTRATEGY);
    }

    @Nullable
    public BaseDataResponse validate(Set<Long> dataIds, String ctrlStrategy, String appId, Long useOrgId) {
        BaseDataResponse response = this.preValidate(dataIds, ctrlStrategy, appId, useOrgId);
        if (!response.isSuccess()) {
            return response;
        }
        response = BaseDataCommonService.isTreeType(this.entityId) ? this.treeValidate(dataIds, useOrgId) : this.generalValidate(dataIds, useOrgId);
        if (!response.isSuccess()) {
            return response;
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse executeChangeCtrlStrategy(List<Long> dataIds, DynamicObject[] allNodes, String newBdCtrl, Long useOrgId) {
        BaseDataResponse response = new BaseDataResponse(true, "");
        boolean isTreeType = BaseDataCommonService.isTreeType(this.entityId);
        if (isTreeType) {
            response = this.isAllModifiable(newBdCtrl, dataIds, allNodes);
        }
        if (!response.isSuccess()) {
            return response;
        }
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entityId);
        ExtActionInfo extActionInfo = ext.beforeChangeCtrlStrategy(this.entityId, dataIds, useOrgId, newBdCtrl);
        if (!extActionInfo.isExecute()) {
            response.setSuccess(false);
            response.setResult(extActionInfo.getData());
            response.setErrorMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d6\u6d88\u4e86\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u7684\u64cd\u4f5c\u3002", (String)"ChangeCtrlStrategyService_26", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return response;
        }
        dataIds.removeAll(extActionInfo.getData().keySet());
        if (BaseDataCommonService.isNewModel(this.entityId)) {
            try {
                new BaseDataCommonService().changeStrategyOnNewModel(this.entityId, newBdCtrl, dataIds);
            }
            catch (Exception e) {
                logger.error("\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                return new BaseDataResponse(false, e.getMessage());
            }
        } else {
            this.changeStrategyOnOldModel(newBdCtrl, dataIds);
        }
        if (!isTreeType) {
            String selectProperties = "id,createorg,number";
            QFilter[] filters = new QFilter[]{new QFilter(ID, "in", dataIds)};
            allNodes = BusinessDataServiceHelper.load((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        }
        this.saveCtrlChangeLog(allNodes, String.valueOf(newBdCtrl), useOrgId);
        return response;
    }

    private BaseDataResponse generalValidate(Set<Long> dataIds, Long useOrgId) {
        QFilter[] filters;
        String selectFields = this.selectFields(Arrays.asList(ID, CTRLSTRATEGY, CREATEORG));
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.entityId, (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter(ID, "in", dataIds)}));
        if (collection == null || collection.length == 0 || collection.length != dataIds.size()) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ChangeCtrlStrategyService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String ctrlStrategy = collection[0].getString(CTRLSTRATEGY);
        Long createOrgId = this.getCreateOrgId(collection[0]);
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(collection.length);
        for (DynamicObject dynamicObject : collection) {
            Long orgId = this.getCreateOrgId(dynamicObject);
            String number = dynamicObject.getString(this.numberField);
            if (!orgId.equals(createOrgId)) {
                return new BaseDataResponse(false, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!ctrlStrategy.equals(dynamicObject.getString(CTRLSTRATEGY))) {
                return new BaseDataResponse(false, ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!orgId.equals(useOrgId)) {
                DynamicObject view = BusinessDataServiceHelper.loadSingleFromCache((String)ORG_ENTITY, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)useOrgId)});
                String msgName = "";
                if (view != null) {
                    msgName = view.getString("name");
                }
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, msgName));
            }
            String strategy = dynamicObject.getString(CTRLSTRATEGY);
            Long masterId = dynamicObject.getLong(this.masterIdPropName);
            Long dataId = dynamicObject.getLong(ID);
            if ("2".equals(strategy) && !dataId.equals(masterId)) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u81ea\u7531\u5206\u914d\u201d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
            }
            idNumberMap.put((Long)dynamicObject.getPkValue(), number);
        }
        if (BaseDataCommonService.isNewModel(this.entityId)) {
            return this.assignValidate(useOrgId, ctrlStrategy, idNumberMap);
        }
        List<Map<String, Long>> assignResults = this.getAssignResult(dataIds);
        if (!assignResults.isEmpty()) {
            Map<String, Long> resultMap = assignResults.get(0);
            String number = (String)idNumberMap.get(resultMap.get(KEY_DATA_ID));
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u5206\u914d\u7684\u57fa\u7840\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
        }
        return this.checkFreeAssign(new ArrayList<Long>(dataIds));
    }

    private BaseDataResponse treeValidate(Set<Long> dataIds, Long useOrgId) {
        String selectProperties = "id, ctrlstrategy, createOrg," + this.masterIdPropName + ",number,level,longnumber";
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", dataIds)};
        DynamicObject[] nodes = BusinessDataServiceHelper.load((String)this.entityId, (String)selectProperties, (QFilter[])filters);
        HashMap<Long, HashSet<Long>> rootNodeMap = new HashMap<Long, HashSet<Long>>(dataIds.size());
        HashSet<String> longNumbers = new HashSet<String>(16);
        for (DynamicObject obj : nodes) {
            int level = obj.getInt(LEVEL);
            Long dataId = obj.getLong(ID);
            String longNumber = obj.getString(LONGNUMBER);
            String number = obj.getString(NUMBER);
            if (level == 0) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u7ea7\u6b21\u4e0d\u80fd\u4e3a0\u3002", (String)"ChangeCtrlStrategyService_23", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
            }
            if (StringUtils.isEmpty((CharSequence)longNumber)) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u957f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChangeCtrlStrategyService_24", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
            }
            if (1 != level) continue;
            HashSet<Long> childs = (HashSet<Long>)rootNodeMap.get(dataId);
            if (null == childs) {
                childs = new HashSet<Long>(16);
            }
            childs.add(dataId);
            rootNodeMap.put(dataId, childs);
            longNumbers.add(longNumber);
        }
        BaseDataResponse response = this.checkAllRootSelected(longNumbers, nodes);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.isCurrentUseOrg(nodes, useOrgId);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.isTheSameCtrlStrategy(nodes);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.isRootNodeIdentify(nodes);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.isRootNodeAssign(nodes);
        if (!response.isSuccess()) {
            return response;
        }
        response = this.checkHaveFreeIdentifyOrPrivate(new ArrayList<Long>(dataIds));
        if (!response.isSuccess()) {
            return response;
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse preValidate(Set<Long> dataIds, String ctrlStrategy, String appId, Long useOrgId) {
        BaseDataResponse paramValidateResponse = this.paramIsNotNull(dataIds, ctrlStrategy, appId = null != appId ? appId : this.getAppId(this.entityId), useOrgId);
        if (!paramValidateResponse.isSuccess()) {
            return paramValidateResponse;
        }
        boolean isCtrlStrategyCorrect = this.isCtrlStrategyExist(ctrlStrategy);
        if (!isCtrlStrategyCorrect) {
            return new BaseDataResponse(false, "ctrlStrategy is not exist");
        }
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)useOrgId, (String)appId, (String)this.entityId, (String)BD_CTRL_CHANGE_PERMITERM) == 0) {
            String caption = FormMetadataCache.getFormConfig((String)this.entityId).getCaption().getLocaleValue();
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ChangeCtrlStrategyService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), caption));
        }
        if (!this.checkHaveConfigOfCtrlStrategy()) {
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u83b7\u53d6\u63a7\u5236\u7b56\u7565\u7684\u7ba1\u63a7\u89c6\u56fe\u5931\u8d25\uff0c \u8bf7\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u4e2d\u5148\u914d\u7f6e\u65b0\u589e\u3002", (String)"ChangeCtrlStrategyService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        BaseDataResponse response = this.checkDataRule(useOrgId, appId, new ArrayList<Long>(dataIds));
        if (!response.isSuccess()) {
            return response;
        }
        return new BaseDataResponse(true, "");
    }

    private String getAppId(String entityId) {
        if (null != entityId) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return null != mainEntityType ? mainEntityType.getAppId() : null;
        }
        return null;
    }

    private BaseDataResponse paramIsNotNull(Set<Long> dataIds, String ctrlStrategy, String appId, Long useOrgId) {
        BaseDataResponse response = new BaseDataResponse(false, "");
        if (null == this.entityId) {
            response.setErrorMsg("entityId is empty");
        } else if (org.apache.commons.collections4.CollectionUtils.isEmpty(dataIds)) {
            response.setErrorMsg("dataIds is empty");
        } else if (StringUtils.isEmpty((CharSequence)ctrlStrategy)) {
            response.setErrorMsg("ctrlStrategy is empty");
        } else if (null == appId) {
            response.setErrorMsg("appId is empty");
        } else if (null == useOrgId) {
            response.setErrorMsg("useOrgId is empty");
        } else {
            response.setSuccess(true);
        }
        return response;
    }

    private boolean checkHaveConfigOfCtrlStrategy() {
        DynamicObject view = BaseDataServiceHelper.getCtrlview((String)this.entityId);
        return null != view;
    }

    private boolean isCtrlStrategyExist(String ctrlStrategy) {
        switch (ctrlStrategy) {
            case "1": 
            case "2": 
            case "5": 
            case "6": 
            case "7": {
                return true;
            }
        }
        return false;
    }

    private BaseDataResponse checkAllRootSelected(Set<String> longNumbers, DynamicObject[] nodes) {
        String errorMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u53ea\u652f\u6301\u4ece\u4e00\u7ea7\u8d44\u6599\u53d8\u66f4\u3002", (String)"ChangeCtrlStrategyService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(longNumbers)) {
            return new BaseDataResponse(false, errorMsg);
        }
        boolean isAllContainRoot = true;
        StringBuilder noticeMsg = new StringBuilder();
        String longNumberDLM = BaseDataCommonService.getLongNumberDLM(nodes[0].getDataEntityType().getName());
        for (DynamicObject obj : nodes) {
            String rootLongNumber;
            int level = obj.getInt(LEVEL);
            String longNumber = obj.getString(LONGNUMBER);
            String number = obj.getString(NUMBER);
            if (1 == level || longNumbers.contains(rootLongNumber = longNumber.substring(0, longNumber.indexOf(longNumberDLM)))) continue;
            isAllContainRoot = false;
            noticeMsg.append(number).append(":");
            noticeMsg.append(ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u53ea\u652f\u6301\u4ece\u4e00\u7ea7\u8d44\u6599\u53d8\u66f4\u3002", (String)"ChangeCtrlStrategyService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            noticeMsg.append("\n");
        }
        if (!isAllContainRoot) {
            return new BaseDataResponse(false, noticeMsg.toString());
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse isCurrentUseOrg(DynamicObject[] nodes, Long useOrgId) {
        for (DynamicObject obj : nodes) {
            Long createOrgId;
            boolean isRootNode;
            long level = obj.getLong(LEVEL);
            boolean bl = isRootNode = 1L == level;
            if (!isRootNode || (createOrgId = obj.get(CREATEORG) instanceof DynamicObject ? (Long)obj.getDynamicObject(CREATEORG).getPkValue() : (obj.get(CREATEORG) instanceof Long ? (Long)obj.get(CREATEORG) : Long.valueOf(0L))).equals(useOrgId)) continue;
            String number = obj.getString(NUMBER);
            return new BaseDataResponse(false, number + "\uff1a" + String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0e%s\u76f8\u540c\u65f6\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"ChangeCtrlStrategyService_10", (String)SYSTEM_TYPE, (Object[])new Object[0])));
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse isTheSameCtrlStrategy(DynamicObject[] nodes) {
        String ctrlStrategy = nodes[0].getString(CTRLSTRATEGY);
        for (DynamicObject obj : nodes) {
            long level = obj.getLong(LEVEL);
            boolean isRootNode = 1L == level;
            String tempCtrlStrategy = obj.getString(CTRLSTRATEGY);
            if (!isRootNode || tempCtrlStrategy.equals(ctrlStrategy)) continue;
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse isRootNodeIdentify(DynamicObject[] treeNodes) {
        for (DynamicObject obj : treeNodes) {
            boolean isRootNode;
            long level = obj.getLong(LEVEL);
            boolean bl = isRootNode = 1L == level;
            if (!isRootNode) continue;
            Long masterId = obj.getLong(this.masterIdPropName);
            String ctrlStrategy = obj.getString(CTRLSTRATEGY);
            boolean isCuAssignType = "1".equals(ctrlStrategy);
            boolean isAssignType = "2".equals(ctrlStrategy);
            Long dataId = obj.getLong(ID);
            if (dataId.equals(masterId)) continue;
            if (isCuAssignType) {
                return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u8d44\u6599\u9010\u7ea7\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), obj.get(NUMBER)));
            }
            if (!isAssignType) continue;
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u8d44\u6599\u81ea\u7531\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), obj.get(NUMBER)));
        }
        return new BaseDataResponse(true, "");
    }

    private BaseDataResponse isRootNodeAssign(DynamicObject[] nodes) {
        boolean isNewModel = BaseDataCommonService.isNewModel(this.entityId);
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(nodes.length);
        HashSet<Long> dataIds = new HashSet<Long>(nodes.length);
        for (DynamicObject obj : nodes) {
            boolean isTypeOfAssign;
            long level = obj.getLong(LEVEL);
            boolean isRootNode = 1L == level;
            String ctrlStrategy = obj.getString(CTRLSTRATEGY);
            boolean bl = isTypeOfAssign = "1".equals(ctrlStrategy) || "2".equals(ctrlStrategy);
            if (!isRootNode || !isTypeOfAssign) continue;
            Long id = obj.getLong(ID);
            dataIds.add(id);
            String number = obj.getString(NUMBER);
            idNumberMap.put(id, number);
        }
        if (isNewModel) {
            String ctrlStrategy = nodes[0].getString(CTRLSTRATEGY);
            Long useOrgId = nodes[0].getLong(CREATEORG_ID);
            return this.assignValidateOnNewModel(useOrgId, ctrlStrategy, idNumberMap);
        }
        List<Map<String, Long>> assignResults = this.getAssignResult(dataIds);
        if (!assignResults.isEmpty()) {
            Map<String, Long> resultMap = assignResults.get(0);
            String number = (String)idNumberMap.get(resultMap.get(KEY_DATA_ID));
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u5206\u914d\u7684\u57fa\u7840\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
        }
        return new BaseDataResponse(true, "");
    }

    private List<Map<String, Long>> getAssignResult(Set<Long> dataIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(dataIds)) {
            return new ArrayList<Map<String, Long>>(1);
        }
        IDataEntityType dt = ORM.create().getDataEntityType(this.entityId);
        String dataTableName = dt.getAlias();
        String dataTableUseName = dataTableName + BASEDATAUSEREGSUFFIX;
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("SELECT  mu.fuseorgid uoid,mu.fcreateorgid coid,mu.fdataid from ", new Object[0]).append(dataTableUseName, new Object[0]).append(" mu ", new Object[0]);
        sbd.append("where ", new Object[0]).appendIn("mu.fdataid", new ArrayList<Long>(dataIds));
        sbd.append(" and mu.FisAssign = '1' ", new Object[0]);
        return (List)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)sbd, rs -> {
            ArrayList tempList = new ArrayList(1);
            if (rs.next()) {
                HashMap<String, Long> tempResult = new HashMap<String, Long>(3);
                tempResult.put(KEY_USE_ORG, rs.getLong(1));
                tempResult.put(KEY_CREATE_ORG, rs.getLong(2));
                tempResult.put(KEY_DATA_ID, rs.getLong(3));
                tempList.add(tempResult);
                return tempList;
            }
            return tempList;
        });
    }

    private BaseDataResponse assignValidateOnNewModel(Long orgId, String ctrlStrategy, Map<Long, String> idNumberMap) {
        Set<Long> alreadyAssignDataIds;
        try {
            alreadyAssignDataIds = this.getAssignDataIds(orgId, ctrlStrategy, new HashSet<Long>(idNumberMap.keySet()));
        }
        catch (Exception e) {
            logger.error("\u4ece\u4f4d\u56fe\u6570\u636e\u4e2d\u83b7\u53d6\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38", (Throwable)e);
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38\uff0c\u6682\u65f6\u65e0\u6cd5\u8fdb\u884c\u7ba1\u63a7\u7b56\u7565\u53d8\u66f4\u3002", (String)"ChangeCtrlStrategyService_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(alreadyAssignDataIds)) {
            return new BaseDataResponse(true, "");
        }
        Long dataId = new ArrayList<Long>(alreadyAssignDataIds).get(0);
        String number = idNumberMap.get(dataId);
        String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u5206\u914d\u7684\u57fa\u7840\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), number);
        return new BaseDataResponse(false, msg);
    }

    private Set<Long> getAssignDataIds(Long orgId, String ctrlStrategy, Set<Long> dataIds) throws Exception {
        Set<Long> alreadyAssignDataIds = Collections.emptySet();
        if ("1".equals(ctrlStrategy)) {
            alreadyAssignDataIds = new BaseDataAssignService(this.entityId).getAssignToDirectSubChildData(dataIds, orgId);
        } else if ("2".equals(ctrlStrategy)) {
            alreadyAssignDataIds = new BaseDataAssignService(this.entityId).getAllAssignTypeData(dataIds, orgId);
        }
        return alreadyAssignDataIds;
    }

    private BaseDataResponse checkHaveFreeIdentifyOrPrivate(List<Long> ids) {
        if (!this.haveFreeAssignOrPrivate()) {
            return new BaseDataResponse(true, "");
        }
        TreeBaseDataCommonService treeService = new TreeBaseDataCommonService(this.entityId);
        List<String> selectFields = Arrays.asList(CTRLSTRATEGY, LONGNUMBER, LEVEL);
        List<DynamicObject> childNodes = treeService.getChildNodesByParentIds(ids, null, selectFields, true);
        StringBuilder noticeMsg = new StringBuilder();
        String longNumberDLM = BaseDataCommonService.getLongNumberDLM(this.entityId);
        for (DynamicObject obj : childNodes) {
            String ctrlStrategy = obj.getString(CTRLSTRATEGY);
            String longNumber = obj.getString(LONGNUMBER);
            String rootLongNumber = obj.getString(NUMBER);
            if (StringUtils.isNotEmpty((CharSequence)longNumber) && longNumber.contains(longNumberDLM)) {
                rootLongNumber = longNumber.substring(0, longNumber.indexOf(longNumberDLM));
            }
            switch (ctrlStrategy) {
                case "2": {
                    noticeMsg.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u8d44\u6599\u6216\u8005\u4e0b\u7ea7\u8d44\u6599\u5b58\u5728\u7b56\u7565\u4e3a\u81ea\u7531\u5206\u914d\u7684\u6570\u636e\uff0c\u4e0d\u652f\u6301\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), rootLongNumber));
                    return new BaseDataResponse(false, noticeMsg.toString());
                }
                case "7": {
                    long level = obj.getLong(LEVEL);
                    if (1L != level) break;
                    return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u79c1\u6709\u578b\u201d\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), rootLongNumber));
                }
            }
        }
        return new BaseDataResponse(true, "");
    }

    private boolean haveFreeAssignOrPrivate() {
        IDataEntityType dt = ORM.create().getDataEntityType(this.entityId);
        String dataTableName = dt.getAlias();
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select fid,fctrlstrategy from ", new Object[0]).append(dataTableName, new Object[0]).append(" where ", new Object[0]);
        sbd.append(String.format("fctrlstrategy = '%s'", "2"), new Object[0]);
        sbd.append(String.format(" or fctrlstrategy = '%s'", "7"), new Object[0]);
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)sbd, rs -> {
            if (rs.next()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    private BaseDataResponse assignValidate(Long orgId, String ctrlStrategy, Map<Long, String> idNumberMap) {
        Set<Long> alreadyAssignDataIds;
        try {
            alreadyAssignDataIds = this.getAssignDataIds(orgId, ctrlStrategy, new HashSet<Long>(idNumberMap.keySet()));
        }
        catch (Exception e) {
            logger.error("\u4ece\u4f4d\u56fe\u6570\u636e\u4e2d\u83b7\u53d6\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38", (Throwable)e);
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5df2\u5206\u914d\u60c5\u51b5\u5f02\u5e38\uff0c\u6682\u65f6\u65e0\u6cd5\u8fdb\u884c\u7ba1\u63a7\u7b56\u7565\u53d8\u66f4\u3002", (String)"ChangeCtrlStrategyService_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(alreadyAssignDataIds)) {
            return new BaseDataResponse(true, "");
        }
        Long dataId = new ArrayList<Long>(alreadyAssignDataIds).get(0);
        String number = idNumberMap.get(dataId);
        String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u5206\u914d\u7684\u57fa\u7840\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), number);
        return new BaseDataResponse(false, msg);
    }

    private BaseDataResponse checkDataRule(Long useOrgId, String appId, List<Long> dataIds) {
        QFilter dataRuleFilter = this.getDataRuleFilter(appId, Collections.singletonList(useOrgId));
        if (null == dataRuleFilter) {
            return new BaseDataResponse(true, "");
        }
        Set<Long> idsMatchDataRule = this.selectMatchDataRuleIds(dataRuleFilter);
        QFilter filter = new QFilter(ID, "in", dataIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entityId, (String)"id,number", (QFilter[])filter.toArray());
        ArrayList<String> messages = new ArrayList<String>(10);
        String opMsg = ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565", (String)"ChangeCtrlStrategyService_17", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (DynamicObject data : doc) {
            long dataId = data.getLong(ID);
            if (idsMatchDataRule.contains(dataId)) continue;
            String number = data.getString(NUMBER);
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%2$s\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChangeCtrlStrategyService_18", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messages.add(String.format(msg, number, opMsg));
        }
        if (!messages.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner("\n");
            messages.forEach(stringJoiner::add);
            return new BaseDataResponse(false, stringJoiner.toString());
        }
        return new BaseDataResponse(true, "");
    }

    private QFilter getDataRuleFilter(String appId, List<Long> orgIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.getDataRuleWithoutDim(currUserId, appId, this.entityId, BD_CTRL_CHANGE_PERMITERM, orgIds);
    }

    private Set<Long> selectMatchDataRuleIds(QFilter dataRuleFilter) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entityId, (String)ID, (QFilter[])new QFilter[]{dataRuleFilter});
        return doc.stream().map(obj -> obj.getLong(ID)).collect(Collectors.toSet());
    }

    private BaseDataResponse checkFreeAssign(List<Long> ids) {
        String selectFields;
        boolean isMaterialInfo = false;
        if (!"masterid".equals(this.masterIdPropName)) {
            selectFields = "id,number," + this.masterIdPropName + ",ctrlstrategy,masterid.number";
            isMaterialInfo = true;
        } else {
            selectFields = "id,number," + this.masterIdPropName + ",ctrlstrategy";
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter(ID, "in", ids);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection list = orm.query(this.entityId, selectFields, filters);
        boolean isTreeType = BaseDataCommonService.isTreeType(this.entityId);
        for (DynamicObject obj : list) {
            boolean checkIdentify;
            String id = obj.get(ID).toString();
            String masterId = obj.get(this.masterIdPropName).toString();
            String ctrlStrategy = obj.get(CTRLSTRATEGY).toString();
            if (isTreeType) {
                boolean bl = checkIdentify = (ctrlStrategy.equals("2") || ctrlStrategy.equals("1")) && !masterId.equals(id);
                if (checkIdentify) {
                    StringBuilder noticeMsg = new StringBuilder();
                    Object number = isMaterialInfo ? obj.get(MASTERID_NUMBER) : obj.get(NUMBER);
                    noticeMsg.append(number).append("\uff1a");
                    if (ctrlStrategy.equals("2")) {
                        noticeMsg.append(ResManager.loadKDString((String)"\u81ea\u7531\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    } else {
                        noticeMsg.append(ResManager.loadKDString((String)"\u9010\u7ea7\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                    return new BaseDataResponse(false, noticeMsg.toString());
                }
                if (!ctrlStrategy.equals("7")) continue;
                return new BaseDataResponse(false, ResManager.loadKDString((String)"\u201c\u79c1\u6709\u578b\u201d\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            checkIdentify = ctrlStrategy.equals("2") && !masterId.equals(id);
            if (!checkIdentify) continue;
            Object number = isMaterialInfo ? obj.get(MASTERID_NUMBER) : obj.get(NUMBER);
            return new BaseDataResponse(false, String.format(ResManager.loadKDString((String)"%s\uff1a\u81ea\u7531\u5206\u914d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"ChangeCtrlStrategyService_25", (String)SYSTEM_TYPE, (Object[])new Object[0]), number));
        }
        return new BaseDataResponse(true, "");
    }

    private String selectFields(List<String> customSelectFields) {
        ArrayList<String> selectFields = new ArrayList<String>(Arrays.asList(this.masterIdPropName, this.numberField));
        selectFields.addAll(customSelectFields);
        return String.join((CharSequence)String.valueOf(','), selectFields);
    }

    private Long getCreateOrgId(DynamicObject data) {
        Object createOrg = data.get(CREATEORG);
        if (createOrg instanceof DynamicObject) {
            return (Long)((DynamicObject)createOrg).getPkValue();
        }
        if (createOrg instanceof Long) {
            return (Long)createOrg;
        }
        return 0L;
    }

    private OpLogAppInfo buildAppLogInfo(Date opTime, Long opOrg, String appId) {
        RequestContext context = RequestContext.get();
        Long userId = context.getCurrUserId();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(userId);
        if (opOrg == null) {
            appLogInfo.setOrgID(Long.valueOf(context.getOrgId()));
        } else {
            appLogInfo.setOrgID(opOrg);
        }
        appLogInfo.setClientIP(context.getLoginIP());
        appLogInfo.setClientType(context.getClient());
        appLogInfo.setClientName(context.getClient());
        appLogInfo.setAccountId(context.getAccountId());
        appLogInfo.setTenantId(context.getTenantId());
        appLogInfo.setLanguage(context.getLang().name());
        appLogInfo.setOpTime(opTime);
        appLogInfo.setOpName("bdctrlchange", BaseDataCommon.getOpName(this.entityId, "bdctrlchange"));
        appLogInfo.setBizObjID(this.entityId);
        appLogInfo.setBizAppID(appId);
        return appLogInfo;
    }

    private void saveCtrlChangeLog(DynamicObject[] objs, String newBdCtrl, Long useOrgId) {
        try {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.entityId);
            String appNumber = met.getBizAppNumber();
            String appId = null;
            if (!StringUtils.isBlank((CharSequence)appNumber)) {
                try {
                    appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
                }
                catch (Exception ex) {
                    appId = met.getAppId();
                }
            }
            ArrayList<OpLogAppInfo> bdCtrlLogs = new ArrayList<OpLogAppInfo>(objs.length);
            Date date = new Date();
            for (DynamicObject obj : objs) {
                DynamicObject createOrg = (DynamicObject)obj.get(CREATEORG);
                OpLogAppInfo appLogInfo = this.buildAppLogInfo(date, useOrgId, appId);
                MultiLangEnumBridge desc = new MultiLangEnumBridge("\u7ec4\u7ec7(\u7f16\u7801)\uff1a%1$s,\u53d8\u66f4\u6570\u636e(\u7f16\u7801)\uff1a%2$s,\u63a7\u5236\u7b56\u7565\u4ee3\u7801\u4e3a\uff1a%3$s\u3002", "ChangeCtrlStrategyService_27", SYSTEM_TYPE);
                appLogInfo.setOpDesc(desc, new String[]{createOrg.getString(NUMBER), obj.getString(NUMBER), newBdCtrl});
                bdCtrlLogs.add(appLogInfo);
            }
            LogServiceHelper.addBatchLog(bdCtrlLogs);
        }
        catch (Exception e) {
            logger.error("saveCtrlChangeLog error:", (Throwable)e);
        }
    }

    private BaseDataResponse isAllModifiable(Object newBdCtrl, List<Long> ids, DynamicObject[] allChilds) {
        int level;
        if (newBdCtrl.equals("1")) {
            return new BaseDataResponse(true, "");
        }
        String longNumberDLM = BaseDataCommonService.getLongNumberDLM(allChilds[0].getDataEntityType().getName());
        HashMap<String, ArrayList<DynamicObject>> longNumberDataIdMap = new HashMap<String, ArrayList<DynamicObject>>(16);
        for (DynamicObject obj2 : allChilds) {
            String longNumber = obj2.getString(LONGNUMBER);
            String rootLongNumber = null;
            level = obj2.getInt(LEVEL);
            if (1 == level) {
                rootLongNumber = longNumber;
            } else if (longNumber.contains(longNumberDLM)) {
                rootLongNumber = longNumber.substring(0, longNumber.indexOf(longNumberDLM));
            }
            ArrayList<DynamicObject> dataIds = (ArrayList<DynamicObject>)longNumberDataIdMap.get(rootLongNumber);
            if (null == dataIds) {
                dataIds = new ArrayList<DynamicObject>(16);
            }
            dataIds.add(obj2);
            longNumberDataIdMap.put(rootLongNumber, dataIds);
        }
        HashSet<String> unModifiableRootLongNumbers = new HashSet<String>(allChilds.length);
        for (DynamicObject obj3 : allChilds) {
            String longNumber = obj3.getString(LONGNUMBER);
            level = obj3.getInt(LEVEL);
            String rootLongNumber = null;
            if (1 == level) {
                rootLongNumber = longNumber;
            } else if (longNumber.contains(longNumberDLM)) {
                rootLongNumber = longNumber.substring(0, longNumber.indexOf(longNumberDLM));
            }
            List sameRootLongNumberNodes = (List)longNumberDataIdMap.get(rootLongNumber);
            if (CollectionUtils.isEmpty((Collection)sameRootLongNumberNodes)) continue;
            Long createOrgId = ((DynamicObject)sameRootLongNumberNodes.get(0)).getLong(CREATEORG_ID);
            for (DynamicObject node : sameRootLongNumberNodes) {
                if (createOrgId.equals(node.getLong(CREATEORG_ID))) continue;
                unModifiableRootLongNumbers.add(rootLongNumber);
            }
        }
        if (!unModifiableRootLongNumbers.isEmpty()) {
            StringBuilder noticeMsg = new StringBuilder();
            for (String rootLongNumber : unModifiableRootLongNumbers) {
                List unModifiableNodes = (List)longNumberDataIdMap.get(rootLongNumber);
                ArrayList unModifiableIds = new ArrayList(unModifiableNodes.size());
                unModifiableNodes.forEach(obj -> unModifiableIds.add(obj.getLong(ID)));
                ids.removeAll(unModifiableIds);
                noticeMsg.append(rootLongNumber).append("\uff1a");
                noticeMsg.append(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u5176\u4e0b\u7ea7\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u540c\uff0c\u53ea\u652f\u6301\u53d8\u66f4\u4e3a\u201c\u9010\u7ea7\u5206\u914d\u201d\u3002", (String)"ChangeCtrlStrategyService_22", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\\r\\n");
            }
            return new BaseDataResponse(false, noticeMsg.toString());
        }
        return new BaseDataResponse(true, "");
    }

    private void changeStrategyOnOldModel(Object newBdCtrl, List<Long> ids) {
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityId));
        this.clearCache(load);
        this.deleteBaseDataUseRange(ids);
        this.deleteBaseDataExc(ids);
        ArrayList<DynamicObject> allChildList = new ArrayList<DynamicObject>(ids.size());
        for (DynamicObject dynamicObject : load) {
            allChildList.add(dynamicObject);
            dynamicObject.set(CTRLSTRATEGY, newBdCtrl);
        }
        SaveServiceHelper.save((DynamicObject[])allChildList.toArray(new DynamicObject[0]));
        this.handleUseData(allChildList);
    }

    private void clearCache(DynamicObject[] load) {
        DynamicObject dataInfo = load[0];
        String ctrlStrategy = dataInfo.getString(CTRLSTRATEGY);
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String baseDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String entityID = dataInfo.getDataEntityType().getName();
        Long createOrgID = 0L;
        BaseDataCtrlCacheMrg.getLocalCtrlCache().clear();
        if (dataInfo.get(CREATEORG) instanceof DynamicObject) {
            DynamicObject createOrg = (DynamicObject)dataInfo.get(CREATEORG);
            createOrgID = (Long)createOrg.getPkValue();
        } else if (dataInfo.get(CREATEORG) instanceof Long) {
            createOrgID = (Long)dataInfo.get(CREATEORG);
        }
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        if ("5".equals(ctrlStrategy)) {
            BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityID);
            BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityID);
        } else if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) {
            this.clearCacheAssign(baseDataUseRegTableName, load, entityID, type);
        } else if ("6".equals(ctrlStrategy)) {
            this.clearCacheCuShare(entityID, createOrgID, type);
        } else if ("7".equals(ctrlStrategy)) {
            String key = entityID + createOrgID;
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            BaseDataCtrlCache.clearBaseDataUseRange((String)entityID, (Long)createOrgID);
        }
    }

    private void clearCacheAssign(String baseDataUseRegTableName, DynamicObject[] dataInfos, String entityID, String type) {
        String dbRouteKey = ORM.create().getDataEntityType(entityID).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        StringBuilder sb = new StringBuilder();
        Object[] param = new Object[dataInfos.length];
        sb.append("select fuseorgid from ").append(baseDataUseRegTableName).append(" where fdataid in (");
        for (int i = 0; i < dataInfos.length; ++i) {
            sb.append(" ?");
            param[i] = dataInfos[i].getPkValue();
            if (i == dataInfos.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        Set result = (Set)DB.query((DBRoute)dbRoute, (String)sb.toString(), (Object[])param, rs -> {
            HashSet<Long> set = new HashSet<Long>(16);
            while (rs.next()) {
                set.add(rs.getLong("fuseorgid"));
            }
            return set;
        });
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        HashSet<Long> clearOrgSet = new HashSet<Long>(result.size());
        for (Long org : result) {
            String key = entityID + org;
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            clearOrgSet.add(org);
        }
        BaseDataCtrlCache.clearBaseDataUseRange((String)entityID, clearOrgSet);
    }

    private void clearCacheCuShare(String entityID, Long createOrgID, String type) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityID);
        if (null == ctrlView) {
            return;
        }
        ArrayList<Long> useOrgList = new ArrayList<Long>();
        useOrgList.add(createOrgID);
        List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), useOrgList, (boolean)true, (boolean)true);
        ArrayList<String> keys = new ArrayList<String>(orgList.size());
        for (Long org : orgList) {
            String key = entityID + org;
            keys.add(key);
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(keys)) {
            BaseDataCtrlCacheMrg.clearCache((String)type, (String[])keys.toArray(new String[0]));
        }
    }

    private void deleteBaseDataExc(List<Long> dataIDs) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entityId);
            String baseDataTableName = dt.getAlias();
            String dbRouteKey = dt.getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            String baseDataUseRangeTableName = baseDataTableName + BASEDATAEXCSUFFIX;
            List dataIdList = Optional.ofNullable(dataIDs).orElseGet(Collections::emptyList).stream().map(Object.class::cast).collect(Collectors.toList());
            SqlBuilder sbd = new SqlBuilder();
            sbd.append("delete from " + baseDataUseRangeTableName + " where ", new Object[0]);
            sbd.appendIn("fdataid", dataIdList);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sbd);
        }
        catch (Exception e) {
            logger.error("deleteBaseDataExc:", (Throwable)e);
        }
    }

    private void handleUseData(List<DynamicObject> saveData) {
        DynamicObject dataInfo = saveData.get(0);
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String baseDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String entityID = dataInfo.getDataEntityType().getName();
        String dbRouteKey = ORM.create().getDataEntityType(entityID).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("delete from ", new Object[0]).append(baseDataUseRegTableName, new Object[0]).append(" where ", new Object[0]);
        List dataIds = saveData.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        sbd.appendIn("fdataid", dataIds);
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (SqlBuilder)sbd);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        BaseDataServiceHelper.baseDataCtrlChangeHandler(saveData);
    }

    private void deleteBaseDataUseRange(List<Long> dataIDs) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entityId);
            String baseDataTableName = dt.getAlias();
            String dbRouteKey = dt.getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            String baseDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
            List dataIdList = Optional.ofNullable(dataIDs).orElseGet(Collections::emptyList).stream().map(Object.class::cast).collect(Collectors.toList());
            SqlBuilder sbd = new SqlBuilder();
            sbd.append("delete from ", new Object[0]).append(baseDataUseRangeTableName, new Object[0]).append(" where ", new Object[0]);
            sbd.appendIn("fdataid", dataIdList);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sbd);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

