/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.validator.ChangeManageRightValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class ChangeManageRightService {
    private static final Log logger = LogFactory.getLog(ChangeManageRightService.class);
    private static final String ORG_ENTITY = "bos_org";
    private static final String BASEDATAUSEREGSUFFIX = "UseReg";
    private static final String BASEDATAUSERANGESUFFIX = "_U";

    public BaseDataResponse changeManageRight(String entityId, Long useOrgId, String appId, Set<Long> dataIds, Long targetOrgId, boolean isValidate) {
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService(entityId);
        ExtActionInfo extActionInfo = ext.beforePermChange(entityId, useOrgId, targetOrgId, dataIds);
        Map<Long, Map<Long, String>> data = extActionInfo.getData();
        if (!extActionInfo.isExecute()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u53d6\u6d88\u4e86\u7ba1\u7406\u6743\u8f6c\u8ba9\u64cd\u4f5c\u3002", (String)"ChangeManageRightService_1", (String)"bos-bd-business", (Object[])new Object[0]);
            if (data.isEmpty()) {
                return new BaseDataResponse(false, msg);
            }
            BaseDataResponse response = new BaseDataResponse(false, msg);
            response.setResult(data);
            return response;
        }
        dataIds.removeAll(data.keySet());
        ChangeManageRightValidator validator = new ChangeManageRightValidator(entityId);
        BaseDataResponse response = validator.validate(useOrgId, appId, dataIds, targetOrgId);
        if (isValidate && !response.isSuccess()) {
            return response;
        }
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            qFilters.add(new QFilter("id", "=", (Object)targetOrgId));
            DynamicObject targetOrg = BusinessDataServiceHelper.loadSingle((String)ORG_ENTITY, (String)"id,number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (null == targetOrg) {
                return new BaseDataResponse(false, "ChangeManageRightService changeManageRight error:targetOrgId is null.");
            }
            if (BaseDataCommonService.isNewModel(entityId)) {
                this.changeOrgPermOnNewModel(useOrgId, targetOrg, new ArrayList<Long>(dataIds), entityId);
            } else {
                this.changeOrgPermOnOldModel(useOrgId, targetOrg, new ArrayList<Long>(dataIds), entityId);
            }
        }
        catch (Exception e) {
            logger.error("ChangeManageRightService ERROR:" + e);
            return new BaseDataResponse(false, ResManager.loadKDString((String)"\u7ba1\u7406\u6743\u8f6c\u8ba9\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ChangeManageRightService_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        BDCtrlLogHelper.saveChangeManageRightLog(entityId, new ArrayList<Long>(dataIds), useOrgId, targetOrgId);
        return new BaseDataResponse(true, "");
    }

    private void changeOrgPermOnNewModel(Long useOrgId, DynamicObject org, List<Long> ids, String entityId) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        BaseDataCommonService service = new BaseDataCommonService();
        service.changeOrgPermOnNewModel(entityId, org, ids, useOrgId);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityId);
        if (baseDataCtrlPlugin != null) {
            baseDataCtrlPlugin.afterPermChangeCheck(ids);
        }
    }

    private void changeOrgPermOnOldModel(Long useOrgId, DynamicObject targetOrg, List<Long> ids, String entityId) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin;
        List allCreateOrgIds;
        long targetOrgId = targetOrg.getLong("id");
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId));
        BaseDataServiceHelper.clearCache((DynamicObject[])load);
        ArrayList<Long> deleteIds = new ArrayList<Long>(load.length);
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>(load.length);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(load.length);
        String dataCtrlStrategy = null;
        for (DynamicObject data : load) {
            String ctrlStrategy = data.getString("ctrlstrategy");
            Long dataId = data.getLong("id");
            if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) {
                deleteParams.add(new Object[]{dataId, useOrgId});
                updateParams.add(new Object[]{targetOrgId, targetOrgId, targetOrgId, dataId});
            } else {
                deleteIds.add(dataId);
            }
            dataCtrlStrategy = ctrlStrategy;
        }
        if (!CollectionUtils.isEmpty(deleteIds)) {
            this.deleteBaseDataUseRange(entityId, deleteIds);
        }
        if (!CollectionUtils.isEmpty(deleteParams)) {
            this.deleteBaseDataUseRangeBatch(entityId, deleteParams);
        }
        if (!CollectionUtils.isEmpty(updateParams)) {
            this.updateAssignOrg(entityId, updateParams);
        }
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(load.length);
        for (DynamicObject data : load) {
            data.set("createorg", (Object)targetOrg);
            data.set("srccreateorg", (Object)targetOrg);
            data.set("org", (Object)targetOrg);
            saveData.add(data);
        }
        if (!saveData.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[0]));
            this.handleUseData(saveData);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
            String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entityId);
            SqlBuilder builder = new SqlBuilder();
            builder.append("update ", new Object[0]).append(dt.getAlias(), new Object[0]).append("set fsrccreateorgid = ?", new Object[]{targetOrgId}).append("where ", new Object[0]).appendIn(masterIdFieldName, ids.toArray()).append("and fid !=" + masterIdFieldName, new Object[0]);
            DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);
        }
        BaseDataCtrlCache.updateIsHasBaseDataUseRange((String)entityId, (Long)targetOrgId, (Boolean)Boolean.TRUE);
        if (CtrlStrategyEnum.GLOBAL_SHARE.getCtrlStrategy().equals(dataCtrlStrategy) && !(allCreateOrgIds = BaseDataCtrlCache.getGlobalShareDataCreateOrg((String)entityId)).contains(targetOrgId)) {
            ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
            createOrgIds.add(targetOrgId);
            BaseDataCtrlCache.updateGlobalShareDataCreateOrg((String)entityId, createOrgIds);
            BaseDataCtrlCache.cleanHasGlobalShareData((String)entityId);
        }
        if ((baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityId)) != null) {
            baseDataCtrlPlugin.afterPermChangeCheck(ids);
        }
    }

    private void handleUseData(List<DynamicObject> doc) {
        DynamicObject dataInfo = doc.get(0);
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String baseDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        ArrayList<Long> deleteDataIds = new ArrayList<Long>(doc.size());
        for (DynamicObject dynamicObject : doc) {
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) continue;
            deleteDataIds.add((Long)dynamicObject.getPkValue());
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!deleteDataIds.isEmpty()) {
                    SqlBuilder sbd = new SqlBuilder();
                    sbd.append("delete from ", new Object[0]).append(baseDataUseRegTableName, new Object[0]).append(" where ", new Object[0]);
                    sbd.appendIn("fdataid", deleteDataIds.toArray());
                    DB.execute((DBRoute)dbRoute, (SqlBuilder)sbd);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (DynamicObject dynamicObject : doc) {
            BaseDataServiceHelper.baseDataOrgChangeHandler((DynamicObject)dynamicObject);
        }
    }

    private void updateAssignOrg(String entityId, List<Object[]> updateParams) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String dbRouteKey = entityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String baseDataTableName = entityType.getAlias();
        String dataBaseUseReg = baseDataTableName + BASEDATAUSEREGSUFFIX;
        StringBuilder deleteUseRegSql = new StringBuilder();
        deleteUseRegSql.append("update ").append(dataBaseUseReg).append(" set fassignorgid = ? ,fcreateorgid = ?,fadminorgid = \uff1f where fdataid = ? ");
        try (TXHandle ignored = TX.requiresNew();){
            ArrayList<Object[]> params = new ArrayList<Object[]>(1000);
            for (Object[] tempDataIds : updateParams) {
                params.add(tempDataIds);
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), params);
                params.clear();
            }
            if (!CollectionUtils.isEmpty(params)) {
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), params);
                params.clear();
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u590d\u5206\u914d\u7ec4\u7ec7\u62a5\u9519", (Throwable)e);
        }
    }

    private void deleteBaseDataUseRangeBatch(String entityId, List<Object[]> deleteParams) {
        StringBuilder deleteUseRangeSql = new StringBuilder();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String dbRouteKey = entityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String baseDataTableName = entityType.getAlias();
        String dataBaseUseReg = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String baseDataUseRange = baseDataTableName + BASEDATAUSERANGESUFFIX;
        deleteUseRangeSql.append("delete ").append(baseDataUseRange).append(" where fdataid = ? and fuseorgid =? ");
        StringBuilder deleteUseRegSql = new StringBuilder();
        deleteUseRegSql.append("delete ").append(dataBaseUseReg).append(" where fdataid = ? and fuseorgid = ? ");
        try (TXHandle ignored = TX.requiresNew();){
            ArrayList<Object[]> params = new ArrayList<Object[]>(1000);
            for (Object[] tempDataIds : deleteParams) {
                params.add(tempDataIds);
                if (params.size() != 1000) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql.toString(), params);
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), params);
                params.clear();
            }
            if (!CollectionUtils.isEmpty(params)) {
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql.toString(), params);
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), params);
                params.clear();
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5206\u914d\u6570\u636e\u62a5\u9519", (Throwable)e);
        }
    }

    private void deleteBaseDataUseRange(String entityId, List<Long> dataIds) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
            String baseDataTableName = dt.getAlias();
            String dbRouteKey = dt.getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            String baseDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
            String deleteUseRangeSql = "delete from " + baseDataUseRangeTableName + " where fdataid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataIds.size());
            for (Long dataId : dataIds) {
                Object[] params = new Object[]{dataId};
                paramsList.add(params);
            }
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, paramsList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

