/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class CtrlStrategyConfigService {
    private static final Log LOGGER = LogFactory.getLog(CtrlStrategyConfigService.class);
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String PROP_ENTITY_ID = "basedataid";
    private static final String PROP_ENTITY = "basedata";
    private static final String PROP_ENTITY_VIEW = "basedataview";
    private static final int MAX_EXP = 500;

    public Map<String, Collection<DynamicObject>> exportStrategyConfig(Object[] configPks) {
        Map<Object, DynamicObject> bdViewRel;
        this.validate(configPks);
        Map<String, DynamicObject> defaultStrategyMap = this.selectDefaultCtrlStrategy(configPks);
        HashMap<String, Collection<DynamicObject>> json = new HashMap<String, Collection<DynamicObject>>(4);
        if (CollectionUtils.isEmpty(defaultStrategyMap)) {
            return json;
        }
        json.put("bd_bddefctrlstrtgy", defaultStrategyMap.values());
        QFilter[] filters = new QFilter[]{new QFilter(PROP_ENTITY, "in", defaultStrategyMap.keySet())};
        Map fieldConfigMap = BusinessDataServiceHelper.loadFromCache((String)"bd_ctrlstgyfieldcfg", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)fieldConfigMap)) {
            json.put("bd_ctrlstgyfieldcfg", fieldConfigMap.values());
        }
        if (CollectionUtils.isEmpty(bdViewRel = this.selectBdViewRel(defaultStrategyMap.keySet()))) {
            return json;
        }
        json.put("bd_basedataview", bdViewRel.values());
        filters = new QFilter[]{new QFilter(PROP_ENTITY_VIEW, "in", bdViewRel.keySet())};
        Map strategyEntityMap = BusinessDataServiceHelper.loadFromCache((String)"bd_bdctrlstrtgy", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)strategyEntityMap)) {
            json.put("bd_bdctrlstrtgy", strategyEntityMap.values());
        }
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u63a5\u53e3\u6267\u884c\u5bfc\u51fa\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u6210\u529f\u3002", "CtrlStrategyConfigService_11", SYSTEM_TYPE);
        this.writOpLog("exp_json", opDes);
        return json;
    }

    public Map<String, String> exportStrategyConfigOnMap(Object[] configPks) {
        this.validate(configPks);
        Map<String, DynamicObject> defaultStrategyMap = this.selectDefaultCtrlStrategy(configPks);
        HashMap<String, String> json = new HashMap<String, String>(4);
        if (CollectionUtils.isEmpty(defaultStrategyMap)) {
            return json;
        }
        String configJson = this.conversionConfig(defaultStrategyMap, "bd_bddefctrlstrtgy");
        json.put("bd_bddefctrlstrtgy", configJson);
        String fieldJson = this.conversionCtrlFieldConfig(defaultStrategyMap.keySet());
        json.put("bd_ctrlstgyfieldcfg", fieldJson);
        Map<Object, DynamicObject> bdViewRel = this.selectBdViewRel(defaultStrategyMap.keySet());
        if (CollectionUtils.isEmpty(bdViewRel)) {
            return json;
        }
        String viewJson = this.conversionConfig(bdViewRel, "bd_basedataview");
        json.put("bd_basedataview", viewJson);
        String strategyJson = this.conversionCtrlStrategyEntity(bdViewRel.keySet());
        json.put("bd_bdctrlstrtgy", strategyJson);
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u63a5\u53e3\u6267\u884c\u5bfc\u51faJSON\u6210\u529f\u3002", "CtrlStrategyConfigService_8", SYSTEM_TYPE);
        this.writOpLog("exp_json", opDes);
        return json;
    }

    private void validate(Object[] configPks) {
        this.isAdminValidate();
        if (null == configPks || configPks.length == 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u9700\u8981\u6267\u884c\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"CtrlStrategyConfigService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        if (configPks.length > 500) {
            String msg = ResManager.loadKDString((String)"\u4e00\u6b21\u6027\u5bfc\u51fa\u7684\u6570\u636e\u4e0d\u80fd\u5927\u4e8e500\u6761\u3002", (String)"CtrlStrategyConfigService_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private void isAdminValidate() {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CtrlStrategyConfigService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private Map<String, DynamicObject> selectDefaultCtrlStrategy(Object[] configPks) {
        DynamicObjectType dt = ORM.create().newDynamicObject("bd_bddefctrlstrtgy").getDynamicObjectType();
        DynamicObject[] arr = BusinessDataServiceHelper.load((Object[])configPks, (DynamicObjectType)dt);
        HashMap<String, DynamicObject> entityStrategyMap = new HashMap<String, DynamicObject>(arr.length);
        for (DynamicObject strategy : arr) {
            Object entity = strategy.get(PROP_ENTITY_ID);
            if (StringUtils.isBlank((Object)entity)) continue;
            if (entity instanceof DynamicObject) {
                String entityId = ((DynamicObject)entity).getString("id");
                entityStrategyMap.put(entityId, strategy);
                continue;
            }
            entityStrategyMap.put(entity.toString(), strategy);
        }
        return entityStrategyMap;
    }

    private String conversionCtrlFieldConfig(Collection<String> entities) {
        QFilter[] filters = new QFilter[]{new QFilter(PROP_ENTITY, "in", entities)};
        Map configMap = BusinessDataServiceHelper.loadFromCache((String)"bd_ctrlstgyfieldcfg", (QFilter[])filters);
        return this.conversionConfig(configMap, "bd_ctrlstgyfieldcfg");
    }

    private String conversionConfig(Map<?, DynamicObject> configMap, String entity) {
        if (CollectionUtils.isEmpty(configMap)) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        Object[] configs = configMap.values().toArray(new Object[0]);
        return DynamicObjectSerializeUtil.serialize((Object[])configs, (DynamicObjectType)type);
    }

    private Map<Object, DynamicObject> selectBdViewRel(Collection<String> entities) {
        QFilter[] filters = new QFilter[]{new QFilter(PROP_ENTITY, "in", entities)};
        return BusinessDataServiceHelper.loadFromCache((String)"bd_basedataview", (QFilter[])filters);
    }

    private String conversionCtrlStrategyEntity(Collection<Object> baseDataViewIds) {
        QFilter[] filters = new QFilter[]{new QFilter(PROP_ENTITY_VIEW, "in", baseDataViewIds)};
        Map strategyEntityMap = BusinessDataServiceHelper.loadFromCache((String)"bd_bdctrlstrtgy", (QFilter[])filters);
        return this.conversionConfig(strategyEntityMap, "bd_bdctrlstrtgy");
    }

    public String exportStrategyConfigSql(Object[] configPks) {
        this.validate(configPks);
        ArrayList<String> scripts = new ArrayList<String>(10);
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        List<String> defaultScripts = this.generateDefaultStrategySql(builder, Arrays.asList(configPks));
        scripts.addAll(defaultScripts);
        Map<String, DynamicObject> defaultStrategyMap = this.selectDefaultCtrlStrategy(configPks);
        if (CollectionUtils.isEmpty(defaultStrategyMap)) {
            return "";
        }
        List<String> fieldConfigSql = this.generateSql(defaultStrategyMap.keySet(), builder, "bd_ctrlstgyfieldcfg");
        scripts.addAll(fieldConfigSql);
        QFilter[] filters = new QFilter[]{new QFilter(PROP_ENTITY, "in", defaultStrategyMap.keySet())};
        List baseDataViewIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_basedataview", (QFilter[])filters, null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)baseDataViewIds)) {
            return String.join((CharSequence)"\n", scripts);
        }
        List<String> viewConfigSql = this.generateSql(defaultStrategyMap.keySet(), builder, "bd_basedataview");
        scripts.addAll(viewConfigSql);
        List<String> strategyEntitySql = this.generateStrategyEntitySql(baseDataViewIds, builder);
        scripts.addAll(strategyEntitySql);
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u63a5\u53e3\u6267\u884c\u5bfc\u51faSQL\u6210\u529f\u3002", "CtrlStrategyConfigService_6", SYSTEM_TYPE);
        this.writOpLog("exp_sql", opDes);
        return String.join((CharSequence)"\n", scripts);
    }

    private List<String> generateStrategyEntitySql(Collection<Object> baseDataViewIds, PreInsDataScriptBuilder builder) {
        StringJoiner joiner = new StringJoiner("','", "fbasedataviewid in ('", "')");
        baseDataViewIds.forEach(e -> joiner.add(e.toString()));
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_bdctrlstrtgy");
        String where = joiner.toString();
        return this.generateStrategyEntitySql((DynamicObjectType)type, builder, where, null);
    }

    private List<String> generateStrategyEntitySql(DynamicObjectType type, PreInsDataScriptBuilder builder, String where, String pkName) {
        ArrayList<String> scripts = new ArrayList<String>(10);
        String entrySql = this.genInsertSqlScript(type, builder, where, pkName);
        if (StringUtils.isNotBlank((CharSequence)entrySql)) {
            scripts.add(entrySql);
        }
        this.genMultilingualSql(builder, where, type, scripts);
        List<DynamicObjectType> entryTypes = this.getEntryTypes(type);
        if (!CollectionUtils.isEmpty(entryTypes)) {
            List<String> subEntrySql = this.genEntryInsertSqlScript(builder, where, type, entryTypes);
            scripts.addAll(subEntrySql);
        }
        return scripts;
    }

    private List<String> genEntryInsertSqlScript(PreInsDataScriptBuilder builder, String where, DynamicObjectType type, List<DynamicObjectType> entryTypes) {
        String pkName = type.getPrimaryKey().getAlias();
        where = pkName + " in (select " + pkName + " from " + type.getAlias() + " where " + where + ")";
        ArrayList<String> scripts = new ArrayList<String>(10);
        for (DynamicObjectType entryDt : entryTypes) {
            List<String> entrySqlList = this.generateStrategyEntitySql(entryDt, builder, where, pkName);
            scripts.addAll(entrySqlList);
        }
        return scripts;
    }

    private List<String> generateSql(Collection<String> entities, PreInsDataScriptBuilder builder, String entity) {
        StringJoiner joiner = new StringJoiner("", "fbasedataid in ('", "')");
        joiner.add(String.join((CharSequence)"','", entities));
        String where = joiner.toString();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        String mainTableSql = this.genInsertSqlScript((DynamicObjectType)type, builder, where, null);
        ArrayList<String> scripts = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((CharSequence)mainTableSql)) {
            scripts.add(mainTableSql);
        }
        this.genMultilingualSql(builder, where, (DynamicObjectType)type, scripts);
        return scripts;
    }

    private void genMultilingualSql(PreInsDataScriptBuilder builder, String where, DynamicObjectType type, List<String> scripts) {
        String pkName;
        String multilingualTableSql;
        DynamicObjectType dt = this.genMultilingualType(type);
        if (null != dt && StringUtils.isNotBlank((CharSequence)(multilingualTableSql = this.genInsertSqlScript(dt, builder, where = (pkName = type.getPrimaryKey().getAlias()) + " in (select " + pkName + " from " + type.getAlias() + " where " + where + ")", pkName)))) {
            scripts.add(multilingualTableSql);
        }
    }

    private List<String> generateDefaultStrategySql(PreInsDataScriptBuilder builder, Collection<?> pks) {
        String multilingualTableSql;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_bddefctrlstrtgy");
        String where = this.genWhereCondition(pks, type.getPrimaryKey());
        ArrayList<String> scripts = new ArrayList<String>(10);
        String mainTableSql = this.genInsertSqlScript((DynamicObjectType)type, builder, where, null);
        if (StringUtils.isNotBlank((CharSequence)mainTableSql)) {
            scripts.add(mainTableSql);
        }
        if (StringUtils.isNotBlank((CharSequence)(multilingualTableSql = this.genMultilingualTableSql((DynamicObjectType)type, builder, where)))) {
            scripts.add(multilingualTableSql);
        }
        return scripts;
    }

    private String genMultilingualTableSql(DynamicObjectType type, PreInsDataScriptBuilder builder, String where) {
        DynamicObjectType dt = this.genMultilingualType(type);
        if (null == dt) {
            return null;
        }
        String pkName = type.getPrimaryKey().getAlias();
        return this.genInsertSqlScript(dt, builder, where, pkName);
    }

    private DynamicObjectType genMultilingualType(DynamicObjectType type) {
        DataEntityPropertyCollection properties = type.getProperties();
        DynamicLocaleProperty mulProp = null;
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof DynamicLocaleProperty)) continue;
            mulProp = (DynamicLocaleProperty)property;
            break;
        }
        return null == mulProp ? null : mulProp.getDynamicCollectionItemPropertyType();
    }

    private List<DynamicObjectType> getEntryTypes(DynamicObjectType type) {
        DataEntityPropertyCollection properties = type.getProperties();
        ArrayList<DynamicObjectType> entryTypes = new ArrayList<DynamicObjectType>(properties.size());
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            entryTypes.add(((EntryProp)property).getDynamicCollectionItemPropertyType());
        }
        return entryTypes;
    }

    private String genInsertSqlScript(DynamicObjectType type, PreInsDataScriptBuilder builder, String where, String customField) {
        DataEntityPropertyCollection properties = type.getProperties();
        LinkedHashSet<String> selectFields = new LinkedHashSet<String>(properties.size() + 1);
        if (!StringUtils.isBlank((CharSequence)customField)) {
            selectFields.add(customField);
        }
        for (IDataEntityProperty property : properties) {
            String alias = property.getAlias();
            if (StringUtils.isBlank((CharSequence)alias) || property.isDbIgnore()) continue;
            selectFields.add(alias);
        }
        String fields = String.join((CharSequence)",", selectFields);
        Map sqlScript = builder.genInsertSQLScript(DBRoute.basedata, type.getAlias(), fields, where, null, null);
        return null == sqlScript ? null : (String)sqlScript.get("sql");
    }

    private String genWhereCondition(Collection<?> pks, ISimpleProperty pkProp) {
        String where = "";
        if (CollectionUtils.isEmpty(pks)) {
            return where;
        }
        String pkName = pkProp.getAlias();
        if (pkProp instanceof VarcharProp) {
            StringJoiner joiner = new StringJoiner("','", "('", "')");
            pks.forEach(e -> joiner.add(e.toString()));
            where = pkName + " in " + joiner.toString();
        } else if (pkProp instanceof LongProp) {
            StringJoiner joiner = new StringJoiner(",", "(", ")");
            pks.forEach(e -> joiner.add(e.toString()));
            where = pkName + " in " + joiner.toString();
        }
        return where;
    }

    public void importStrategyObjConfig(Map<String, Collection<DynamicObject>> config) {
        this.isAdminValidate();
        try (TXHandle tx = TX.required();){
            try {
                Collection<DynamicObject> strategies = config.get("bd_bddefctrlstrtgy");
                this.saveImportData(strategies, "bd_bddefctrlstrtgy");
                Collection<DynamicObject> fields = config.get("bd_ctrlstgyfieldcfg");
                this.saveImportData(fields, "bd_ctrlstgyfieldcfg");
                Collection<DynamicObject> views = config.get("bd_basedataview");
                this.saveImportData(views, "bd_basedataview");
                Collection<DynamicObject> strategyEntities = config.get("bd_bdctrlstrtgy");
                this.saveImportData(strategyEntities, "bd_bdctrlstrtgy");
                MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u63a5\u53e3\u6267\u884c\u5bfc\u5165\u7ba1\u63a7\u914d\u7f6e\u6210\u529f\u3002", "CtrlStrategyConfigService_13", SYSTEM_TYPE);
                this.writOpLog("imp_json", opDes);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5bfc\u5165\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CtrlStrategyConfigService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    public void importStrategyConfig(Map<String, String> config) {
        this.isAdminValidate();
        try (TXHandle tx = TX.required();){
            try {
                String configJson = config.get("bd_bddefctrlstrtgy");
                this.saveImportData(configJson, "bd_bddefctrlstrtgy");
                String fieldJson = config.get("bd_ctrlstgyfieldcfg");
                this.saveImportData(fieldJson, "bd_ctrlstgyfieldcfg");
                String viewJson = config.get("bd_basedataview");
                this.saveImportData(viewJson, "bd_basedataview");
                String strategyJson = config.get("bd_bdctrlstrtgy");
                this.saveImportData(strategyJson, "bd_bdctrlstrtgy");
                MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u63a5\u53e3\u6267\u884c\u5bfc\u5165JSON\u6210\u529f\u3002", "CtrlStrategyConfigService_4", SYSTEM_TYPE);
                this.writOpLog("imp_json", opDes);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u5bfc\u5165\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\u5931\u8d25.", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u7ba1\u63a7\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CtrlStrategyConfigService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private void saveImportData(String configJson, String entity) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        List<DynamicObject> configs = this.deserialize(configJson, (DynamicObjectType)type);
        this.saveImportData(configs, entity);
    }

    private void saveImportData(Collection<DynamicObject> configs, String entity) {
        if (CollectionUtils.isEmpty(configs)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        ArrayList<Object> dataIds = new ArrayList<Object>(configs.size());
        ArrayList<DynamicObject> clones = new ArrayList<DynamicObject>(configs.size());
        CloneUtils cloneUtils = new CloneUtils(true, true);
        String pkName = type.getPrimaryKey().getName();
        Iterator<DynamicObject> iterator = configs.iterator();
        while (iterator.hasNext()) {
            DynamicObject config = iterator.next();
            DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)config);
            Object pk = config.getPkValue();
            clone.set(pkName, pk);
            dataIds.add(pk);
            this.resetEntryPkValue(config, clone, (DynamicObjectType)type);
            clones.add(clone);
            iterator.remove();
        }
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])dataIds.toArray());
        SaveServiceHelper.save((DynamicObject[])clones.toArray(new DynamicObject[0]));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    private void resetEntryPkValue(DynamicObject config, DynamicObject clone, DynamicObjectType type) {
        List collectionProperties = type.getProperties().getCollectionProperties(true);
        if (CollectionUtils.isEmpty((Collection)collectionProperties)) {
            return;
        }
        for (ICollectionProperty property : collectionProperties) {
            if (!(property instanceof DynamicLocaleProperty) && !(property instanceof EntryProp)) continue;
            DynamicCollectionProperty prop = (DynamicCollectionProperty)property;
            String propName = prop.getName();
            DynamicObjectCollection entryCloneColl = clone.getDynamicObjectCollection(propName);
            DynamicObjectCollection entryColl = config.getDynamicObjectCollection(propName);
            if (CollectionUtils.isEmpty((Collection)entryColl) || CollectionUtils.isEmpty((Collection)entryCloneColl)) continue;
            this.setEntryPkValue(entryCloneColl, entryColl, prop.getDynamicCollectionItemPropertyType());
        }
    }

    private void setEntryPkValue(DynamicObjectCollection cloneColl, DynamicObjectCollection coll, DynamicObjectType type) {
        String pkName = type.getPrimaryKey().getName();
        for (int i = 0; i < coll.size() && i < cloneColl.size(); ++i) {
            DynamicObject config = (DynamicObject)coll.get(i);
            DynamicObject clone = (DynamicObject)cloneColl.get(i);
            clone.set(pkName, config.getPkValue());
            this.resetEntryPkValue(config, clone, type);
        }
    }

    private List<DynamicObject> deserialize(String configJson, DynamicObjectType type) {
        if (StringUtils.isBlank((CharSequence)configJson)) {
            return Collections.emptyList();
        }
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)configJson, (DynamicObjectType)type);
        ArrayList<DynamicObject> configs = new ArrayList<DynamicObject>(deserialize.length);
        for (Object v : deserialize) {
            configs.add((DynamicObject)v);
        }
        return configs;
    }

    private void writOpLog(String opKey, MultiLangEnumBridge opDes) {
        RequestContext context = RequestContext.get();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(Long.valueOf(context.getCurrUserId()));
        appLogInfo.setOrgID(Long.valueOf(context.getOrgId()));
        appLogInfo.setLanguage(context.getLang().name());
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOpName(opKey, BaseDataCommon.getOpName("bd_bddefctrlstrtgy", opKey));
        appLogInfo.setOpDesc(opDes, new String[0]);
        appLogInfo.setBizObjID("bd_bddefctrlstrtgy");
        appLogInfo.setBizAppID(EntityMetadataCache.getBizAppNumber((String)"bd_bddefctrlstrtgy"));
        appLogInfo.setAccountId(context.getAccountId());
        appLogInfo.setTenantId(context.getTenantId());
        appLogInfo.setClientName(context.getClient());
        appLogInfo.setClientIP(context.getLoginIP());
        appLogInfo.setClientType(context.getClient());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }
}

