/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DataSynService {
    private static final Log LOGGER = LogFactory.getLog(DataSynService.class);
    private static final String BASEDATA_URC_SUFFIX = "_URC";
    private static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    private static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";

    public void consumeAssignData(Map<String, Object> customParams) {
        String entityID = (String)customParams.get("entityID");
        String maxConsumeTimes = (String)customParams.get("maxConsumeTimes");
        if (kd.bos.util.StringUtils.isEmpty((String)maxConsumeTimes)) {
            maxConsumeTimes = CTRLSTRATEGY_CU_ASSIGN;
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        String baseDataTableName = dt.getAlias();
        String bdURCTableName = baseDataTableName + BASEDATA_URC_SUFFIX;
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        this.handleUnValidData(entityID, dbRoute, bdURCTableName);
        this.handleAssign(entityID, dbRoute, baseDataTableName, bdURCTableName, maxConsumeTimes);
        this.handleUnassign(entityID, dbRoute, bdURCTableName, maxConsumeTimes);
    }

    private void handleUnValidData(String entityID, DBRoute dbRoute, String bdURCTableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append(bdURCTableName);
        sb.append(" urc set fvalid = '0' where fconsumestatus <> '1' and fvalid = '1' and exists ( ");
        sb.append(" select maxct.fuseorgid,maxct.fdataid,maxct.fcreatetime from ( ");
        sb.append(" select max(fcreatetime) as fcreatetime,fuseorgid,fdataid from ");
        sb.append(bdURCTableName);
        sb.append(" where fconsumestatus <> '1' and fvalid = '1' group by fuseorgid,fdataid having count(fuseorgid)>1) maxct ");
        sb.append(" where urc.fuseorgid = maxct.fuseorgid and urc.fdataid = maxct.fdataid and urc.fcreatetime < maxct.fcreatetime)");
        DB.execute((DBRoute)dbRoute, (String)sb.toString());
    }

    private void handleAssign(String entityID, DBRoute dbRoute, String baseDataTableName, String bdURCTableName, String maxConsumeTimes) {
        String synType = CTRLSTRATEGY_CU_ASSIGN;
        StringBuilder urcQuery = new StringBuilder();
        urcQuery.append(" select urc.fid,urc.fassignorgid,urc.fdataid,urc.fuseorgid,m.fctrlstrategy,m.fcreateorgid,m.fmasterid from ");
        urcQuery.append(bdURCTableName).append(" urc ");
        urcQuery.append("  left join ").append(baseDataTableName).append(" m ");
        urcQuery.append("  on urc.fdataid = m.fid ");
        urcQuery.append("  where (fconsumestatus = '0' or fconsumestatus = '2') and fsyntype = '1' and fvalid = '1' ");
        urcQuery.append("  and fconsumetimes <  ").append(maxConsumeTimes);
        urcQuery.append("  order by fassignorgid, fuseorgid; ");
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)urcQuery.toString());){
            Map assignResult;
            ArrayList<Long> dataIDs = new ArrayList<Long>(32);
            ArrayList<Long> orgIDs = new ArrayList<Long>(32);
            Long lastAssignOrgId = null;
            Long lastUseOrgId = null;
            StringBuilder checkErrorSb = new StringBuilder();
            ArrayList<Object[]> checkErrorParams = new ArrayList<Object[]>(10);
            Timestamp nowTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
            List<Long> ctrlViewOrgs = BaseDataCommonService.getCtrlViewCuOrgs(entityID);
            for (Row row : ds) {
                Long fid = row.getLong("fid");
                Long dataId = row.getLong("fdataid");
                Long assignOrgId = row.getLong("fassignorgid");
                Long useOrgId = row.getLong("fuseorgid");
                String ctrlStrategy = row.getString("fctrlstrategy");
                Long createOrgId = row.getLong("fcreateorgid");
                Long masterId = row.getLong("fmasterid");
                if (!CTRLSTRATEGY_CU_FREE_ASSIGN.equals(ctrlStrategy)) {
                    checkErrorSb.append(ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e3a\u81ea\u7531\u5206\u914d\u7684\u6570\u636e\u624d\u80fd\u5206\u914d\u3002", (String)"DataSynService_1", (String)"bos-bd-business", (Object[])new Object[0]));
                }
                if (!assignOrgId.equals(createOrgId)) {
                    checkErrorSb.append(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"DataSynService_2", (String)"bos-bd-business", (Object[])new Object[0]));
                }
                if (!ctrlViewOrgs.contains(assignOrgId) || !ctrlViewOrgs.contains(useOrgId)) {
                    checkErrorSb.append(ResManager.loadKDString((String)"\u5206\u914d\u7ec4\u7ec7\u548c\u4f7f\u7528\u7ec4\u7ec7\u5fc5\u987b\u662f\u57fa\u7840\u6570\u636e\u63a7\u5236\u89c6\u56fe\u91cc\u7684\u7ba1\u63a7\u5355\u5143\u3002", (String)"DataSynService_3", (String)"bos-bd-business", (Object[])new Object[0]));
                }
                if (!masterId.equals(dataId)) {
                    checkErrorSb.append(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u7684\u81ea\u7531\u5206\u914d\u7c7b\u578b\u6570\u636e\u4e0d\u80fd\u5206\u914d\u3002", (String)"DataSynService_0", (String)"bos-bd-business", (Object[])new Object[0]));
                }
                if (checkErrorSb.length() > 0) {
                    Object[] param = new Object[]{checkErrorSb.toString(), nowTimestamp, fid};
                    checkErrorParams.add(param);
                    checkErrorSb.delete(0, checkErrorSb.length());
                    continue;
                }
                if (lastAssignOrgId == null) {
                    lastAssignOrgId = assignOrgId;
                }
                if (lastUseOrgId == null) {
                    lastUseOrgId = useOrgId;
                }
                if (!assignOrgId.equals(lastAssignOrgId) || !useOrgId.equals(lastUseOrgId) || dataIDs.size() >= 10000) {
                    orgIDs.add(lastUseOrgId);
                    assignResult = BaseDataServiceHelper.batchAssignWithDetail((String)entityID, (Long)lastAssignOrgId, dataIDs, orgIDs);
                    dataIDs.removeAll(assignResult.keySet());
                    this.updateURCWithSuccessDataIds(synType, dbRoute, bdURCTableName, lastUseOrgId, dataIDs);
                    this.updateURCWithFailResults(synType, dbRoute, bdURCTableName, lastUseOrgId, assignResult);
                    dataIDs.clear();
                    orgIDs.clear();
                    lastAssignOrgId = assignOrgId;
                    lastUseOrgId = useOrgId;
                    dataIDs.add(dataId);
                    continue;
                }
                dataIDs.add(dataId);
            }
            if (checkErrorParams.size() > 0) {
                this.updateURCWithCheckErrorParams(dbRoute, bdURCTableName, checkErrorParams);
            }
            if (dataIDs.size() > 0) {
                orgIDs.add(lastUseOrgId);
                AssignService assignService = new AssignService(entityID);
                String appId = DataSynService.getAppId(entityID);
                BaseDataResponse response = assignService.assign(lastAssignOrgId, appId, new HashSet<Long>(dataIDs), new HashSet<Long>(orgIDs), false);
                assignResult = response.getResult();
                if (!CollectionUtils.isEmpty((Map)assignResult)) {
                    dataIDs.removeAll(assignResult.keySet());
                }
                this.updateURCWithSuccessDataIds(synType, dbRoute, bdURCTableName, lastUseOrgId, dataIDs);
                this.updateURCWithFailResults(synType, dbRoute, bdURCTableName, lastUseOrgId, assignResult);
            }
        }
        catch (Exception e) {
            LOGGER.error("DataSynService.handleAssign error,EntityID is:" + entityID, (Throwable)e);
            throw e;
        }
    }

    private static String getAppId(String entityId) {
        FormConfig config = FormMetadataCache.getFormConfig((String)entityId);
        String appId = config.getAppId();
        String[] appIds = Instance.getAppIds();
        if (null == appIds || appIds.length == 0) {
            appIds = Instance.getInnerAppIds();
        }
        String defaultAppId = "bos";
        if (null == appIds || appIds.length == 0) {
            return defaultAppId;
        }
        Set collect = Arrays.stream(appIds).collect(Collectors.toSet());
        collect.removeIf(StringUtils::isBlank);
        if (collect.isEmpty()) {
            return defaultAppId;
        }
        return collect.contains(appId) ? appId : (String)collect.iterator().next();
    }

    private void handleUnassign(String entityID, DBRoute dbRoute, String bdURCTableName, String maxConsumeTimes) {
        String synType = CTRLSTRATEGY_CU_FREE_ASSIGN;
        StringBuilder urcQuery = new StringBuilder();
        urcQuery.append(" select fid,fdataid,fuseorgid,fconsumestatus,fcreatetime,fconsumetime from ");
        urcQuery.append(bdURCTableName);
        urcQuery.append("  where (fconsumestatus = '0' or fconsumestatus = '2') and fsyntype = '2' and fvalid = '1' ");
        urcQuery.append("  and fconsumetimes <  ").append(maxConsumeTimes);
        urcQuery.append("  order by fuseorgid; ");
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)urcQuery.toString());){
            List<Object> cancelFailResults;
            List<Long> cancelSuccessDataIds;
            List cancelAssignResult;
            HashSet<Long> dataIDs = new HashSet<Long>(32);
            HashSet<Long> orgIDs = new HashSet<Long>(32);
            Long lastUseOrgId = null;
            for (Row row : ds) {
                Long dataId = row.getLong("fdataid");
                Long useOrgId = row.getLong("fuseorgid");
                if (lastUseOrgId == null) {
                    lastUseOrgId = useOrgId;
                }
                if (!useOrgId.equals(lastUseOrgId) || dataIDs.size() >= 10000) {
                    orgIDs.add(lastUseOrgId);
                    cancelAssignResult = BaseDataServiceHelper.cancelAssign((String)entityID, dataIDs, orgIDs);
                    cancelSuccessDataIds = cancelAssignResult.stream().filter(CancelAssignResult::isSuccess).map(CancelAssignResult::getDataId).collect(Collectors.toList());
                    this.updateURCWithSuccessDataIds(synType, dbRoute, bdURCTableName, lastUseOrgId, cancelSuccessDataIds);
                    cancelFailResults = cancelAssignResult.stream().filter(e -> !e.isSuccess()).collect(Collectors.toList());
                    this.updateURCWithFailResults(synType, dbRoute, bdURCTableName, lastUseOrgId, cancelFailResults);
                    dataIDs.clear();
                    orgIDs.clear();
                    lastUseOrgId = useOrgId;
                    dataIDs.add(dataId);
                    continue;
                }
                dataIDs.add(dataId);
            }
            if (dataIDs.size() > 0) {
                orgIDs.add(lastUseOrgId);
                cancelAssignResult = BaseDataServiceHelper.cancelAssign((String)entityID, dataIDs, orgIDs);
                cancelSuccessDataIds = cancelAssignResult.stream().filter(CancelAssignResult::isSuccess).map(CancelAssignResult::getDataId).collect(Collectors.toList());
                this.updateURCWithSuccessDataIds(synType, dbRoute, bdURCTableName, lastUseOrgId, cancelSuccessDataIds);
                cancelFailResults = cancelAssignResult.stream().filter(e -> !e.isSuccess()).collect(Collectors.toList());
                this.updateURCWithFailResults(synType, dbRoute, bdURCTableName, lastUseOrgId, cancelFailResults);
            }
        }
        catch (Exception e2) {
            LOGGER.error("DataSynService.handleUnassign error,EntityID is:" + entityID, (Throwable)e2);
            throw e2;
        }
    }

    private void updateURCWithCheckErrorParams(DBRoute dbRoute, String bdURCTableName, List<Object[]> checkErrorParams) {
        if (CollectionUtils.isEmpty(checkErrorParams)) {
            return;
        }
        StringBuilder updateURCSQL = new StringBuilder();
        updateURCSQL.append(" update ");
        updateURCSQL.append(bdURCTableName);
        updateURCSQL.append(" set fconsumestatus = '2',ffaillog = ?,fconsumetime = ?,fconsumetimes = fconsumetimes + 1 ");
        updateURCSQL.append(" where fid = ? ;");
        DB.executeBatch((DBRoute)dbRoute, (String)updateURCSQL.toString(), checkErrorParams);
    }

    private void updateURCWithFailResults(String synType, DBRoute dbRoute, String bdURCTableName, Long lastUseOrgId, List<CancelAssignResult> cancelFailResults) {
        if (CollectionUtils.isEmpty(cancelFailResults)) {
            return;
        }
        Timestamp nowTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        String consumeStatusFail = CTRLSTRATEGY_CU_FREE_ASSIGN;
        StringBuilder updateURCSQL = new StringBuilder();
        updateURCSQL.append(" update ");
        updateURCSQL.append(bdURCTableName);
        updateURCSQL.append(" set fconsumestatus = ?,ffaillog = ?,fconsumetime = ?,fconsumetimes = fconsumetimes + 1 ");
        updateURCSQL.append(" where fuseorgid = ? and fdataid = ? and fsyntype = ? and fvalid = '1' ;");
        ArrayList<Object[]> params = new ArrayList<Object[]>(cancelFailResults.size());
        for (CancelAssignResult cancelFailResult : cancelFailResults) {
            params.add(new Object[]{consumeStatusFail, cancelFailResult.getErrorMsg(), nowTimestamp, lastUseOrgId, cancelFailResult.getDataId(), synType});
        }
        DB.executeBatch((DBRoute)dbRoute, (String)updateURCSQL.toString(), params);
    }

    private void updateURCWithFailResults(String synType, DBRoute dbRoute, String bdURCTableName, Long lastUseOrgId, Map<Long, Map<Long, String>> cancelFailResults) {
        if (CollectionUtils.isEmpty(cancelFailResults)) {
            return;
        }
        Timestamp nowTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        String consumeStatusFail = CTRLSTRATEGY_CU_ASSIGN;
        StringBuilder updateURCSQL = new StringBuilder();
        updateURCSQL.append(" update ");
        updateURCSQL.append(bdURCTableName);
        updateURCSQL.append(" set fconsumestatus = ?,ffaillog = ?,fconsumetime = ?,fconsumetimes = fconsumetimes + 1, ");
        updateURCSQL.append(" where fuseorgid = ? and fdataid = ? and fsyntype = ? and fvalid = '1';");
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, Map<Long, String>> next : cancelFailResults.entrySet()) {
            Long dataId = next.getKey();
            Map<Long, String> useOrgId2FailLogMap = next.getValue();
            for (Map.Entry<Long, String> useOrg2FailLogEntry : useOrgId2FailLogMap.entrySet()) {
                Long useOrgId = useOrg2FailLogEntry.getKey();
                String failLog = useOrg2FailLogEntry.getValue();
                params.add(new Object[]{consumeStatusFail, failLog, nowTimestamp, useOrgId, dataId, synType});
            }
        }
        DB.executeBatch((DBRoute)dbRoute, (String)updateURCSQL.toString(), params);
    }

    private void updateURCWithSuccessDataIds(String synType, DBRoute dbRoute, String bdURCTableName, Long lastUseOrgId, Collection<Long> dataIDs) {
        if (CollectionUtils.isEmpty(dataIDs)) {
            return;
        }
        Timestamp noeTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        SqlBuilder updateURCSQL = new SqlBuilder();
        updateURCSQL.append(" update ", new Object[0]);
        updateURCSQL.append(bdURCTableName, new Object[0]);
        updateURCSQL.append(" set fconsumestatus = '1', ", new Object[0]);
        updateURCSQL.append(" fconsumetimes = fconsumetimes + 1, ", new Object[0]);
        updateURCSQL.append(" fconsumetime = ?", new Object[]{noeTimestamp});
        updateURCSQL.append(" where fsyntype = ?", new Object[]{synType});
        updateURCSQL.append(" and fuseorgid = ?", new Object[]{lastUseOrgId});
        updateURCSQL.append(" and fvalid = '1' ", new Object[0]);
        updateURCSQL.append(" and ", new Object[0]);
        updateURCSQL.appendIn(" fdataid", new ArrayList<Long>(dataIDs));
        DB.execute((DBRoute)dbRoute, (SqlBuilder)updateURCSQL);
    }
}

