/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.ctsy.service.CtsyIndividualizeService;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.utils.BaseDataMutexUtils;
import kd.bos.bd.validator.BaseDataIndividualizeValidator;
import kd.bos.bd.validator.FreeStrategyIndividualizeValidator;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang.StringUtils;

@SdkInternal
public class IndividualizeService {
    private static final Log LOGGER = LogFactory.getLog(IndividualizeService.class);
    private final String entityId;
    private final String masterIdPropName;
    private boolean isNewModel;
    private BaseDataIndividualizeValidator validator;
    private static final String CREATE_ORG_ID = "createOrg_id";
    private static final String ORG_ID = "org_id";

    public IndividualizeService(String entityId) {
        this.entityId = entityId;
        this.isNewModel = BaseDataCommonService.isNewModel(entityId);
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        this.validator = new BaseDataIndividualizeValidator(entityId, this.masterIdPropName);
    }

    public BaseDataResponse individualize(Long useOrgId, String appId, Set<Long> dataIds) {
        BaseDataResponse response = this.validator.validateIndividualize(useOrgId, appId, dataIds);
        if (!response.isSuccess()) {
            return response;
        }
        Map<Long, String> errorMap = this.individualize(useOrgId, dataIds);
        if (CollectionUtils.isEmpty(errorMap)) {
            new CtsyIndividualizeService(this.entityId, useOrgId).ctsyIndividualize(dataIds);
            return new BaseDataResponse(true, "");
        }
        return new BaseDataResponse(false, String.join((CharSequence)"\n", errorMap.values()));
    }

    protected BaseDataResponse individualizeNotVerifyingRights(Long useOrgId, Set<Long> dataIds, String entityId) {
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        BaseDataIndividualizeValidator validator = new BaseDataIndividualizeValidator(entityId, masterIdPropName){

            @Override
            protected boolean hasOpPerm(Long useOrgId, String appId) {
                return true;
            }
        };
        BaseDataResponse response = validator.validateIndividualize(useOrgId, "", dataIds);
        if (response.isSuccess()) {
            Map<Long, String> errorMap = this.individualize(useOrgId, dataIds);
            if (CollectionUtils.isEmpty(errorMap)) {
                return new BaseDataResponse(true, "");
            }
            return new BaseDataResponse(false, String.join((CharSequence)"\n", errorMap.values()));
        }
        return response;
    }

    Map<Long, String> individualize(Long useOrgId, Set<Long> dataIds) {
        DynamicObject[] doc = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityId));
        ArrayList<DynamicObject[]> dataList = new ArrayList<DynamicObject[]>(doc.length);
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (DynamicObject oldObj : doc) {
            DynamicObject newObj = this.copyData(oldObj, cloneUtils, useOrgId);
            oldObj.set("useorg", (Object)useOrgId);
            DynamicObject[] objects = new DynamicObject[]{oldObj, newObj};
            dataList.add(objects);
        }
        Map errorMap = BaseDataServiceHelper.batchHandleModify((String)this.entityId, (Long)useOrgId, dataList);
        HashSet<Long> distributeDataIds = new HashSet<Long>(dataIds);
        if (null != errorMap && !CollectionUtils.isEmpty(errorMap.keySet())) {
            distributeDataIds.removeAll(errorMap.keySet());
        }
        if (!CollectionUtils.isEmpty(distributeDataIds)) {
            new CtsyIndividualizeService(this.entityId, useOrgId).ctsyIndividualize(distributeDataIds);
        }
        return errorMap;
    }

    private DynamicObject copyData(DynamicObject originalData, CloneUtils cloneUtils, Long useOrgId) {
        DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)originalData);
        clone.set("id", null);
        clone.set("createorg", (Object)useOrgId);
        clone.set(CREATE_ORG_ID, (Object)useOrgId);
        clone.set(ORG_ID, (Object)useOrgId);
        clone.set(this.masterIdPropName, (Object)originalData.getLong(this.masterIdPropName));
        clone.set("bitindex", null);
        clone.set("sourcedata", null);
        clone.set("srcindex", null);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> executeIndividualizeOnFreeStrategy(Long useOrgId, String appId, Set<Long> dataIds, IBaseDataCtrlPlugin service) {
        HashMap<Long, String> individualizeFailMap = new HashMap<Long, String>(16);
        HashSet<String> mutexes = new HashSet<String>(dataIds.size());
        dataIds.forEach(v -> mutexes.add(String.format("%s_%s", v, useOrgId)));
        ArrayList<Long> copy = new ArrayList<Long>(dataIds);
        try {
            HashMap<Long, String> mutex;
            List<DataMutexResult> dataMutexResults = BaseDataMutexUtils.batchRequireAndReturnFailMutex(this.entityId, "individuation", mutexes);
            for (DataMutexResult mutexResult : dataMutexResults) {
                mutex = mutexResult.getId();
                mutexes.remove(mutex);
                Long dataId = Long.valueOf(StringUtils.substringBefore((String)((Object)mutex), (String)"_"));
                dataIds.remove(dataId);
                individualizeFailMap.put(dataId, mutexResult.getMessage());
            }
            FreeStrategyIndividualizeValidator validator = new FreeStrategyIndividualizeValidator(this.entityId, this.masterIdPropName);
            BaseDataResponse response = validator.validateIndividualize(useOrgId, appId, dataIds);
            individualizeFailMap.putAll(validator.getIndividualizeFailMap());
            if (!response.isSuccess()) {
                dataIds.forEach(v -> individualizeFailMap.put((Long)v, response.getErrorMsg()));
                mutex = individualizeFailMap;
                return mutex;
            }
            if (CollectionUtils.isEmpty(dataIds)) {
                mutex = individualizeFailMap;
                return mutex;
            }
            if (null == service) {
                service = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityId);
            }
            CloneUtils cloneUtils = new CloneUtils(true, true);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
            Integer batchSize = Integer.getInteger("bd_individualize_batch_size", 10000);
            ArrayList<Long> originalIds = new ArrayList<Long>(batchSize);
            for (Long dataId : dataIds) {
                originalIds.add(dataId);
                if (originalIds.size() < batchSize) continue;
                this.batchExecuteIndividualize(useOrgId, originalIds, entityType, cloneUtils, service);
                originalIds.clear();
            }
            if (!originalIds.isEmpty()) {
                this.batchExecuteIndividualize(useOrgId, originalIds, entityType, cloneUtils, service);
            }
            HashMap<Long, String> hashMap = individualizeFailMap;
            return hashMap;
        }
        finally {
            BaseDataMutexUtils.batchRelease(this.entityId, mutexes, "individuation");
            BDCtrlLogHelper.saveIndividualizeLog(this.entityId, copy, useOrgId, individualizeFailMap);
        }
    }

    private void batchExecuteIndividualize(Long useOrgId, List<Long> dataIds, MainEntityType entityType, CloneUtils cloneUtils, IBaseDataCtrlPlugin service) {
        if (this.isNewModel) {
            new BaseDataCustomService(this.entityId).executeIndividualizeOnFreeStrategy(useOrgId, dataIds, service);
            return;
        }
        List<long[]> individualizeInfos = this.generateIndividualizeData(useOrgId, dataIds, entityType, cloneUtils, service);
        String tableName = entityType.getAlias();
        DBRoute route = DBRoute.of((String)entityType.getDBRouteKey());
        try (TXHandle tx = TX.required();){
            try {
                this.updateOrgUseRangData(tableName, route, useOrgId, dataIds, individualizeInfos);
                this.updateOrgUseRegData(tableName, route, useOrgId, individualizeInfos);
                this.updateUseExcData(tableName, route, useOrgId, individualizeInfos);
            }
            catch (Throwable e) {
                tx.markRollback();
                LOGGER.error("\u4e2a\u6027\u5316\u4fdd\u5b58\u4f7f\u7528\u5173\u7cfb\u4fe1\u606f\u5931\u8d25...", e);
                throw e;
            }
        }
    }

    private List<long[]> generateIndividualizeData(Long useOrgId, List<Long> dataIds, MainEntityType entityType, CloneUtils cloneUtils, IBaseDataCtrlPlugin service) {
        HashMap<Long, DynamicObject> individualizeMap = new HashMap<Long, DynamicObject>(dataIds.size());
        Map<Long, long[]> individualizeDataInfoMap = this.generateIndividualizeData(useOrgId, dataIds, entityType, cloneUtils, individualizeMap);
        HashMap data2CreateOrgMap = new HashMap(dataIds.size());
        individualizeDataInfoMap.values().forEach(v -> data2CreateOrgMap.put(v[0], v[1]));
        if (service != null) {
            service.beforeSaveIndividualizeData(this.entityId, data2CreateOrgMap, useOrgId, individualizeMap);
        }
        Object[] individualizeArr = SaveServiceHelper.save((DynamicObject[])individualizeMap.values().toArray(new DynamicObject[0]));
        if (null != service) {
            service.afterSaveIndividualizeData(this.entityId, data2CreateOrgMap, useOrgId, individualizeMap);
        }
        ArrayList<long[]> dataList = new ArrayList<long[]>(dataIds.size());
        for (Object individualize : individualizeArr) {
            Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)individualize, this.masterIdPropName);
            long[] data = individualizeDataInfoMap.remove(masterId);
            if (null == data) continue;
            data[2] = (Long)((DynamicObject)individualize).getPkValue();
            dataList.add(data);
        }
        try {
            IBaseDataCtrlPlugin plugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityId);
            if (null != plugin) {
                for (DynamicObject newDataInfo : individualizeMap.values()) {
                    plugin.handleModify(newDataInfo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4e2a\u6027\u5316\u4e1a\u52a1\u5904\u7406\u5f02\u5e38...", (Throwable)e);
        }
        return dataList;
    }

    private Map<Long, long[]> generateIndividualizeData(Long useOrgId, List<Long> dataIds, MainEntityType entityType, CloneUtils cloneUtils, Map<Long, DynamicObject> individualizeMap) {
        DynamicObject useOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)useOrgId)});
        DynamicObject[] originals = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)entityType);
        HashMap<Long, long[]> individualizeDataInfoMap = new HashMap<Long, long[]>(dataIds.size());
        for (int i = 0; i < originals.length; ++i) {
            DynamicObject original = originals[i];
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject(original, "createorg");
            Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject(original, this.masterIdPropName);
            long originalPk = (Long)original.getPkValue();
            individualizeDataInfoMap.put(masterId, new long[]{originalPk, createOrgId, 0L});
            DynamicObject clone = this.copyData(original, cloneUtils, useOrgId);
            clone.set("srccreateorg", original.get("createorg"));
            clone.set("useorg", (Object)useOrg);
            individualizeMap.put(originalPk, clone);
            originals[i] = null;
        }
        return individualizeDataInfoMap;
    }

    private void updateOrgUseRangData(String tableName, DBRoute route, Long useOrgId, Collection<Long> originals, List<long[]> individualizeInfos) {
        if (individualizeInfos.isEmpty()) {
            return;
        }
        String rangTable = tableName + "_U";
        SqlBuilder builder = new SqlBuilder();
        builder.append("delete from", new Object[0]).append(rangTable, new Object[0]).append("where fuseorgid = ?", new Object[]{useOrgId}).append("and", new Object[0]).appendIn("fdataid", originals.toArray());
        DB.execute((DBRoute)route, (SqlBuilder)builder);
        String insertSql = " insert into " + rangTable + "(FUseOrgID, FDataID) values(?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(individualizeInfos.size());
        for (long[] individualize : individualizeInfos) {
            params.add(new Object[]{useOrgId, individualize[2]});
        }
        DB.executeBatch((DBRoute)route, (String)insertSql, params);
    }

    private void updateOrgUseRegData(String tableName, DBRoute route, Long useOrgId, List<long[]> individualizeInfos) {
        String regTable = tableName + "Usereg";
        String insertSql = " insert into " + regTable + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign, FAssignOrgID) values(?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(individualizeInfos.size());
        for (long[] individualize : individualizeInfos) {
            params.add(new Object[]{useOrgId, individualize[2], useOrgId, useOrgId, "2", "0", 0L});
        }
        DB.executeBatch((DBRoute)route, (String)insertSql, params);
    }

    private void updateUseExcData(String tableName, DBRoute route, Long useOrgId, List<long[]> individualizeInfos) {
        String excTable = tableName + "exc";
        String insertSql = "insert into " + excTable + "(fuseorgid, FDataID, FCreateOrgID, FNEWDATAID) values(?, ?, ?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(individualizeInfos.size());
        for (long[] individualize : individualizeInfos) {
            params.add(new Object[]{useOrgId, individualize[0], individualize[1], individualize[2]});
        }
        DB.executeBatch((DBRoute)route, (String)insertSql, params);
    }
}

