/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bd.pojo.AutoIndividualData;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.IndividualizeService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;

@SdkInternal
public class TreeBaseDataCommonService
extends BaseDataCommonService {
    private static final int BATCH_LONG_NUMBER_SIZE = 100;
    private static final int DEFAULT_MAX_FACTOR = 300;

    public TreeBaseDataCommonService(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        super.init(entity);
    }

    public static boolean isAssignUnDetail(String entity) {
        if (!TreeBaseDataCommonService.isTreeTypeBaseData(entity)) {
            return false;
        }
        DynamicObject config = TreeBaseDataCommonService.getCtrlStrategyConfig(entity);
        if (null == config) {
            return false;
        }
        return config.getBoolean("assignundetail");
    }

    public Map<Long, String> checkTreeDataAssign(List<Long> ids, Long useOrgId, boolean needAll) {
        HashMap<Long, String> noticeIdsMap = new HashMap<Long, String>(ids.size());
        List<DynamicObject> leafList = this.getLeafNodes(ids, noticeIdsMap);
        Map<Long, String> treeIdsMap = this.getAllTreeNode(leafList, useOrgId);
        if (needAll) {
            return treeIdsMap;
        }
        for (Long id : ids) {
            if (!treeIdsMap.containsKey(id)) continue;
            noticeIdsMap.remove(id);
        }
        return noticeIdsMap;
    }

    private List<DynamicObject> getLeafNodes(List<Long> ids, Map<Long, String> nodesMap) {
        String selectFields = "id,number,isleaf,longnumber";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])filters);
        ArrayList<DynamicObject> leafList = new ArrayList<DynamicObject>(10);
        if (coll == null || coll.length == 0) {
            return leafList;
        }
        for (DynamicObject dynamicObject : coll) {
            Long id = dynamicObject.getLong("id");
            nodesMap.put(id, dynamicObject.getString("number"));
            if (!dynamicObject.getBoolean("isleaf")) continue;
            leafList.add(dynamicObject);
        }
        return leafList;
    }

    public Map<Long, String> getAllTreeNode(Collection<DynamicObject> collection, Long useOrgId) {
        HashMap<Long, String> treeIdsMap = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(collection)) {
            return treeIdsMap;
        }
        HashSet<Long> leafNodeIds = new HashSet<Long>(collection.size());
        ArrayList<String> longNumberList = new ArrayList<String>(10);
        String dlm = BaseDataCommonService.getLongNumberDLM(this.entity);
        for (DynamicObject obj : collection) {
            Long dataId = obj.getLong("id");
            leafNodeIds.add(dataId);
            String longNumber = obj.getString("longnumber");
            if (StringUtils.isBlank((CharSequence)longNumber)) continue;
            treeIdsMap.put(dataId, obj.getString("number"));
            longNumberList.add(longNumber);
            if (!longNumber.contains(dlm)) continue;
            this.getLongNumbers(longNumberList, longNumber, dlm);
        }
        if (longNumberList.isEmpty()) {
            return treeIdsMap;
        }
        List<TreeNode> integrityNodes = this.getIntegrityNodes(longNumberList, leafNodeIds, useOrgId);
        this.eachBuildNodeMapping(integrityNodes, treeIdsMap);
        return treeIdsMap;
    }

    private void eachBuildNodeMapping(List<TreeNode> nodes, Map<Long, String> treeIdsMap) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (TreeNode node : nodes) {
            treeIdsMap.put(Long.valueOf(node.getId()), node.getLongNumber());
            this.eachBuildNodeMapping(node.getChildren(), treeIdsMap);
        }
    }

    public List<Long> getIntegrityTreeNodeIds(Collection<Long> dataIds, Long currentOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("isleaf", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entity, (String)"id, longnumber", (QFilter[])filters);
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        String dlm = BaseDataCommonService.getLongNumberDLM(this.entity);
        ArrayList<String> longNumList = new ArrayList<String>(10);
        HashSet<Long> leafDataIds = new HashSet<Long>(collection.size());
        for (DynamicObject data : collection) {
            String longNumber = data.getString("longnumber");
            leafDataIds.add(data.getLong("id"));
            if (!StringUtils.isNotBlank((CharSequence)longNumber)) continue;
            longNumList.add(longNumber);
            if (!longNumber.contains(dlm)) continue;
            this.getLongNumbers(longNumList, longNumber, dlm);
        }
        return this.getIntegrityTreeNodeIds(leafDataIds, longNumList, currentOrgId);
    }

    private List<Long> getIntegrityTreeNodeIds(Set<Long> dataIds, List<String> longNumList, Long currentOrgId) {
        List<TreeNode> nodes = this.getIntegrityRootNodes(dataIds, longNumList, currentOrgId);
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> integrityNodeIds = new ArrayList<Long>(longNumList.size());
        for (TreeNode node : nodes) {
            integrityNodeIds.add(Long.valueOf(node.getId()));
            this.eachCollectChildDataIds(node.getChildren(), integrityNodeIds);
        }
        return integrityNodeIds;
    }

    public List<Long> getIntegrityNodeIds(Set<Long> dataIds, Long currentOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entity, (String)"longnumber", (QFilter[])filters);
        String dlm = BaseDataCommonService.getLongNumberDLM(this.entity);
        ArrayList<String> longNumList = new ArrayList<String>(10);
        for (DynamicObject data : collection) {
            String longNumber = data.getString("longnumber");
            if (!StringUtils.isNotBlank((CharSequence)longNumber)) continue;
            longNumList.add(longNumber);
            if (!longNumber.contains(dlm)) continue;
            this.getLongNumbers(longNumList, longNumber, dlm);
        }
        return this.getIntegrityTreeNodeIds(dataIds, longNumList, currentOrgId);
    }

    public List<TreeNode> getIntegrityRootNodes(Set<Long> dataId, List<String> longNumList, Long currentOrgId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (CollectionUtils.isEmpty(dataId)) {
            return nodes;
        }
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)this.entity, (Long)currentOrgId);
        QFilter[] filters = new QFilter[]{filter, new QFilter("longnumber", "in", (Object)longNumList.toArray())};
        String selectFields = this.buildSelectFields(Collections.emptyList());
        Collection values = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)selectFields, (QFilter[])filters).values();
        ArrayList<TreeNode> allNodes = new ArrayList<TreeNode>(16);
        if (CollectionUtils.isEmpty(values)) {
            return nodes;
        }
        values.forEach(e -> allNodes.add(this.createTreeNode(e.getString("id"), (DynamicObject)e, false)));
        List<TreeNode> treeNodes = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).buildIntegrityNodes(allNodes);
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return treeNodes;
        }
        for (TreeNode node : allNodes) {
            TreeNode root;
            if (!dataId.contains(Long.valueOf(node.getId())) || (root = this.getIntegrityNode(allNodes, node)).isCheckable()) continue;
            nodes.add(root);
            root.setCheckable(true);
        }
        return nodes;
    }

    public List<TreeNode> getIntegrityNodes(List<String> numberList, Set<Long> leafNodeIds, Long currentOrgId) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (CollectionUtils.isEmpty(numberList)) {
            return nodes;
        }
        QFilter[] filters = new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)this.entity, (Long)currentOrgId), new QFilter("longnumber", "in", (Object)numberList.toArray())};
        String selectFields = this.buildSelectFields(Collections.emptyList());
        Collection values = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)selectFields, (QFilter[])filters).values();
        if (!CollectionUtils.isEmpty(values)) {
            ArrayList<TreeNode> allNodes = new ArrayList<TreeNode>(16);
            for (DynamicObject value : values) {
                TreeNode node = this.createTreeNode(value.getString("id"), value, false);
                node.setLeaf(value.getBoolean("isleaf"));
                node.setLongNumber(value.getString("number"));
                allNodes.add(node);
            }
            List<TreeNode> treeNodes = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).buildIntegrityNodes(allNodes);
            if (!CollectionUtils.isEmpty(treeNodes)) {
                return treeNodes;
            }
            for (TreeNode node : allNodes) {
                TreeNode root;
                if (!node.isLeaf() || !leafNodeIds.contains(Long.valueOf(node.getId())) || (root = this.getIntegrityNode(allNodes, node)).isCheckable()) continue;
                nodes.add(root);
                root.setCheckable(true);
            }
        }
        return nodes;
    }

    private TreeNode getIntegrityNode(List<TreeNode> nodes, TreeNode node) {
        String pid = node.getParentid();
        if (StringUtils.isEmpty((CharSequence)pid)) {
            return node;
        }
        for (TreeNode parent : nodes) {
            if (!pid.equals(parent.getId())) continue;
            if (!node.isExpend()) {
                parent.addChild(node);
                node.setExpend(true);
            }
            node = this.getIntegrityNode(nodes, parent);
        }
        return node;
    }

    private void getLongNumbers(List<String> numberList, String longNumber, String dlm) {
        int lastIndex = longNumber.lastIndexOf(dlm);
        String number = longNumber.substring(0, lastIndex);
        numberList.add(number);
        if (number.contains(dlm)) {
            this.getLongNumbers(numberList, number, dlm);
        }
    }

    public List<DynamicObject> getChildNodesByParentIds(List<Long> parentDataIds, QFilter customFilter, List<String> fields, boolean includeParent) {
        if (CollectionUtils.isEmpty(parentDataIds)) {
            return new ArrayList<DynamicObject>(0);
        }
        List<TreeNode> nodes = this.getNodesByParentIds(parentDataIds, customFilter, fields);
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(parentDataIds.size());
        HashSet<Long> pIds = new HashSet<Long>(parentDataIds);
        for (TreeNode node : nodes) {
            if (!parentDataIds.contains(Long.valueOf(node.getId()))) continue;
            if (includeParent) {
                dataList.add((DynamicObject)node.getData());
            }
            this.eachCollectChildNodes(node.getChildren(), dataList, pIds, includeParent);
        }
        return dataList;
    }

    public List<Long> getChildNodeIdsByParentIds(List<Long> parentDataIds, QFilter customFilter, boolean includeParent) {
        if (CollectionUtils.isEmpty(parentDataIds)) {
            return Collections.emptyList();
        }
        List<TreeNode> nodes = this.getNodesByParentIds(parentDataIds, customFilter, Collections.emptyList());
        ArrayList<Long> dataIds = new ArrayList<Long>(parentDataIds.size());
        for (TreeNode node : nodes) {
            Long dataId = Long.valueOf(node.getId());
            if (!parentDataIds.contains(dataId)) continue;
            dataIds.add(dataId);
            this.eachCollectChildDataIds(node.getChildren(), dataIds);
        }
        if (includeParent) {
            return dataIds;
        }
        dataIds.removeAll(parentDataIds);
        return dataIds;
    }

    public Collection<DynamicObject> getUnLastVisibleNodeByIds(Long orgId, Collection<Long> dataIds, String selectFields) {
        if (CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        QFilter[] filters = new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)this.entity, (Long)orgId), new QFilter("parent", "in", dataIds)};
        ArrayList notLastVisibleNodeIds = new ArrayList(dataIds.size());
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), this.entity, "parent", filters);){
            ds.forEach(e -> notLastVisibleNodeIds.add(e.getLong("parent")));
        }
        if (notLastVisibleNodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        return QueryServiceHelper.query((String)this.entity, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", notLastVisibleNodeIds)});
    }

    public void correctTreeDataHierarchy(Long orgId, List<Long> resetLeaves, Map<Long, Long> original2CurrPkMap) {
        if (CollectionUtils.isEmpty(resetLeaves) || !TreeBaseDataCommonService.isAssignUnDetail(this.entity)) {
            return;
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append("update ", new Object[0]).append(dt.getAlias(), new Object[0]).append("set fisleaf = '1' where", new Object[0]).appendIn("fid", resetLeaves.toArray());
        DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);
        if (CollectionUtils.isEmpty(original2CurrPkMap)) {
            return;
        }
        Map<Long, Long> childParentMap = this.getChildParentOrgMap(orgId);
        DynamicObject[] childNodes = this.getChildNodes(original2CurrPkMap.keySet(), childParentMap);
        if (childNodes == null || childNodes.length == 0) {
            return;
        }
        ArrayList<Long> masterIds = new ArrayList<Long>(childNodes.length);
        HashMap<Long, List<Object[]>> correctParentDataMap = new HashMap<Long, List<Object[]>>(childNodes.length);
        for (DynamicObject node : childNodes) {
            Long originalParentId = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(node, "parent");
            Long currParentId = original2CurrPkMap.get(originalParentId);
            if (null == currParentId) continue;
            Object[] values = new Object[3];
            DynamicObject parent = node.getDynamicObject("parent");
            Long parentMasterId = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(parent, this.masterIdPropName);
            values[0] = parentMasterId;
            values[1] = node;
            values[2] = currParentId;
            Long createOrgId = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(node, "createorg");
            correctParentDataMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add(values);
            masterIds.add(parentMasterId);
        }
        Map<Long, Map<Long, DynamicObject>> newParentMap = this.executeAutoIndividual(masterIds, correctParentDataMap, childParentMap);
        if (!CollectionUtils.isEmpty(newParentMap)) {
            this.correctParentInfo(childNodes, correctParentDataMap, newParentMap, childParentMap);
        }
    }

    private Map<Long, Long> getChildParentOrgMap(Long orgId) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(String.valueOf(ctrlView.get("number")));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        param.setId(orgId.longValue());
        param.setIncludeDisable(true);
        param.setIncludeFreeze(true);
        List treeNodes = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        if (CollectionUtils.isEmpty((Collection)treeNodes)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> childParentOrgMap = new HashMap<Long, Long>(16);
        this.buildChildParentOrg(treeNodes, childParentOrgMap);
        return childParentOrgMap;
    }

    private void buildChildParentOrg(List<TreeNode> treeNodes, Map<Long, Long> childParentOrgMap) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return;
        }
        for (TreeNode node : treeNodes) {
            String pid = node.getParentid();
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                childParentOrgMap.put(Long.valueOf(node.getId()), Long.valueOf(pid));
            }
            this.buildChildParentOrg(node.getChildren(), childParentOrgMap);
        }
    }

    private DynamicObject[] getChildNodes(Collection<Long> parentIds, Map<Long, Long> childParentOrgMap) {
        if (childParentOrgMap.keySet().isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", childParentOrgMap.keySet()), new QFilter("parent", "in", parentIds)};
        return BusinessDataServiceHelper.load((String)this.entity, (String)("parent, createorg, " + this.masterIdPropName), (QFilter[])filters);
    }

    private void correctParentInfo(DynamicObject[] childNodes, Map<Long, List<Object[]>> correctParentDataMap, Map<Long, Map<Long, DynamicObject>> newParentMap, Map<Long, Long> childParentMap) {
        ArrayList<DynamicObject> updateParentNodes = new ArrayList<DynamicObject>(childNodes.length);
        for (Map.Entry<Long, List<Object[]>> entry : correctParentDataMap.entrySet()) {
            Long createOrgId = entry.getKey();
            Map<Long, DynamicObject> parentMstId2DataMap = newParentMap.get(createOrgId);
            for (Object[] value : entry.getValue()) {
                DynamicObject newParent;
                Long parentMasterId = (Long)value[0];
                if (CollectionUtils.isEmpty(parentMstId2DataMap)) {
                    parentMstId2DataMap = this.getParentMstId2Data(parentMasterId, createOrgId, newParentMap, childParentMap);
                }
                if (null == (newParent = parentMstId2DataMap.get(parentMasterId))) continue;
                DynamicObject node = (DynamicObject)value[1];
                node.set("parent", (Object)newParent);
                updateParentNodes.add(node);
            }
        }
        if (!updateParentNodes.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateParentNodes.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, DynamicObject> getParentMstId2Data(Long parentMasterId, Long orgId, Map<Long, Map<Long, DynamicObject>> newParentMap, Map<Long, Long> childParentMap) {
        Long parentOrgId = childParentMap.get(orgId);
        if (null == parentOrgId) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> parentMstId2DataMap = newParentMap.get(parentOrgId);
        if (CollectionUtils.isEmpty(parentMstId2DataMap) || !parentMstId2DataMap.containsKey(parentMasterId)) {
            return this.getParentMstId2Data(parentMasterId, parentOrgId, newParentMap, childParentMap);
        }
        return parentMstId2DataMap;
    }

    private Map<Long, Map<Long, DynamicObject>> executeAutoIndividual(List<Long> masterIds, Map<Long, List<Object[]>> correctParentDataMap, Map<Long, Long> childParentMap) {
        Map<Long, Set<Long>> autoIndividualMap = this.disassembleAutoIndividualData(correctParentDataMap, childParentMap);
        if (CollectionUtils.isEmpty(autoIndividualMap)) {
            return Collections.emptyMap();
        }
        IndividualizeService service = new IndividualizeService(this.entity);
        autoIndividualMap.forEach(service::individualize);
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", autoIndividualMap.keySet()), new QFilter(this.masterIdPropName, "in", masterIds), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName)};
        DynamicObject[] customDataArr = BusinessDataServiceHelper.load((String)this.entity, (String)("id, isleaf, createorg, " + this.masterIdPropName), (QFilter[])filters);
        if (customDataArr == null || customDataArr.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<Long, DynamicObject>> newParentMap = new HashMap<Long, Map<Long, DynamicObject>>(customDataArr.length);
        for (DynamicObject customData : customDataArr) {
            customData.set("isleaf", (Object)Boolean.FALSE);
            Long createOrgId = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(customData, "createorg");
            Long masterId = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(customData, this.masterIdPropName);
            newParentMap.computeIfAbsent(createOrgId, k -> new HashMap(16)).put(masterId, customData);
        }
        SaveServiceHelper.save((DynamicObject[])customDataArr);
        return newParentMap;
    }

    private Map<Long, Set<Long>> disassembleAutoIndividualData(Map<Long, List<Object[]>> correctParentDataMap, Map<Long, Long> childParentMap) {
        HashMap<Long, List<Long>> supperOrgMap = new HashMap<Long, List<Long>>(childParentMap.size());
        for (Map.Entry<Long, Long> entry : childParentMap.entrySet()) {
            Long orgId = entry.getKey();
            Long parentId = entry.getValue();
            supperOrgMap.computeIfAbsent(orgId, k -> new ArrayList(10)).add(parentId);
            this.buildSupperOrg(orgId, parentId, childParentMap, supperOrgMap);
        }
        HashMap<Long, Set<Long>> autoIndividualMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, List<Object[]>> entry : correctParentDataMap.entrySet()) {
            Long createOrgId = entry.getKey();
            List supperOrgIds = (List)supperOrgMap.get(createOrgId);
            if (CollectionUtils.isEmpty((Collection)supperOrgIds)) {
                entry.getValue().forEach(e -> autoIndividualMap.computeIfAbsent(createOrgId, k -> new HashSet(16)).add((Long)e[2]));
                continue;
            }
            for (Object[] value : entry.getValue()) {
                Long autoIndividualOrgId = this.getAutoIndividualOrg((Long)value[0], createOrgId, supperOrgIds, correctParentDataMap);
                autoIndividualMap.computeIfAbsent(autoIndividualOrgId, k -> new HashSet(16)).add((Long)value[2]);
            }
        }
        return autoIndividualMap;
    }

    private Long getAutoIndividualOrg(Long masterId, Long currOrgId, List<Long> supperOrgIds, Map<Long, List<Object[]>> correctParentDataMap) {
        for (int i = supperOrgIds.size() - 1; i >= 0; --i) {
            Long parentId = supperOrgIds.get(i);
            List<Object[]> supperDataArr = correctParentDataMap.get(parentId);
            if (CollectionUtils.isEmpty(supperDataArr)) continue;
            for (Object[] data : supperDataArr) {
                if (!masterId.equals((Long)data[0])) continue;
                return parentId;
            }
        }
        return currOrgId;
    }

    private void buildSupperOrg(Long currentOrgId, Long orgId, Map<Long, Long> childParentMap, Map<Long, List<Long>> supperOrgMap) {
        Long parentId = childParentMap.get(orgId);
        if (null != parentId) {
            supperOrgMap.computeIfAbsent(currentOrgId, k -> new ArrayList(10)).add(parentId);
            this.buildSupperOrg(currentOrgId, parentId, childParentMap, supperOrgMap);
        }
    }

    private List<TreeNode> getNodesByParentIds(List<Long> pIds, QFilter filter, Collection<String> fields) {
        QFilter[] filters;
        String selectFields = this.buildSelectFields(fields);
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", pIds)}));
        if (dataArr == null || dataArr.length == 0) {
            return Collections.emptyList();
        }
        List<TreeNode> extNodes = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).getNodesByParentIds(this.entity, pIds, filter, selectFields);
        if (!CollectionUtils.isEmpty(extNodes)) {
            return extNodes;
        }
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(dataArr.length);
        ArrayList<String> longNumList = new ArrayList<String>(dataArr.length);
        for (DynamicObject data : dataArr) {
            String longNumber = data.getString("longnumber");
            longNumList.add(longNumber);
            String dataId = data.getString("id");
            nodeMap.put(dataId, this.createTreeNode(dataId, data, true));
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        if (pIds.size() > 300) {
            nodeMap.putAll(this.hierarchicalQueryChildNodes(pIds, filter, selectFields));
            List<TreeNode> treeNodes = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).buildIntegrityNodes(nodeMap.values());
            if (!CollectionUtils.isEmpty(treeNodes)) {
                return treeNodes;
            }
            nodeMap.values().forEach(node -> this.eachFindParentNode((TreeNode)node, (Map<String, TreeNode>)nodeMap, (List<TreeNode>)nodes));
            return nodes;
        }
        nodeMap.putAll(this.selectNodeByLongNumber(longNumList, selectFields, filter));
        List<TreeNode> treeNodes = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).buildIntegrityNodes(nodeMap.values());
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return treeNodes;
        }
        nodeMap.values().forEach(node -> this.eachFindParentNode((TreeNode)node, (Map<String, TreeNode>)nodeMap, (List<TreeNode>)nodes));
        return nodes;
    }

    public List<TreeNode> buildTreeNodesById(List<Long> dataIds) {
        String selectFields = this.buildSelectFields(Collections.emptyList());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)this.entity, (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return Collections.emptyList();
        }
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(coll.size());
        for (DynamicObject data : coll) {
            Long dataId = data.getLong("id");
            nodeMap.put(dataId.toString(), this.createTreeNode(dataId.toString(), data, false));
        }
        List<TreeNode> treeNodes = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).buildIntegrityNodes(nodeMap.values());
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return treeNodes;
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        nodeMap.values().forEach(node -> this.eachFindParentNode((TreeNode)node, (Map<String, TreeNode>)nodeMap, (List<TreeNode>)nodes));
        return nodes;
    }

    private String buildSelectFields(Collection<String> fields) {
        Set<String> extProps;
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList("id", "parent", "number", "longnumber", "ctrlstrategy", "isleaf"));
        if (!CollectionUtils.isEmpty(fields)) {
            fieldSet.addAll(fields);
        }
        if (!CollectionUtils.isEmpty(extProps = BaseDataBusinessServiceUtils.getBaseDataSubExtService(this.entity).selectProps(this.entity))) {
            fieldSet.addAll(extProps);
        }
        return String.join((CharSequence)String.valueOf(','), fieldSet);
    }

    private Map<String, TreeNode> hierarchicalQueryChildNodes(Collection<Long> parentDataIds, QFilter customFilter, String selectFields) {
        QFilter[] filters = new QFilter[]{customFilter, new QFilter("parent", "in", parentDataIds)};
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])filters);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(dataArr.length);
        ArrayList<Long> dataIds = new ArrayList<Long>(dataArr.length);
        for (DynamicObject data : dataArr) {
            Long dataId = data.getLong("id");
            dataIds.add(dataId);
            nodeMap.put(dataId.toString(), this.createTreeNode(dataId.toString(), data, true));
        }
        if (!nodeMap.isEmpty()) {
            nodeMap.putAll(this.hierarchicalQueryChildNodes(dataIds, customFilter, selectFields));
        }
        return nodeMap;
    }

    private Map<String, TreeNode> selectNodeByLongNumber(List<String> longNumList, String selectFields, QFilter filter) {
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(longNumList.size());
        int size = longNumList.size();
        int totalPage = size % 100 > 0 ? size / 100 + 1 : size / 100;
        for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
            int fromIndex = pageNo * 100;
            int toIndex = Math.min((pageNo + 1) * 100, size);
            List<String> values = longNumList.subList(fromIndex, toIndex);
            nodeMap.putAll(this.batchSelectChildNodes(values, selectFields, filter));
        }
        return nodeMap;
    }

    private Map<String, TreeNode> batchSelectChildNodes(List<String> longNumbers, String selectProperties, QFilter customFilter) {
        String dlm = TreeBaseDataCommonService.getLongNumberDLM(this.entity);
        String longNum = longNumbers.get(0);
        QFilter filter = new QFilter("longnumber", "like", (Object)(longNum + dlm + "%"));
        for (int i = 1; i < longNumbers.size(); ++i) {
            filter = filter.or(new QFilter("longnumber", "like", (Object)(longNumbers.get(i) + dlm + "%")));
        }
        QFilter[] filters = new QFilter[]{filter, customFilter};
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)this.entity, (String)selectProperties, (QFilter[])filters);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(dataArr.length);
        for (DynamicObject data : dataArr) {
            String dataId = data.getString("id");
            nodeMap.put(dataId, this.createTreeNode(dataId, data, true));
        }
        return nodeMap;
    }

    private TreeNode createTreeNode(String dataId, DynamicObject data, boolean includeData) {
        Long pid = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(data, "parent");
        String parentId = 0L != pid ? pid.toString() : "";
        String number = data.getString("number");
        TreeNode node = includeData ? new TreeNode(parentId, dataId, number, (Object)data) : new TreeNode(parentId, dataId, number);
        node.setType(data.getString("ctrlstrategy"));
        node.setLongText(data.getString("longnumber"));
        return node;
    }

    private void eachFindParentNode(TreeNode node, Map<String, TreeNode> nodeMap, List<TreeNode> nodes) {
        TreeNode parent = nodeMap.get(node.getParentid());
        if (null == parent) {
            if (!node.isExpend()) {
                node.setExpend(true);
                nodes.add(node);
            }
            return;
        }
        if (node.isCheckable()) {
            return;
        }
        parent.addChild(node);
        node.setCheckable(true);
        this.eachFindParentNode(parent, nodeMap, nodes);
    }

    private void eachCollectChildDataIds(List<TreeNode> childNodes, Collection<Long> values) {
        if (CollectionUtils.isEmpty(childNodes)) {
            return;
        }
        for (TreeNode node : childNodes) {
            values.add(Long.valueOf(node.getId()));
            List children = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            this.eachCollectChildDataIds(children, values);
        }
    }

    private void eachCollectChildNodes(List<TreeNode> childNodes, List<DynamicObject> values, Set<Long> pIds, boolean includeParent) {
        if (CollectionUtils.isEmpty(childNodes)) {
            return;
        }
        for (TreeNode node : childNodes) {
            List children;
            if (includeParent) {
                values.add((DynamicObject)node.getData());
            } else if (!pIds.contains(Long.valueOf(node.getId()))) {
                values.add((DynamicObject)node.getData());
            }
            if (CollectionUtils.isEmpty((Collection)(children = node.getChildren()))) continue;
            this.eachCollectChildNodes(children, values, pIds, includeParent);
        }
    }

    boolean autoIndividualOnGraduallyStrategy(ListOrderedMap<Long, AutoIndividualData> autoIndividualizeMap, Long orgId) {
        if (CollectionUtils.isEmpty(autoIndividualizeMap)) {
            return false;
        }
        HashSet<Long> autoIndividualizeIds = new HashSet<Long>(autoIndividualizeMap.size());
        for (AutoIndividualData data : autoIndividualizeMap.values()) {
            if (data.isPersonalized()) continue;
            autoIndividualizeIds.add(data.getOriginalId());
        }
        if (autoIndividualizeIds.isEmpty()) {
            return false;
        }
        new IndividualizeService(this.entity).individualize(orgId, autoIndividualizeIds);
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "=", (Object)orgId), new QFilter(this.masterIdPropName, "in", (Object)autoIndividualizeMap.keySet())};
        String selectFields = "id, parent, number, isleaf, bitindex, srcindex, sourcedata, ctrlstrategy," + this.masterIdPropName;
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])filters);
        if (null == dataArr || dataArr.length == 0) {
            return false;
        }
        for (DynamicObject data : dataArr) {
            Long masterId = data.getLong(this.masterIdPropName);
            AutoIndividualData individualData = (AutoIndividualData)autoIndividualizeMap.get((Object)masterId);
            if (null == individualData) continue;
            individualData.setData(data);
            individualData.setLeaf(data.getBoolean("isleaf"));
            individualData.setBitIndex(data.getInt("bitindex"));
            individualData.setSrcIndex(data.getInt("srcindex"));
            individualData.setSrcId(data.getLong("sourcedata"));
            individualData.setNumber(data.getString("number"));
            individualData.setParentId(TreeBaseDataCommonService.getLongPropertyFromDynamicObject(data, "parent"));
            individualData.setGraduallyStrategy("1".equals(data.getString("ctrlstrategy")));
            if (individualData.isPersonalized()) {
                individualData.setOriginalId(data.getLong("sourcedata"));
                continue;
            }
            individualData.setIndividualId(data.getLong("id"));
        }
        return this.correctParentAndLeafInfo(autoIndividualizeMap);
    }

    private boolean correctParentAndLeafInfo(ListOrderedMap<Long, AutoIndividualData> autoIndividualizeMap) {
        boolean isUpdateHierarchy = false;
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(10);
        Long top = (Long)autoIndividualizeMap.firstKey();
        AutoIndividualData lastData = (AutoIndividualData)autoIndividualizeMap.get((Object)top);
        Long lastKey = (Long)autoIndividualizeMap.lastKey();
        for (Map.Entry entry : autoIndividualizeMap.entrySet()) {
            Long masterId = (Long)entry.getKey();
            AutoIndividualData individualData = (AutoIndividualData)entry.getValue();
            DynamicObject data = individualData.getData();
            if (top.equals(masterId)) {
                if (!individualData.isLeaf()) continue;
                data.set("isleaf", (Object)Boolean.FALSE);
                updates.add(data);
                continue;
            }
            boolean isUpdate = false;
            Long newPid = lastData.getIndividualId();
            if (null != newPid && !newPid.equals(individualData.getParentId())) {
                data.set("parent", (Object)newPid);
                individualData.setParentId(newPid);
                isUpdate = true;
                isUpdateHierarchy = true;
                individualData.setUpdateHierarchy(true);
            }
            if (masterId.equals(lastKey)) {
                if (!individualData.isLeaf()) {
                    isUpdate = true;
                    data.set("isleaf", (Object)Boolean.TRUE);
                }
            } else if (individualData.isLeaf()) {
                isUpdate = true;
                data.set("isleaf", (Object)Boolean.FALSE);
            }
            if (isUpdate) {
                updates.add(data);
            }
            lastData = individualData;
        }
        if (!updates.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
        return isUpdateHierarchy;
    }

    Map<Long, List<Integer>> autoIndividualOnFreeStrategy(List<Long> dataIds, Map<Long, Set<Long>> personalizedMap, Map<Long, Set<Long>> unableAssignMap) {
        return this.eachAutoIndividual(dataIds, personalizedMap, unableAssignMap, Collections.emptyMap(), false);
    }

    void autoIndividualOnGraduallyStrategy(List<Long> dataIds, Map<Long, Set<Long>> personalizedMap, Map<Long, Set<Long>> unableAssignMap, Map<Long, Long> id2MstIdMap) {
        this.eachAutoIndividual(dataIds, personalizedMap, unableAssignMap, id2MstIdMap, true);
    }

    private Map<Long, List<Integer>> eachAutoIndividual(List<Long> dataIds, Map<Long, Set<Long>> personalizedMap, Map<Long, Set<Long>> unableAssignMap, Map<Long, Long> id2MstIdMap, boolean isGraduallyStrategy) {
        HashMap<Long, List<Integer>> excludeIndexes = new HashMap<Long, List<Integer>>(16);
        List<TreeNode> treeNodes = this.buildTreeNodesById(dataIds);
        for (Map.Entry<Long, Set<Long>> entry : personalizedMap.entrySet()) {
            Long orgId = entry.getKey();
            ArrayList<TreeNode> individualNodes = new ArrayList<TreeNode>(10);
            Set<Long> personalizedIds = entry.getValue();
            Set<Long> notPassDataIds = unableAssignMap.get(orgId);
            block1: for (Long dataId : personalizedIds) {
                if (null != notPassDataIds && notPassDataIds.contains(dataId)) continue;
                for (TreeNode treeNode : treeNodes) {
                    TreeNode childNode = treeNode.getTreeNode(dataId.toString());
                    if (null == childNode) continue;
                    individualNodes.add(childNode);
                    continue block1;
                }
            }
            List<Integer> srcIndexes = this.autoIndividual(orgId, individualNodes, personalizedIds, id2MstIdMap, isGraduallyStrategy);
            if (CollectionUtils.isEmpty(srcIndexes)) continue;
            excludeIndexes.computeIfAbsent(orgId, k -> new ArrayList(srcIndexes.size())).addAll(srcIndexes);
        }
        return excludeIndexes;
    }

    private List<Integer> autoIndividual(Long orgId, List<TreeNode> individualNodes, Set<Long> unableIndividualIds, Map<Long, Long> id2MstIdMap, boolean isGraduallyStrategy) {
        QFilter filter;
        if (CollectionUtils.isEmpty(individualNodes)) {
            return Collections.emptyList();
        }
        Set<Long> childNodeIds = this.getChildNodeIds(individualNodes, new HashSet<Long>(16));
        Set<Long> needIndividualIds = childNodeIds.stream().filter(e -> !unableIndividualIds.contains(e)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(needIndividualIds)) {
            return Collections.emptyList();
        }
        new IndividualizeService(this.entity).individualize(orgId, needIndividualIds);
        boolean isNewModel = TreeBaseDataCommonService.isNewModel(this.entity);
        String selectFields = isNewModel ? "id, parent, isleaf, srcindex," + this.masterIdPropName : "id, parent, isleaf, " + this.masterIdPropName;
        if (isGraduallyStrategy) {
            ArrayList<Long> masterIds = new ArrayList<Long>(childNodeIds.size());
            for (Long nodeId : childNodeIds) {
                Long masterId = id2MstIdMap.get(nodeId);
                if (null == masterId) continue;
                masterIds.add(masterId);
            }
            filter = new QFilter(this.masterIdPropName, "in", masterIds);
        } else {
            filter = new QFilter(this.masterIdPropName, "in", childNodeIds);
        }
        QFilter[] filters = new QFilter[]{filter, new QFilter("createorg", "=", (Object)orgId)};
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)this.entity, (String)selectFields, (QFilter[])filters);
        if (null == dataArr || dataArr.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> srcIndexes = new ArrayList<Integer>(dataArr.length);
        HashMap<Long, DynamicObject> autoIndividualizeMap = new HashMap<Long, DynamicObject>(dataArr.length);
        for (DynamicObject data : dataArr) {
            Long mstId = data.getLong(this.masterIdPropName);
            autoIndividualizeMap.put(mstId, data);
            if (!isNewModel) continue;
            srcIndexes.add(data.getInt("srcindex"));
        }
        ArrayList updates = new ArrayList(autoIndividualizeMap.size());
        individualNodes.forEach(e -> this.correctParentAndLeafInfo((TreeNode)e, (Map<Long, DynamicObject>)autoIndividualizeMap, id2MstIdMap, updates, isGraduallyStrategy));
        if (!updates.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
        return srcIndexes;
    }

    private void correctParentAndLeafInfo(TreeNode node, Map<Long, DynamicObject> autoIndividualizeMap, Map<Long, Long> id2MstIdMap, List<DynamicObject> updates, boolean isGraduallyStrategy) {
        Long dataId = Long.valueOf(node.getId());
        List children = node.getChildren();
        boolean hasChildren = !CollectionUtils.isEmpty((Collection)children);
        boolean isUpdate = false;
        DynamicObject data = null;
        if (isGraduallyStrategy && null != id2MstIdMap) {
            data = autoIndividualizeMap.get(id2MstIdMap.get(dataId));
        } else if (!isGraduallyStrategy) {
            data = autoIndividualizeMap.get(dataId);
        }
        if (null != data) {
            boolean isLeaf = data.getBoolean("isleaf");
            if (hasChildren && isLeaf) {
                data.set("isleaf", (Object)false);
                isUpdate = true;
            } else if (!hasChildren && !isLeaf) {
                data.set("isleaf", (Object)true);
                isUpdate = true;
            }
            String originalPid = node.getParentid();
            if (StringUtils.isNotBlank((CharSequence)originalPid)) {
                DynamicObject newParent;
                if (isGraduallyStrategy) {
                    Long masterId = id2MstIdMap.get(Long.valueOf(originalPid));
                    newParent = autoIndividualizeMap.get(masterId);
                } else {
                    newParent = autoIndividualizeMap.get(Long.valueOf(originalPid));
                }
                Long newPid = null == newParent ? null : TreeBaseDataCommonService.getLongPropertyFromDynamicObject(newParent, "id");
                Long currPid = TreeBaseDataCommonService.getLongPropertyFromDynamicObject(data, "parent");
                if (null != newPid && !newPid.equals(currPid)) {
                    data.set("parent", (Object)newPid);
                    isUpdate = true;
                }
            }
            if (isUpdate) {
                updates.add(data);
            }
        }
        if (hasChildren) {
            children.forEach(e -> this.correctParentAndLeafInfo((TreeNode)e, autoIndividualizeMap, id2MstIdMap, updates, isGraduallyStrategy));
        }
    }

    private Set<Long> getChildNodeIds(List<TreeNode> individuals, Set<Long> dataIds) {
        if (!CollectionUtils.isEmpty(individuals)) {
            for (TreeNode node : individuals) {
                dataIds.add(Long.valueOf(node.getId()));
                List children = node.getChildren();
                this.getChildNodeIds(children, dataIds);
            }
        }
        return dataIds;
    }
}

