/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bd.pojo.SupplementColumnEnum;
import kd.bos.bd.service.AbstractBaseService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataSupplementService
extends AbstractBaseService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataSupplementService.class);

    public void modelSupplement(boolean isNewModel, String entity) {
        String key;
        LocalMemoryCache localCache = BaseDataSupplementService.getLocalCache();
        Object value = localCache.get(key = String.format("bd_supplement_%s_%s", RequestContext.get().getAccountId(), entity));
        if (!Objects.isNull(value) && Boolean.parseBoolean(value.toString())) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        if (null == dt) {
            localCache.put(key, (Object)Boolean.TRUE.toString());
            return;
        }
        String alias = dt.getAlias();
        if (StringUtils.isBlank((CharSequence)alias)) {
            localCache.put(key, (Object)Boolean.TRUE.toString());
            return;
        }
        String tableName = alias.toUpperCase();
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        this.checkAndAddColumn(entity, tableName, route, SupplementColumnEnum.SRC_ORG_ID);
        if (isNewModel) {
            this.newModelSupplement(entity, tableName, route);
        } else {
            this.originalModelSupplement(entity, tableName, route);
        }
        localCache.put(key, (Object)Boolean.TRUE.toString());
    }

    public void addSrcOrgIdColumn(String entity) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        if (null == dt) {
            return;
        }
        String alias = dt.getAlias();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            String tableName = alias.toUpperCase();
            DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
            this.checkAndAddColumn(entity, tableName, route, SupplementColumnEnum.SRC_ORG_ID);
        }
    }

    private void newModelSupplement(String entity, String tableName, DBRoute route) {
        this.checkAndAddColumn(entity, tableName, route, SupplementColumnEnum.BIT_INDEX);
        this.checkAndAddColumn(entity, tableName, route, SupplementColumnEnum.SRC_BIT_INDEX);
        this.checkAndAddColumn(entity, tableName, route, SupplementColumnEnum.SRC_DATA_ID);
        String bitTableName = (tableName + "_bit").toUpperCase();
        this.checkAndCreateTable(entity, bitTableName, route, () -> {
            SqlBuilder builder = new SqlBuilder();
            builder.append("CREATE TABLE ", new Object[0]).append(bitTableName, new Object[0]).append(" (  ", new Object[0]).append("FORGID BIGINT NOT NULL, ", new Object[0]).append("FDATA BLOB NOT NULL, ", new Object[0]).append("CONSTRAINT ", new Object[0]).append(this.getPkName(bitTableName), new Object[0]).append(" PRIMARY KEY (FORGID))", new Object[0]);
            return builder;
        });
    }

    private void originalModelSupplement(String entity, String tableName, DBRoute route) {
        String useRelTable = (tableName + "_U").toUpperCase();
        this.checkAndCreateTable(entity, useRelTable, route, () -> {
            SqlBuilder builder = new SqlBuilder();
            builder.append("create table ", new Object[0]).append(useRelTable, new Object[0]).append(" (  ", new Object[0]).append("FDataID bigint not null,  ", new Object[0]).append("FCreateOrgID bigint null,  ", new Object[0]).append("FUseOrgID bigint not null,  ", new Object[0]).append("constraint ", new Object[0]).append(this.getPkName(useRelTable), new Object[0]).append(" primary key (FDataID, FUseOrgID) ) ", new Object[0]);
            return builder;
        });
        String useRegTable = (tableName + "USEREG").toUpperCase();
        this.checkAndCreateTable(entity, useRegTable, route, () -> {
            SqlBuilder builder = new SqlBuilder();
            builder.append("create table ", new Object[0]).append(useRegTable, new Object[0]).append(" (", new Object[0]).append("FUseOrgID bigint  not null,", new Object[0]).append("FDataID  bigint not null,", new Object[0]).append("FCreateOrgID bigint null,", new Object[0]).append("FAdminOrgID bigint  null,", new Object[0]).append("FCtrlStrategy varchar(10)   null,", new Object[0]).append("FIsAssign char(1) null,", new Object[0]).append("FAssignOrgID bigint  null,", new Object[0]).append("FMASTERID bigint null,", new Object[0]).append("constraint ", new Object[0]).append(this.getPkName(useRegTable), new Object[0]).append(" primary key (FDataID, FUseOrgID)) ", new Object[0]);
            return builder;
        });
        String useExcTable = (tableName + "EXC").toUpperCase();
        this.checkAndCreateTable(entity, useExcTable, route, () -> {
            SqlBuilder builder = new SqlBuilder();
            builder.append("create table ", new Object[0]).append(useExcTable, new Object[0]).append(" (", new Object[0]).append("FDataID bigint not null,", new Object[0]).append("FNewDataID bigint not null,", new Object[0]).append("FCreateOrgID bigint null,", new Object[0]).append("FUseOrgID bigint not null,", new Object[0]).append("constraint ", new Object[0]).append(this.getPkName(useExcTable), new Object[0]).append(" primary key (FDataID, FUseOrgID)) ", new Object[0]);
            return builder;
        });
    }

    private String getPkName(String tableName) {
        StringJoiner joiner = new StringJoiner("", "PK_", "");
        int delimiterSize = joiner.length() + tableName.length() - 30;
        return delimiterSize > 0 ? joiner.add(tableName.substring(delimiterSize)).toString() : joiner.add(tableName).toString();
    }

    private void checkAndAddColumn(String entity, String tableName, DBRoute route, SupplementColumnEnum columnEnum) {
        LocalMemoryCache localCache;
        String accountId = RequestContext.get().getAccountId();
        String key = String.format("bd_%s_%s_%s", accountId, tableName, columnEnum.getColumnName());
        String type = String.format("field_type_%s_%s", accountId, entity);
        if (this.isCacheValue(type, key, localCache = BaseDataSupplementService.getLocalCache())) {
            return;
        }
        DLock lock = DLock.create((String)String.format("bd_ctrl_add_column_%s", entity));
        lock.lock();
        try {
            if (this.isCacheValue(type, key, localCache)) {
                return;
            }
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)String.format("tx_column_add_%s_%s", tableName, columnEnum.getColumnName()));){
                if (DB.existColumn((DBRoute)route, (String)tableName, (String)columnEnum.getColumnName())) {
                    localCache.put(key, (Object)Boolean.TRUE.toString());
                    BD_COMMON_CACHE.put(type, key, Boolean.TRUE.toString(), Integer.MAX_VALUE, TimeUnit.DAYS);
                    return;
                }
                try {
                    SqlBuilder builder = new SqlBuilder();
                    builder.append("ALTER TABLE ", new Object[0]).append(tableName, new Object[0]).append(" ADD (", new Object[0]).append(columnEnum.getSqlFragment(), new Object[0]).append(" )", new Object[0]);
                    DB.execute((DBRoute)route, (SqlBuilder)builder);
                    localCache.put(key, (Object)Boolean.TRUE.toString());
                    BD_COMMON_CACHE.put(type, key, Boolean.TRUE.toString(), Integer.MAX_VALUE, TimeUnit.DAYS);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7ed9\u6570\u636e\u8868[{0}]\u6dfb\u52a0\u5b57\u6bb5[{1}]\u5931\u8d25...", new Object[]{tableName, columnEnum.getColumnName(), e});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93%1$s\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataSupplementService_0", (String)"bos-bd-business", (Object[])new Object[0]), columnEnum.getColumnName()));
        }
        finally {
            lock.unlock();
        }
    }

    private void checkAndCreateTable(String entity, String tableName, DBRoute route, Supplier<SqlBuilder> supplier) {
        LocalMemoryCache localCache;
        String accountId = RequestContext.get().getAccountId();
        String key = String.format("bd_%s_%s", accountId, tableName);
        String type = String.format("table_type_%s_%s", accountId, entity);
        if (this.isCacheValue(type, key, localCache = BaseDataSupplementService.getLocalCache())) {
            return;
        }
        DLock lock = DLock.create((String)String.format("bd_ctrl_create_table_%s", tableName));
        lock.lock();
        try {
            if (this.isCacheValue(type, key, localCache)) {
                return;
            }
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)String.format("tx_table_create_%s", tableName));){
                if (DB.exitsTable((DBRoute)route, (String)tableName)) {
                    localCache.put(key, (Object)Boolean.TRUE.toString());
                    BD_COMMON_CACHE.put(type, key, Boolean.TRUE.toString(), Integer.MAX_VALUE, TimeUnit.DAYS);
                    return;
                }
                try {
                    SqlBuilder builder = supplier.get();
                    DB.execute((DBRoute)route, (SqlBuilder)builder);
                    localCache.put(key, (Object)Boolean.TRUE.toString());
                    BD_COMMON_CACHE.put(type, key, Boolean.TRUE.toString(), Integer.MAX_VALUE, TimeUnit.DAYS);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u6570\u636e\u8868[{0}]\u5931\u8d25...", (Object)tableName, (Object)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6570\u636e\u8868%1$s\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataSupplementService_1", (String)"bos-bd-business", (Object[])new Object[0]), tableName));
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isCacheValue(String type, String key, LocalMemoryCache localCache) {
        boolean cached;
        Object value = localCache.get(key);
        boolean bl = cached = !Objects.isNull(value) && Boolean.parseBoolean(value.toString());
        if (cached) {
            return true;
        }
        String cache = (String)BD_COMMON_CACHE.get(type, key);
        if (Boolean.parseBoolean(cache)) {
            localCache.put(key, (Object)Boolean.TRUE.toString());
            return true;
        }
        return false;
    }

    public Map<Object, DynamicObject> individualizeSupplement(String entityId, List<DynamicObject[]> dataList) {
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(dataList.size());
        if (CollectionUtils.isEmpty(dataList)) {
            return result;
        }
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        ArrayList<DynamicObject> missingSrcOrgDataList = new ArrayList<DynamicObject>(dataList.size());
        for (DynamicObject[] node : dataList) {
            DynamicObject newObj = node[1];
            Long srcOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject(newObj, "srccreateorg");
            if (0L != srcOrgId) continue;
            DynamicObject oldObj = node[0];
            Object masterId = oldObj.get(masterIdPropName);
            result.put(masterId, newObj);
            if (Objects.equals(oldObj.getPkValue(), masterId)) {
                newObj.set("srccreateorg", oldObj.get("createorg"));
                continue;
            }
            missingSrcOrgDataList.add(newObj);
        }
        if (missingSrcOrgDataList.isEmpty()) {
            return result;
        }
        List pks = missingSrcOrgDataList.stream().mapToLong(v -> v.getLong(masterIdPropName)).boxed().collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pks)};
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)"createorg", (QFilter[])filters);
        for (DynamicObject individualData : missingSrcOrgDataList) {
            DynamicObject originalData = (DynamicObject)dataMap.get(individualData.getLong(masterIdPropName));
            if (null == originalData) continue;
            individualData.set("srccreateorg", originalData.get("createorg"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCtrlStrategyFieldAfterCopy(String entity, List<DynamicObject> dataList) {
        if (CollectionUtils.isEmpty(dataList) || !BaseDataCommonService.isNewModel(entity)) {
            return;
        }
        String lockKey = this.getGenIndexLockKey(entity);
        DLock lock = DLock.create((String)lockKey);
        lock.lock();
        try {
            boolean bitIndexHasChange = false;
            int bitIndex = this.getMaxBitIndex(entity, dataList.size());
            for (DynamicObject data : dataList) {
                if (data.getDataEntityState().getFromDatabase()) continue;
                data.set("sourcedata", data.getPkValue());
                data.set("bitindex", (Object)(++bitIndex));
                data.set("srcindex", (Object)bitIndex);
                bitIndexHasChange = true;
            }
            if (bitIndexHasChange) {
                this.updateBaseDataBitIndexCache(entity, String.valueOf(bitIndex));
            }
        }
        finally {
            lock.unlock();
        }
    }
}

