/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.subscribe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.pojo.AutoAssignPlanDetail;
import kd.bos.bd.service.AutoAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class BaseDataAutoAssignPlugin
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(BaseDataAutoAssignPlugin.class);
    private static final String APP_ID = "appId";
    private static final String PLAN_DETAIL = "plandetail";
    private static final int ASSIGN_BATCH_NUM_NEW_MODEL = 50000000;
    private static final int ASSIGN_BATCH_NUM_OLD_MODEL = 100000;
    private final AutoAssignService autoAssignService = new AutoAssignService();

    public Object compensateEvent(KDBizEvent evt) {
        return super.compensateEvent(evt);
    }

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        return super.calculateUserIds(evt);
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        return super.buildBillUrl(evt);
    }

    public Object handleEvent(KDBizEvent evt) {
        String entityId = ((EntityEvent)evt).getEntityNumber();
        List businessKeys = ((EntityEvent)evt).getBusinesskeys();
        DynamicObjectCollection autoAssignPlans = new AutoAssignService().getAutoAssignPlan(entityId);
        this.executeAutoAssign(entityId, autoAssignPlans, businessKeys);
        return super.handleEvent(evt);
    }

    private void executeAutoAssign(String entityId, DynamicObjectCollection autoAssignPlans, List<String> businessKeys) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (autoAssignPlans.isEmpty() || null == ctrlView) {
            LOGGER.info("BaseDataAutoAssignPlugin end cause by: autoAssignPlans is empty or ctrlView is null.");
            return;
        }
        Long viewId = ctrlView.getLong("id");
        ArrayList<Long> planIds = new ArrayList<Long>(autoAssignPlans.size());
        autoAssignPlans.forEach(autoAssignPlan -> planIds.add(autoAssignPlan.getLong("id")));
        Map<Long, List<AutoAssignPlanDetail>> planDetailMap = this.autoAssignService.getPlanDetailMap(planIds);
        List<Long> filterConditionIds = this.autoAssignService.getFilterConditionIds(autoAssignPlans, planDetailMap);
        if (CollectionUtils.isEmpty(filterConditionIds) || CollectionUtils.isEmpty(businessKeys)) {
            LOGGER.info("BaseDataAutoAssignPlugin end cause by: filterConditionIds or dataId is empty.");
            return;
        }
        Map<Long, String> filterConditionMap = this.autoAssignService.getFilterConditionMap(filterConditionIds);
        Map<Long, List<Long>> planDetailIdUseOrgIdMap = this.autoAssignService.getPlanDetailIdUseOrgIdMap(viewId, autoAssignPlans);
        ArrayList<Long> autoAssignPlanIds = new ArrayList<Long>(autoAssignPlans.size());
        for (DynamicObject autoAssignPlan2 : autoAssignPlans) {
            List<AutoAssignPlanDetail> planDetails = planDetailMap.get(autoAssignPlan2.getLong(PLAN_DETAIL));
            if (CollectionUtils.isEmpty(planDetails)) {
                LOGGER.info("BaseDataAutoAssignPlugin end cause by: planDetails is empty.");
                continue;
            }
            this.executeAutoAssignDetail(entityId, businessKeys, viewId, filterConditionMap, planDetailIdUseOrgIdMap, autoAssignPlan2, planDetails);
            autoAssignPlanIds.add(autoAssignPlan2.getLong("id"));
        }
        this.autoAssignService.updateExecuteTime(autoAssignPlanIds);
    }

    private void executeAutoAssignDetail(String entityId, List<String> businessKeys, Long viewId, Map<Long, String> filterConditionMap, Map<Long, List<Long>> planDetailIdUseOrgIdMap, DynamicObject autoAssignPlan, List<AutoAssignPlanDetail> planDetails) {
        String appId = autoAssignPlan.getString(APP_ID);
        String ctrlStrategy = autoAssignPlan.getString("ctrlstrategy");
        for (AutoAssignPlanDetail planDetail : planDetails) {
            long planDetailId = planDetail.getEntryId();
            long filterConditionId = planDetail.getFilterConditionId();
            long assignOrgId = planDetail.getAssignOrgId();
            String filterCondition = filterConditionMap.get(filterConditionId);
            HashSet<Long> dataIds = new HashSet<Long>(businessKeys.size());
            businessKeys.forEach(businessKey -> dataIds.add(Long.valueOf(businessKey)));
            List<Long> baseDataIdsMatch = this.autoAssignService.getBaseDataMatch(entityId, assignOrgId, filterCondition, ctrlStrategy, dataIds);
            List<Long> useOrgIds = planDetailIdUseOrgIdMap.get(planDetailId);
            if (CollectionUtils.isEmpty(useOrgIds) || baseDataIdsMatch.isEmpty()) continue;
            if (Boolean.TRUE.equals(planDetail.isContainSubordinate())) {
                useOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, useOrgIds, (boolean)true, (boolean)false);
                useOrgIds = this.autoAssignService.getCuOrgIds(viewId, useOrgIds);
            }
            if (CollectionUtils.isEmpty(baseDataIdsMatch)) continue;
            this.assignBatchHandle(entityId, assignOrgId, appId, baseDataIdsMatch, useOrgIds, planDetailId, autoAssignPlan);
        }
    }

    public void assignBatchHandle(String entityId, long assignOrgId, String appId, List<Long> dataIds, List<Long> useOrgIds, Long planDetailId, DynamicObject autoAssignPlan) {
        int assignBatchNum;
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(useOrgIds)) {
            return;
        }
        long currentNum = (long)dataIds.size() * (long)useOrgIds.size();
        int n = assignBatchNum = BaseDataCommonService.isNewModel(entityId) ? 50000000 : 100000;
        if (currentNum <= (long)assignBatchNum) {
            BaseDataResponse assignResult = this.autoAssignService.assign(entityId, assignOrgId, appId, new HashSet<Long>(dataIds), new HashSet<Long>(useOrgIds), planDetailId);
            this.autoAssignService.saveAssignResult(entityId, planDetailId, Collections.singletonList(assignResult), autoAssignPlan);
            return;
        }
        this.assignBatchHandleByData(entityId, assignOrgId, appId, dataIds, useOrgIds, planDetailId, autoAssignPlan);
    }

    private void assignBatchHandleByData(String entityId, long assignOrgId, String appId, List<Long> dataIds, List<Long> orgIdList, Long planDetailId, DynamicObject autoAssignPlan) {
        int assignBatchNum = BaseDataCommonService.isNewModel(entityId) ? 50000000 : 100000;
        HashSet<Long> orgIds = new HashSet<Long>(orgIdList);
        int pageSize = assignBatchNum / orgIds.size();
        if (BaseDataCommonService.isTreeType(entityId)) {
            this.batchExecuteCancelAssignTreeData(orgIds, entityId, dataIds, pageSize, assignOrgId, appId, planDetailId, autoAssignPlan);
        } else {
            int size = dataIds.size();
            int totalPage = size % pageSize > 0 ? size / pageSize + 1 : size / pageSize;
            ArrayList<BaseDataResponse> assignResults = new ArrayList<BaseDataResponse>(totalPage);
            for (int pageNo = 1; pageNo <= totalPage; ++pageNo) {
                int fromIndex = (pageNo - 1) * pageSize;
                int toIndex = Math.min(pageNo * pageSize, size);
                HashSet<Long> values = new HashSet<Long>(dataIds.subList(fromIndex, toIndex));
                BaseDataResponse assignResult = this.autoAssignService.assign(entityId, assignOrgId, appId, values, orgIds, planDetailId);
                assignResults.add(assignResult);
            }
            this.autoAssignService.saveAssignResult(entityId, planDetailId, assignResults, autoAssignPlan);
        }
    }

    private void batchExecuteCancelAssignTreeData(Set<Long> orgIds, String entityId, List<Long> dataIds, int pageSize, Long assignOrgId, String appId, Long planDetailId, DynamicObject autoAssignPlan) {
        List<TreeNode> nodes = new TreeBaseDataCommonService(entityId).buildTreeNodesById(dataIds);
        ArrayList<HashSet<Long>> batchDataIds = new ArrayList<HashSet<Long>>(10);
        HashSet<Long> pageDataIds = new HashSet<Long>(16);
        for (TreeNode node : nodes) {
            this.collectCancelDataIds(node, pageDataIds);
            if (pageDataIds.size() < pageSize) continue;
            batchDataIds.add(pageDataIds);
            pageDataIds = new HashSet(16);
        }
        if (!pageDataIds.isEmpty()) {
            batchDataIds.add(pageDataIds);
        }
        int totalPage = batchDataIds.size();
        ArrayList<BaseDataResponse> assignResults = new ArrayList<BaseDataResponse>(totalPage);
        for (int pageNo = 1; pageNo <= batchDataIds.size(); ++pageNo) {
            Set values = (Set)batchDataIds.get(pageNo - 1);
            BaseDataResponse assignResult = this.autoAssignService.assign(entityId, assignOrgId, appId, values, orgIds, planDetailId);
            assignResults.add(assignResult);
        }
        this.autoAssignService.saveAssignResult(entityId, planDetailId, assignResults, autoAssignPlan);
    }

    private void collectCancelDataIds(TreeNode node, Collection<Long> values) {
        values.add(Long.valueOf(node.getId()));
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode childNode : children) {
            if (null == childNode) continue;
            this.collectCancelDataIds(childNode, values);
        }
    }
}

