/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.pojo.AutoAssignPlanDetail;
import kd.bos.bd.service.AutoAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.validator.AutoAssignValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AutoAssignJobTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AutoAssignJobTask.class);
    private static final String ENTITY_ID = "entityId";
    private static final String APP_ID = "appId";
    private static final String AUTO_ASSIGN_PLAN_ID = "autoAssignPlanId";
    private static final String PLAN_DETAIL = "planDetail";
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final int ASSIGN_BATCH_NUM_NEW_MODEL = 50000000;
    private static final int ASSIGN_BATCH_NUM_OLD_MODEL = 100000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isFromOrgSaveEvt = "event_org_save".equals(map.get("task_source"));
        if (isFromOrgSaveEvt) {
            Map viewOrgTmp = (Map)SerializationUtils.fromJsonString((String)map.get("task_view_org").toString(), HashMap.class);
            HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgTmp.size());
            for (Map.Entry entry : viewOrgTmp.entrySet()) {
                Set useOrgIds = ((Collection)entry.getValue()).stream().mapToLong(v -> Long.parseLong(v.toString())).boxed().collect(Collectors.toSet());
                viewOrgMap.put(Long.valueOf(entry.getKey().toString()), useOrgIds);
            }
            Map entityViewTmp = (Map)SerializationUtils.fromJsonString((String)map.get("task_entity_view").toString(), HashMap.class);
            HashMap<String, Long> entityViewMap = new HashMap<String, Long>(entityViewTmp.size());
            for (Map.Entry entry : entityViewTmp.entrySet()) {
                entityViewMap.put((String)entry.getKey(), Long.valueOf(entry.getValue().toString()));
            }
            this.autoAssignAfterOrgChange(viewOrgMap, entityViewMap);
        } else {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u5206\u914d", (String)"AutoAssignJobTask_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), new HashMap(1));
            if (null != map.get(ENTITY_ID) && null != map.get(AUTO_ASSIGN_PLAN_ID)) {
                String entityId = (String)map.get(ENTITY_ID);
                List autoAssignPlanIds = (List)map.get(AUTO_ASSIGN_PLAN_ID);
                if (CollectionUtils.isEmpty((Collection)autoAssignPlanIds)) {
                    LOGGER.info("AutoAssignJobTask end cause by: autoAssignPlanIds is isEmpty.");
                    return;
                }
                ArrayList<Long> autoAssignPlanIdList = new ArrayList<Long>(autoAssignPlanIds.size());
                autoAssignPlanIds.forEach(planDetailId -> autoAssignPlanIdList.add(Long.valueOf(planDetailId.toString())));
                this.assignRightNow(entityId, autoAssignPlanIdList);
            }
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(16);
        result.put("success", true);
        this.feedbackCustomdata(result);
    }

    private void autoAssignAfterOrgChange(Map<Long, Set<Long>> viewOrgMap, Map<String, Long> entityViewMap) {
        if (CollectionUtils.isEmpty(viewOrgMap) || CollectionUtils.isEmpty(entityViewMap)) {
            return;
        }
        int index = 0;
        int size = entityViewMap.size();
        for (Map.Entry<String, Long> entry : entityViewMap.entrySet()) {
            Long viewId = entry.getValue();
            Set<Long> currOrgIds = viewOrgMap.get(viewId);
            String entity = entry.getKey();
            String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c[%1$s]\u8d44\u6599\u7684\u5206\u914d\u3002", (String)"AutoAssignJobTask_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), FormMetadataCache.getFormConfig((String)entity).getCaption().getLocaleValue());
            this.feedbackProgress(100 * index / size, desc, new HashMap(1));
            ++index;
            if (this.isStop()) {
                this.stop();
            }
            new AutoAssignService().autoAssignAfterOrgChange(viewId, currOrgIds, entity);
        }
    }

    private void assignRightNow(String entityId, List<Long> autoAssignPlanIdList) {
        if (CollectionUtils.isEmpty(autoAssignPlanIdList)) {
            LOGGER.info("AutoAssignJobTask end cause by: autoAssignPlanIdList is isEmpty.");
            return;
        }
        boolean isAssignDataBeyondMaxNum = new AutoAssignValidator().isAssignDataBeyondMaxNum(entityId, autoAssignPlanIdList);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (isAssignDataBeyondMaxNum) {
            LOGGER.info("AutoAssignJobTask end cause by: assignData beyond max-num.");
            return;
        }
        Long viewId = ctrlView.getLong("id");
        AutoAssignService autoAssignService = new AutoAssignService();
        DynamicObjectCollection autoAssignPlans = autoAssignService.getAutoAssignPlan(entityId, autoAssignPlanIdList);
        Map<Long, List<AutoAssignPlanDetail>> planDetailMap = autoAssignService.getPlanDetailMap(autoAssignPlanIdList);
        List<Long> filterConditionIds = autoAssignService.getFilterConditionIds(autoAssignPlans, planDetailMap);
        Map<Long, String> filterConditionMap = autoAssignService.getFilterConditionMap(filterConditionIds);
        Map<Long, List<Long>> planDetailIdUseOrgIdMap = autoAssignService.getPlanDetailIdUseOrgIdMap(viewId, autoAssignPlans);
        ArrayList<Long> executeAutoPlanIds = new ArrayList<Long>(autoAssignPlans.size());
        for (DynamicObject autoAssignPlan : autoAssignPlans) {
            List<AutoAssignPlanDetail> planDetails = planDetailMap.get(autoAssignPlan.getLong(PLAN_DETAIL));
            if (CollectionUtils.isEmpty(planDetails)) continue;
            String appId = autoAssignPlan.getString(APP_ID);
            String ctrlStrategy = autoAssignPlan.getString("ctrlstrategy");
            for (AutoAssignPlanDetail planDetail : planDetails) {
                long planDetailId = planDetail.getEntryId();
                long filterConditionId = planDetail.getFilterConditionId();
                long assignOrgId = planDetail.getAssignOrgId();
                String filterCondition = filterConditionMap.get(filterConditionId);
                List<Long> baseDataIdsMatch = autoAssignService.getBaseDataMatch(entityId, assignOrgId, filterCondition, ctrlStrategy);
                List<Long> useOrgIds = planDetailIdUseOrgIdMap.get(planDetailId);
                if (CollectionUtils.isEmpty(baseDataIdsMatch) || CollectionUtils.isEmpty(useOrgIds)) continue;
                if (Boolean.TRUE.equals(planDetail.isContainSubordinate())) {
                    useOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, useOrgIds, (boolean)true, (boolean)false);
                    useOrgIds = autoAssignService.getCuOrgIds(viewId, useOrgIds);
                }
                this.assignBatchHandle(entityId, assignOrgId, appId, baseDataIdsMatch, useOrgIds, planDetailId, autoAssignPlan);
            }
            executeAutoPlanIds.add(autoAssignPlan.getLong("id"));
        }
        autoAssignService.updateExecuteTime(executeAutoPlanIds);
    }

    public void assignBatchHandle(String entityId, long assignOrgId, String appId, List<Long> dataIds, List<Long> useOrgIds, Long planDetailId, DynamicObject autoAssignPlan) {
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(useOrgIds)) {
            return;
        }
        int assignBatchNum = BaseDataCommonService.isNewModel(entityId) ? 50000000 : 100000;
        long currentNum = (long)dataIds.size() * (long)useOrgIds.size();
        if (currentNum <= (long)assignBatchNum) {
            AutoAssignService autoAssignService = new AutoAssignService();
            BaseDataResponse assignResult = autoAssignService.assign(entityId, assignOrgId, appId, new HashSet<Long>(dataIds), new HashSet<Long>(useOrgIds), planDetailId);
            autoAssignService.saveAssignResult(entityId, planDetailId, Collections.singletonList(assignResult), autoAssignPlan);
            return;
        }
        this.assignBatchHandleByData(entityId, assignOrgId, appId, dataIds, useOrgIds, planDetailId, autoAssignPlan);
    }

    private void assignBatchHandleByData(String entityId, long assignOrgId, String appId, List<Long> dataIds, List<Long> orgIdList, Long planDetailId, DynamicObject autoAssignPlan) {
        int assignBatchNum = BaseDataCommonService.isNewModel(entityId) ? 50000000 : 100000;
        HashSet<Long> orgIds = new HashSet<Long>(orgIdList);
        AutoAssignService autoAssignService = new AutoAssignService();
        int pageSize = assignBatchNum / orgIds.size();
        if (BaseDataCommonService.isTreeType(entityId)) {
            this.batchExecuteCancelAssignTreeData(orgIds, entityId, dataIds, pageSize, assignOrgId, appId, planDetailId, autoAssignPlan);
        } else {
            int size = dataIds.size();
            int totalPage = size % pageSize > 0 ? size / pageSize + 1 : size / pageSize;
            double segment = (double)pageSize / (double)size;
            ArrayList<BaseDataResponse> assignResults = new ArrayList<BaseDataResponse>(totalPage);
            for (int pageNo = 1; pageNo <= totalPage; ++pageNo) {
                this.feedbackProgress((int)segment, this.getAssigningMsg(), null);
                int fromIndex = (pageNo - 1) * pageSize;
                int toIndex = Math.min(pageNo * pageSize, size);
                HashSet<Long> values = new HashSet<Long>(dataIds.subList(fromIndex, toIndex));
                BaseDataResponse assignResult = autoAssignService.assign(entityId, assignOrgId, appId, values, orgIds, planDetailId);
                assignResults.add(assignResult);
            }
            autoAssignService.saveAssignResult(entityId, planDetailId, assignResults, autoAssignPlan);
        }
    }

    private void batchExecuteCancelAssignTreeData(Set<Long> orgIds, String entityId, List<Long> dataIds, int pageSize, Long assignOrgId, String appId, Long planDetailId, DynamicObject autoAssignPlan) {
        AutoAssignService autoAssignService = new AutoAssignService();
        List<TreeNode> nodes = new TreeBaseDataCommonService(entityId).buildTreeNodesById(dataIds);
        ArrayList<HashSet<Long>> batchDataIds = new ArrayList<HashSet<Long>>(10);
        HashSet<Long> pageDataIds = new HashSet<Long>(16);
        for (TreeNode node : nodes) {
            this.collectCancelDataIds(node, pageDataIds);
            if (pageDataIds.size() < pageSize) continue;
            batchDataIds.add(pageDataIds);
            pageDataIds = new HashSet(16);
        }
        if (!pageDataIds.isEmpty()) {
            batchDataIds.add(pageDataIds);
        }
        int totalPage = batchDataIds.size();
        double segment = 1.0 / (double)totalPage;
        ArrayList<BaseDataResponse> assignResults = new ArrayList<BaseDataResponse>(totalPage);
        for (int pageNo = 1; pageNo <= batchDataIds.size(); ++pageNo) {
            this.feedbackProgress((int)segment, this.getAssigningMsg(), null);
            Set values = (Set)batchDataIds.get(pageNo - 1);
            BaseDataResponse assignResult = autoAssignService.assign(entityId, assignOrgId, appId, values, orgIds, planDetailId);
            assignResults.add(assignResult);
        }
        autoAssignService.saveAssignResult(entityId, planDetailId, assignResults, autoAssignPlan);
    }

    private void collectCancelDataIds(TreeNode node, Collection<Long> values) {
        values.add(Long.valueOf(node.getId()));
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode childNode : children) {
            if (null == childNode) continue;
            this.collectCancelDataIds(childNode, values);
        }
    }

    private String getAssigningMsg() {
        return ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"AutoAssignJobTask_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }
}

