/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.task;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class BDRefreshBaseDataUseRangeTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BDRefreshBaseDataUseRangeTask.class);
    private static final String BASEDATAID = "basedataid";
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String PARAM_EXCUTECOUNT = "excutecount";
    private static final int DEFAULT_EXCUTECOUNT = 300;
    private static final String PARAM_EXCUTE_ENDTIME = "endtime";
    private static final int DEFAULT_EXCUTE_ENDTIME = 7;
    private static final String BASEDATAUSERANGESUFFIX = "_U";
    private static final String BD_BDDEFCTRLSTRTGY = "bd_bddefctrlstrtgy";
    private static final String CTRLVIEW = "ctrlview";
    private static final String NUMBER = "number";
    private static final String CTRLVIEW_ID = "ctrlview.id";
    private static final String CTRLVIEW_NUMBER = "ctrlview.number";
    private static final String ORG_ID = "org.id";

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        logger.info("\u5f00\u59cb\u6267\u884c\u5237\u65b0\u57fa\u7840\u8d44\u6599\u4f7f\u7528\u8303\u56f4\u4efb\u52a1...");
        try {
            String selectProperties = "id,basedataid,ctrlview";
            DynamicObject[] defaultCtrlStrategys = BusinessDataServiceHelper.load((String)BD_BDDEFCTRLSTRTGY, (String)selectProperties, null);
            if (null == defaultCtrlStrategys || defaultCtrlStrategys.length == 0) {
                return;
            }
            List<String> entityIds = new ArrayList<String>(defaultCtrlStrategys.length);
            HashMap<String, Long> entityIdToViewId = new HashMap<String, Long>(defaultCtrlStrategys.length);
            HashMap<String, String> entityIdToViewNumber = new HashMap<String, String>(defaultCtrlStrategys.length);
            for (DynamicObject defaultCtrlStrategy : defaultCtrlStrategys) {
                if (null == defaultCtrlStrategy.get(BASEDATAID) || null == defaultCtrlStrategy.get(CTRLVIEW)) continue;
                String entityId = ((DynamicObject)defaultCtrlStrategy.get(BASEDATAID)).getString(NUMBER);
                entityIds.add(entityId);
                entityIdToViewId.put(entityId, defaultCtrlStrategy.getLong(CTRLVIEW_ID));
                entityIdToViewNumber.put(entityId, defaultCtrlStrategy.getString(CTRLVIEW_NUMBER));
            }
            if (CollectionUtils.isEmpty(entityIds = this.getAllUnRefreshEntity(entityIds))) {
                return;
            }
            ArrayList<String> unnecessaryToRefresh = new ArrayList<String>(entityIds.size());
            Iterator<String> iterator = entityIds.iterator();
            while (iterator.hasNext()) {
                String entityId = iterator.next();
                boolean isHasCushareData = this.isHasCushareData(entityId);
                if (isHasCushareData) continue;
                unnecessaryToRefresh.add(entityId);
                iterator.remove();
            }
            if (!CollectionUtils.isEmpty(unnecessaryToRefresh)) {
                this.saveRefreshBaseDataRecord(unnecessaryToRefresh);
            }
            if (!CollectionUtils.isEmpty(entityIds)) {
                this.handleNeedRefreshBaseData(paramMap, entityIds, entityIdToViewId, entityIdToViewNumber);
            }
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u57fa\u7840\u8d44\u6599\u4f7f\u7528\u8303\u56f4\u4efb\u52a1\u5f02\u5e38:", (Throwable)e);
        }
    }

    private void handleNeedRefreshBaseData(Map<String, Object> paramMap, List<String> entityIds, Map<String, Long> entityIdToViewId, Map<String, String> entityIdToViewNumber) {
        ArrayList<String> handledEntityIds = new ArrayList<String>(entityIds.size());
        Object excuteCount = paramMap.get(PARAM_EXCUTECOUNT);
        int excutecount = 0;
        try {
            excutecount = null == excuteCount ? 300 : Integer.parseInt(excuteCount.toString());
        }
        catch (Exception e) {
            logger.error("BDRefreshBaseDataUseRangeTask handleNeedRefreshBaseData param is error", (Throwable)e);
        }
        for (int i = 0; i < excutecount && i < entityIds.size() && !this.isDeadLine(paramMap); ++i) {
            String entityId = entityIds.get(i);
            Long viewId = entityIdToViewId.get(entityId);
            String viewNumber = entityIdToViewNumber.get(entityId);
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)false);
            List<Long> cuOrgIds = this.getCuOrgs(viewId, orgIds);
            Map supOrgIdMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, cuOrgIds);
            Map<Long, List<Long>> orgToDataIdsMap = this.getOrgToDataIdsMap(entityId);
            Map<Long, Long> orgToUseRangeMap = this.getOrgToUseRangeMap(entityId, cuOrgIds);
            List<Long> needRefreshOrgIds = this.getOrgWhichDataIsAbsense(cuOrgIds, supOrgIdMap, orgToDataIdsMap, orgToUseRangeMap);
            boolean refeshed = false;
            if (!CollectionUtils.isEmpty(needRefreshOrgIds)) {
                refeshed = this.repairCushare(entityId, needRefreshOrgIds, paramMap);
            }
            if (!refeshed) continue;
            handledEntityIds.add(entityId);
        }
        if (!CollectionUtils.isEmpty(handledEntityIds)) {
            this.saveRefreshBaseDataRecord(handledEntityIds);
        }
    }

    private boolean isDeadLine(Map<String, Object> paramMap) {
        Date nowDate = new Date(System.currentTimeMillis());
        Date endTime = (Date)nowDate.clone();
        int endTimeInt = 7;
        try {
            Object excuteEndtime = paramMap.get(PARAM_EXCUTE_ENDTIME);
            endTimeInt = null == excuteEndtime ? 7 : Integer.parseInt(excuteEndtime.toString());
        }
        catch (NumberFormatException e) {
            logger.error("BDRefreshBaseDataUseRangeTask isDeadLine error:", (Throwable)e);
        }
        endTime.setHours(endTimeInt);
        endTime.setMinutes(0);
        endTime.setSeconds(0);
        return nowDate.after(endTime);
    }

    private List<Long> getOrgWhichDataIsAbsense(List<Long> orgIds, Map<Long, List<Long>> supOrgIdMap, Map<Long, List<Long>> orgToDataIdsMap, Map<Long, Long> orgToUseRangeMap) {
        ArrayList<Long> needRefreshOrgIds = new ArrayList<Long>(orgIds.size());
        for (Long orgId : orgIds) {
            Long currentOrgDataNum = orgToUseRangeMap.get(orgId);
            List<Long> supOrgIds = supOrgIdMap.get(orgId);
            supOrgIds.add(orgId);
            int supOrgDataNum = 0;
            for (Long supOrgId : supOrgIds) {
                List<Long> tempDataIds = orgToDataIdsMap.get(supOrgId);
                if (CollectionUtils.isEmpty(tempDataIds)) continue;
                supOrgDataNum += tempDataIds.size();
            }
            if (supOrgDataNum == 0 || null != currentOrgDataNum && currentOrgDataNum >= (long)supOrgDataNum) continue;
            needRefreshOrgIds.add(orgId);
        }
        return needRefreshOrgIds;
    }

    private Map<Long, Long> getOrgToUseRangeMap(String entityId, List<Long> cuOrgIds) {
        if (BaseDataCommonService.isNewModel(entityId)) {
            return this.getOrgToUseRangeMapOnNewModel(entityId, cuOrgIds);
        }
        HashMap<Long, Long> orgToUseRangeMap = new HashMap<Long, Long>(16);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        String baseDataTableName = dt.getAlias();
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String bsaeDataUseRangeTableName = baseDataTableName + BASEDATAUSERANGESUFFIX;
        SqlBuilder getBaseDataSQL = new SqlBuilder();
        getBaseDataSQL.append("select u.fuseorgid,count(u.fdataid) as userangenum from ", new Object[0]).append(bsaeDataUseRangeTableName, new Object[0]);
        getBaseDataSQL.append(" u inner join ", new Object[0]).append(baseDataTableName, new Object[0]).append(" t on u.fdataid = t.fid ", new Object[0]);
        getBaseDataSQL.append(" where ", new Object[0]);
        getBaseDataSQL.append(String.format("t.fctrlstrategy = '%s'", "6"), new Object[0]);
        getBaseDataSQL.append(" and ", new Object[0]);
        getBaseDataSQL.appendIn("u.fuseorgid", cuOrgIds.toArray());
        getBaseDataSQL.append(" group by u.fuseorgid", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)BDRefreshBaseDataUseRangeTask.class.getName(), (DBRoute)dbRoute, (SqlBuilder)getBaseDataSQL);){
            for (Row row : ds) {
                Long useOrgId = row.getLong("fuseorgid");
                Long useRangeNum = row.getLong("userangenum");
                orgToUseRangeMap.putIfAbsent(useOrgId, useRangeNum);
            }
        }
        return orgToUseRangeMap;
    }

    private Map<Long, Long> getOrgToUseRangeMapOnNewModel(String entityId, List<Long> cuOrgIds) {
        HashMap<Long, Long> orgToUseRangeMap = null;
        try {
            Map<Long, RoaringBitmap> orgUseRelBitMap = BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(cuOrgIds, entityId);
            int[] indexs = BaseDataUseRelQueryEngine.getUseBaseDataIndexArrByOrgId(cuOrgIds, entityId);
            if (indexs.length == 0) {
                return new HashMap<Long, Long>(1);
            }
            Map<Integer, Long> indexToCuDataIdMap = this.getIndexToCuDataIdMap(entityId, indexs);
            orgToUseRangeMap = new HashMap(orgUseRelBitMap.size());
            Set<Map.Entry<Long, RoaringBitmap>> entrySet = orgUseRelBitMap.entrySet();
            for (Map.Entry<Long, RoaringBitmap> entry : entrySet) {
                Long orgId = entry.getKey();
                Long num = 0L;
                RoaringBitmap roaringBitmap = entry.getValue();
                for (int index : indexs = roaringBitmap.toArray()) {
                    if (null == indexToCuDataIdMap.get(index)) continue;
                    Long l = num;
                    Long l2 = num = Long.valueOf(num + 1L);
                }
                orgToUseRangeMap.put(orgId, num);
            }
        }
        catch (Exception e) {
            logger.error("getOrgToUseRangeMapOnNewModel error:", (Throwable)e);
            orgToUseRangeMap = new HashMap<Long, Long>(1);
        }
        return orgToUseRangeMap;
    }

    private Map<Integer, Long> getIndexToCuDataIdMap(String entityId, int[] indexs) {
        HashMap<Integer, Long> indexToCuDataIdMap = new HashMap<Integer, Long>(indexs.length);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String dbRouteKey = entityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String baseDataTableName = entityType.getAlias();
        ArrayList<Integer> params = new ArrayList<Integer>(indexs.length);
        for (int i = 0; i < indexs.length; ++i) {
            params.add(indexs[i]);
        }
        SqlBuilder querySQL = new SqlBuilder();
        querySQL.append("select fid,fbitindex from ", new Object[0]).append(baseDataTableName, new Object[0]).append(" where ", new Object[0]);
        querySQL.appendIn("fbitindex", params).append(String.format(" and fctrlstrategy = '%s'", "6"), new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)BDRefreshBaseDataUseRangeTask.class.getName(), (DBRoute)dbRoute, (SqlBuilder)querySQL);){
            for (Row row : ds) {
                Integer bitindex = row.getInteger("fbitindex");
                Long id = row.getLong("fid");
                indexToCuDataIdMap.put(bitindex, id);
            }
        }
        return indexToCuDataIdMap;
    }

    private Map<Long, List<Long>> getOrgToDataIdsMap(String entityId) {
        HashMap<Long, List<Long>> orgToDataIdsMap = new HashMap<Long, List<Long>>(16);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        String baseDataTableName = dt.getAlias();
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        StringBuilder getBaseDataSQL = new StringBuilder();
        getBaseDataSQL.append("select fid,fcreateorgid from ").append(baseDataTableName);
        getBaseDataSQL.append(" where fctrlstrategy = '");
        getBaseDataSQL.append("6").append("'");
        try (DataSet ds = DB.queryDataSet((String)BDRefreshBaseDataUseRangeTask.class.getName(), (DBRoute)dbRoute, (String)getBaseDataSQL.toString());){
            for (Row row : ds) {
                Long dataId = row.getLong("fid");
                Long createOrgId = row.getLong("fcreateorgid");
                orgToDataIdsMap.computeIfAbsent(createOrgId, key -> new ArrayList()).add(dataId);
            }
        }
        return orgToDataIdsMap;
    }

    private boolean isHasCushareData(String entityId) {
        boolean isHasCushareData = false;
        try {
            BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
            String baseDataTableName = dt.getAlias();
            String dbRouteKey = dt.getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            StringBuilder isHasCushareDataSQL = new StringBuilder();
            isHasCushareDataSQL.append("select top 1 fid from ").append(baseDataTableName).append(" where fctrlstrategy = '");
            isHasCushareDataSQL.append("6").append("'");
            isHasCushareData = (Boolean)DB.query((DBRoute)dbRoute, (String)isHasCushareDataSQL.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    return rs.next();
                }
            });
        }
        catch (Exception e) {
            isHasCushareData = false;
            logger.error("\u57fa\u7840\u8d44\u6599\uff1a" + entityId + ",\u67e5\u8be2\u57fa\u672c\u4fe1\u606f\u8868\u5f02\u5e38:", (Throwable)e);
        }
        return isHasCushareData;
    }

    private void saveRefreshBaseDataRecord(List<String> entityIds) {
        try {
            DBRoute dbRoute = DBRoute.of((String)DBRoute.base.getRouteKey());
            ArrayList<Object[]> params = new ArrayList<Object[]>(entityIds.size());
            String addSQL = "insert into t_bd_refreshbasedatarecord (fid,fentityid) values (?,?)";
            long[] ids = DB.genGlobalLongIds((int)entityIds.size());
            for (int i = 0; i < entityIds.size(); ++i) {
                String entityId = entityIds.get(i);
                long id = ids[i];
                params.add(new Object[]{id, entityId});
            }
            DB.executeBatch((DBRoute)dbRoute, (String)addSQL, params);
        }
        catch (Exception e) {
            logger.error("BDRefreshBaseDataUseRangeTask.addToRefreshBaseDataRecord error:", (Throwable)e);
        }
    }

    private List<String> getAllUnRefreshEntity(List<String> entityIds) {
        List<String> refreshedEntityIds = this.getAllRefreshedEntityIds();
        if (!CollectionUtils.isEmpty(refreshedEntityIds)) {
            Iterator<String> iterator = entityIds.iterator();
            while (iterator.hasNext()) {
                String entityId = iterator.next();
                boolean isContain = false;
                for (String refreshedEntityId : refreshedEntityIds) {
                    if (!refreshedEntityId.equals(entityId)) continue;
                    isContain = true;
                    break;
                }
                if (!isContain) continue;
                iterator.remove();
            }
        }
        return entityIds;
    }

    private List<String> getAllRefreshedEntityIds() {
        DBRoute dbRoute = DBRoute.of((String)DBRoute.base.getRouteKey());
        String getRefreshEntitySQL = "select fid,fentityid from t_bd_refreshbasedatarecord";
        return (List)DB.query((DBRoute)dbRoute, (String)getRefreshEntitySQL, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> refreshedEntityIds = new ArrayList<String>(16);
                while (rs.next()) {
                    String entityId = rs.getString("fentityid");
                    if (!StringUtils.isNotEmpty((CharSequence)entityId)) continue;
                    refreshedEntityIds.add(entityId);
                }
                return refreshedEntityIds;
            }
        });
    }

    private List<Long> getCuOrgs(Long viewId, List<Long> orgIds) {
        QFilter f1 = new QFilter("org", "in", orgIds);
        QFilter f2 = new QFilter("view.id", "=", (Object)viewId);
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter f4 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        qfilters = new QFilter[]{f1, f2, f3, f4};
        ArrayList<Long> cuOrgIds = new ArrayList<Long>(orgIds.size());
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(BDRefreshBaseDataUseRangeTask.class.getName(), ENTITYID_ORG_STRUCTURE, ORG_ID, qfilters);){
            for (Row row : ds) {
                Long orgId = row.getLong(ORG_ID);
                if (orgId == null) continue;
                cuOrgIds.add(orgId);
            }
        }
        return cuOrgIds;
    }

    private boolean repairCushare(String entityID, List<Long> orgIds, Map<String, Object> paramMap) {
        if (StringUtils.isEmpty((CharSequence)entityID) || CollectionUtils.isEmpty(orgIds)) {
            return true;
        }
        if (null == BaseDataServiceHelper.checkBaseDataCtrl((String)entityID)) {
            return true;
        }
        ArrayList<Long> tempOrgIds = new ArrayList<Long>(1000);
        if (orgIds.size() > 1000) {
            for (Long orgId : orgIds) {
                tempOrgIds.add(orgId);
                if (tempOrgIds.size() != 1000) continue;
                ArrayList orgs = new ArrayList(tempOrgIds);
                if (this.isDeadLine(paramMap)) {
                    return false;
                }
                BaseDataServiceHelper.refreshBaseDataUseRange((String)entityID, orgs);
                tempOrgIds.clear();
            }
            if (!tempOrgIds.isEmpty()) {
                if (this.isDeadLine(paramMap)) {
                    return false;
                }
                BaseDataServiceHelper.refreshBaseDataUseRange((String)entityID, tempOrgIds);
            }
        } else {
            if (this.isDeadLine(paramMap)) {
                return false;
            }
            BaseDataServiceHelper.refreshBaseDataUseRange((String)entityID, orgIds);
        }
        return true;
    }
}

