/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.bd.service.BaseDataAutoUpgradeService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;

public class BaseDataAutoUpgradeTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(BaseDataAutoUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!BaseDataCommonService.isNewTenantByFeatureOfCosmic("6.0")) {
            this.updateTaskCycleAndCheckStatus();
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("upgradestatus", "!=", (Object)"2"), new QFilter("checkstatus", "=", (Object)Boolean.FALSE)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)"basedataid", (QFilter[])filters);
        if (collection.isEmpty()) {
            this.updateTaskCycleAndCheckStatus();
            return;
        }
        ThreadPool pool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
        ArrayList<Future> futures = new ArrayList<Future>(collection.size());
        BaseDataAutoUpgradeService service = new BaseDataAutoUpgradeService();
        for (DynamicObject data : collection) {
            String entity = data.getString("basedataid");
            futures.add(pool.submit(() -> {
                try {
                    service.generateIndexAndFillBit(entity);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
                return Boolean.TRUE;
            }, RequestContext.get()));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
        this.updateTaskCycle();
    }

    private void updateTaskCycleAndCheckStatus() {
        this.updateTaskCycle();
        DB.execute((DBRoute)DBRoute.base, (String)"update T_BD_DefaultCtrlStrategy set fcheckstatus = '1', fmodifytime = ?;", (Object[])new Object[]{new Date()});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_bddefctrlstrtgy");
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    private void updateTaskCycle() {
        DB.execute((DBRoute)DBRoute.base, (String)"UPDATE T_SCH_SCHEDULE SET FREPEATMODE = 'n', FSTATUS = '0' WHERE FID = '31G7/04245HL';");
    }
}

