/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bd.annotation.BaseDataCtrlBusinessSPIParam;
import kd.bos.bd.ext.AbstractBaseDataBusinessService;
import kd.bos.bd.ext.ChangeManageRightBusinessService;
import kd.bos.bd.ext.IBaseDataFieldRuleExtService;
import kd.bos.bd.ext.IBaseDataModelExtService;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.IBaseDataUseRangeExtService;
import kd.bos.bd.ext.IndividualizeBusinessService;
import kd.bos.bd.utils.FieldPropUtils;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BaseDataBusinessServiceUtils {
    private static final Log LOGGER = LogFactory.getLog(BaseDataBusinessServiceUtils.class);
    private static final String BOS_ENTITY_META = "bos_entitymeta";
    private static final int DEFAULT_CAPACITY = 16;
    private static final Map<String, List<AbstractBaseDataBusinessService>> CHANGE_MANAGE_RIGHT_TEMPLATE = new ConcurrentHashMap<String, List<AbstractBaseDataBusinessService>>(16);
    private static final Map<String, List<AbstractBaseDataBusinessService>> CHANGE_MANAGE_RIGHT_ENTITY = new ConcurrentHashMap<String, List<AbstractBaseDataBusinessService>>(16);
    private static final Map<String, List<AbstractBaseDataBusinessService>> INDIVIDUALIZE_TEMPLATE = new ConcurrentHashMap<String, List<AbstractBaseDataBusinessService>>(16);
    private static final Map<String, List<AbstractBaseDataBusinessService>> INDIVIDUALIZE_ENTITY = new ConcurrentHashMap<String, List<AbstractBaseDataBusinessService>>(16);
    private static final Map<Class<?>, List<?>> CACHED_SERVICES = new ConcurrentHashMap(16);
    private static final Map<String, String> TPL_NUM_ID_MAP = new ConcurrentHashMap<String, String>(16);

    private BaseDataBusinessServiceUtils() {
    }

    public static boolean isEnableVersion(String entityId) {
        return BaseDataBusinessServiceUtils.getBaseDataSubExtService(entityId).isEnableVersion(entityId);
    }

    public static IBaseDataSubExtService getBaseDataSubExtService(String entity) {
        List<IBaseDataSubExtService> services = BaseDataBusinessServiceUtils.loadSortingService(entity, IBaseDataSubExtService.class);
        return services.isEmpty() ? new IBaseDataSubExtService(){} : services.get(0);
    }

    public static List<IBaseDataFieldRuleExtService> getFieldRuleExtService(String entity) {
        return BaseDataBusinessServiceUtils.loadSortingService(entity, IBaseDataFieldRuleExtService.class);
    }

    public static IBaseDataUseRangeExtService getBaseDataUseRangeExtService(String entityId) {
        List<IBaseDataUseRangeExtService> services = BaseDataBusinessServiceUtils.loadSortingService(entityId, IBaseDataUseRangeExtService.class);
        return services.isEmpty() ? null : services.get(0);
    }

    public static List<IBaseDataModelExtService> getModelSupportExtService(String entity) {
        return BaseDataBusinessServiceUtils.loadSortingService(entity, IBaseDataModelExtService.class);
    }

    private static <T> List<T> loadSortingService(String entity, Class<T> clazz) {
        List<T> services = BaseDataBusinessServiceUtils.loadSortingServiceImpl(clazz);
        if (CollectionUtils.isEmpty(services)) {
            return services;
        }
        ArrayList<T> result = new ArrayList<T>(services.size());
        String inheritPath = EntityMetadataCache.getDataEntityType((String)entity).getInheritPath();
        Set inheritPaths = StringUtils.isBlank((String)inheritPath) ? Collections.emptySet() : Arrays.stream(inheritPath.split(",")).collect(Collectors.toSet());
        for (T service : services) {
            BaseDataCtrlBusinessSPIParam annotation = service.getClass().getAnnotation(BaseDataCtrlBusinessSPIParam.class);
            if (null == annotation) continue;
            if (annotation.isTemplate()) {
                Set templateIds = Arrays.stream(annotation.templateNumbers()).filter(StringUtils::isNotEmpty).map(TPL_NUM_ID_MAP::get).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                templateIds.retainAll(inheritPaths);
                if (templateIds.isEmpty()) continue;
                result.add(service);
                continue;
            }
            Set entityIds = Arrays.stream(annotation.entityIds()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            if (!entityIds.contains(entity)) continue;
            result.add(service);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> loadSortingServiceImpl(Class<T> clazz) {
        List<Object> services = CACHED_SERVICES.get(clazz);
        if (null != services) {
            return services;
        }
        Class<BaseDataBusinessServiceUtils> clazz2 = BaseDataBusinessServiceUtils.class;
        synchronized (BaseDataBusinessServiceUtils.class) {
            services = CACHED_SERVICES.get(clazz);
            if (null != services) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return services;
            }
            services = BaseDataBusinessServiceUtils.loadSortingService(clazz);
            CACHED_SERVICES.put(clazz, services);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return services;
        }
    }

    private static <T> List<T> loadSortingService(Class<T> clazz) {
        ArrayList<T> services = new ArrayList<T>(10);
        HashSet tplNumbers = new HashSet(16);
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        for (T service : serviceLoader) {
            BaseDataCtrlBusinessSPIParam annotation = service.getClass().getAnnotation(BaseDataCtrlBusinessSPIParam.class);
            if (null == annotation) continue;
            if (annotation.isTemplate()) {
                Set templateNumbers = Arrays.stream(annotation.templateNumbers()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                if (templateNumbers.isEmpty()) continue;
                services.add(service);
                tplNumbers.addAll(templateNumbers);
                continue;
            }
            Set entityIds = Arrays.stream(annotation.entityIds()).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            if (entityIds.isEmpty()) continue;
            services.add(service);
        }
        tplNumbers.removeAll(TPL_NUM_ID_MAP.keySet());
        if (!tplNumbers.isEmpty()) {
            QFilter[] filter = new QFilter[]{new QFilter("number", "in", tplNumbers)};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)BaseDataBusinessServiceUtils.class.getName(), (String)BOS_ENTITY_META, (String)"id, number", (QFilter[])filter, (String)"");){
                ds.forEach(row -> TPL_NUM_ID_MAP.put(row.getString("number"), row.getString("id")));
            }
        }
        services.sort(BaseDataBusinessServiceUtils::sort);
        return services;
    }

    private static int sort(Object curr, Object next) {
        int nextPriority;
        BaseDataCtrlBusinessSPIParam currAnnotation = curr.getClass().getAnnotation(BaseDataCtrlBusinessSPIParam.class);
        BaseDataCtrlBusinessSPIParam nextAnnotation = next.getClass().getAnnotation(BaseDataCtrlBusinessSPIParam.class);
        int currPriority = currAnnotation.order();
        if (currPriority == (nextPriority = nextAnnotation.order())) {
            if (!currAnnotation.isTemplate()) {
                return -1;
            }
            if (!nextAnnotation.isTemplate()) {
                return 1;
            }
            return 0;
        }
        return currPriority > nextPriority ? -1 : 1;
    }

    public static ChangeManageRightBusinessService getChangeManageRightService(String entityId) {
        Map<String, List<AbstractBaseDataBusinessService>> templateMap = CHANGE_MANAGE_RIGHT_TEMPLATE;
        Map<String, List<AbstractBaseDataBusinessService>> entityMap = CHANGE_MANAGE_RIGHT_ENTITY;
        BaseDataBusinessServiceUtils.loadBusinessSPI(ChangeManageRightBusinessService.class, templateMap, entityMap);
        ChangeManageRightBusinessService templateService = (ChangeManageRightBusinessService)BaseDataBusinessServiceUtils.getBusinessService(entityId, templateMap, entityMap);
        if (null == templateService) {
            templateService = new ChangeManageRightBusinessService(){};
        }
        LOGGER.info("load implements of CancelAssignBusinessService CLASSNAME:" + templateService.getClass());
        return templateService;
    }

    public static IndividualizeBusinessService getIndividualizeBusinessService(String entityId) {
        Map<String, List<AbstractBaseDataBusinessService>> templateMap = INDIVIDUALIZE_TEMPLATE;
        Map<String, List<AbstractBaseDataBusinessService>> entityMap = INDIVIDUALIZE_ENTITY;
        BaseDataBusinessServiceUtils.loadBusinessSPI(IndividualizeBusinessService.class, templateMap, entityMap);
        IndividualizeBusinessService templateService = (IndividualizeBusinessService)BaseDataBusinessServiceUtils.getBusinessService(entityId, templateMap, entityMap);
        if (null == templateService) {
            templateService = new IndividualizeBusinessService(){};
        }
        LOGGER.info("load implements of IndividualizeBusinessService CLASSNAME:" + templateService.getClass());
        return templateService;
    }

    private static void loadBusinessSPI(Class<? extends AbstractBaseDataBusinessService> clazz, Map<String, List<AbstractBaseDataBusinessService>> templateMap, Map<String, List<AbstractBaseDataBusinessService>> entityMap) {
        boolean templateIsEmpty = CollectionUtils.isEmpty(templateMap);
        boolean entityIsEmpty = CollectionUtils.isEmpty(entityMap);
        if (!templateIsEmpty && !entityIsEmpty) {
            return;
        }
        ServiceLoader<? extends AbstractBaseDataBusinessService> serviceLoader = ServiceLoader.load(clazz);
        for (AbstractBaseDataBusinessService abstractBaseDataBusinessService : serviceLoader) {
            String[] templateNumbers;
            List paramNumbers;
            BaseDataCtrlBusinessSPIParam annotation = abstractBaseDataBusinessService.getClass().getAnnotation(BaseDataCtrlBusinessSPIParam.class);
            if (null == annotation) {
                throw new KDBizException(String.format("Loading businessService exception: BaseDataCtrlBusinessSPIParam not found on %s.", abstractBaseDataBusinessService.getClass()));
            }
            boolean isTemplate = annotation.isTemplate();
            if (isTemplate && templateIsEmpty && !CollectionUtils.isEmpty(paramNumbers = Arrays.stream(templateNumbers = annotation.templateNumbers()).filter(StringUtils::isNotEmpty).collect(Collectors.toList()))) {
                QFilter idFilter = new QFilter("number", "in", paramNumbers);
                DynamicObjectCollection entityDoc = QueryServiceHelper.query((String)BOS_ENTITY_META, (String)FieldPropUtils.getSelectField("id", "number"), (QFilter[])new QFilter[]{idFilter});
                entityDoc.stream().map(entity -> entity.getString("id")).forEach(templateNumber -> templateMap.computeIfAbsent((String)templateNumber, k -> new ArrayList(10)).add((AbstractBaseDataBusinessService)businessService));
            }
            if (isTemplate || !entityIsEmpty) continue;
            String[] entityIds = annotation.entityIds();
            Arrays.stream(entityIds).filter(StringUtils::isNotEmpty).forEach(entityID -> entityMap.computeIfAbsent((String)entityID, k -> new ArrayList(10)).add((AbstractBaseDataBusinessService)businessService));
        }
    }

    private static AbstractBaseDataBusinessService getBusinessService(String entityId, Map<String, List<AbstractBaseDataBusinessService>> templateMap, Map<String, List<AbstractBaseDataBusinessService>> entityMap) {
        List<AbstractBaseDataBusinessService> serviceList = entityMap.get(entityId);
        AbstractBaseDataBusinessService entityService = Optional.ofNullable(serviceList).orElseGet(Collections::emptyList).stream().sorted().findFirst().orElse(null);
        if (null != entityService) {
            return entityService;
        }
        String inheritPath = EntityMetadataCache.getDataEntityType((String)entityId).getInheritPath();
        List entityTemplates = Arrays.stream(inheritPath.split(",")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityTemplates)) {
            return null;
        }
        return entityTemplates.stream().filter(entityTemplate -> null != templateMap.get(entityTemplate)).map(templateMap::get).flatMap(Collection::stream).sorted().findFirst().orElse(null);
    }
}

