/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.validate.DataMutexResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public final class BaseDataMutexUtils {
    private static Log LOGGER = LogFactory.getLog(BaseDataMutexUtils.class);
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String KEY_LOCK_ID = "dataObjId";
    private static final String KEY_LOCK_NUMBER = "dataObjNumber";
    private static final String KEY_GROUP_ID = "groupId";
    private static final String KEY_ENTITY = "entityKey";
    private static final String KEY_OPERATION = "operationKey";
    private static final String KEY_IS_STRICT = "isStrict";
    private static final String KEY_CALL_SOURCE = "callSource";
    private static final String VALUE_DEFAULT_GROUP_ID = "default_netctrl";

    public static List<DataMutexResult> batchRequireAndReturnFailMutex(String entity, Collection<Long> dataIds, String opKey) {
        return BaseDataMutexUtils.batchRequireAndReturn(entity, dataIds, opKey);
    }

    public static List<DataMutexResult> batchRequireAndReturnFailMutex(String entity, String opKey, Collection<String> values) {
        return BaseDataMutexUtils.batchRequireAndReturn(entity, values, opKey);
    }

    private static List<DataMutexResult> batchRequireAndReturn(String entity, Collection<?> values, String opKey) {
        List<DataMutexResult> dataMutexResults = BaseDataMutexUtils.batchRequire(entity, values, opKey);
        ArrayList<DataMutexResult> failMutex = new ArrayList<DataMutexResult>(10);
        for (DataMutexResult dataMutexResult : dataMutexResults) {
            if (dataMutexResult.isSuccess()) continue;
            failMutex.add(dataMutexResult);
        }
        return failMutex;
    }

    private static List<DataMutexResult> batchRequire(String entity, Collection<?> values, String opKey) {
        if (CollectionUtils.isEmpty(values)) {
            return new ArrayList<DataMutexResult>(0);
        }
        HashMap<String, DataMutexResult> dataMutexResults = new HashMap<String, DataMutexResult>(values.size());
        List<Map<String, Object>> mutexRequireList = BaseDataMutexUtils.getMutexRequireList(entity, values, opKey);
        try (DataMutex dataMutex = DataMutex.create();){
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String dataId = (String)mutexItem.getKey();
                DataMutexResult dataMutexResult = new DataMutexResult(dataId, ((Boolean)mutexItem.getValue()).booleanValue());
                dataMutexResults.put(dataId, dataMutexResult);
                if (((Boolean)mutexItem.getValue()).booleanValue()) continue;
                String clientDescription = BaseDataMutexUtils.getClientDescription(dataMutex, dataId, VALUE_DEFAULT_GROUP_ID, entity);
                dataMutexResult.setMessage(clientDescription);
            }
        }
        catch (IOException e) {
            for (Object value : values) {
                String id = String.valueOf(value);
                if (dataMutexResults.containsKey(id)) continue;
                DataMutexResult dataMutexResult = new DataMutexResult(id, false);
                dataMutexResults.put(id, dataMutexResult);
                String msg = ResManager.loadKDString((String)"%1$s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                dataMutexResult.setMessage(String.format(msg, e.getMessage()));
            }
        }
        return new ArrayList<DataMutexResult>(dataMutexResults.values());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Long> batchRelease(String entity, String opKey, Collection<Long> mutexLocks) {
        if (CollectionUtils.isEmpty(mutexLocks)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> failIds = new ArrayList<Long>(10);
        ArrayList mutexRequireList = new ArrayList(mutexLocks.size());
        mutexLocks.forEach(mutexLock -> mutexRequireList.add(BaseDataMutexUtils.getBaseRequireParams(String.valueOf(mutexLock), entity, opKey)));
        try (DataMutex dataMutex = DataMutex.create();){
            Map releaseResult = dataMutex.batchRelease(mutexRequireList);
            for (Map.Entry releaseItem : releaseResult.entrySet()) {
                if (((Boolean)releaseItem.getValue()).booleanValue()) continue;
                failIds.add(Long.valueOf((String)releaseItem.getKey()));
            }
            if (!failIds.isEmpty()) {
                LOGGER.info(String.format("\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u5931\u8d25, \u5171\u5931\u8d25%s\u5f20\uff1a%s", failIds.size(), JSON.toJSONString(failIds)));
            }
            ArrayList<Long> arrayList = failIds;
            return arrayList;
        }
        catch (IOException e) {
            LOGGER.error("\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519...", (Throwable)e);
            return new ArrayList<Long>(mutexLocks);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> batchRelease(String entity, Collection<String> mutexLocks, String opKey) {
        if (CollectionUtils.isEmpty(mutexLocks)) {
            return new ArrayList<String>(0);
        }
        ArrayList failIds = new ArrayList(10);
        ArrayList mutexRequireList = new ArrayList(mutexLocks.size());
        mutexLocks.forEach(mutexLock -> mutexRequireList.add(BaseDataMutexUtils.getBaseRequireParams(mutexLock, entity, opKey)));
        try (DataMutex dataMutex = DataMutex.create();){
            Map releaseResult = dataMutex.batchRelease(mutexRequireList);
            for (Map.Entry releaseItem : releaseResult.entrySet()) {
                if (((Boolean)releaseItem.getValue()).booleanValue()) continue;
                failIds.add(releaseItem.getKey());
            }
            if (!failIds.isEmpty()) {
                LOGGER.info(String.format("\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u5931\u8d25, \u5171\u5931\u8d25%s\u5f20\uff1a%s", failIds.size(), JSON.toJSONString(failIds)));
            }
            ArrayList arrayList = failIds;
            return arrayList;
        }
        catch (IOException e) {
            LOGGER.error("\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519...", (Throwable)e);
            return new ArrayList<String>(mutexLocks);
        }
    }

    private static String getClientDescription(DataMutex dataMutex, String dataId, String groupId, String entity) {
        String msg;
        Map lockInfo = dataMutex.getLockInfo(dataId, groupId, entity);
        if (lockInfo == null) {
            return ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        Long userId = Long.valueOf((String)lockInfo.get("userid"));
        String userName = "";
        if (userId == -1L) {
            userName = "guest";
        } else {
            DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
            if (userObj != null) {
                userName = userObj.getString("name");
            }
        }
        String client = (String)lockInfo.get("client");
        if (StringUtils.isBlank((CharSequence)client)) {
            String msg2 = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            return String.format(msg2, userName);
        }
        switch (client) {
            case "web": {
                msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                break;
            }
            case "mobile": {
                msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u79fb\u52a8\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                break;
            }
            case "batch": 
            case "MQ": {
                msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728\u540e\u53f0\u4efb\u52a1\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                break;
            }
            default: {
                msg = ResManager.loadKDString((String)"%1$s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"BaseDataMutexUtils_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        }
        return String.format(msg, userName);
    }

    private static List<Map<String, Object>> getMutexRequireList(String entity, Collection<?> values, String opKey) {
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(values.size());
        for (Object value : values) {
            Map<String, Object> requireParam = BaseDataMutexUtils.getBaseRequireParams(String.valueOf(value), entity, opKey);
            requireParam.put(KEY_LOCK_NUMBER, String.valueOf(value));
            requireParam.put(KEY_IS_STRICT, Boolean.TRUE);
            requireParam.put(KEY_CALL_SOURCE, "default");
            requireParam.put("isOpenIntentLocks", Boolean.FALSE);
            mutexRequireList.add(requireParam);
        }
        return mutexRequireList;
    }

    private static Map<String, Object> getBaseRequireParams(String lockId, String entity, String opKey) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
        requireParam.put(KEY_LOCK_ID, lockId);
        requireParam.put(KEY_GROUP_ID, VALUE_DEFAULT_GROUP_ID);
        requireParam.put(KEY_ENTITY, entity);
        requireParam.put(KEY_OPERATION, opKey);
        return requireParam;
    }
}

