/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.roaringbitmap.RoaringBitmap;

public final class KryoSerializerUtils {
    private static final Log LOGGER = LogFactory.getLog(KryoSerializerUtils.class);
    private static final ThreadLocal<Kryo> KRYO_THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.register(RoaringBitmap.class);
        kryo.setReferences(false);
        kryo.setRegistrationRequired(false);
        return kryo;
    });
    private static final ThreadLocal<Kryo> KRYO_REL_THREAD_LOCAL = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.register(BaseDataUseRelBit.class);
        kryo.setReferences(false);
        kryo.setRegistrationRequired(false);
        return kryo;
    });

    private KryoSerializerUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serRoaringBitmap(RoaringBitmap bitmap) {
        try (Output output = new Output(1024, -1);){
            Kryo kryo = KRYO_THREAD_LOCAL.get();
            kryo.writeObjectOrNull(output, (Object)bitmap, bitmap.getClass());
            output.flush();
            byte[] byArray = output.toBytes();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5e8f\u5217\u5316RoaringBitmap\u5f02\u5e38...", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5e8f\u5217\u5316\u4f4d\u56fe\u6570\u636e\u5f02\u5e38\u3002", (String)"KryoSerializerUtils_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RoaringBitmap desRoaringBitmapByteArr(byte[] bytes) {
        try (Input input = new Input();){
            Kryo kryo = KRYO_THREAD_LOCAL.get();
            if (bytes != null) {
                input.setBuffer(bytes);
            }
            RoaringBitmap roaringBitmap = (RoaringBitmap)kryo.readObjectOrNull(input, RoaringBitmap.class);
            return roaringBitmap;
        }
        catch (Exception e) {
            LOGGER.error("\u53cd\u5e8f\u5217\u5316RoaringBitmap\u5f02\u5e38...", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u4f4d\u56fe\u6570\u636e\u5f02\u5e38\u3002", (String)"KryoSerializerUtils_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RoaringBitmap desRoaringBitmapByInput(InputStream in) {
        try (Input input = new Input(in);){
            Kryo kryo = KRYO_THREAD_LOCAL.get();
            RoaringBitmap roaringBitmap = (RoaringBitmap)kryo.readObjectOrNull(input, RoaringBitmap.class);
            return roaringBitmap;
        }
        catch (Exception e) {
            LOGGER.error("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38...", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] cacheSerializer(BaseDataUseRelBit useRelBit) {
        try (Output output = new Output(1024, -1);){
            Kryo kryo = KRYO_REL_THREAD_LOCAL.get();
            kryo.writeObjectOrNull(output, (Object)useRelBit, useRelBit.getClass());
            output.flush();
            byte[] byArray = output.toBytes();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("BaseDataUseRelBit\u5e8f\u5217\u5316\u5f02\u5e38...", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5e8f\u5217\u5316\u4f4d\u56fe\u6570\u636e\u5f02\u5e38\u3002", (String)"KryoSerializerUtils_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BaseDataUseRelBit cacheDeserializer(byte[] bytes) {
        try (Input input = new Input();){
            Kryo kryo = KRYO_REL_THREAD_LOCAL.get();
            if (bytes != null) {
                input.setBuffer(bytes);
            }
            BaseDataUseRelBit baseDataUseRelBit = (BaseDataUseRelBit)kryo.readObjectOrNull(input, BaseDataUseRelBit.class);
            return baseDataUseRelBit;
        }
        catch (Exception e) {
            LOGGER.error("BaseDataUseRelBit\u53cd\u5e8f\u5217\u5316\u5f02\u5e38...", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u4f4d\u56fe\u6570\u636e\u5f02\u5e38\u3002", (String)"KryoSerializerUtils_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BaseDataUseRelBit cacheDeserializer(InputStream in) {
        try (Input input = new Input(in);){
            Kryo kryo = KRYO_REL_THREAD_LOCAL.get();
            BaseDataUseRelBit baseDataUseRelBit = (BaseDataUseRelBit)kryo.readObjectOrNull(input, BaseDataUseRelBit.class);
            return baseDataUseRelBit;
        }
        catch (Exception e) {
            LOGGER.error("BaseDataUseRelBit\u53cd\u5e8f\u5217\u5316\u5f02\u5e38...", (Throwable)e);
            return null;
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6d41\u5173\u95ed\u5931\u8d25...", (Throwable)e);
        }
    }
}

