/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public abstract class AbstractBaseDataPreValidator {
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final String FIELD_IS_CU = "isctrlunit";
    private static final String OP_ASSIGN_SEARCH = "assign_search";
    private String assignQueryCtrlStrategy;
    private IFormView view;
    private String opType;
    private String masterIdPropName;
    private String statusProName = "status";
    private boolean isIgnoreStatus;
    private String opMsg;
    protected String numberField;
    protected String entity;
    private static final String ORG_ENTITY = "bos_org";

    protected IFormView getView() {
        return this.view;
    }

    private String getAssignSearch() {
        return ResManager.loadKDString((String)"\u5206\u914d\u67e5\u8be2", (String)"AbstractBaseDataPreValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private String getCancelAssign() {
        return ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d", (String)"AbstractBaseDataPreValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    protected void init(IFormView view, String entity, String type) {
        this.view = view;
        this.entity = entity;
        this.opType = type;
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        this.numberField = BaseDataCommonService.isOtherMasterIdType(entity) ? "masterid.number" : "number";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        this.statusProName = dt.getBillStatus();
        this.isIgnoreStatus = StringUtils.isBlank((CharSequence)this.statusProName) || dt.getProperty(this.statusProName).isDbIgnore();
    }

    private String getOpMsg() {
        if (null == this.opMsg) {
            this.opMsg = this.generateOpMsg();
        }
        return this.opMsg;
    }

    public String getAssignQueryCtrlStrategy() {
        return this.assignQueryCtrlStrategy;
    }

    public boolean validateDataWithSpecificOpType(String appId, Long currentOrgId, List<Long> dataIds) {
        boolean isAssignStrategy;
        if (!this.permValidate(appId, currentOrgId)) {
            return false;
        }
        if (!this.matchDataRule(appId, currentOrgId, dataIds)) {
            return false;
        }
        DynamicObjectCollection collection = this.getDataCollectionByDataIds(dataIds, Collections.emptyList());
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return false;
        }
        DynamicObject baseData = (DynamicObject)collection.get(0);
        long orgId = baseData.getLong("createorg");
        String ctrlStrategy = baseData.getString("ctrlstrategy");
        if ("2".equals(ctrlStrategy) && !currentOrgId.equals(orgId)) {
            DynamicObject view = BusinessDataServiceHelper.loadSingleFromCache((String)ORG_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentOrgId)});
            String msgName = "";
            if (view != null) {
                msgName = view.getString("name");
            }
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u201c\u81ea\u7531\u5206\u914d\u201d\u7684\u57fa\u7840\u6570\u636e\u53ea\u80fd\u7531\u521b\u5efa\u7ec4\u7ec7%2$s\uff0c\u7ec4\u7ec7\u201c%3$s\u201d\u4e0d\u662f\u57fa\u7840\u8d44\u6599\u7684\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AbstractBaseDataPreValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(msg, baseData.getString(this.numberField), this.getOpMsg(), msgName));
            return false;
        }
        if (!this.eachValidateData(collection)) {
            return false;
        }
        DynamicObject view = BaseDataServiceHelper.getCtrlview((String)this.entity);
        if (view == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u63a7\u5236\u7b56\u7565\u7684\u7ba1\u63a7\u89c6\u56fe\u5931\u8d25\uff0c \u8bf7\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u4e2d\u5148\u914d\u7f6e\u65b0\u589e\u3002", (String)"AbstractBaseDataPreValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        QFilter[] orgFilters = new QFilter[]{new QFilter("org", "=", (Object)currentOrgId), new QFilter("view", "=", view.getPkValue())};
        DynamicObject useOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org_structure", (String)"isctrlunit,name", (QFilter[])orgFilters);
        if (useOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u5728\u7ba1\u63a7\u89c6\u56fe\u4e2d\u3002", (String)"AbstractBaseDataPreValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        boolean bl = isAssignStrategy = "1".equals(ctrlStrategy) || "2".equals(ctrlStrategy);
        if (!useOrg.getBoolean(FIELD_IS_CU) && isAssignStrategy) {
            String ctrlStrategyName = "2".equals(ctrlStrategy) ? ResManager.loadKDString((String)"\u6309\u7ba1\u63a7\u5355\u5143\u81ea\u7531\u5206\u914d", (String)"AbstractBaseDataPreValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6309\u7ba1\u63a7\u5355\u5143\u9010\u7ea7\u5206\u914d", (String)"AbstractBaseDataPreValidator_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u662f\u7ba1\u63a7\u5355\u5143\uff0c\u4e0d\u80fd%2$s\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e3a%3$s\u7684\u57fa\u7840\u6570\u636e\u3002", (String)"AbstractBaseDataPreValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            String orgName = useOrg.getString("name");
            this.getView().showTipNotification(String.format(msg, orgName, this.getOpMsg(), ctrlStrategyName));
            return false;
        }
        return this.otherBusinessValidate(currentOrgId, collection, dataIds);
    }

    private boolean eachValidateData(DynamicObjectCollection collection) {
        DynamicObject data = (DynamicObject)collection.get(0);
        String ctrlStrategy = data.getString("ctrlstrategy");
        long orgId = data.getLong("createorg");
        HashSet<String> strategies = new HashSet<String>(Arrays.asList("1", "2", "3", "4"));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entity);
        for (DynamicObject baseData : collection) {
            String strategy;
            String msg;
            String number = baseData.getString(this.numberField);
            if (!this.isIgnoreStatus && !BillStatus.C.name().equalsIgnoreCase(baseData.getString(this.statusProName))) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u672a\u5ba1\u6838\u7684\u6570\u636e\u4e0d\u5141\u8bb8%2$s\u3002", (String)"AbstractBaseDataPreValidator_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, this.getOpMsg());
                this.getView().showTipNotification(msg);
                return false;
            }
            if (!baseData.getBoolean("enable")) {
                msg = ResManager.loadKDString((String)"%1$s\uff1a\u6570\u636e\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u518d%2$s\u3002", (String)"AbstractBaseDataPreValidator_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msg, number, this.getOpMsg()));
                return false;
            }
            if ("2".equals(ctrlStrategy)) {
                msg = "";
                if (!baseData.getString("id").equals(baseData.getString(this.masterIdPropName)) && dataEntityType instanceof BasedataEntityType) {
                    msg = this.getOpMsg().equals(this.getAssignSearch()) ? String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u81ea\u7531\u5206\u914d\u201d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u5206\u914d\uff0c\u4e0d\u9700\u8981%2$s\u3002", (String)"AbstractBaseDataPreValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, this.getOpMsg()) : (this.getOpMsg().equals(this.getCancelAssign()) ? String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u81ea\u7531\u5206\u914d\u201d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u5206\u914d\uff0c\u4e0d\u9700\u8981%2$s\u3002", (String)"AbstractBaseDataPreValidator_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, this.getOpMsg()) : String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c\u81ea\u7531\u5206\u914d\u201d\u7684\u4e2a\u6027\u5316\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u5206\u914d\u3002", (String)"AbstractBaseDataPreValidator_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, this.getOpMsg()));
                    this.getView().showTipNotification(msg);
                    return false;
                }
            }
            if (!strategies.contains(strategy = baseData.getString("ctrlstrategy"))) {
                String msg2 = ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565\u4e3a\u201c\u81ea\u7531\u5206\u914d\u201d\u6216\u201c\u9010\u7ea7\u5206\u914d\u201d\u7684\u57fa\u7840\u6570\u636e\u624d\u80fd%s\u3002", (String)"AbstractBaseDataPreValidator_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msg2, this.getOpMsg()));
                return false;
            }
            if (!OP_ASSIGN_SEARCH.equals(this.opType) && !ctrlStrategy.equals(strategy)) {
                String msg3 = ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf%1$s\u3002", (String)"AbstractBaseDataPreValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msg3, this.getOpMsg()));
                return false;
            }
            if (!"2".equals(ctrlStrategy) || orgId == baseData.getLong("createorg")) continue;
            String msg4 = ResManager.loadKDString((String)"\u6309\u7ba1\u63a7\u5355\u5143\u81ea\u7531\u5206\u914d%1$s\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf%2$s\u3002", (String)"AbstractBaseDataPreValidator_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(msg4, this.getCreateOrgCaptionName(), this.getOpMsg()));
            return false;
        }
        this.assignQueryCtrlStrategy = ctrlStrategy;
        return true;
    }

    private String getCreateOrgCaptionName() {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
        IDataEntityProperty createOrgPro = (IDataEntityProperty)dt.getProperties().get((Object)"createorg");
        if (null != createOrgPro) {
            return createOrgPro.getDisplayName().getLocaleValue();
        }
        return ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"AbstractBaseDataPreValidator_15", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    public boolean otherBusinessValidate(Long currentOrgId, DynamicObjectCollection collection, List<Long> dataIds) {
        return true;
    }

    protected String getOrderBys() {
        return null;
    }

    protected Set<String> getSelectFields() {
        HashSet<String> selectFields = new HashSet<String>(Arrays.asList("id", "ctrlstrategy", "createorg", "enable"));
        selectFields.add(this.masterIdPropName);
        selectFields.add(this.numberField);
        if (!this.isIgnoreStatus) {
            selectFields.add(this.statusProName);
        }
        return selectFields;
    }

    protected abstract boolean permValidate(String var1, Long var2);

    protected abstract String generateOpMsg();

    protected boolean assignPermValidate(String appId, Long orgId) {
        boolean hasAssignPerm;
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        boolean bl = hasAssignPerm = 1 == PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)this.entity, (String)"80513208000000ac");
        if (!hasAssignPerm) {
            String caption = FormMetadataCache.getFormConfig((String)this.entity).getCaption().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AbstractBaseDataPreValidator_16", (String)SYSTEM_TYPE, (Object[])new Object[0]), caption, this.getOpMsg()));
        }
        return hasAssignPerm;
    }

    protected DynamicObjectCollection getDataCollectionByDataIds(List<Long> dataIds, Collection<String> fields) {
        Set<String> selectFieldList = this.getSelectFields();
        if (!CollectionUtils.isEmpty(fields)) {
            selectFieldList.addAll(fields);
        }
        String selectFields = String.join((CharSequence)",", selectFieldList);
        QFilter[] bdFilters = new QFilter[]{new QFilter("id", "in", dataIds)};
        return QueryServiceHelper.query((String)this.entity, (String)selectFields, (QFilter[])bdFilters, (String)this.getOrderBys());
    }

    boolean matchDataRule(String appId, Long currentOrgId, List<Long> dataIds) {
        Map<String, Object> map = AbstractBaseDataPreValidator.checkDataRule(appId, this.entity, this.getPermItemId(), currentOrgId, this.getOpMsg(), dataIds);
        List messages = (List)map.get("messages");
        if (messages.size() > 0) {
            StringJoiner stringJoiner = new StringJoiner("\r\n");
            messages.forEach(stringJoiner::add);
            if (messages.size() == 1) {
                this.getView().showTipNotification(stringJoiner.toString());
            } else {
                this.getView().showMessage(stringJoiner.toString());
            }
        }
        return (Boolean)map.get("isMatch");
    }

    protected abstract String getPermItemId();

    private static Map<String, Object> checkDataRule(String appId, String entity, String permItemId, Long currentOrgId, String opMsg, List<Long> dataIds) {
        QFilter dataRuleFilter = AbstractBaseDataPreValidator.getDataRuleFilter(appId, entity, permItemId, Collections.singletonList(currentOrgId));
        if (null == dataRuleFilter) {
            return AbstractBaseDataPreValidator.packResult(new ArrayList<String>(0));
        }
        Set<Long> idsMatchDataRule = AbstractBaseDataPreValidator.selectMatchDataRuleIds(dataRuleFilter, entity);
        QFilter filter = new QFilter("id", "in", dataIds);
        DynamicObjectCollection selectObjs = QueryServiceHelper.query((String)entity, (String)"id,number", (QFilter[])filter.toArray());
        ArrayList<String> messages = new ArrayList<String>(10);
        for (DynamicObject data : selectObjs) {
            long dataId = data.getLong("id");
            if (idsMatchDataRule.contains(dataId)) continue;
            String number = data.getString("number");
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%2$s\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractBaseDataPreValidator_17", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messages.add(String.format(msg, number, opMsg));
        }
        return AbstractBaseDataPreValidator.packResult(messages);
    }

    private static QFilter getDataRuleFilter(String appId, String entity, String permItemId, List<Long> orgIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.getDataRuleWithoutDim(currUserId, appId, entity, permItemId, orgIds);
    }

    private static Set<Long> selectMatchDataRuleIds(QFilter dataRuleFilter, String entity) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{dataRuleFilter});
        return objs.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    private static Map<String, Object> packResult(List<String> messages) {
        HashMap<String, Object> res = new HashMap<String, Object>(16);
        res.put("isMatch", messages.isEmpty());
        res.put("messages", messages);
        return res;
    }

    private static Map<String, Object> checkDataRule(String appId, String entity, String permItemId, Long currentOrgId, String opMsg, ListSelectedRowCollection selectedRows) {
        QFilter dataRuleFilter = AbstractBaseDataPreValidator.getDataRuleFilter(appId, entity, permItemId, Collections.singletonList(currentOrgId));
        if (null == dataRuleFilter) {
            return AbstractBaseDataPreValidator.packResult(new ArrayList<String>(0));
        }
        Set<Long> idsMatchDataRule = AbstractBaseDataPreValidator.selectMatchDataRuleIds(dataRuleFilter, entity);
        ArrayList<String> messages = new ArrayList<String>();
        for (ListSelectedRow row : selectedRows) {
            Long dataId = (Long)row.getPrimaryKeyValue();
            if (idsMatchDataRule.contains(dataId)) continue;
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%2$s\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractBaseDataPreValidator_17", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messages.add(String.format(msg, row.getNumber(), opMsg));
        }
        return AbstractBaseDataPreValidator.packResult(messages);
    }

    private static FormShowParameter buildFormShowParameter(List<String> messages) {
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(1);
        customParams.put("errorMsg", messages);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.setCustomParams(customParams);
        if (messages.size() == 1) {
            parameter.getOpenStyle().setShowType(ShowType.Floating);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setShowTitle(false);
        return parameter;
    }

    private static boolean checkFuncPerm(String dimOrg, long createOrg, String appId, String entityNumber, String permItemId, String opName, IFormView view) {
        boolean hasFunction;
        long userId = RequestContext.get().getCurrUserId();
        String caption = FormMetadataCache.getFormConfig((String)entityNumber).getCaption().getLocaleValue();
        boolean bl = hasFunction = 1 == PermissionServiceHelper.checkPermission((long)userId, (String)dimOrg, (long)createOrg, (String)appId, (String)entityNumber, (String)permItemId);
        if (!hasFunction) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"AbstractBaseDataPreValidator_16", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            view.showErrorNotification(String.format(msg, caption, opName));
            return false;
        }
        return true;
    }
}

