/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public abstract class AbstractBaseDataValidator {
    static final String SYSTEM_TYPE = "bos-bd-business";
    IFormView view;
    String numberField;
    String masterIdPropName;
    String entity;

    void init() {
        boolean isOtherMasterIdType = BaseDataCommonService.isOtherMasterIdType(this.entity);
        this.numberField = isOtherMasterIdType ? "masterid.number" : "number";
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)this.entity);
    }

    String selectFields(List<String> customSelectFields) {
        ArrayList<String> selectFields = new ArrayList<String>(Arrays.asList(this.masterIdPropName, this.numberField));
        selectFields.addAll(customSelectFields);
        return String.join((CharSequence)String.valueOf(','), selectFields);
    }

    Long getCreateOrgId(DynamicObject data) {
        Object createOrg = data.get("createorg");
        if (createOrg instanceof DynamicObject) {
            return (Long)((DynamicObject)createOrg).getPkValue();
        }
        if (createOrg instanceof Long) {
            return (Long)createOrg;
        }
        return 0L;
    }

    String getCreateOrgName() {
        String entityId = this.getEntityNumber();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        IDataEntityProperty createOrgPro = (IDataEntityProperty)entityType.getProperties().get((Object)"createorg");
        if (null != createOrgPro) {
            return createOrgPro.getDisplayName().getLocaleValue();
        }
        return ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"AbstractBaseDataValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    String getEntityNumber() {
        String entity = ((AbstractListView)this.view).getEntityTypeId();
        return FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
    }

    String getAppId() {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
        String appNumber = this.view.getFormShowParameter().getAppId();
        String appId = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appId = met.getAppId();
            }
        }
        return appId;
    }

    Set<Long> getAssignDataIds(String entity, Long orgId, String ctrlStrategy, Set<Long> dataIds) throws Exception {
        Set<Long> alreadyAssignDataIds = Collections.emptySet();
        if ("1".equals(ctrlStrategy)) {
            alreadyAssignDataIds = new BaseDataAssignService(entity).getAssignToDirectSubChildData(dataIds, orgId);
        } else if ("2".equals(ctrlStrategy)) {
            alreadyAssignDataIds = new BaseDataAssignService(entity).getAllAssignTypeData(dataIds, orgId);
        }
        return alreadyAssignDataIds;
    }

    Set<Long> getAssignDataIdsOnOriginalModel(Set<Long> dataIds) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)this.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("SELECT top 1 fdataid from %sUseReg where FisAssign = '1' and ", dt.getAlias()), new Object[0]);
        builder.appendIn("fdataid", dataIds.toArray());
        return (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            if (rs.next()) {
                return Collections.singleton(rs.getLong("fdataid"));
            }
            return Collections.emptySet();
        });
    }

    BaseDataResponse checkDataRule(Long useOrgId, String appId, Object[] dataIds, String permItemKey, String operateName) {
        QFilter dataRuleFilter = this.getDataRuleFilter(appId, Collections.singletonList(useOrgId), permItemKey);
        if (null == dataRuleFilter) {
            return new BaseDataResponse(true, "");
        }
        Set<Long> idsMatchDataRule = this.selectMatchDataRuleIds(dataRuleFilter);
        QFilter filter = new QFilter("id", "in", (Object)dataIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entity, (String)"id,number", (QFilter[])filter.toArray());
        ArrayList<String> messages = new ArrayList<String>(10);
        for (DynamicObject data : doc) {
            long dataId = data.getLong("id");
            if (idsMatchDataRule.contains(dataId)) continue;
            String number = data.getString("number");
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%2$s\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractBaseDataValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            messages.add(String.format(msg, number, operateName));
        }
        if (!messages.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner("\r\n");
            messages.forEach(stringJoiner::add);
            return new BaseDataResponse(false, stringJoiner.toString());
        }
        return new BaseDataResponse(true, "");
    }

    private QFilter getDataRuleFilter(String appId, List<Long> orgIds, String permItemKey) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return service.getDataRuleWithoutDim(currUserId, appId, this.entity, permItemKey, orgIds);
    }

    private Set<Long> selectMatchDataRuleIds(QFilter dataRuleFilter) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.entity, (String)"id", (QFilter[])new QFilter[]{dataRuleFilter});
        return doc.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }
}

