/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.pojo.AutoAssignPlanDetail;
import kd.bos.bd.service.AutoAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.validator.TreeBaseDataAssignPreValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AutoAssignValidator
extends AutoAssignService {
    private static final String SYSTEM_TYPE = "bos-bd-business";
    private static final int ASSIGN_MAX_NUM_OLD_MODEL = 20000000;

    public boolean isAssignDataBeyondMaxNum(String entityId, Long autoAssignPlanId) {
        ArrayList<Long> autoAssignPlanIds = new ArrayList<Long>(1);
        autoAssignPlanIds.add(autoAssignPlanId);
        return this.isAssignDataBeyondMaxNum(entityId, autoAssignPlanIds);
    }

    public boolean isAssignDataBeyondMaxNum(String entityId, List<Long> autoAssignPlanIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (null == ctrlView) {
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u89c6\u56fe\u4e3a\u7a7a\u3002", (String)"AutoAssignValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        DynamicObjectCollection autoAssignPlans = this.getAutoAssignPlan(entityId, autoAssignPlanIds);
        Map<Long, List<AutoAssignPlanDetail>> planDetailMap = this.getPlanDetailMap(autoAssignPlanIds);
        List<Long> filterConditionIds = this.getFilterConditionIds(autoAssignPlans, planDetailMap);
        Map<Long, String> filterConditionMap = this.getFilterConditionMap(filterConditionIds);
        Long viewId = ctrlView.getLong("id");
        Map<Long, List<Long>> planDetailIdUseOrgIdMap = this.getPlanDetailIdUseOrgIdMap(viewId, autoAssignPlans);
        for (DynamicObject autoAssignPlan : autoAssignPlans) {
            List<AutoAssignPlanDetail> planDetails = planDetailMap.get(autoAssignPlan.getLong("planDetail"));
            if (CollectionUtils.isEmpty(planDetails)) continue;
            String ctrlStrategy = autoAssignPlan.getString("ctrlstrategy");
            for (AutoAssignPlanDetail planDetail : planDetails) {
                List<Long> useOrgIds;
                long planDetailId = planDetail.getEntryId();
                long filterConditionId = planDetail.getFilterConditionId();
                long assignOrgId = planDetail.getAssignOrgId();
                String filterCondition = filterConditionMap.get(filterConditionId);
                List<Long> baseDataIdsMatch = this.getBaseDataMatch(entityId, assignOrgId, filterCondition, ctrlStrategy);
                if (!this.isBeyondMaxNum(entityId, baseDataIdsMatch, useOrgIds = planDetailIdUseOrgIdMap.get(planDetailId))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBeyondMaxNum(String entityId, List<Long> baseDataIdsMatch, List<Long> useOrgIds) {
        if (!CollectionUtils.isEmpty(baseDataIdsMatch) && !CollectionUtils.isEmpty(useOrgIds)) {
            long currentNum = (long)baseDataIdsMatch.size() * (long)useOrgIds.size();
            if (BaseDataCommonService.isNewModel(entityId)) {
                return false;
            }
            return currentNum >= 20000000L;
        }
        return false;
    }

    public static String getErrorMsgOfBeyondMaxAssignNum() {
        return String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002\u5206\u914d\u7684\u6570\u636e\u91cf\u5927\u4e8e%s\uff0c\u8bf7\u5347\u7ea7\u7ba1\u63a7\u7b56\u7565\u65b0\u6a21\u578b\uff0c\u4ee5\u4fbf\u7ee7\u7eed\u4f7f\u7528\u7cfb\u7edf\u3002", (String)"AutoAssignValidator_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), 20000000);
    }

    public BaseDataResponse validateAssignData(String entityId, Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        QFilter idFilter;
        QFilter[] filters;
        String selectProperties;
        DynamicObject[] doc;
        String masterIdFiledName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        BaseDataResponse response = this.batchForeachValidate(assignOrgId, masterIdFiledName, orgIds, doc = BusinessDataServiceHelper.load((String)entityId, (String)(selectProperties = BaseDataCommonService.isTreeType(entityId) ? "id,number,createOrg.id,status,ctrlStrategy,isLeaf,longNumber," + masterIdFiledName : "id,number,createOrg.id,status,ctrlStrategy," + masterIdFiledName), (QFilter[])(filters = new QFilter[]{idFilter = new QFilter("id", "in", dataIds)})));
        if (!response.isSuccess()) {
            return response;
        }
        if (!BaseDataCommonService.isTreeType(entityId)) {
            return new BaseDataResponse(true, "");
        }
        TreeBaseDataAssignPreValidator treeValidator = new TreeBaseDataAssignPreValidator(entityId, assignOrgId);
        return treeValidator.treeValidate(new ArrayList<Long>(dataIds));
    }

    private boolean assignPermValidate(String entityId, String appId, Long orgId) {
        RequestContext context = RequestContext.get();
        long userId = context.getCurrUserId();
        return 1 == PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityId, (String)"80513208000000ac");
    }

    private BaseDataResponse batchForeachValidate(Long assignOrgId, String masterIdFiledName, Set<Long> orgIds, DynamicObject[] doc) {
        HashMap result = new HashMap(doc.length);
        for (DynamicObject obj : doc) {
            HashMap errorMsg;
            Long dataId = obj.getLong("id");
            long masterId = obj.getLong(masterIdFiledName);
            String number = obj.getString("number");
            if (masterId == 0L) {
                errorMsg = new HashMap(orgIds.size());
                orgIds.forEach(orgId -> errorMsg.put(orgId, ResManager.loadKDString((String)"\u5b58\u5728masterId\u4e3a0\u7684\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\u6570\u636e\u3002", (String)"BaseDataAssignValidator_7", (String)SYSTEM_TYPE, (Object[])new Object[0])));
                result.putIfAbsent(dataId, errorMsg);
            }
            if (orgIds.size() != 1 || !assignOrgId.equals(orgIds.toArray()[0])) continue;
            errorMsg = new HashMap(orgIds.size());
            orgIds.forEach(orgId -> errorMsg.put(orgId, String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u80fd\u5c06\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u5206\u914d\u7ed9\u81ea\u5df1\u3002", (String)"BaseDataAssignValidator_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), number)));
            result.putIfAbsent(dataId, errorMsg);
        }
        if (!CollectionUtils.isEmpty(result)) {
            BaseDataResponse response = new BaseDataResponse(false, "");
            response.setResult(result);
            return response;
        }
        return new BaseDataResponse(true, "");
    }
}

